/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.changeweb;

import com.huawei.lego.common.changeport.PortsUtil;
import com.huawei.lego.common.ha.HAInfo;
import com.huawei.lego.common.ha.HaLinkNode;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class ChangeWebCommon {
    private static final String SMANAGER_PORT_KEY = "https.port";
    private static final int EXIT_FAIL = 1;
    private static final int EXIT_SUCC = 0;
    private static final Log LOGGER = LogFactory.getInstance(ChangeWebCommon.class);

    public static void main(String[] args) {
        int exitStatus = 0;
        if (args.length < 1) {
            LOGGER.error((Object)"param is error.", "");
            exitStatus = 1;
        }
        if (!ChangeWebCommon.isPortCanBeUsed(args[0])) {
            LOGGER.error((Object)("the port can not be used, port: " + args[0]), "");
            exitStatus = 1;
        }
        System.exit(exitStatus);
    }

    public static boolean isPortCanBeUsed(String port) {
        if (null == port || port.trim().isEmpty()) {
            LOGGER.info((Object)"port is null, return true.", "");
            return true;
        }
        PortsUtil util = new PortsUtil("");
        Map<String, String> allPorts = util.getAllPorts();
        allPorts.remove(SMANAGER_PORT_KEY);
        allPorts.putAll(ChangeWebCommon.getHALinkPorts());
        for (Map.Entry<String, String> entry : allPorts.entrySet()) {
            if (!port.equals(entry.getValue())) continue;
            LOGGER.error((Object)("the port " + port + " is occupid by " + entry.getKey()), "");
            return false;
        }
        return true;
    }

    private static Map<String, String> getHALinkPorts() {
        HashMap<String, String> linkPorts = new HashMap<String, String>();
        HAInfo haInfo = HAInfo.getHAInfo();
        if (haInfo.isSingleHA()) {
            LOGGER.info((Object)"current is single ha, no need get ha link port.", "");
            return linkPorts;
        }
        int iSyncTmp = 0;
        for (HaLinkNode node : haInfo.getSyncList()) {
            String key = "sync" + iSyncTmp;
            linkPorts.put(key, node.getLocalPort());
            ++iSyncTmp;
        }
        int iHeartTmp = 0;
        for (HaLinkNode node : haInfo.getHeartList()) {
            String key = "heart" + iHeartTmp;
            linkPorts.put(key, node.getLocalPort());
            ++iHeartTmp;
        }
        return linkPorts;
    }
}

