/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cloud;

import com.huawei.lego.common.cloud.model.OpenStackAvailabilityZoneMapping;
import com.huawei.lego.common.cloud.model.OpenstackProject;
import com.huawei.lego.common.cloud.model.OpenstackRegion;
import com.huawei.lego.common.cloud.model.PhVmInfo;
import com.huawei.lego.common.cloud.model.PoReplicaInfo;
import com.huawei.lego.common.cloud.model.PoReplicaPairInfo;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloudUpdateUtil
extends UpdateUtil {
    private static Log logger = LogFactory.getInstance(CloudUpdateUtil.class);
    private static Map<String, String> regionMap = new HashMap<String, String>();
    private static Map<String, String> projectMap = new HashMap<String, String>();
    private static String openstackUuid = null;
    private static final String path = "/home/DRManager/openstack_projects.json";
    private static final String splitStr = ":";

    public static void updateAzMapping(Connection connect) {
        PreparedStatement preparedStatement = null;
        try {
            Set<OpenStackAvailabilityZoneMapping> set = CloudUpdateUtil.constructAzMappingInfo(connect);
            CloudUpdateUtil.insertAzMappingInfo(connect, set);
            logger.info((Object)"insert az mapping success.");
        }
        catch (Exception e) {
            logger.error((Object)("updateAzMapping failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), (Throwable)e);
        }
        finally {
            CloudUpdateUtil.closeStatement(preparedStatement);
        }
    }

    public static void updateVolTypeMapping(Connection connect) {
        PreparedStatement preparedStatement = null;
        try {
            Map<String, Map<String, String>> volTypeMap = CloudUpdateUtil.constructVolType(connect);
            CloudUpdateUtil.insertVolTypeMappingInfo(connect, volTypeMap);
            logger.info((Object)"insert volType success.");
        }
        catch (Exception e) {
            logger.error((Object)("updateVolTypeMapping failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), (Throwable)e);
        }
        finally {
            CloudUpdateUtil.closeStatement(preparedStatement);
        }
    }

    private static Map<String, PoReplicaInfo> getPoReplicaInfo(Connection connect) throws SQLException {
        String selectSQL = "select poid, propvalue from ti_po_prop where propName='replicationInfo'";
        PreparedStatement preparedStatement = connect.prepareStatement(selectSQL);
        ResultSet rs = preparedStatement.executeQuery();
        HashMap<String, PoReplicaInfo> map = new HashMap<String, PoReplicaInfo>();
        if (null != rs) {
            while (rs.next()) {
                String poId = rs.getString(1);
                String replicationInfoStr = rs.getString(2);
                if (VerifyUtil.isEmpty((String)replicationInfoStr)) continue;
                JSONObject jsonObject = JSONObject.fromObject((Object)replicationInfoStr);
                PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)jsonObject, PoReplicaInfo.class);
                map.put(poId, poReplicaInfo);
            }
        }
        return map;
    }

    private static Map<String, Map<String, String>> constructVolType(Connection connect) throws SQLException {
        Map<String, PoReplicaInfo> replicaInfoMap = CloudUpdateUtil.getPoReplicaInfo(connect);
        HashMap<String, Map<String, String>> volTypeMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, PoReplicaInfo> entry : replicaInfoMap.entrySet()) {
            PoReplicaInfo poReplicaInfo = entry.getValue();
            List<PoReplicaPairInfo> poReplicaPairInfos = poReplicaInfo.getPairInfos();
            if (VerifyUtil.isEmpty(poReplicaPairInfos)) continue;
            for (PoReplicaPairInfo poReplicaPairInfo : poReplicaPairInfos) {
                if (null == poReplicaPairInfo || VerifyUtil.isEmpty((String)poReplicaPairInfo.getDrVolumeType()) || VerifyUtil.isEmpty((String)poReplicaPairInfo.getVolumeType())) continue;
                String type = null;
                type = poReplicaInfo.getRegionUuid().equals(poReplicaInfo.getDrRegionUuid()) ? "csha" : "csdr";
                HashMap<String, String> volType = (HashMap<String, String>)volTypeMap.get(type);
                if (null == volType) {
                    volType = new HashMap<String, String>();
                    volTypeMap.put(type, volType);
                }
                if (poReplicaPairInfo.getVolumeType().compareTo(poReplicaPairInfo.getDrVolumeType()) < 0) {
                    volType.put(poReplicaPairInfo.getVolumeType(), poReplicaPairInfo.getDrVolumeType());
                    continue;
                }
                volType.put(poReplicaPairInfo.getDrVolumeType(), poReplicaPairInfo.getVolumeType());
            }
        }
        return volTypeMap;
    }

    public static void updateHoldVmInfo(Connection connect) {
        PreparedStatement preparedStatement = null;
        try {
            Map<String, PoReplicaInfo> map = CloudUpdateUtil.constructHoldVmInfo(connect);
            CloudUpdateUtil.updatePoReplicaInfo(connect, map);
            logger.info((Object)"updatePoReplicaInfo success.");
        }
        catch (Exception e) {
            logger.error((Object)("updateHoldVmInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), (Throwable)e);
            throw new PatchException("updateHoldVmInfo failed.");
        }
        finally {
            CloudUpdateUtil.closeStatement(preparedStatement);
        }
    }

    private static Set<OpenStackAvailabilityZoneMapping> constructAzMappingInfo(Connection connect) throws SQLException {
        String selectSQL = "select PGID,PROPNAME,PROPVALUE from ti_protectgroup_prop where pgid not in (select protectgroupid from ti_serviceinstance where type='hypermetro' or type='csha')";
        PreparedStatement preparedStatement = connect.prepareStatement(selectSQL);
        ResultSet rs = preparedStatement.executeQuery();
        if (null != rs) {
            HashMap<String, OpenStackAvailabilityZoneMapping> map = new HashMap<String, OpenStackAvailabilityZoneMapping>();
            while (rs.next()) {
                String protectGroupId = rs.getString(1);
                String propName = rs.getString(2);
                String propValue = rs.getString(3);
                CloudUpdateUtil.setRegionId(protectGroupId, propName, propValue, map);
                CloudUpdateUtil.setDrRegionId(protectGroupId, propName, propValue, map);
                CloudUpdateUtil.setAzId(protectGroupId, propName, propValue, map);
                CloudUpdateUtil.setDrAzId(protectGroupId, propName, propValue, map);
            }
            if (VerifyUtil.isEmpty(map)) {
                return null;
            }
            ArrayList list = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                OpenStackAvailabilityZoneMapping azMapping = (OpenStackAvailabilityZoneMapping)entry.getValue();
                if (azMapping.checkEmpty() || list.contains(entry.getValue())) continue;
                list.add(entry.getValue());
            }
            return new HashSet<OpenStackAvailabilityZoneMapping>(list);
        }
        return null;
    }

    private static void insertAzMappingInfo(Connection connect, Set<OpenStackAvailabilityZoneMapping> set) throws SQLException {
        if (VerifyUtil.isEmpty(set)) {
            return;
        }
        for (OpenStackAvailabilityZoneMapping mapping : set) {
            String insertSQL = "insert into ti_openstack_az_mapping(PRIMARYREGIONID,PRIMARYREGION,SECONDREGIONID,SECONDREGION,PRIMARYAZID,PRIMARYAZ,SECONDAZID,SECONDAZ,TYPE,moid) values(?,?, ?, ?, ?, ?, ?, ?, ?, ?)";
            long moid = CloudUpdateUtil.inertManagedObjectData(connect, "OpenStackAvailabilityZoneMapping", "csdr");
            PreparedStatement preparedStatement = connect.prepareStatement(insertSQL);
            preparedStatement.setString(1, mapping.getPrimaryRegionId());
            preparedStatement.setString(2, mapping.getPrimaryRegion());
            preparedStatement.setString(3, mapping.getSecondRegionId());
            preparedStatement.setString(4, mapping.getSecondRegion());
            preparedStatement.setString(5, mapping.getPrimaryAzId());
            preparedStatement.setString(6, mapping.getPrimaryAz());
            preparedStatement.setString(7, mapping.getSecondAzId());
            preparedStatement.setString(8, mapping.getSecondAz());
            preparedStatement.setString(9, "csdr");
            preparedStatement.setLong(10, moid);
            preparedStatement.executeUpdate();
        }
    }

    private static void setRegionId(String protectGroupId, String propName, String propValue, Map<String, OpenStackAvailabilityZoneMapping> map) {
        if ("regionId".equalsIgnoreCase(propName)) {
            OpenStackAvailabilityZoneMapping mapping = map.get(protectGroupId);
            if (null == mapping) {
                mapping = new OpenStackAvailabilityZoneMapping();
            }
            mapping.setPrimaryRegion(CloudUpdateUtil.getProjectId(propValue));
            mapping.setPrimaryRegionId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, mapping);
        }
    }

    private static void setDrRegionId(String protectGroupId, String propName, String propValue, Map<String, OpenStackAvailabilityZoneMapping> map) {
        if ("drRegionId".equalsIgnoreCase(propName)) {
            OpenStackAvailabilityZoneMapping mapping = map.get(protectGroupId);
            if (null == mapping) {
                mapping = new OpenStackAvailabilityZoneMapping();
            }
            mapping.setSecondRegion(CloudUpdateUtil.getProjectId(propValue));
            mapping.setSecondRegionId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, mapping);
        }
    }

    private static void setAzId(String protectGroupId, String propName, String propValue, Map<String, OpenStackAvailabilityZoneMapping> map) {
        if ("zoneName".equalsIgnoreCase(propName)) {
            OpenStackAvailabilityZoneMapping mapping = map.get(protectGroupId);
            if (null == mapping) {
                mapping = new OpenStackAvailabilityZoneMapping();
            }
            mapping.setPrimaryAz(CloudUpdateUtil.getProjectId(propValue));
            mapping.setPrimaryAzId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, mapping);
        }
    }

    private static void setDrAzId(String protectGroupId, String propName, String propValue, Map<String, OpenStackAvailabilityZoneMapping> map) {
        if ("drZoneName".equalsIgnoreCase(propName)) {
            OpenStackAvailabilityZoneMapping mapping = map.get(protectGroupId);
            if (null == mapping) {
                mapping = new OpenStackAvailabilityZoneMapping();
            }
            mapping.setSecondAz(CloudUpdateUtil.getProjectId(propValue));
            mapping.setSecondAzId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, mapping);
        }
    }

    private static void insertVolTypeMappingInfo(Connection connect, Map<String, Map<String, String>> volTypeMap) throws SQLException {
        if (VerifyUtil.isEmpty(volTypeMap)) {
            return;
        }
        String deleteSQL = "delete from ti_openstack_volType_mapping";
        PreparedStatement preparedStatement = connect.prepareStatement(deleteSQL);
        preparedStatement.executeUpdate();
        for (Map.Entry<String, Map<String, String>> entry : volTypeMap.entrySet()) {
            String type = entry.getKey();
            for (Map.Entry<String, String> entry1 : entry.getValue().entrySet()) {
                String insertSQL = "insert into ti_openstack_volType_mapping(PRIMARYVOLTYPE,SECONDVOLTYPE,PRIMARYAZID,SECONDAZID,moid) values(?,?,?,?,?)";
                long moid = CloudUpdateUtil.inertManagedObjectData(connect, "OpenStackVolTypeMapping", type);
                preparedStatement = connect.prepareStatement(insertSQL);
                preparedStatement.setString(1, entry1.getKey());
                preparedStatement.setString(2, entry1.getValue());
                preparedStatement.setString(3, "");
                preparedStatement.setString(4, "");
                preparedStatement.setLong(5, moid);
                preparedStatement.executeUpdate();
            }
        }
    }

    private static Map<String, PoReplicaInfo> constructHoldVmInfo(Connection connect) throws SQLException {
        String selectSQL = "select  c.OWNERID, c.PLACEHOLDVMNAME, c.PLACEHOLDVM, d.propvalue from (select a.OWNERID, a.PLACEHOLDVMNAME, b.PLACEHOLDVM from (select OWNERID, VALUE as PLACEHOLDVMNAME from  ti_recoverysetting where name='PLACEHOLDVMNAME') a inner join (select OWNERID, VALUE as PLACEHOLDVM from  ti_recoverysetting where name='PLACEHOLDVM') b on a.OWNERID=b.OWNERID) c inner join (select poid, propvalue from ti_po_prop where propName='replicationInfo' ) d on c.OWNERID = d.poid";
        PreparedStatement preparedStatement = connect.prepareStatement(selectSQL);
        ResultSet rs = preparedStatement.executeQuery();
        if (null != rs) {
            HashMap<String, PoReplicaInfo> map = new HashMap<String, PoReplicaInfo>();
            while (rs.next()) {
                JSONObject jsonObject;
                PoReplicaInfo poReplicaInfo;
                String poid = rs.getString(1);
                String placeHoldVmName = rs.getString(2);
                String placeHoldVm = rs.getString(3);
                String replicationInfoStr = rs.getString(4);
                if (VerifyUtil.isEmpty((String)replicationInfoStr) || null != (poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)(jsonObject = JSONObject.fromObject((Object)replicationInfoStr)), PoReplicaInfo.class)).getPhVmInfo()) continue;
                PhVmInfo phVmInfo = new PhVmInfo();
                phVmInfo.setName(placeHoldVmName);
                phVmInfo.setVmUuid(placeHoldVm);
                phVmInfo.setStatus("stopped");
                if (!phVmInfo.checkEmpty()) {
                    poReplicaInfo.setPhVmInfo(phVmInfo);
                }
                map.put(poid, poReplicaInfo);
            }
            if (VerifyUtil.isEmpty(map)) {
                return null;
            }
            return map;
        }
        return null;
    }

    private static void updatePoReplicaInfo(Connection connect, Map<String, PoReplicaInfo> map) throws SQLException {
        if (VerifyUtil.isEmpty(map)) {
            return;
        }
        for (Map.Entry<String, PoReplicaInfo> entry : map.entrySet()) {
            String insertSQL = "update ti_po_prop set propvalue=? where poid=? and propname='replicationInfo'";
            PreparedStatement preparedStatement = connect.prepareStatement(insertSQL);
            PoReplicaInfo poReplicaInfo = entry.getValue();
            String regionId = CloudUpdateUtil.getProjectId(poReplicaInfo.getRegionUuid());
            String projectId = CloudUpdateUtil.getProjectId(poReplicaInfo.getProjUuid());
            String drRegionId = CloudUpdateUtil.getProjectId(poReplicaInfo.getDrRegionUuid());
            String drProjectId = CloudUpdateUtil.getProjectId(poReplicaInfo.getDrProjUuid());
            String newProjectId = projectMap.get(regionId + projectId);
            String newDrProjectId = projectMap.get(drRegionId + drProjectId);
            poReplicaInfo.setProjUuid(openstackUuid + splitStr + newProjectId);
            poReplicaInfo.setDrProjUuid(openstackUuid + splitStr + newDrProjectId);
            JSONObject jsonObject = JSONObject.fromObject((Object)poReplicaInfo);
            preparedStatement.setString(1, jsonObject.toString());
            preparedStatement.setString(2, entry.getKey());
            preparedStatement.executeUpdate();
        }
    }

    private static long inertManagedObjectData(Connection connect, String discriminator, String type) throws SQLException {
        String uuid = CloudUpdateUtil.getOpenstackUUid(connect) + splitStr + UUIDGenerator.getUUID();
        String insertSQL = "insert into t_managedobject(uuid,DISCRIMINATOR,managed,type,is_top_mo) values(?,?,TRUE,?,FALSE)";
        PreparedStatement preparedStatement = connect.prepareStatement(insertSQL, 1);
        preparedStatement.setString(1, uuid);
        preparedStatement.setString(2, discriminator);
        preparedStatement.setString(3, type);
        preparedStatement.executeUpdate();
        ResultSet rs = preparedStatement.getGeneratedKeys();
        if (rs.next()) {
            Long id = rs.getLong(1);
            return id;
        }
        throw new PatchException("inertManagedObjectData error");
    }

    private static String getOpenstackUUid(Connection connect) throws SQLException {
        if (!VerifyUtil.isEmpty((String)openstackUuid)) {
            return openstackUuid;
        }
        String sql = "select uuid from ti_fusionsphereopenstack a inner join t_managedobject b on a.mo_id=b.moid";
        PreparedStatement preparedStatement = connect.prepareStatement(sql);
        ResultSet rs = preparedStatement.executeQuery();
        if (null != rs && rs.next()) {
            openstackUuid = rs.getString(1);
            return openstackUuid;
        }
        throw new PatchException("get OpenstackUUid error.");
    }

    public static List<OpenstackProject> updateRegionAndProject(Connection connect) throws SQLException {
        String projectStr = CloudUpdateUtil.readJson(path);
        JSONArray array = JSONObject.fromObject((Object)projectStr).getJSONArray("projects");
        List list = JSONArray.toCollection((JSONArray)array, OpenstackProject.class);
        if (VerifyUtil.isEmpty((Collection)list)) {
            logger.error((Object)"OpenstackProject is empty.");
            throw new PatchException("get OpenstackProject error.");
        }
        for (OpenstackProject project : list) {
            projectMap.put(project.getNewRegionId() + project.getOldProjectId(), project.getNewProjectId());
        }
        for (OpenstackProject project : list) {
            regionMap.put(project.getRegionId(), project.getNewRegionId());
        }
        CloudUpdateUtil.updateRegionId(connect);
        Map<String, OpenstackRegion> map = CloudUpdateUtil.getOpenstackRegion(connect);
        CloudUpdateUtil.updateProjectId(connect, map);
        return list;
    }

    private static Map<String, OpenstackRegion> getOpenstackRegion(Connection connect) throws SQLException {
        String selectSQL = "select PGID,PROPNAME,PROPVALUE from ti_protectgroup_prop where pgid not in (select protectgroupid from ti_serviceinstance where type='hypermetro' or type='csha')";
        PreparedStatement preparedStatement = connect.prepareStatement(selectSQL);
        ResultSet rs = preparedStatement.executeQuery();
        if (null != rs) {
            HashMap<String, OpenstackRegion> map = new HashMap<String, OpenstackRegion>();
            while (rs.next()) {
                String protectGroupId = rs.getString(1);
                String propName = rs.getString(2);
                String propValue = rs.getString(3);
                CloudUpdateUtil.getOpenstackRegion(protectGroupId, propName, propValue, map);
            }
            return map;
        }
        return null;
    }

    private static void updateRegionId(Connection connect) throws SQLException {
        openstackUuid = CloudUpdateUtil.getOpenstackUUid(connect);
        for (Map.Entry<String, String> entry : regionMap.entrySet()) {
            String oldRegion = entry.getKey();
            String newRegion = entry.getValue();
            String updateSql = "update ti_protectgroup_prop set propvalue=replace(propvalue,'%s','%s') where propname='regionId' or propname='drRegionId'";
            updateSql = String.format(updateSql, oldRegion, newRegion);
            PreparedStatement preparedStatement = connect.prepareStatement(updateSql);
            preparedStatement.executeUpdate();
            String oldRegionUuid = openstackUuid + splitStr + oldRegion;
            String newRegionUuid = openstackUuid + splitStr + newRegion;
            String updateSql2 = "update TI_PO_PROP set propvalue=replace(propvalue,'%s','%s') where propname='replicationInfo'";
            updateSql2 = String.format(updateSql2, oldRegionUuid, newRegionUuid);
            PreparedStatement preparedStatement2 = connect.prepareStatement(updateSql2);
            preparedStatement2.executeUpdate();
            String updateSql22 = "update TI_PO_PROP set propvalue=replace(propvalue,'%s','%s') where propname='regionId'";
            updateSql22 = String.format(updateSql22, oldRegion, newRegion);
            PreparedStatement preparedStatement22 = connect.prepareStatement(updateSql22);
            preparedStatement22.executeUpdate();
            oldRegionUuid = openstackUuid + splitStr + oldRegion;
            newRegionUuid = openstackUuid + splitStr + newRegion;
            updateSql2 = "update TI_PROTECTGROUPREPLICA_PROP set propvalue=replace(propvalue,'%s','%s') where propname='regionId' or propname='drRegionId'";
            updateSql2 = String.format(updateSql2, oldRegionUuid, newRegionUuid);
            preparedStatement2 = connect.prepareStatement(updateSql2);
            preparedStatement2.executeUpdate();
        }
    }

    private static void updateProjectId(Connection connect, Map<String, OpenstackRegion> map) throws SQLException {
        for (Map.Entry<String, OpenstackRegion> entry : map.entrySet()) {
            String pgId = entry.getKey();
            OpenstackRegion region = entry.getValue();
            String newProjectId = projectMap.get(region.getRegionId() + region.getProjectId());
            String newDrProjectId = projectMap.get(region.getDrRegionId() + region.getDrProjectId());
            String updateSql = "update ti_protectgroup_prop set propvalue=replace(propvalue,'%s','%s') where propname='projectId' and pgid='%s'";
            updateSql = String.format(updateSql, region.getProjectId(), newProjectId, pgId);
            PreparedStatement preparedStatement = connect.prepareStatement(updateSql);
            preparedStatement.executeUpdate();
            updateSql = "update ti_protectgroup_prop set propvalue=replace(propvalue,'%s','%s') where propname='drProjectId' and pgid='%s'";
            updateSql = String.format(updateSql, region.getDrProjectId(), newDrProjectId, pgId);
            preparedStatement = connect.prepareStatement(updateSql);
            preparedStatement.executeUpdate();
            updateSql = "update ti_serviceinstance set projectid='%s' where PROTECTGROUPID='%s'";
            updateSql = String.format(updateSql, newProjectId, pgId);
            preparedStatement = connect.prepareStatement(updateSql);
            preparedStatement.executeUpdate();
        }
        Map<String, PoReplicaInfo> replicaInfoMap = CloudUpdateUtil.getPoReplicaInfo(connect);
        CloudUpdateUtil.updatePoReplicaInfo(connect, replicaInfoMap);
    }

    private static void getOpenstackRegion(String protectGroupId, String propName, String propValue, Map<String, OpenstackRegion> map) {
        OpenstackRegion region;
        if ("regionId".equalsIgnoreCase(propName)) {
            region = map.get(protectGroupId);
            if (null == region) {
                region = new OpenstackRegion();
            }
            region.setRegionId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, region);
        }
        if ("drRegionId".equalsIgnoreCase(propName)) {
            region = map.get(protectGroupId);
            if (null == region) {
                region = new OpenstackRegion();
            }
            region.setDrRegionId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, region);
        }
        if ("projectId".equalsIgnoreCase(propName)) {
            region = map.get(protectGroupId);
            if (null == region) {
                region = new OpenstackRegion();
            }
            region.setProjectId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, region);
        }
        if ("drProjectId".equalsIgnoreCase(propName)) {
            region = map.get(protectGroupId);
            if (null == region) {
                region = new OpenstackRegion();
            }
            region.setDrProjectId(CloudUpdateUtil.getProjectId(propValue));
            map.put(protectGroupId, region);
        }
    }

    private static String readJson(String path) {
        InputStreamReader reader = null;
        StringBuilder result = new StringBuilder();
        FileInputStream is = null;
        try {
            int tempchar;
            File confFile = CloudUpdateUtil.getConfigFile(path);
            is = new FileInputStream(confFile);
            reader = new InputStreamReader((InputStream)is, "UTF-8");
            while ((tempchar = ((Reader)reader).read()) != -1) {
                result.append((char)tempchar);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)("readJson project.json failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new PatchException("get OpenstackProject error.");
            }
            catch (Throwable throwable) {
                CommonUtil.close(reader);
                CommonUtil.close(is);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)reader);
        CommonUtil.close((Closeable)is);
        return result.toString();
    }

    private static File getConfigFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        return file;
    }
}

