/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cloud.model;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OpenStackAvailabilityZoneMapping {
    private String primaryAzId;
    private String primaryAz;
    private String secondAzId;
    private String secondAz;
    private String primaryRegionId;
    private String primaryRegion;
    private String secondRegionId;
    private String secondRegion;

    public String getPrimaryAzId() {
        return this.primaryAzId;
    }

    public void setPrimaryAzId(String primaryAzId) {
        this.primaryAzId = primaryAzId;
    }

    public String getSecondAzId() {
        return this.secondAzId;
    }

    public void setSecondAzId(String secondAzId) {
        this.secondAzId = secondAzId;
    }

    public String getPrimaryAz() {
        return this.primaryAz;
    }

    public void setPrimaryAz(String primaryAz) {
        this.primaryAz = primaryAz;
    }

    public String getSecondAz() {
        return this.secondAz;
    }

    public void setSecondAz(String secondAz) {
        this.secondAz = secondAz;
    }

    public String getPrimaryRegion() {
        return this.primaryRegion;
    }

    public void setPrimaryRegion(String primaryRegion) {
        this.primaryRegion = primaryRegion;
    }

    public void setPrimaryRegionId(String primaryRegionId) {
        this.primaryRegionId = primaryRegionId;
    }

    public String getPrimaryRegionId() {
        return this.primaryRegionId;
    }

    public String getSecondRegion() {
        return this.secondRegion;
    }

    public void setSecondRegion(String secondRegion) {
        this.secondRegion = secondRegion;
    }

    public void setSecondRegionId(String secondRegionId) {
        this.secondRegionId = secondRegionId;
    }

    public String getSecondRegionId() {
        return this.secondRegionId;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.checkAzMapping((OpenStackAvailabilityZoneMapping)obj);
    }

    private boolean checkAzMapping(OpenStackAvailabilityZoneMapping mapping) {
        int i;
        List<String> regionIds = Arrays.asList(this.primaryRegionId, this.secondRegionId);
        Collections.sort(regionIds);
        List<String> azIds = Arrays.asList(this.primaryAzId, this.secondAzId);
        Collections.sort(azIds);
        List<String> otherRegionIds = Arrays.asList(mapping.primaryRegionId, mapping.secondRegionId);
        Collections.sort(otherRegionIds);
        List<String> otherAzIds = Arrays.asList(mapping.primaryAzId, mapping.secondAzId);
        Collections.sort(otherAzIds);
        for (i = 0; i < regionIds.size(); ++i) {
            if (null != regionIds.get(i) && regionIds.get(i).equals(otherRegionIds.get(i))) continue;
            return false;
        }
        for (i = 0; i < azIds.size(); ++i) {
            if (null != azIds.get(i) && azIds.get(i).equals(otherAzIds.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean checkEmpty() {
        return VerifyUtil.isEmpty((String)this.primaryRegionId) || VerifyUtil.isEmpty((String)this.primaryAzId) || VerifyUtil.isEmpty((String)this.secondRegionId) || VerifyUtil.isEmpty((String)this.secondAzId);
    }
}

