/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cloud.service.merge.dbmerge.impl;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.cloud.service.merge.IDoubleRDMergeService;
import com.huawei.lego.common.cloud.service.merge.manager.ITableNanager;
import com.huawei.lego.common.cloud.service.merge.manager.impl.TableManagerImpl;
import com.huawei.lego.common.cloud.service.merge.util.ExportDataUtil;
import com.huawei.lego.common.cloud.service.merge.util.LocaleDBUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DoubleDBMergeServiceImpl
implements IDoubleRDMergeService {
    private static final String TABLE_PATH = "/home/GaussDB/DBMergeTemp";
    private static Log logger = LogFactory.getInstance(DoubleDBMergeServiceImpl.class);
    private List<String> tarLineSign = new ArrayList<String>();
    private List<String> tableSortedPath = new ArrayList<String>();
    private Map<String, List<StringBuilder>> cacheData = new HashMap<String, List<StringBuilder>>();
    private Map<String, String> tableNameToSeq = new HashMap<String, String>();
    private List<String> cacheSeqSql = new ArrayList<String>();
    private ITableNanager manager = new TableManagerImpl(this.cacheData);

    public DoubleDBMergeServiceImpl() {
        this.tableNameToSeq.put("t_user", "T_USER_USER_ID_SEQ");
        this.tableNameToSeq.put("t_user_acl", "T_USER_ACL_ACL_ID_SEQ");
        this.tableNameToSeq.put("t_user_customsetting", "T_USER_CUSTOMSETTING_ID_SEQ");
        this.tableNameToSeq.put("t_role", "T_ROLE_ROLE_ID_SEQ");
        this.tableNameToSeq.put("ti_protectgrouplog", "TI_PROTECTGROUPLOG_HISTORYLOGID_SEQ");
        this.tableNameToSeq.put("ti_drmtask", "TI_DRMTASK_TASKID_SEQ");
        this.tarLineSign.add("ti_protectgroup");
        this.tarLineSign.add("ti_protectgroup_prop");
        this.tarLineSign.add("ti_protectobject");
        this.tarLineSign.add("ti_po_prop");
        this.tarLineSign.add("ti_protectgroupreplica");
        this.tarLineSign.add("ti_protectgroupreplica_prop");
        this.tarLineSign.add("ti_protectgrouplog");
        this.tarLineSign.add("ti_protectgrouplogdetail");
        this.tarLineSign.add("ti_policytemplate");
        this.tarLineSign.add("ti_policytemplate_prop");
        this.tarLineSign.add("ti_schedule");
        this.tarLineSign.add("ti_schedulerangetime");
        this.tarLineSign.add("ti_user_r_biz");
        this.tarLineSign.add("ti_recoveryplan");
        this.tarLineSign.add("ti_recoverylog");
        this.tarLineSign.add("ti_recoveryprocessordetail");
        this.tarLineSign.add("ti_recoverysetting");
        this.tarLineSign.add("ti_recoveryprocessdefinition");
        this.tarLineSign.add("ti_recoveryprocessor");
        this.tarLineSign.add("ti_recoveryprocessor_props");
        this.tarLineSign.add("ti_rp_globalsettings");
        this.tarLineSign.add("t_user");
        this.tarLineSign.add("t_user_r_role");
        this.tarLineSign.add("t_role");
        this.tarLineSign.add("t_operation_r_role");
        this.tarLineSign.add("t_user_acl");
        this.tarLineSign.add("t_user_customsetting");
        this.tarLineSign.add("ti_drp_r_pg");
        this.tarLineSign.add("ti_drmtask");
        this.tarLineSign.add("ti_fusionsphereopenstack");
        this.tarLineSign.add("t_managedobject");
        this.tarLineSign.add("ti_protectaction");
        this.tarLineSign.add("ti_protectaction_param");
        this.tarLineSign.add("ti_dr_resource");
        this.tableSortedPath.add("t_user");
        this.tableSortedPath.add("t_role");
        this.tableSortedPath.add("t_user_r_role");
        this.tableSortedPath.add("t_operation_r_role");
        this.tableSortedPath.add("t_user_acl");
        this.tableSortedPath.add("t_user_customsetting");
        this.tableSortedPath.add("ti_policytemplate");
        this.tableSortedPath.add("ti_policytemplate_prop");
        this.tableSortedPath.add("ti_protectgroup");
        this.tableSortedPath.add("ti_protectgroup_prop");
        this.tableSortedPath.add("ti_protectobject");
        this.tableSortedPath.add("ti_po_prop");
        this.tableSortedPath.add("ti_protectgroupreplica");
        this.tableSortedPath.add("ti_protectgroupreplica_prop");
        this.tableSortedPath.add("ti_protectgrouplog");
        this.tableSortedPath.add("ti_protectgrouplogdetail");
        this.tableSortedPath.add("ti_schedule");
        this.tableSortedPath.add("ti_schedulerangetime");
        this.tableSortedPath.add("ti_protectaction");
        this.tableSortedPath.add("ti_protectaction_param");
        this.tableSortedPath.add("ti_recoveryplan");
        this.tableSortedPath.add("ti_recoveryprocessdefinition");
        this.tableSortedPath.add("ti_recoveryprocessor");
        this.tableSortedPath.add("ti_recoveryprocessor_props");
        this.tableSortedPath.add("ti_recoverylog");
        this.tableSortedPath.add("ti_recoveryprocessordetail");
        this.tableSortedPath.add("ti_recoverysetting");
        this.tableSortedPath.add("ti_rp_globalsettings");
        this.tableSortedPath.add("ti_user_r_biz");
        this.tableSortedPath.add("ti_drp_r_pg");
        this.tableSortedPath.add("ti_drmtask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(File tarFile) throws Exception {
        this.getDataFromDRDBFile(tarFile);
        Connection connect = null;
        try {
            DataBaseInfo dbInfo = ExportDataUtil.getInstallInfo();
            connect = LegoDBConnection.getInstance().connectGaussDB(dbInfo, "LEGO");
            this.replaceOpenstackUuid(connect);
            this.replaceDevSN(connect);
            this.replaceSite(connect);
            this.initSysResouce(connect);
            this.initProtectgroupRecoveryName(connect);
            this.initUserAndRole(connect);
            this.replaceId(connect);
            this.write();
            if (!CmdUtil.execShellCmd("chown -R GaussDB /home/GaussDB/DBMergeTemp")) {
                logger.error((Object)"change ower error.");
                throw new PatchException("excute cmd error.");
            }
            for (int i = 0; i < this.tableSortedPath.size(); ++i) {
                String tableName = this.tableSortedPath.get(i);
                String tablePath = TABLE_PATH + File.separator + this.tableSortedPath.get(i);
                if (!new File(tablePath).exists()) continue;
                StringBuilder build = new StringBuilder("/usr/local/gaussdb/bin/gsql -d LEGO");
                build.append(" -U ").append(dbInfo.getDbaUsername()).append(" -W ").append(dbInfo.getDbaPassword()).append(" -p ").append(dbInfo.getDbPort()).append(" -c ").append("\"copy ").append(tableName).append(" from '").append(tablePath).append("'\"");
                if (!CmdUtil.execShellCmd(build.toString())) {
                    logger.error((Object)("insert table error, tableName is " + tableName));
                    throw new PatchException("excute cmd error.");
                }
                logger.info((Object)("insert table success, tableName is " + tableName));
            }
            FileUtil.deleteAllFolder(new File(TABLE_PATH));
            this.modifyDBSEQ(connect);
        }
        finally {
            if (null != connect) {
                connect.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyDBSEQ(Connection connect) throws Exception {
        for (String sql : this.cacheSeqSql) {
            PreparedStatement statement = null;
            try {
                statement = connect.prepareStatement(sql);
                statement.execute();
            }
            finally {
                if (null == statement) continue;
                statement.close();
            }
        }
    }

    private void replaceId(Connection connect) throws Exception {
        this.replaceProtectHistorId(connect);
        this.replaceProtectTaskId(connect);
    }

    private void replaceProtectTaskId(Connection connect) throws Exception {
        List<StringBuilder> tarTable = this.cacheData.get("ti_drmtask");
        if (null == tarTable || tarTable.size() < 2) {
            logger.info((Object)"tarTable is empty");
            return;
        }
        HashSet<Long> localeIds = new HashSet<Long>(LocaleDBUtil.queryIds(connect, "ti_drmtask", "TASKID"));
        List<String> tableIds = this.manager.getColumnValues("ti_drmtask", "TASKID");
        HashSet<Long> tableIdSet = new HashSet<Long>(this.manager.convertToLong(tableIds));
        int idIndex = this.manager.getColumnIndex("ti_drmtask", "TASKID");
        for (int i = 1; i < tarTable.size(); ++i) {
            String newIdString;
            StringBuilder builder = tarTable.get(i);
            String[] rowDatas = builder.toString().split("\\t|\\\\t");
            long drId = Long.parseLong(rowDatas[idIndex]);
            if (!tableIdSet.contains(drId)) continue;
            Long newId = this.retryAvailableId(localeIds, drId, tableIdSet);
            localeIds.add(newId);
            rowDatas[idIndex] = newIdString = String.valueOf(newId);
            this.manager.rebuildBuilder(builder, rowDatas);
        }
        this.modifyDBSeq("ti_drmtask", localeIds);
    }

    private void replaceProtectHistorId(Connection connect) throws Exception {
        List<StringBuilder> tarTable = this.cacheData.get("ti_protectgrouplog");
        if (null == tarTable || tarTable.size() < 2) {
            logger.info((Object)"tarTable is empty");
            return;
        }
        HashSet<Long> localeIds = new HashSet<Long>(LocaleDBUtil.queryIds(connect, "ti_protectgrouplog", "HISTORYLOGID"));
        List<String> tableIds = this.manager.getColumnValues("ti_protectgrouplog", "HISTORYLOGID");
        HashSet<Long> tableIdSet = new HashSet<Long>(this.manager.convertToLong(tableIds));
        int idIndex = this.manager.getColumnIndex("ti_protectgrouplog", "HISTORYLOGID");
        for (int i = 1; i < tarTable.size(); ++i) {
            String newIdString;
            StringBuilder builder = tarTable.get(i);
            String[] rowDatas = builder.toString().split("\\t|\\\\t");
            long drId = Long.parseLong(rowDatas[idIndex]);
            if (!tableIdSet.contains(drId)) continue;
            Long newId = this.retryAvailableId(localeIds, drId, tableIdSet);
            localeIds.add(newId);
            rowDatas[idIndex] = newIdString = String.valueOf(newId);
            this.manager.updateRow("ti_protectgrouplogdetail", "HISTORYLOGID", String.valueOf(drId), "HISTORYLOGID", newIdString);
            this.manager.rebuildBuilder(builder, rowDatas);
        }
        this.modifyDBSeq("ti_protectgrouplog", localeIds);
    }

    private void replaceDevSN(Connection connect) throws Exception {
        String sn = LocaleDBUtil.getDevSn(connect);
        String oldSn = this.manager.getColumnValue("ti_dr_resource", "DISCRIMINATOR", "DrFusionSphereOpenStack", "DEVICESN");
        this.manager.replaceAll(oldSn, sn);
    }

    private void replaceSite(Connection connect) throws Exception {
        String siteId = LocaleDBUtil.getSiteId(connect);
        String drSiteId = this.getDrSiteId();
        this.manager.replaceAll(drSiteId, siteId);
        List<StringBuilder> ti_user_r_biz = this.cacheData.get("ti_user_r_biz");
        if (null == ti_user_r_biz || ti_user_r_biz.size() < 2) {
            return;
        }
        ArrayList<StringBuilder> tobeDelete = new ArrayList<StringBuilder>();
        for (StringBuilder stringBuilder : ti_user_r_biz) {
            if (!stringBuilder.toString().contains("1\t" + siteId) && !stringBuilder.toString().contains("1\\\\t" + siteId)) continue;
            tobeDelete.add(stringBuilder);
        }
        this.manager.remove("ti_user_r_biz", tobeDelete);
    }

    private String getDrSiteId() {
        String siteId = this.manager.getColumnValue("ti_dr_resource", "DISCRIMINATOR", "DrFusionSphereOpenStack", "SITEID");
        this.cacheData.remove("ti_dr_resource");
        return siteId;
    }

    private void initSysResouce(Connection connect) throws Exception {
        Map<String, String> ti_policytemplate_map = LocaleDBUtil.queryDataBySql(connect, "ti_policytemplate", "NAME", "PTID", "PARENTID", null);
        List<StringBuilder> ti_policytemplate = this.cacheData.get("ti_policytemplate");
        List<StringBuilder> ti_schedule = this.cacheData.get("ti_schedule");
        if (null == ti_policytemplate || ti_policytemplate.size() < 2) {
            logger.info((Object)"ti_policytemplate is empty .");
            return;
        }
        int ptidIndex = this.manager.getColumnIndex("ti_policytemplate", "PTID");
        int nameIndex = this.manager.getColumnIndex("ti_policytemplate", "NAME");
        int parentIdIndex = this.manager.getColumnIndex("ti_policytemplate", "PARENTID");
        ArrayList<StringBuilder> tobeDeletePt = new ArrayList<StringBuilder>();
        ArrayList<String> tobeDeletePtid = new ArrayList<String>();
        for (int i = 1; i < ti_policytemplate.size(); ++i) {
            StringBuilder stringBuilder = ti_policytemplate.get(i);
            String[] rowDatas = stringBuilder.toString().split("\\t|\\\\t");
            String name = rowDatas[nameIndex];
            String parentId = rowDatas[parentIdIndex];
            String newParentId = ti_policytemplate_map.get(name);
            if ("".equals(parentId) || "\\N".equals(parentId) || "\\\\N".equals(parentId)) {
                tobeDeletePt.add(stringBuilder);
                tobeDeletePtid.add(rowDatas[ptidIndex]);
                continue;
            }
            rowDatas[parentIdIndex] = newParentId;
            this.manager.rebuildBuilder(stringBuilder, rowDatas);
        }
        for (StringBuilder pt : tobeDeletePt) {
            ti_policytemplate.remove(pt);
        }
        List<StringBuilder> ti_policytemplate_prop = this.cacheData.get("ti_policytemplate_prop");
        ArrayList<StringBuilder> tobeDeletePtProp = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> tobeDeletePtSch = new ArrayList<StringBuilder>();
        for (String id : tobeDeletePtid) {
            for (StringBuilder stringBuilder : ti_policytemplate_prop) {
                if (!stringBuilder.toString().contains(id)) continue;
                tobeDeletePtProp.add(stringBuilder);
            }
            if (null == ti_schedule || ti_schedule.size() < 2) continue;
            for (StringBuilder stringBuilder : ti_schedule) {
                if (!stringBuilder.toString().contains(id)) continue;
                tobeDeletePtSch.add(stringBuilder);
            }
        }
        this.manager.remove("ti_policytemplate_prop", tobeDeletePtProp);
        this.manager.remove("ti_schedule", tobeDeletePtSch);
    }

    private void initProtectgroupRecoveryName(Connection connect) throws Exception {
        this.initProtectgroupName(connect);
        this.initRecoveryName(connect);
    }

    private void initRecoveryName(Connection connect) throws Exception {
        Set<String> localeRecoveryNames = LocaleDBUtil.getLocaleRecoveryName(connect);
        HashSet<String> tableRecoveryNames = new HashSet<String>(this.manager.getColumnValues("ti_recoveryplan", "PLANNAME"));
        List<StringBuilder> recoveryplans = this.cacheData.get("ti_recoveryplan");
        if (null == recoveryplans || recoveryplans.size() < 2) {
            logger.info((Object)"recoveryPlan is empty");
            return;
        }
        int recoveryNameIndex = this.manager.getColumnIndex("ti_recoveryplan", "PLANNAME");
        for (int i = 1; i < recoveryplans.size(); ++i) {
            StringBuilder recoveryBuilder = recoveryplans.get(i);
            String[] recoveryRowDatas = recoveryBuilder.toString().split("\\t|\\\\t");
            if (localeRecoveryNames.contains(recoveryRowDatas[recoveryNameIndex])) {
                String newRoleName = this.retryAvailableName(localeRecoveryNames, recoveryRowDatas[recoveryNameIndex], 32, tableRecoveryNames);
                localeRecoveryNames.add(newRoleName);
                recoveryRowDatas[recoveryNameIndex] = newRoleName;
            }
            this.manager.rebuildBuilder(recoveryBuilder, recoveryRowDatas);
        }
    }

    private void initProtectgroupName(Connection connect) throws Exception {
        Set<String> localeProtectgroupNames = LocaleDBUtil.getLocaleProtectgroupName(connect);
        HashSet<String> tableProtectgroupNames = new HashSet<String>(this.manager.getColumnValues("ti_protectgroup", "PGNAME"));
        List<StringBuilder> protectgroups = this.cacheData.get("ti_protectgroup");
        if (null == protectgroups || protectgroups.size() < 2) {
            logger.info((Object)"pg is empty");
            return;
        }
        int protectgroupNameIndex = this.manager.getColumnIndex("ti_protectgroup", "PGNAME");
        for (int i = 1; i < protectgroups.size(); ++i) {
            StringBuilder pgBuilder = protectgroups.get(i);
            String[] pgRowDatas = pgBuilder.toString().split("\\t|\\\\t");
            if (localeProtectgroupNames.contains(pgRowDatas[protectgroupNameIndex])) {
                String newPgName = this.retryAvailableName(localeProtectgroupNames, pgRowDatas[protectgroupNameIndex], 32, tableProtectgroupNames);
                localeProtectgroupNames.add(newPgName);
                pgRowDatas[protectgroupNameIndex] = newPgName;
            }
            this.manager.rebuildBuilder(pgBuilder, pgRowDatas);
        }
    }

    private void write() throws Exception {
        FileUtil.deleteAllFolder(new File(TABLE_PATH));
        Set<Map.Entry<String, List<StringBuilder>>> entries = this.cacheData.entrySet();
        File dir = new File(TABLE_PATH);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                logger.error((Object)"create DBMergeTemp dir error. ");
                throw new PatchException("create DBMergeTemp dir error. ");
            }
        } else {
            logger.error((Object)"DBMergeTemp dir exist. ");
            throw new PatchException("DBMergeTemp dir exist. ");
        }
        for (Map.Entry<String, List<StringBuilder>> entry : entries) {
            this.writeOneTable(entry.getValue(), entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneTable(List<StringBuilder> builderList, String tableName) throws Exception {
        if (null == builderList || builderList.size() < 2) {
            return;
        }
        File file = new File(TABLE_PATH + File.separator + tableName);
        if (file.exists()) {
            file.delete();
        }
        if (!file.createNewFile()) {
            logger.error((Object)"can't create table file.");
            throw new PatchException("can't create table file.");
        }
        FileWriter write = null;
        try {
            write = new FileWriter(file);
            for (int i = 1; i < builderList.size(); ++i) {
                write.write(builderList.get(i).toString().replaceAll("\\\\t", "\t") + "\n");
            }
        }
        finally {
            if (null != write) {
                write.close();
            }
        }
    }

    private void initUserAndRole(Connection connect) throws Exception {
        this.removeSystemDefault();
        this.modifyThreePartyUserAndRole(connect);
    }

    private void modifyThreePartyUserAndRole(Connection connect) throws Exception {
        this.modifyUser(connect);
        this.modifyUserAcl(connect);
        this.modifyUserCustomsetting(connect);
        this.modifyRole(connect);
    }

    private void modifyUserCustomsetting(Connection connect) throws Exception {
        Set<Long> localeIds = LocaleDBUtil.getLocaleUserCustomsetting(connect);
        List<String> tableIds = this.manager.getColumnValues("t_user_customsetting", "ID");
        HashSet<Long> tableIdSet = new HashSet<Long>(this.manager.convertToLong(tableIds));
        List<StringBuilder> users_customsetting = this.cacheData.get("t_user_customsetting");
        if (null == users_customsetting || users_customsetting.size() < 2) {
            logger.info((Object)"role is empty");
            return;
        }
        int idIndexInAcl = this.manager.getColumnIndex("t_user_customsetting", "ID");
        for (int i = 1; i < users_customsetting.size(); ++i) {
            String newRoleIdString;
            StringBuilder builder = users_customsetting.get(i);
            String[] roleRowDatas = builder.toString().split("\\t|\\\\t");
            long drId = Long.parseLong(roleRowDatas[idIndexInAcl]);
            if (!localeIds.contains(drId)) continue;
            Long newId = this.retryAvailableId(localeIds, drId, tableIdSet);
            localeIds.add(newId);
            roleRowDatas[idIndexInAcl] = newRoleIdString = String.valueOf(newId);
            this.manager.rebuildBuilder(builder, roleRowDatas);
        }
        this.modifyDBSeq("t_user_customsetting", localeIds);
    }

    private void modifyUserAcl(Connection connect) throws Exception {
        Set<Long> localeAclIds = LocaleDBUtil.getLocaleUserAcl(connect);
        List<String> tableIds = this.manager.getColumnValues("t_user_acl", "ACL_ID");
        HashSet<Long> tableIdSet = new HashSet<Long>(this.manager.convertToLong(tableIds));
        List<StringBuilder> users_acl = this.cacheData.get("t_user_acl");
        if (null == users_acl || users_acl.size() < 2) {
            logger.info((Object)"users_acl is empty");
            return;
        }
        int idIndexInAcl = this.manager.getColumnIndex("t_user_acl", "ACL_ID");
        for (int i = 1; i < users_acl.size(); ++i) {
            String newRoleIdString;
            StringBuilder builder = users_acl.get(i);
            String[] roleRowDatas = builder.toString().split("\\t|\\\\t");
            long drId = Long.parseLong(roleRowDatas[idIndexInAcl]);
            if (!localeAclIds.contains(drId)) continue;
            Long newId = this.retryAvailableId(localeAclIds, drId, tableIdSet);
            localeAclIds.add(newId);
            roleRowDatas[idIndexInAcl] = newRoleIdString = String.valueOf(newId);
            this.manager.rebuildBuilder(builder, roleRowDatas);
        }
        this.modifyDBSeq("t_user_acl", localeAclIds);
    }

    private void modifyRole(Connection connect) throws Exception {
        HashSet<Long> localeRoleIds = new HashSet<Long>(LocaleDBUtil.queryIds(connect, "t_role", "ROLE_ID"));
        List<String> tableIds = this.manager.getColumnValues("t_role", "ROLE_ID");
        HashSet<Long> tableRoleIds = new HashSet<Long>(this.manager.convertToLong(tableIds));
        HashSet<String> localeRoleNames = new HashSet<String>(LocaleDBUtil.queryDataBySql(connect, "t_role", "ROLE_NAME", null, null));
        HashSet<String> tableRoleNames = new HashSet<String>(this.manager.getColumnValues("t_role", "ROLE_NAME"));
        List<StringBuilder> roles = this.cacheData.get("t_role");
        if (null == roles || roles.size() < 2) {
            logger.info((Object)"role is empty");
            return;
        }
        int roleNameIndexInRoles = this.manager.getColumnIndex("t_role", "ROLE_NAME");
        int roleIdIndexInRoles = this.manager.getColumnIndex("t_role", "ROLE_ID");
        for (int i = 1; i < roles.size(); ++i) {
            StringBuilder roleBuilder = roles.get(i);
            String[] roleRowDatas = roleBuilder.toString().split("\\t|\\\\t");
            long drRoleId = Long.parseLong(roleRowDatas[roleIdIndexInRoles]);
            if (localeRoleIds.contains(drRoleId)) {
                String newRoleIdString;
                Long newRoleId = this.retryAvailableId(localeRoleIds, drRoleId, tableRoleIds);
                localeRoleIds.add(newRoleId);
                roleRowDatas[roleIdIndexInRoles] = newRoleIdString = String.valueOf(newRoleId);
                this.modifyAssociationRoles(drRoleId, newRoleIdString);
            }
            if (localeRoleNames.contains(roleRowDatas[roleNameIndexInRoles])) {
                String newRoleName = this.retryAvailableName(localeRoleNames, roleRowDatas[roleNameIndexInRoles], 64, tableRoleNames);
                localeRoleNames.add(newRoleName);
                roleRowDatas[roleNameIndexInRoles] = newRoleName;
            }
            this.manager.rebuildBuilder(roleBuilder, roleRowDatas);
        }
        this.modifyDBSeq("t_role", localeRoleIds);
    }

    private void modifyDBSeq(String tableName, Set<Long> ids) {
        String seqName = this.tableNameToSeq.get(tableName);
        if (null == seqName) {
            logger.error((Object)("init index error , tableName :" + tableName));
            return;
        }
        long max = 1L;
        for (Long id : ids) {
            max = Long.max(max, id);
        }
        logger.info((Object)("tableName " + tableName + ", index : " + ++max));
        this.cacheSeqSql.add("SELECT pg_catalog.setval('" + this.tableNameToSeq.get(tableName) + "', " + max + ", true)");
    }

    private void modifyAssociationRoles(long drRoleId, String newRoleIdString) {
        this.manager.updateRow("t_operation_r_role", "ROLE_ID", String.valueOf(drRoleId), "ROLE_ID", newRoleIdString);
        this.manager.updateRow("t_user_r_role", "ROLE_ID", String.valueOf(drRoleId), "ROLE_ID", newRoleIdString);
    }

    private void modifyUser(Connection connect) throws Exception {
        HashSet<Long> localeUserIds = new HashSet<Long>(LocaleDBUtil.queryIds(connect, "t_user", "USER_ID"));
        List<String> tableUserIds = this.manager.getColumnValues("t_user", "USER_ID");
        HashSet<Long> tableIdSet = new HashSet<Long>(this.manager.convertToLong(tableUserIds));
        HashSet<String> localeUserNames = new HashSet<String>(LocaleDBUtil.queryDataBySql(connect, "t_user", "USER_NAME", null, null));
        HashSet<String> tableUserNames = new HashSet<String>(this.manager.getColumnValues("t_user", "USER_NAME"));
        List<StringBuilder> users = this.cacheData.get("t_user");
        if (null == users || users.size() < 2) {
            logger.info((Object)"user is empty");
            return;
        }
        int userNameIndexInUsers = this.manager.getColumnIndex("t_user", "USER_NAME");
        int userIdIndexInUsers = this.manager.getColumnIndex("t_user", "USER_ID");
        for (int i = 1; i < users.size(); ++i) {
            StringBuilder userBuilder = users.get(i);
            String[] userRowDatas = userBuilder.toString().split("\\t|\\\\t");
            long drUserId = Long.parseLong(userRowDatas[userIdIndexInUsers]);
            if (localeUserIds.contains(drUserId)) {
                String newUserIdString;
                Long newUserId = this.retryAvailableId(localeUserIds, drUserId, tableIdSet);
                localeUserIds.add(newUserId);
                userRowDatas[userIdIndexInUsers] = newUserIdString = String.valueOf(newUserId);
                this.modifyAssociationUsers(drUserId, newUserIdString);
            }
            if (localeUserNames.contains(userRowDatas[userNameIndexInUsers])) {
                String newUserName = this.retryAvailableName(localeUserNames, userRowDatas[userNameIndexInUsers], 64, tableUserNames);
                localeUserNames.add(newUserName);
                userRowDatas[userNameIndexInUsers] = newUserName;
            }
            this.manager.rebuildBuilder(userBuilder, userRowDatas);
        }
        this.modifyDBSeq("t_user", localeUserIds);
    }

    private void modifyAssociationUsers(long drUserId, String newUserIdString) {
        this.manager.updateRow("ti_user_r_biz", "USERID", String.valueOf(drUserId), "USERID", newUserIdString);
        this.manager.updateRow("t_user_r_role", "USER_ID", String.valueOf(drUserId), "USER_ID", newUserIdString);
        this.manager.updateRow("t_user_acl", "USER_ID", String.valueOf(drUserId), "USER_ID", newUserIdString);
        this.manager.updateRow("t_user_customsetting", "USER_ID", String.valueOf(drUserId), "USER_ID", newUserIdString);
    }

    private String retryAvailableName(Set<String> localeDbNames, String needReplaceName, int len, Set<String> tableNames) {
        tableNames.remove(needReplaceName);
        String name = null;
        name = needReplaceName.length() + 7 < len ? needReplaceName + "_dr" : needReplaceName.substring(0, needReplaceName.length() - 7) + "_dr";
        int i = 1;
        String tempName = name;
        while (localeDbNames.contains(tempName) || tableNames.contains(tempName)) {
            tempName = name + String.valueOf(i);
            ++i;
        }
        return tempName;
    }

    private Long retryAvailableId(Set<Long> localeUserIds, Long num, Set<Long> tableUserIds) {
        tableUserIds.remove(num);
        while (localeUserIds.contains(num) || tableUserIds.contains(num)) {
            Long l = num;
            Long l2 = num = Long.valueOf(num + 1L);
        }
        return num;
    }

    private void removeSystemDefault() {
        this.removeSysUser();
        this.removeSysRole();
    }

    private void removeSysRole() {
        String administratorId = this.manager.getColumnValue("t_role", "ROLE_NAME", "administrator", "ROLE_ID");
        this.manager.deleteRow("t_role", "ROLE_NAME", "administrator");
        String operatorId = this.manager.getColumnValue("t_role", "ROLE_NAME", "operator", "ROLE_ID");
        this.manager.deleteRow("t_role", "ROLE_NAME", "operator");
        String auditorId = this.manager.getColumnValue("t_role", "ROLE_NAME", "auditor", "ROLE_ID");
        this.manager.deleteRow("t_role", "ROLE_NAME", "auditor");
        String NBIRoleId = this.manager.getColumnValue("t_role", "ROLE_NAME", "NBIRole", "ROLE_ID");
        this.manager.deleteRow("t_role", "ROLE_NAME", "NBIRole");
        this.manager.deleteRow("t_operation_r_role", "ROLE_ID", administratorId, operatorId, auditorId, NBIRoleId);
    }

    private void removeSysUser() {
        String adminId = this.manager.getColumnValue("t_user", "USER_NAME", "admin", "USER_ID");
        this.manager.deleteRow("t_user", "USER_NAME", "admin");
        this.manager.deleteRow("t_user_acl", "ACL_ID", adminId);
        String sycadminId = this.manager.getColumnValue("t_user", "USER_NAME", "SyncAdmin", "USER_ID");
        this.manager.deleteRow("t_user", "USER_NAME", "SyncAdmin");
        this.manager.deleteRow("t_user_acl", "ACL_ID", sycadminId);
    }

    private void replaceOpenstackUuid(Connection connect) throws Exception {
        String openstackUuid = LocaleDBUtil.getOpenstackUuid(connect);
        String openstackMoid = this.manager.getColumnValue("ti_fusionsphereopenstack", null, null, "MO_ID");
        this.cacheData.remove("ti_fusionsphereopenstack");
        String drOpenstackUuid = this.manager.getColumnValue("t_managedobject", "MOID", openstackMoid, "UUID");
        this.cacheData.remove("t_managedobject");
        this.manager.replaceAll(drOpenstackUuid + ":", openstackUuid + ":");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataFromDRDBFile(File tarFile) throws Exception {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(tarFile));
            String line = null;
            String tableName = null;
            boolean start = false;
            ArrayList<StringBuilder> tempList = null;
            while (null != (line = reader.readLine())) {
                if (line.startsWith("COPY") && null != (tableName = this.matchTarget(line))) {
                    start = true;
                    tempList = new ArrayList<StringBuilder>();
                    tempList.add(new StringBuilder(line));
                    continue;
                }
                if (start && line.equals("\\.")) {
                    this.cacheData.put(tableName, (List<StringBuilder>)tempList);
                    tableName = null;
                    start = false;
                }
                if (!start) continue;
                tempList.add(new StringBuilder(line));
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }

    private String matchTarget(String line) {
        String temp = line.substring(5).toLowerCase();
        for (String lineStart : this.tarLineSign) {
            if (!temp.startsWith(lineStart + " (")) continue;
            return lineStart;
        }
        return null;
    }
}

