/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cloud.service.merge.manager.impl;

import com.huawei.lego.common.cloud.service.merge.manager.ITableNanager;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TableManagerImpl
implements ITableNanager {
    private static Log logger = LogFactory.getInstance(TableManagerImpl.class);
    private Map<String, List<StringBuilder>> cacheData;

    public TableManagerImpl(Map<String, List<StringBuilder>> cacheData) {
        this.cacheData = cacheData;
    }

    @Override
    public void updateRow(String tableName, String conditionColumnName, String conditionColumnValue, String tarColumnName, String newColumnValue) {
        int conditionColumnIndex = this.getColumnIndex(tableName, conditionColumnName);
        int tarColumnIndex = this.getColumnIndex(tableName, tarColumnName);
        List<StringBuilder> tarTable = this.cacheData.get(tableName);
        if (null == tarTable || tarTable.size() < 2) {
            logger.info((Object)"tarTable is empty");
            return;
        }
        for (int i = 1; i < tarTable.size(); ++i) {
            StringBuilder rowBuilder = tarTable.get(i);
            String[] rowDatas = rowBuilder.toString().split("\\t|\\\\t");
            if (null != conditionColumnValue && !conditionColumnValue.equals(rowDatas[conditionColumnIndex])) continue;
            rowDatas[tarColumnIndex] = newColumnValue;
            this.rebuildBuilder(rowBuilder, rowDatas);
        }
    }

    @Override
    public void deleteRow(String tableName, String conditionColumnName, String ... conditionColumnValue) {
        int conditionColumnIndex = this.getColumnIndex(tableName, conditionColumnName);
        ArrayList<StringBuilder> tobeDelete = new ArrayList<StringBuilder>();
        List<StringBuilder> tarTable = this.cacheData.get(tableName);
        if (null == tarTable || tarTable.size() < 2) {
            logger.info((Object)"tarTable is empty");
            return;
        }
        for (int i = 1; i < tarTable.size(); ++i) {
            StringBuilder rowBuilder = tarTable.get(i);
            String[] rowDatas = rowBuilder.toString().split("\\t|\\\\t");
            for (int j = 0; j < conditionColumnValue.length; ++j) {
                if (!conditionColumnValue[j].equals(rowDatas[conditionColumnIndex])) continue;
                tobeDelete.add(rowBuilder);
            }
        }
        for (StringBuilder delete : tobeDelete) {
            tarTable.remove(delete);
        }
    }

    @Override
    public int getColumnIndex(String tableName, String columnName) {
        List<StringBuilder> table = this.cacheData.get(tableName);
        if (null == table || table.size() < 1) {
            logger.error((Object)("can't get column index , tableName is" + tableName + " , columnName is " + columnName));
            throw new PatchException("get columnIndex error .");
        }
        Integer columnIndex = null;
        String tableHeader = this.getColumnsString(table.get(0).toString());
        String[] tableHeaders = tableHeader.split(", ");
        for (int i = 0; i < tableHeaders.length; ++i) {
            if (!tableHeaders[i].equals(columnName)) continue;
            columnIndex = i;
            break;
        }
        if (null == columnIndex) {
            logger.error((Object)("can't get column index , tableName is" + tableName + " , columnName is " + columnName));
            throw new PatchException("get columnIndex error .");
        }
        return columnIndex;
    }

    @Override
    public String getColumnsString(String line) {
        return line.substring(line.indexOf("(") + 1, line.indexOf(")"));
    }

    @Override
    public void rebuildBuilder(StringBuilder builder, String[] rowDatas) {
        builder.delete(0, builder.length());
        for (int i = 0; i < rowDatas.length; ++i) {
            builder.append(rowDatas[i]);
            if (i == rowDatas.length - 1) continue;
            builder.append("\\t");
        }
    }

    @Override
    public String getColumnValue(String tableName, String conditionColumnName, String conditionColumnValue, String tarColumnName) {
        List<StringBuilder> table = this.cacheData.get(tableName);
        if (null == table || table.size() < 2) {
            logger.error((Object)("can't get column value , tarcolumn name is " + tarColumnName + " ,conditionColumnName is " + conditionColumnName + " ,conditionColumnValue is " + conditionColumnValue + ", table name is " + tableName));
            throw new PatchException("get tarColumn value error .");
        }
        int tarColumnIndex = this.getColumnIndex(tableName, tarColumnName);
        if (null == conditionColumnValue) {
            String[] values = table.get(1).toString().split("\\t|\\\\t");
            return values[tarColumnIndex];
        }
        int conditionColumnIndex = this.getColumnIndex(tableName, conditionColumnName);
        for (int i = 1; i < table.size(); ++i) {
            String[] values = table.get(i).toString().split("\\t|\\\\t");
            if (!conditionColumnValue.equals(values[conditionColumnIndex])) continue;
            return values[tarColumnIndex];
        }
        logger.error((Object)("can't get column value , tarcolumn name is " + tarColumnName + " ,conditionColumnName is " + conditionColumnName + " ,conditionColumnValue is " + conditionColumnValue + ", table name is " + tableName));
        throw new PatchException("get tarColumn value error .");
    }

    @Override
    public List<String> getColumnValues(String tableName, String tarColumnName) {
        List<StringBuilder> table = this.cacheData.get(tableName);
        ArrayList<String> values = new ArrayList<String>();
        if (null == table || table.size() < 2) {
            return values;
        }
        int tarColumnIndex = this.getColumnIndex(tableName, tarColumnName);
        for (int i = 1; i < table.size(); ++i) {
            String[] vals = table.get(i).toString().split("\\t|\\\\t");
            values.add(vals[tarColumnIndex]);
        }
        return values;
    }

    @Override
    public List<Long> convertToLong(Collection<String> collection) {
        ArrayList<Long> values = new ArrayList<Long>();
        if (null == collection) {
            logger.info((Object)"collection is null");
            return values;
        }
        for (String string : collection) {
            values.add(Long.parseLong(string));
        }
        return values;
    }

    @Override
    public void replaceAll(String oldString, String newString) {
        Collection<List<StringBuilder>> datas = this.cacheData.values();
        for (List<StringBuilder> data : datas) {
            if (null == datas || datas.size() < 2) continue;
            for (int i = 1; i < data.size(); ++i) {
                StringBuilder builder = data.get(i);
                String row = builder.toString();
                String newRow = row.replaceAll(oldString, newString);
                builder.delete(0, builder.length());
                builder.append(newRow);
            }
        }
    }

    @Override
    public void remove(String tableName, List<StringBuilder> tobeDelete) {
        List<StringBuilder> table = this.cacheData.get(tableName);
        if (null == table) {
            return;
        }
        for (StringBuilder delete : tobeDelete) {
            table.remove(delete);
        }
    }
}

