/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cloud.service.merge.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ExportDataUtil {
    private static Log logger = LogFactory.getInstance(ExportDataUtil.class);

    public static boolean exportData() {
        try {
            DataBaseInfo dbInfo = ExportDataUtil.getInstallInfo();
            String currentPath = new File("").getCanonicalPath();
            String destFile = currentPath + File.separator + "dataExport.conf";
            File file = new File(destFile);
            if (file.exists()) {
                file.delete();
            }
            StringBuilder cmdStr = new StringBuilder();
            cmdStr.append("/usr/local/gaussdb/bin/gs_dump -h ");
            cmdStr.append(dbInfo.getDbHost());
            cmdStr.append(" -U ");
            cmdStr.append(dbInfo.getDbaUsername());
            cmdStr.append(" -W ");
            cmdStr.append(dbInfo.getDbaPassword());
            cmdStr.append(" -p ");
            cmdStr.append(dbInfo.getDbPort());
            cmdStr.append(" --pg-format lego -f ");
            cmdStr.append(destFile);
            return CmdUtil.execShellCmd(cmdStr.toString());
        }
        catch (Exception e) {
            logger.error((Object)("export data failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            return false;
        }
    }

    private static String decrypt(String data, String installPath) {
        String sp = File.separator;
        String appHome = installPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "conf" + sp + "wcc";
        try {
            KmcInstance.initComponent((String)appHome);
            return KmcInstance.decrypt((String)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DataBaseInfo getInstallInfo() {
        DataBaseInfo dbInfo = new DataBaseInfo();
        try {
            List list;
            String installFile = OSInformation.getInstalledFile();
            File file = new File(installFile);
            if (!file.exists()) {
                throw new PatchException("can not find the RDInstalled.xml");
            }
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(installFile);
            List pathList = document.selectNodes("/install/installpath");
            if (null != pathList && !pathList.isEmpty()) {
                Element ele = (Element)pathList.get(0);
                dbInfo.setServerInstallPath(ele.attributeValue("path"));
            }
            if (null != (list = document.selectNodes("/install/database")) && !list.isEmpty()) {
                Element ele = (Element)list.get(0);
                dbInfo.setDbHost(ele.attributeValue("dbhost"));
                dbInfo.setDbPort(ele.attributeValue("dbport"));
                dbInfo.setDbaUsername(ele.attributeValue("manageruserName"));
                dbInfo.setDbaPassword(ExportDataUtil.decrypt(ele.attributeValue("managerpassword"), dbInfo.getServerInstallPath()));
            }
            return dbInfo;
        }
        catch (Exception e) {
            logger.error((Object)("get installInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new LegoCheckedException("get installInfo failed");
        }
    }
}

