/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cloud.service.merge.util;

import com.huawei.lego.common.exception.PatchException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocaleDBUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> queryDataBySql(Connection connect, String tableName, String columnNameKey, String columnNameValue, String conditionName, String conditionValue) throws Exception {
        Statement statement = null;
        HashMap<String, String> datas = new HashMap<String, String>();
        try {
            StringBuilder sql = new StringBuilder("select tar." + columnNameKey + ", tar." + columnNameValue + " from " + tableName + " as tar");
            if (null != conditionName && null != conditionValue) {
                sql.append(" where tar." + conditionName + "=?");
                statement = connect.prepareStatement(sql.toString());
                statement.setObject(1, conditionValue);
            } else if (null != conditionName && null == conditionValue) {
                sql.append(" where tar." + conditionName + " is null");
                statement = connect.prepareStatement(sql.toString());
            } else {
                statement = connect.prepareStatement(sql.toString());
            }
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                datas.put(result.getString(1), result.getString(2));
            }
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> queryDataBySql(Connection connect, String tableName, String columnName, String conditionName, String conditionValue) throws Exception {
        Statement statement = null;
        ArrayList<String> datas = new ArrayList<String>();
        try {
            StringBuilder sql = new StringBuilder("select tar." + columnName + " from " + tableName + " as tar");
            if (null != conditionName) {
                sql.append(" where tar." + conditionName + "=?");
            }
            statement = connect.prepareStatement(sql.toString());
            if (null != conditionName) {
                statement.setObject(1, conditionValue);
            }
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                datas.add(result.getString(1));
            }
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> queryIds(Connection connect, String tableName, String columnName) throws Exception {
        Statement statement = null;
        ArrayList<Long> datas = new ArrayList<Long>();
        try {
            statement = connect.prepareStatement("select tar." + columnName + " from " + tableName + " as tar");
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                datas.add(result.getLong(1));
            }
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOpenstackUuid(Connection connect) throws Exception {
        PreparedStatement statement = null;
        String openstackUuid = null;
        try {
            statement = connect.prepareStatement("select mo.uuid from T_managedobject as mo where mo.moid in (select MO_ID from ti_fusionsphereopenstack)");
            ResultSet result = statement.executeQuery();
            result.next();
            openstackUuid = result.getString(1);
            if (null == openstackUuid || openstackUuid.trim().isEmpty()) {
                throw new PatchException("can't get locale openstack uuid .");
            }
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        return openstackUuid;
    }

    public static String getDevSn(Connection connect) throws Exception {
        return LocaleDBUtil.queryDataBySql(connect, "ti_dr_resource", "DEVICESN", "DISCRIMINATOR", "DrFusionSphereOpenStack").get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSiteId(Connection connect) throws Exception {
        PreparedStatement statement = null;
        String date = null;
        try {
            statement = connect.prepareStatement("select re.SITEID from ti_dr_resource as re where re.DISCRIMINATOR = 'DrFusionSphereOpenStack'");
            ResultSet result = statement.executeQuery();
            result.next();
            date = result.getString(1);
            if (null == date || date.trim().isEmpty()) {
                throw new PatchException("can't get locale site id .");
            }
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        return date;
    }

    public static Set<String> getLocaleRecoveryName(Connection connect) throws Exception {
        return new HashSet<String>(LocaleDBUtil.queryDataBySql(connect, "ti_recoveryplan", "PLANNAME", null, null));
    }

    public static Set<String> getLocaleProtectgroupName(Connection connect) throws Exception {
        return new HashSet<String>(LocaleDBUtil.queryDataBySql(connect, "ti_protectgroup", "PGNAME", null, null));
    }

    public static Set<Long> getLocaleUserCustomsetting(Connection connect) throws Exception {
        return new HashSet<Long>(LocaleDBUtil.queryIds(connect, "t_user_customsetting", "ID"));
    }

    public static Set<Long> getLocaleUserAcl(Connection connect) throws Exception {
        return new HashSet<Long>(LocaleDBUtil.queryIds(connect, "t_user_acl", "ACL_ID"));
    }
}

