/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cmd;

import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;

public class ImportConfig {
    private static final int KEY_LEN_MIN = 16;
    private static final int KEY_LEN_MAX = 112;
    private static final String IMPORT = "importKey";
    private static final String UPDATE = "updateKey";
    private static Log logger = LogFactory.getInstance(ImportConfig.class);

    public static void main(String[] args) {
        if (!ImportConfig.checkParams(args)) {
            SystemExitUtil.exitFail();
        }
        try {
            if (IMPORT.equals(args[0])) {
                WccEncryptor.getInstance().generateWorkKey(args[1]);
            } else if (UPDATE.equals(args[0])) {
                WccEncryptor.updateCrypt();
            } else {
                logger.warn((Object)"the key is not legal.");
            }
            SystemExitUtil.exitOK();
        }
        catch (Exception e) {
            logger.error((Object)("generate work key failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
    }

    private static boolean checkParams(String ... data) {
        if (data.length <= 0) {
            logger.error((Object)"the args is error.", "");
            return false;
        }
        if (IMPORT.equals(data[0]) && data.length < 2) {
            logger.error((Object)"import key param is error.", "");
            return false;
        }
        return true;
    }
}

