/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.extend;

import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.AESEncryptor;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class ExtendCommon {
    private static Log logger = LogFactory.getInstance(ExtendCommon.class);
    private static InstalledSystem system = null;
    private static Map<String, ProductBundles> installedBundle = null;
    private static String oldVersion = "";
    private static final String V1R3 = "V100R003C10";
    private static final String V1R3SPC200 = "V100R003C10SPC200";
    private static final String VR_NAME = "UltraVR";

    public static void setOldVersion(String oldVersion) {
        ExtendCommon.oldVersion = oldVersion;
    }

    public static boolean isR3Upgrade() {
        if (!oldVersion.contains(V1R3)) {
            return false;
        }
        if (oldVersion.contains(VR_NAME) && !oldVersion.contains(V1R3SPC200)) {
            logger.info((Object)"UltraVR V1R3C10SPC200", "");
            return false;
        }
        return true;
    }

    public static void setInstalledSystem() {
        system = InitInstalledXmlTool.getInstalledSystem();
        installedBundle = system.getPdMap();
    }

    public static void queryData(Connection connect, String querySql, String updateSql) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = InitSQL.executeSQLQuery(connect, querySql);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                ExtendCommon.updateData(connect, rs, updateSql);
            }
        }
        catch (PatchException ep) {
            logger.error((Object)"", (Throwable)ep, "");
            PatchException ex = new PatchException("", ep);
            throw ex;
        }
        catch (SQLException e) {
            logger.error((Object)("queryData failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchException ex = new PatchException("queryData failed");
            throw ex;
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("close faile: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateAssignedVmOsOptionsType(Connection connect) {
        Statement preparedStatement = null;
        int idIndex = 1;
        int propValueIndex = 2;
        try {
            String queryAssignedVm = "select ID, PROPVALUE from ti_assignedvm_prop where PROPNAME = 'vmMgrInfo';";
            String updateAssignedVm = "update ti_assignedvm_prop set PROPVALUE=? where ID=? and PROPNAME='vmMgrInfo';";
            preparedStatement = InitSQL.executeSQLQuery(connect, queryAssignedVm);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                String resultDecode;
                String id = rs.getString(idIndex);
                String propsValue = rs.getString(propValueIndex);
                JSONObject config = JSONObject.fromObject((Object)propsValue);
                String osOption = config.getString("osOption");
                if (VerifyUtil.isEmpty((String)osOption) || !AESEncryptor.encode(resultDecode = AESEncryptor.decode(osOption)).equals(osOption)) continue;
                osOption = WccEncryptor.encode(resultDecode);
                config.put((Object)"osOption", (Object)osOption);
                InitSQL.executeSQL(connect, updateAssignedVm, new Object[]{config.toString(), id});
            }
        }
        catch (PatchException ep) {
            try {
                logger.error((Object)String.format("update OsOptionsType failed: %s", ExceptionUtil.getErrorMessage((Throwable)ep)));
                throw ep;
                catch (SQLException e) {
                    logger.error((Object)String.format("update OsOptionsType failed: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                    PatchException ex = new PatchException("queryData failed");
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement == null) throw throwable;
                    preparedStatement.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.error((Object)String.format("close fail: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                throw throwable;
            }
        }
        try {
            if (preparedStatement == null) return;
            preparedStatement.close();
            return;
        }
        catch (SQLException e) {
            logger.error((Object)String.format("close fail: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateProtectGroupOsOptionsType(Connection connect) {
        Statement preparedStatement = null;
        int poIdIndex = 1;
        int propValueIndex = 2;
        try {
            String queryPo = "select POID, PROPVALUE from ti_po_prop where PROPNAME = 'vmMgrInfo';";
            String updatePo = "update ti_po_prop set PROPVALUE=? where POID=? and PROPNAME = 'vmMgrInfo';";
            preparedStatement = InitSQL.executeSQLQuery(connect, queryPo);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                String resultDecode;
                String poId = rs.getString(poIdIndex);
                String propsValue = rs.getString(propValueIndex);
                JSONObject config = JSONObject.fromObject((Object)propsValue);
                String osOption = config.getString("osOption");
                if (VerifyUtil.isEmpty((String)osOption) || !AESEncryptor.encode(resultDecode = AESEncryptor.decode(osOption)).equals(osOption)) continue;
                osOption = WccEncryptor.encode(resultDecode);
                config.put((Object)"osOption", (Object)osOption);
                InitSQL.executeSQL(connect, updatePo, new Object[]{config.toString(), poId});
            }
        }
        catch (PatchException ep) {
            try {
                logger.error((Object)String.format("update OsOptionsType failed: %s", ExceptionUtil.getErrorMessage((Throwable)ep)));
                throw ep;
                catch (SQLException e) {
                    logger.error((Object)String.format("update OsOptionsType failed: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                    PatchException ex = new PatchException("queryData failed");
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement == null) throw throwable;
                    preparedStatement.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.error((Object)String.format("close fail: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                throw throwable;
            }
        }
        try {
            if (preparedStatement == null) return;
            preparedStatement.close();
            return;
        }
        catch (SQLException e) {
            logger.error((Object)String.format("close fail: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
            return;
        }
    }

    public static void updateData(Connection connect, ResultSet rs, String sql) throws PatchException {
        try {
            String value = rs.getString(1);
            String key1 = rs.getString(2);
            String key2 = rs.getString(3);
            if (null != value && !"".equals(value) && AESEncryptor.encode(AESEncryptor.decode(value)).equals(value)) {
                String pw = WccEncryptor.encode(AESEncryptor.decode(value));
                InitSQL.executeSQL(connect, sql, new Object[]{pw, key1, key2});
            }
        }
        catch (SQLException e) {
            logger.error((Object)("update Data failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchException ex = new PatchException("update Data failed");
            throw ex;
        }
    }

    public static boolean isBundleInstalled(String bundleID) {
        boolean isInstalled = false;
        if (null == installedBundle || installedBundle.size() == 0) {
            return isInstalled;
        }
        if (installedBundle.containsKey(bundleID)) {
            isInstalled = true;
        }
        return isInstalled;
    }
}

