/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.ha;

import com.huawei.lego.common.ha.HAConfigEnum;
import com.huawei.lego.common.ha.HAConfigInfo;
import com.huawei.lego.common.ha.HAInfo;
import com.huawei.lego.common.ha.HaLinkNode;
import com.huawei.lego.common.ha.LinkInfo;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.util.ArrayList;

public class DisasterRecoveryData {
    private static Log logger = LogFactory.getInstance(DisasterRecoveryData.class);
    private boolean isEnable;
    private String drType;
    private HAConfigInfo haData;

    public DisasterRecoveryData() {
    }

    public DisasterRecoveryData(boolean isUpgrade) {
        if (!isUpgrade) {
            return;
        }
        String runPath = InitInstalledXmlTool.getInstallPath() + File.separator + "Runtime";
        String backPath = InitInstalledXmlTool.getInstallPath() + File.separator + "Runtime@tmp";
        if (new File(backPath).exists()) {
            runPath = backPath;
        }
        if (!new File(runPath + File.separator + "ha").exists()) {
            logger.info((Object)"can not find the ha path, single update ", "");
            this.setEnable(false);
            return;
        }
        HAConfigInfo haConfig = new HAConfigInfo();
        HAInfo haInfo = HAInfo.getHAInfo();
        if ("single".equals(haInfo.getCurrentType()) && "disable".equals(haInfo.getAsStatus())) {
            this.setEnable(false);
            return;
        }
        if ("single".equals(haInfo.getCurrentType()) && !"disable".equals(haInfo.getAsStatus())) {
            this.dealActiveStandby(haConfig, haInfo);
        } else if ("double".equals(haInfo.getCurrentType())) {
            this.setEnable(true);
            this.setDrType(HAConfigEnum.InstallTypeEnum.HA.getType());
        } else {
            logger.warn((Object)("type is not legal. type:" + haInfo.getCurrentType()), "");
        }
    }

    private void dealActiveStandby(HAConfigInfo haConfig, HAInfo haInfo) {
        this.setEnable(true);
        this.setDrType(HAConfigEnum.InstallTypeEnum.AS.getType());
        haConfig.setRole(haInfo.getAsStatus());
        ArrayList<LinkInfo> linkList = new ArrayList<LinkInfo>();
        for (HaLinkNode node : haInfo.getSyncList()) {
            LinkInfo link = new LinkInfo();
            link.setLocalIp(node.getLocalIp());
            link.setLocalPort(node.getLocalPort());
            link.setPeerIp(node.getPeerIp());
            link.setPeerPort(node.getPeerPort());
            link.setName(HAConfigEnum.CONFIG_ENUM.SYNC.getConfigLab());
            linkList.add(link);
        }
        haConfig.setLinkInfo(linkList);
        this.setHaData(haConfig);
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public String getDrType() {
        return this.drType;
    }

    public HAConfigInfo getHaData() {
        return this.haData;
    }

    public void setEnable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public void setDrType(String drType) {
        this.drType = drType;
    }

    public void setHaData(HAConfigInfo haData) {
        this.haData = haData;
    }
}

