/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.ha;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.ha.HaLinkNode;
import com.huawei.lego.common.install.InstallCommon;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class HAInfo {
    private static final String SP = "\n";
    private static final String HEARTNODE = "/haarb/link/ippair/node";
    private static final String SYNCNODE = "/hasync/link/ippair/node";
    private static final int EXIT_FAIL = 1;
    private static final int EXIT_SUCC = 0;
    private static final Log logger = LogFactory.getInstance(HAInfo.class);
    private static HAInfo haInfo = null;
    private static String INSTALLPATH = "";
    private String currentType;
    private String status;
    private String asStatus = "disable";
    private String floatIP;
    private String floatIP2;
    private String localName;
    private String remoteName;
    private String gwLink;
    private List<HaLinkNode> heartList = new ArrayList<HaLinkNode>();
    private List<HaLinkNode> syncList = new ArrayList<HaLinkNode>();

    private HAInfo() {
        this.initCommonInfo();
        if ("double".equals(this.getCurrentType())) {
            this.getHAStatus();
            this.getGateWayAndFloatIP();
            this.getNodeName();
            String arbFile = INSTALLPATH + "/ha/module/haarb/conf/haarb.xml";
            String syncFile = INSTALLPATH + "/ha/module/hasync/conf/hasync.xml";
            this.setHeartList(this.getLinkInfo(arbFile, HEARTNODE));
            this.setSyncList(this.getLinkInfo(syncFile, SYNCNODE));
        } else if (!"disable".equals(this.getAsStatus())) {
            this.getNodeName();
            String syncFile = INSTALLPATH + "/ha/module/hasync/conf/hasync.xml";
            this.setSyncList(this.getLinkInfo(syncFile, SYNCNODE));
        } else {
            logger.debug((Object)("type:" + this.getCurrentType()));
        }
    }

    public static HAInfo getHAInfo() {
        if (null == haInfo) {
            haInfo = new HAInfo();
        }
        return haInfo;
    }

    public String getFloatIP2() {
        return this.floatIP2;
    }

    public void setFloatIP2(String floatIP2) {
        this.floatIP2 = floatIP2;
    }

    public boolean isSingleHA() {
        boolean isSingle = true;
        if (!"single".equalsIgnoreCase(this.getCurrentType())) {
            isSingle = false;
        }
        return isSingle;
    }

    private void getHAStatus() {
        String locaConfig = INSTALLPATH + "/ha/local/haarb/conf/haarb_local.xml";
        File file = new File(locaConfig);
        if (!file.exists()) {
            throw new PatchException("getHAStatus failed, hararb_local.xml not found.");
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            Element local = (Element)document.selectSingleNode("/haarb/harole");
            String status = local.attributeValue("value");
            if ("1".equals(status)) {
                this.setStatus("active");
            } else if ("2".equals(status)) {
                this.setStatus("standby");
            } else {
                this.setStatus("unknown");
            }
        }
        catch (Exception e) {
            throw new PatchException("getNodeName failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private void getGateWayAndFloatIP() {
        String gwConfigFile = INSTALLPATH + "/ha/module/haarb/conf/haarb.xml";
        File file = new File(gwConfigFile);
        if (!file.exists()) {
            throw new PatchException("getGateWayAndFloatIP failed, haarb.xml not exists");
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            StringBuffer buffer = new StringBuffer();
            Document document = reader.read(file);
            List eleList = document.selectNodes("/haarb/gateway/ip");
            if (null != eleList && eleList.size() > 0) {
                for (Node ele : eleList) {
                    HAInfo.checkIP(((Element)ele).attributeValue("value"));
                    buffer.append(((Element)ele).attributeValue("value"));
                    buffer.append(",");
                }
                this.setGwLink(buffer.toString().substring(0, buffer.toString().length() - 1));
            }
            List floatList = document.selectNodes("/haarb/arp/arpip");
            for (int i = 0; i < floatList.size(); ++i) {
                String ip = ((Element)floatList.get(i)).attributeValue("value");
                HAInfo.checkIP(ip);
                if (i == 0) {
                    this.setFloatIP(ip);
                }
                if (i != 1) continue;
                this.setFloatIP2(ip);
            }
        }
        catch (Exception e) {
            throw new PatchException("getGatewayIp failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private void getNodeName() {
        String locaConfig = INSTALLPATH + "/ha/local/hacom/conf/hacom_local.xml";
        File file = new File(locaConfig);
        if (!file.exists()) {
            throw new PatchException("getNodeName failed, file not exists: " + file.getName());
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            Element local = (Element)document.selectSingleNode("/hacom/local");
            HAInfo.checkNodeName(local.attributeValue("name"));
            this.setLocalName(local.attributeValue("name"));
            Element peer = (Element)document.selectSingleNode("/hacom/peer");
            HAInfo.checkNodeName(peer.attributeValue("name"));
            this.setRemoteName(peer.attributeValue("name"));
        }
        catch (Exception e) {
            throw new PatchException("getNodeName failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private static void checkPort(String port) {
        if (!port.matches("\\d{4,5}") || Integer.parseInt(port) < 1024 || Integer.parseInt(port) > 65535) {
            throw new PatchException("check port failed: " + port);
        }
    }

    private static void checkIP(String ipstr) {
        if (!ParamCheck.checkIpAddress(ipstr)) {
            throw new PatchException("ip is invalied: " + ipstr);
        }
    }

    private static void checkNodeName(String name) {
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_-]{1,39}");
        Matcher matcher = pattern.matcher(Normalizer.normalize(name, Normalizer.Form.NFKC));
        if (!matcher.matches()) {
            throw new PatchException("name is invalied: " + name);
        }
    }

    private List<HaLinkNode> getLinkInfo(String configFile, String nodes) {
        File file = new File(configFile);
        if (!file.exists()) {
            throw new PatchException("getLinkInfo failed, file not exists: " + file.getName());
        }
        ArrayList<HaLinkNode> linkList = new ArrayList<HaLinkNode>();
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            String parentNode = nodes.substring(0, nodes.lastIndexOf("/"));
            String sonNode = nodes.substring(nodes.lastIndexOf("/") + 1);
            List eleList = document.selectNodes(parentNode);
            for (Node ele : eleList) {
                HaLinkNode node = new HaLinkNode();
                node.setParentNode(parentNode);
                node.setSonNode(sonNode);
                List sNodeList = ele.selectNodes(sonNode);
                for (Node sEle : sNodeList) {
                    HAInfo.checkNodeName(((Element)sEle).attributeValue("name"));
                    HAInfo.checkIP(((Element)sEle).attributeValue("ip"));
                    HAInfo.checkPort(((Element)sEle).attributeValue("port"));
                    if (this.localName.equals(((Element)sEle).attributeValue("name"))) {
                        node.setLocalName(((Element)sEle).attributeValue("name"));
                        node.setLocalIp(((Element)sEle).attributeValue("ip"));
                        node.setLocalPort(((Element)sEle).attributeValue("port"));
                        continue;
                    }
                    node.setPeerName(((Element)sEle).attributeValue("name"));
                    node.setPeerIp(((Element)sEle).attributeValue("ip"));
                    node.setPeerPort(((Element)sEle).attributeValue("port"));
                }
                linkList.add(node);
            }
            return linkList;
        }
        catch (Exception e) {
            throw new PatchException("getHeartLink failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private void initCommonInfo() {
        String haPath = INSTALLPATH + "/ha";
        if (!new File(haPath).exists()) {
            logger.info((Object)"ha path is not exists, return single ha", "");
            this.setCurrentType("single");
            return;
        }
        String configFile = INSTALLPATH + "/ha/module/hacom/conf/hacom.xml";
        File file = new File(configFile);
        if (!file.exists()) {
            throw new PatchException("initCommonInfo failed, hacom.xml not exists");
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            Element ele1 = (Element)document.selectSingleNode("/hacom/hamode");
            this.setCurrentType(ele1.attribute("value").getText());
            Element ele2 = (Element)document.selectSingleNode("/hacom/cascade");
            if (null != ele2) {
                this.setAsStatus(ele2.attribute("value").getText());
            }
        }
        catch (Exception e) {
            throw new PatchException("get ha type failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public String getCurrentType() {
        return this.currentType;
    }

    public void setCurrentType(String currentType) {
        this.currentType = currentType;
    }

    public String getFloatIP() {
        return this.floatIP;
    }

    public String getHeartLink() {
        StringBuffer heartLink = new StringBuffer();
        for (HaLinkNode node : this.getHeartList()) {
            heartLink.append(node.getLocalName() + ":" + InstallCommon.getFormatIp(node.getLocalIp()) + ":" + node.getLocalPort());
            heartLink.append(",");
            heartLink.append(node.getPeerName() + ":" + InstallCommon.getFormatIp(node.getPeerIp()) + ":" + node.getPeerPort());
            heartLink.append(";");
        }
        String link = heartLink.toString();
        if (link.endsWith(";")) {
            link = link.substring(0, link.lastIndexOf(";"));
        }
        return link;
    }

    public String getSyncLink() {
        StringBuffer syncLink = new StringBuffer();
        for (HaLinkNode node : this.getSyncList()) {
            syncLink.append(node.getLocalName() + ":" + InstallCommon.getFormatIp(node.getLocalIp()) + ":" + node.getLocalPort());
            syncLink.append(",");
            syncLink.append(node.getPeerName() + ":" + InstallCommon.getFormatIp(node.getPeerIp()) + ":" + node.getPeerPort());
            syncLink.append(";");
        }
        String link = syncLink.toString();
        if (link.endsWith(";")) {
            link = link.substring(0, link.lastIndexOf(";"));
        }
        return link;
    }

    public String getGwLink() {
        return this.gwLink;
    }

    public void setFloatIP(String floatIP) {
        this.floatIP = floatIP;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public List<HaLinkNode> getHeartList() {
        return this.heartList;
    }

    public List<HaLinkNode> getSyncList() {
        return this.syncList;
    }

    public void setHeartList(List<HaLinkNode> heartList) {
        this.heartList = heartList;
    }

    public void setSyncList(List<HaLinkNode> syncList) {
        this.syncList = syncList;
    }

    public void setGwLink(String gwLink) {
        this.gwLink = gwLink;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAsStatus() {
        return this.asStatus;
    }

    public void setAsStatus(String asStatus) {
        this.asStatus = asStatus;
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        msg.append("HA mode: " + this.getCurrentType());
        if ("double".equals(this.getCurrentType())) {
            msg.append(", HA status: " + this.getStatus()).append(", HA floatip1: " + this.getFloatIP()).append(", HA floatip2: " + this.getFloatIP2()).append(", gateway: " + this.getGwLink()).append(", heart: " + this.getHeartLink()).append(", local name: " + this.getLocalName()).append(", peer name: " + this.getRemoteName()).append(", sync: " + this.getSyncLink());
        }
        return msg.toString();
    }

    private static String getLinkInfo(List<HaLinkNode> nodeList) {
        StringBuffer msg = new StringBuffer();
        for (HaLinkNode node : nodeList) {
            msg.append(node.getLocalIp());
            msg.append(":");
            msg.append(node.getLocalPort());
            msg.append(",");
            msg.append(node.getPeerIp());
            msg.append(":");
            msg.append(node.getPeerPort());
            msg.append(";");
        }
        return msg.toString();
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new PatchException("need a file, args.length=" + args.length);
            }
            HAInfo haInfo = HAInfo.getHAInfo();
            if (haInfo.isSingleHA()) {
                logger.info((Object)"current is single ha, no need display ha info while upgrading.", "");
                return;
            }
            StringBuffer msg = new StringBuffer();
            msg.append("HaMode=" + haInfo.getCurrentType() + SP);
            msg.append("HaLocalName=" + haInfo.getLocalName() + SP);
            msg.append("HaPeerName=" + haInfo.getRemoteName() + SP);
            msg.append("HaArbLk=" + HAInfo.getLinkInfo(haInfo.getHeartList()) + SP);
            msg.append("HaSyncLk=" + HAInfo.getLinkInfo(haInfo.getSyncList()) + SP);
            String floatIp = haInfo.getFloatIP();
            if (!VerifyUtil.isEmpty((String)haInfo.getFloatIP2())) {
                floatIp = floatIp + "," + haInfo.getFloatIP2();
            }
            msg.append("HaArpLk=" + floatIp + SP);
            msg.append("HaGwLk=" + haInfo.getGwLink() + SP);
            FileUtil.writeFile(args[0], msg.toString());
        }
        catch (Exception e) {
            logger.error((Object)("get ha info failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            System.exit(1);
        }
        logger.info((Object)"get ha info successful.", "");
        System.exit(0);
    }

    static {
        String installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
        INSTALLPATH = installPath + "/Runtime";
        if (new File(installPath + "/Runtime@tmp").exists()) {
            INSTALLPATH = installPath + "/Runtime@tmp";
        }
    }
}

