/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.install;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.DataBaseUtil;
import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.util.dbtool.InitDBTool;
import com.huawei.drm.install.common.util.dbtool.UninstallDBTool;
import com.huawei.lego.cli.update.NeedInstallBundles;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.extend.IextendCallBack;
import com.huawei.lego.common.ha.HAConfigEnum;
import com.huawei.lego.common.ha.HAConfigInfo;
import com.huawei.lego.common.ha.LinkInfo;
import com.huawei.lego.common.install.InstallCommon;
import com.huawei.lego.common.install.NetWorkPanel;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.InitInstallScript;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.common.util.dbtool.ChangeDbInforInJar;
import com.huawei.lego.common.util.dbtool.GaussDBUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class Install {
    protected static final int STEP1_MAXNUMBER = 10;
    protected static final int STEP2_MAXNUMBER = 15;
    protected static final int STEP3_MAXNUMBER = 30;
    protected static final int STEP4_MAXNUMBER = 40;
    protected static final int STEP5_MAXNUMBER = 50;
    protected static final int STEP6_MAXNUMBER = 70;
    protected static final int STEP7_MAXNUMBER = 75;
    protected static final int STEP8_MAXNUMBER = 80;
    protected static final int STEP9_MAXNUMBER = 90;
    protected static final int STEP10_MAXNUMBER = 100;
    protected static final int SLOW = 1000;
    protected static final int FAST = 50;
    private static final int MB = 1024;
    private static final String STATE_COLUME = "STATE";
    private static final String BASE_PATH = InstallConstant.getsBasePath();
    private static final String LINE_SP = "\n";
    private static Log logger = LogFactory.getInstance(Install.class);
    private String installPath;

    public Install(String installPath) {
        this.installPath = installPath;
    }

    public void process() {
        logger.info((Object)"enter install process.", "");
        try {
            this.installDatabase();
            this.installBase();
            this.installProduct();
            this.changeConfigFile();
            this.executeSystemScript();
            this.initDBData();
            this.executeProductExtend();
            if (OSInformation.isLinux()) {
                this.isInterrupted();
                this.installHASoft();
            }
            this.endProcess();
            this.dealwithInstallSucc();
        }
        catch (InstallException e) {
            logger.error((Object)("install failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            if (e.getErrorCode() <= 0L) {
                e.setErrorCode(20005L);
            }
            this.dealwithInstallFail(e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("install failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            InstallException exception = new InstallException(20005L);
            this.dealwithInstallFail(exception);
            throw exception;
        }
    }

    private void installHASoft() {
        InstallCommon.installHASoft(this.installPath, false);
    }

    private void writeConfig(String message) {
        try {
            String currPath = new File("").getCanonicalPath();
            String confFile = currPath + File.separator + "ha" + File.separator + "haconfig.conf";
            File file = new File(confFile);
            if (file.exists()) {
                logger.info((Object)("delete tmpfile: " + file.delete()), "");
            }
            FileWriter write = null;
            try {
                write = new FileWriter(file);
                write.write(message);
                write.flush();
            }
            catch (IOException e) {
                logger.error((Object)("write config file failed: " + e), "");
                throw new InstallException("write HA config failed.");
            }
            finally {
                this.releaseStream(write);
            }
        }
        catch (IOException e) {
            logger.error((Object)("get path failed: " + e), "");
            throw new InstallException("write HA config failed.");
        }
    }

    private String getFormatIp(String addr) {
        String address = addr;
        if (VerifyUtil.isEmpty((String)addr)) {
            return address;
        }
        if (addr.contains(":")) {
            address = "[" + addr + "]";
        }
        return address;
    }

    private void initHAConfig(HAConfigInfo haParam) {
        StringBuffer buff = new StringBuffer();
        String localName = haParam.getMasterName();
        String peerName = haParam.getSpareName();
        buff.append("MODE=HA\n");
        buff.append("LOCALROLE=" + haParam.getRole() + LINE_SP);
        buff.append("LOCALNAME=" + localName + LINE_SP);
        buff.append("PEERNAME=" + peerName + LINE_SP);
        StringBuffer heartBeat = new StringBuffer();
        StringBuffer sync = new StringBuffer();
        for (LinkInfo info : haParam.getLinkInfo()) {
            if (info.getName().startsWith(HAConfigEnum.CONFIG_ENUM.HEART.getConfigLab())) {
                heartBeat.append(info.getLocalName()).append(":").append(this.getFormatIp(info.getLocalIp())).append(":").append(info.getLocalPort()).append(",").append(info.getPeerName()).append(":").append(this.getFormatIp(info.getPeerIp())).append(":").append(info.getPeerPort()).append(";");
            }
            if (!info.getName().startsWith(HAConfigEnum.CONFIG_ENUM.SYNC.getConfigLab())) continue;
            sync.append(info.getLocalName()).append(":").append(this.getFormatIp(info.getLocalIp())).append(":").append(info.getLocalPort()).append(",").append(info.getPeerName()).append(":").append(this.getFormatIp(info.getPeerIp())).append(":").append(info.getPeerPort()).append(";");
        }
        if (heartBeat.toString().endsWith(";")) {
            heartBeat.deleteCharAt(heartBeat.length() - 1);
        }
        if (sync.toString().endsWith(";")) {
            sync.deleteCharAt(sync.length() - 1);
        }
        buff.append("HERTBEAT=" + heartBeat.toString() + LINE_SP);
        buff.append("SYNC=" + sync.toString() + LINE_SP);
        StringBuffer gateway = new StringBuffer();
        for (LinkInfo gStr : haParam.getLinkInfo()) {
            if (!gStr.getName().startsWith(HAConfigEnum.CONFIG_ENUM.GW.getConfigLab())) continue;
            gateway.append(gStr.getGwIp()).append(",");
        }
        if (gateway.toString().endsWith(",")) {
            gateway.deleteCharAt(gateway.length() - 1);
        }
        buff.append("GATEWAY=" + gateway.toString() + LINE_SP);
        if (VerifyUtil.isEmpty((String)haParam.getFloatIP2())) {
            buff.append("FLOATIP=" + haParam.getFloatIP() + LINE_SP);
        } else {
            buff.append("FLOATIP=" + haParam.getFloatIP() + "," + haParam.getFloatIP2() + LINE_SP);
        }
        logger.info((Object)("Str: " + buff.toString()), "");
        this.writeConfig(buff.toString());
    }

    private void dealwithInstallSucc() {
        SystemPrint.systemPrintStr("Installation is completed.\n\n*************Install Succeed!*************\n\n");
    }

    private void installRollback() {
        logger.info((Object)"start install rollback.", "");
        try {
            CmdUtil.runInstallScript(InitInstallScript.getInstance().getRollbackScript());
            FileUtil.deleteFile(OSInformation.getInstalledFile());
            try {
                try {
                    GaussDBUtil.stopGaussDatabase();
                }
                catch (Exception e) {
                    logger.error((Object)("stop db failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
                GaussDBUtil.unInstallGaussDB();
                if (OSInformation.isLinux()) {
                    String rmServiceFileName = BASE_PATH + "/Runtime/bin/rmService.sh";
                    SignVerifier.getInstance().verify(rmServiceFileName);
                    CmdUtil.runShell(rmServiceFileName, new String[0]);
                } else {
                    String rmServiceFileName = this.installPath + File.separator + "Runtime" + File.separator + "bin" + File.separator + "rdShortcut.bat";
                    if (new File(rmServiceFileName).exists()) {
                        CmdUtil.runbatParams(rmServiceFileName, null);
                    }
                }
                FileUtil.deleteAllFolder(new File(this.installPath + File.separator + LegoResourceManager.getProValue("install.lego_version.platform.name")));
            }
            catch (Exception e) {
                logger.error((Object)("uninstall gaussdb failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
        catch (Exception e) {
            logger.error((Object)("rollback failed, errMsg= " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private void dealwithInstallFail(InstallException exp) {
        if (exp.getErrorCode() != 20008L) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.INSTALL.FAILED", LegoResourceManager.getProValue("software.install.name")));
        }
        try {
            this.installRollback();
        }
        catch (Exception e) {
            logger.error((Object)("install rollback failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private void endProcess() {
        this.isInterrupted();
        try {
            this.cleanInstalledFile();
        }
        catch (Exception e) {
            logger.error((Object)("end process failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private void initDBData() {
        this.isInterrupted();
        logger.info((Object)"start init db data.", "");
        try {
            DataBaseInfo dbInfo = this.getDBInfo();
            UninstallDBTool.uninstallDB(dbInfo, this.installPath);
            for (ProductBundles productBundles : this.getNeedInstalledBundle()) {
                InitDBTool.uninstallProductDB(dbInfo, productBundles.getId());
            }
            this.isInterrupted();
            InitDBTool.initPlatformDB(dbInfo);
            for (ProductBundles productBundles : this.getNeedInstalledBundle()) {
                this.isInterrupted();
                logger.info((Object)("start init product data, id=" + productBundles.getId()), "");
                String productPath = productBundles.getBundlePath();
                InitDBTool.initProductDB(dbInfo, productPath);
            }
            this.isInterrupted();
            UpdateUtil.dealGaussDBUserAuth();
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("init db data failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20012L);
        }
    }

    private void executeProductExtend() {
        this.isInterrupted();
        logger.info((Object)"start execute product extend process.", "");
        for (ProductBundles productBundles : this.getNeedInstalledBundle()) {
            String clzName = productBundles.getExtendCallBackClz();
            if (VerifyUtil.isEmpty((String)clzName)) continue;
            logger.info((Object)("Call product extend class :" + clzName), "");
            try {
                IextendCallBack callBack = (IextendCallBack)Class.forName(clzName).newInstance();
                callBack.callInstall();
            }
            catch (Exception e) {
                logger.info((Object)("execute product extend failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new InstallException(20013L);
            }
        }
    }

    private void changeConfigFile() {
        this.isInterrupted();
        this.generateInstalledFile();
        this.generateLicFile();
        InstallCommon.updatePortInI();
        this.savePathForLinux();
    }

    private void generateLicFile() {
        logger.info((Object)"begin generate license xml", "");
        XMLWriter output = null;
        FileOutputStream fos = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            String fileName = LegoResourceManager.getProValue("install.params.license.file");
            String userhomeOutPutPath = OSInformation.getUserHomePath() + File.separator + fileName;
            String installOutPutPath = this.installPath + File.separator + "Runtime" + File.separator + "LegoRuntime" + File.separator + "lic" + File.separator + fileName;
            if (new File(userhomeOutPutPath).exists()) {
                logger.info((Object)"Copy licfile start.", "");
                UpdateUtil.updateLicXml(userhomeOutPutPath);
                FileUtil.copyFile(userhomeOutPutPath, installOutPutPath);
                return;
            }
            Document document = DocumentHelper.createDocument();
            Element installElement = document.addElement("install");
            Element pathEle = installElement.addElement("lic");
            pathEle.addAttribute("sit", String.valueOf(System.currentTimeMillis()));
            fos = new FileOutputStream(userhomeOutPutPath);
            output = new XMLWriter((OutputStream)fos, format);
            output.write(document);
            FileUtil.copyFile(userhomeOutPutPath, installOutPutPath);
            this.releaseStream(output);
            this.releaseStream(fos);
        }
        catch (Exception e) {
            logger.error((Object)("Generate license xml Error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException("");
        }
        finally {
            this.releaseStream(output);
            this.releaseStream(fos);
        }
    }

    private void installBase() {
        this.isInterrupted();
        this.copyRuntimeFile();
        this.installPlatForm();
        this.changeDBConnectionInfo(this.getDBInfo());
        try {
            String backKeystore = this.installPath + File.separator + "Runtime" + LegoResourceManager.getProValue("install.platform.keystore");
            String tomcatKeystore = this.installPath + File.separator + "Runtime" + LegoResourceManager.getProValue("install.tomcat.keystore");
            if (!new File(backKeystore).exists()) {
                throw new InstallException("dealWithCerts, can not find the backend keystore.");
            }
            FileUtil.copyFile(backKeystore, tomcatKeystore);
        }
        catch (Exception e) {
            logger.error((Object)("copy bcm.keystore to tomcat.keystore failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException("");
        }
    }

    protected void copyRuntimeFile() {
        try {
            logger.info((Object)"start copy runtime file.", "");
            FileUtil.copyFolder(BASE_PATH + LegoResourceManager.getProValue("install.lego_version.platform.runtime"), this.installPath + File.separator + "Runtime");
            FileUtil.copyFolder(BASE_PATH + "/lib", this.installPath + "/Runtime/bin/lib");
            FileUtil.copyFolder(BASE_PATH + "/config", this.installPath + "/Runtime/bin/config");
        }
        catch (Exception e) {
            logger.error((Object)("copy runtime file failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20003L);
        }
    }

    private void installDatabase() {
        this.isInterrupted();
        try {
            logger.info((Object)"start install database.", "");
            GaussDBUtil.installGaussDB();
            GaussDBUtil.startGaussDB();
            GaussDBUtil.reinforceGaussDB();
        }
        catch (Exception e) {
            logger.error((Object)("install database failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20011L);
        }
    }

    protected void savePathForLinux() {
        OutputStreamWriter sWriter1 = null;
        if (OSInformation.isLinux()) {
            try {
                sWriter1 = new FileWriter(BASE_PATH + "/savePath.lego");
                sWriter1.write(this.installPath);
                sWriter1.flush();
            }
            catch (IOException e) {
                logger.error((Object)("savePathForLinux failed, errMsg: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            finally {
                if (null != sWriter1) {
                    try {
                        sWriter1.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("close failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                    }
                    sWriter1 = null;
                }
            }
        }
    }

    protected void installPlatForm() {
        logger.info((Object)"start install platform.", "");
        try {
            UpdateUtil.changeWccLogConfFile(this.installPath);
            logger.info((Object)"copy backend platform File Begin ", "");
            String oldwar = BASE_PATH + File.separator + "PlatFrom" + File.separator + "PlatForm_Front";
            String newwar = this.installPath + File.separator + LegoResourceManager.getProValue("install.lego_version.frontend.war.path");
            FileUtil.copyFolder(oldwar, newwar);
            Collection<PlatformBundles> collect = InitBundleXmlTool.initPlatFormBundls().values();
            String backFolder = BASE_PATH + File.separator + "PlatFrom" + File.separator + "PlatForm_BackEnd";
            for (PlatformBundles platformBundles : collect) {
                List<String> backEndJarList = platformBundles.getJarList();
                for (String string : backEndJarList) {
                    logger.info((Object)("start copy platform jar to backend: " + string), "");
                    String oldPath = backFolder + File.separator + string;
                    String newPath = this.installPath + File.separator + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + File.separator + string;
                    FileUtil.copyFile(oldPath, newPath);
                }
                List<String> frontEndJarList = platformBundles.getFrontJarList();
                for (String name3 : frontEndJarList) {
                    logger.info((Object)("start copy platform jar to tomcat: " + name3), "");
                    String oldPath = backFolder + File.separator + name3;
                    String newPath = this.installPath + File.separator + LegoResourceManager.getProValue("install.lego_version.frontend.jar.path") + File.separator + name3;
                    FileUtil.copyFile(oldPath, newPath);
                }
            }
            String oldSheetPath = BASE_PATH + LegoResourceManager.getProValue("install.uninstalldb.src");
            String newPath = this.installPath + File.separator + LegoResourceManager.getProValue("install.uninstalldb.target");
            FileUtil.copyFolder(oldSheetPath, newPath);
            String srcPath = BASE_PATH + File.separator + LegoResourceManager.getProValue("update.initdb.gauss");
            String destPath = this.installPath + File.separator + LegoResourceManager.getProValue("update.platform.initdb.path");
            FileUtil.copyFolder(srcPath, destPath);
            String string = BASE_PATH + LegoResourceManager.getProValue("default.gauss.script.source");
            String newGaussScriptPath = this.installPath + File.separator + LegoResourceManager.getProValue("default.gauss.script.target");
            FileUtil.copyFolder(string, newGaussScriptPath);
        }
        catch (Exception e) {
            logger.error((Object)("installPlatForm Error, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20003L);
        }
    }

    private NetWorkPanel getNetworkPanel() {
        return PrepareParamUtil.getsInstallDto().getNetWorkPanel();
    }

    private DataBaseInfo getDBInfo() {
        return PrepareParamUtil.getsInstallDto().getDbDto();
    }

    protected void generateInstalledFile() {
        XMLWriter output2 = null;
        XMLWriter output3 = null;
        XMLWriter output = null;
        FileWriter fos = null;
        FileWriter fos2 = null;
        FileWriter fos3 = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            String fileName = LegoResourceManager.getProValue("install.params.installed.file");
            String outPutPath = OSInformation.getInstalledFile();
            Document document = DocumentHelper.createDocument();
            Element installElement = document.addElement("install");
            Element pathEle = installElement.addElement("installpath");
            pathEle.addAttribute("path", this.installPath);
            InstallCommon.addInstalledXml(installElement, this.getNetworkPanel());
            DataBaseUtil.updateDatabaseConfig(this.installPath, this.getDBInfo());
            fos2 = new FileWriter(this.installPath + "/Runtime/bin/" + fileName);
            output2 = new XMLWriter((Writer)fos2, format);
            output2.write(document);
            fos3 = new FileWriter(this.installPath + "/Runtime/monitor/" + fileName);
            output3 = new XMLWriter((Writer)fos3, format);
            output3.write(document);
            this.generateInstallXMLOne(installElement);
            this.generateInstallXMLTwo(installElement);
            fos = new FileWriter(outPutPath);
            output = new XMLWriter((Writer)fos, format);
            output.write(document);
            logger.info((Object)("end generate installed xml" + fileName), "");
            this.releaseStream(output2);
            this.releaseStream(output3);
            this.releaseStream(output);
            this.releaseStream(fos);
            this.releaseStream(fos2);
            this.releaseStream(fos3);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Generate installed xml Error, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new InstallException("");
            }
            catch (Throwable throwable) {
                this.releaseStream(output2);
                this.releaseStream(output3);
                this.releaseStream(output);
                this.releaseStream(fos);
                this.releaseStream(fos2);
                this.releaseStream(fos3);
                throw throwable;
            }
        }
    }

    private void generateInstallXMLOne(Element installElement) {
        for (PlatformBundles ptBundle : this.getPlatformBundleInfo()) {
            Element pdEleTmp = installElement.addElement("platform");
            pdEleTmp.addAttribute("id", ptBundle.getId());
            pdEleTmp.addAttribute("version", ptBundle.getVersion());
            pdEleTmp.addAttribute("name", ptBundle.getName());
            pdEleTmp.addAttribute("required", Boolean.toString(ptBundle.isNeeded()));
            pdEleTmp.addAttribute("description", ptBundle.getDescription());
            pdEleTmp.addAttribute("size", ptBundle.getSize());
            pdEleTmp.addAttribute("dependson", ptBundle.getDependson());
            pdEleTmp.addAttribute("dependsonversion", ptBundle.getDependsonVersion());
            List<String> bkJarList = ptBundle.getJarList();
            for (String jarName : bkJarList) {
                Element jarEle = pdEleTmp.addElement("jar");
                jarEle.addText(jarName);
            }
        }
    }

    private List<PlatformBundles> getPlatformBundleInfo() {
        ArrayList<PlatformBundles> ptList = new ArrayList<PlatformBundles>();
        List<PlatformBundles> tmpList = NeedInstallBundles.PLATFORM_BUNDLES;
        String platform = PrepareParamUtil.getsInstallDto().getPlatformId();
        for (PlatformBundles pt : tmpList) {
            if (VerifyUtil.isEmpty((String)platform) || !platform.equals(pt.getId())) continue;
            logger.info((Object)("add user selected bundle: " + pt.getId()), "");
            ptList.add(pt);
        }
        return ptList;
    }

    private void generateInstallXMLTwo(Element installElement) {
        for (ProductBundles pdBundle : this.getNeedInstalledBundle()) {
            String extendClz;
            Element pdElementTmp = installElement.addElement("product");
            pdElementTmp.addAttribute("id", pdBundle.getId());
            pdElementTmp.addAttribute("version", pdBundle.getVersion());
            pdElementTmp.addAttribute("name", pdBundle.getName());
            pdElementTmp.addAttribute("required", Boolean.toString(pdBundle.isNeeded()));
            pdElementTmp.addAttribute("description", pdBundle.getDescription());
            pdElementTmp.addAttribute("size", pdBundle.getSize());
            pdElementTmp.addAttribute("dependson", pdBundle.getDependson());
            pdElementTmp.addAttribute("dependsonversion", pdBundle.getDependsonVersion());
            List<String> bkJarList = pdBundle.getBackEndJar();
            for (String string : bkJarList) {
                Element bkjarEle = pdElementTmp.addElement("backendjar");
                bkjarEle.addText(string);
            }
            List<String> ftJarList = pdBundle.getFrontEndJar();
            for (String jarName3 : ftJarList) {
                Element ftjarEle = pdElementTmp.addElement("frontendjar");
                ftjarEle.addText(jarName3);
            }
            String string = pdBundle.getWindowsUnsCmd();
            String linuxUnsCmd = pdBundle.getLinuxUnsCmd();
            if (null != string) {
                Element windowUnsCmdEle = pdElementTmp.addElement("finalizescript");
                windowUnsCmdEle.addAttribute("os", "windows");
                windowUnsCmdEle.addText(string);
            }
            if (null != linuxUnsCmd) {
                Element linuxUnsCmdEle = pdElementTmp.addElement("finalizescript");
                linuxUnsCmdEle.addAttribute("os", "linux");
                linuxUnsCmdEle.addText(linuxUnsCmd);
            }
            if (null == (extendClz = pdBundle.getExtendCallBackClz())) continue;
            Element callbackclassEle = pdElementTmp.addElement("extend").addElement("callbackclass");
            callbackclassEle.addAttribute("class", extendClz);
        }
    }

    public void installProduct() {
        this.isInterrupted();
        logger.info((Object)"start install product", "");
        try {
            List<Object> bundleList = new ArrayList();
            List<Object> userSelectList = new ArrayList();
            bundleList = NeedInstallBundles.PRODUCT_BUNDLES;
            userSelectList = PrepareParamUtil.getsInstallDto().getProductList();
            for (ProductBundles productBundles : bundleList) {
                if (!userSelectList.contains(productBundles.getId())) {
                    logger.info((Object)("user not select " + productBundles.getId() + ", no need install."), "");
                    continue;
                }
                logger.info((Object)("start install product, id=" + productBundles.getId()), "");
                List<String> backEndJarList = productBundles.getBackEndJar();
                for (String string : backEndJarList) {
                    logger.info((Object)("start copy product jar to backend, name=" + string), "");
                    String oldProductPath = BASE_PATH + LegoResourceManager.getProValue("install.product.path") + File.separator + productBundles.getBundlePath() + File.separator + string;
                    String newProductPath = this.installPath + File.separator + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + File.separator + string;
                    FileUtil.copyFile(oldProductPath, newProductPath);
                }
                List<String> frontEndJarList = productBundles.getFrontEndJar();
                for (String name3 : frontEndJarList) {
                    logger.info((Object)("start copy product jar to tomcat, name=" + name3), "");
                    String oldProductPath = BASE_PATH + LegoResourceManager.getProValue("install.product.path") + File.separator + productBundles.getBundlePath() + File.separator + name3;
                    String newFrontPath = this.installPath + File.separator + LegoResourceManager.getProValue("install.lego_version.frontend.jar.path") + File.separator + name3;
                    FileUtil.copyFile(oldProductPath, newFrontPath);
                }
                String string = BASE_PATH + LegoResourceManager.getProValue("install.product.path") + File.separator + productBundles.getBundlePath() + File.separator + "script";
                String newPath = this.installPath + File.separator + LegoResourceManager.getProValue("install.uninstalldb.script") + productBundles.getId();
                FileUtil.copyFolder(string, newPath);
                String srcPath = BASE_PATH + LegoResourceManager.getProValue("install.product.path") + File.separator + productBundles.getBundlePath() + File.separator + LegoResourceManager.getProValue("update.product.initdb.path");
                String destPath = this.installPath + File.separator + LegoResourceManager.getProValue("install.uninstalldb.script") + productBundles.getId() + File.separator + "update";
                FileUtil.copyFolder(srcPath, destPath);
            }
        }
        catch (Exception e) {
            logger.error((Object)("install product failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20003L);
        }
    }

    protected void changeDBConnectionInfo(DataBaseInfo dbInfo) {
        try {
            ChangeDbInforInJar.changePropDBFile(dbInfo, this.installPath);
        }
        catch (Exception e) {
            logger.error((Object)("changeDBConnectionInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20007L);
        }
    }

    protected void isInterrupted() {
    }

    protected void openPath() {
        if (OSInformation.isWindows()) {
            try {
                String[] cmd = new String[5];
                String path = this.installPath + File.separator + "Runtime";
                if (!new File(path).exists()) {
                    logger.error((Object)"open path failed, the open path is not exists.", "");
                    return;
                }
                cmd[0] = "cmd";
                cmd[1] = "/c";
                cmd[2] = "start";
                cmd[3] = " ";
                cmd[4] = path.replace(" ", "\" \"").replace("\\/", "/").replace("//", "/").replace(" ", "\" \"");
                String cmdLine = "cmd /c start " + path;
                CmdUtil.execStrCmd(cmdLine);
            }
            catch (Exception ex) {
                logger.error((Object)("openPath Error: " + ExceptionUtil.getErrorMessage((Throwable)ex)), "");
            }
        }
    }

    protected void dealWithStartUp() {
        if (OSInformation.isWindows()) {
            String cmdPath = this.installPath + "/Runtime/bin/startSystem.vbe";
            try {
                SignVerifier.getInstance().verify(cmdPath);
            }
            catch (SignatureException e) {
                logger.error((Object)"dealWithStartUp failed.", (Throwable)e, "verify fail");
                return;
            }
            CmdUtil.runbatParams(cmdPath, null);
        } else {
            String shStr = this.installPath + "/Runtime/bin/startSystem.sh";
            try {
                SignVerifier.getInstance().verify(shStr);
            }
            catch (SignatureException e) {
                logger.error((Object)"dealWithStartUp error :", (Throwable)e, "verify fail");
                return;
            }
            try {
                CmdUtil.runSysoShell(shStr);
            }
            catch (IOException e) {
                logger.error((Object)"Start System cmd has some error :", (Throwable)e, "");
            }
            catch (InterruptedException e) {
                logger.error((Object)"Start System cmd has some error :", (Throwable)e, "");
            }
        }
    }

    protected void executeSystemScript() {
        this.isInterrupted();
        logger.info((Object)"start execute System Script.", "");
        try {
            if (OSInformation.isLinux()) {
                logger.info((Object)"Linux Permission setting:", "");
                CmdUtil.setLinuxWithoutRoot(this.installPath);
            }
            if (OSInformation.isWindows()) {
                String legoServer = this.installPath + "/Runtime/LegoRuntime/serviceMgr.bat";
                String legoWebSrv = this.installPath + "/Runtime/Tomcat6/bin/service.bat";
                String monitor = this.installPath + "/Runtime/monitor/serviceMgr.bat";
                String menuCmd = this.installPath + "/Runtime/bin/createShortcut.bat";
                String tmpBatPath = this.installPath + "\\Runtime\\tmp\\setAuth.bat";
                SignVerifier.getInstance().verify(new String[]{legoServer, legoWebSrv, monitor});
                SignVerifier.getInstance().verify(new String[]{menuCmd, tmpBatPath});
                if (InitInstalledXmlTool.isInstalled()) {
                    this.cleanOldService();
                }
                long memTotal = (long)(Float.parseFloat(Singleton.getInstance().getSystemInfor().getMemory()) * 1024.0f);
                CmdUtil.runbatParams(legoServer, new String[]{"install", String.valueOf(memTotal)});
                CmdUtil.runbatParams(legoWebSrv, new String[]{"install"});
                CmdUtil.runbatParams(monitor, new String[]{"install"});
                CmdUtil.runbatParams(menuCmd, null);
                CmdUtil.runbatParams(tmpBatPath, new String[]{Singleton.getInstance().getSystem().getDbInfor().getDbFilePath(), OSInformation.getUserHomePath()});
                for (ProductBundles productBundles : this.getNeedInstalledBundle()) {
                    String windowsInitCmd = productBundles.getWindowsInitCmd();
                    logger.info((Object)("begin callBack product script, name=" + windowsInitCmd), "");
                    if (VerifyUtil.isEmpty((String)windowsInitCmd) || !windowsInitCmd.endsWith(".bat") && !windowsInitCmd.endsWith(".vbe")) continue;
                    String path = BASE_PATH + LegoResourceManager.getProValue("install.product.path") + File.separator + productBundles.getBundlePath() + File.separator + windowsInitCmd;
                    CmdUtil.runbatParams(path, null);
                }
            } else {
                String installServiceFileName = this.installPath + "/Runtime/bin/installService.sh";
                CmdUtil.runShell(installServiceFileName, new String[0]);
                for (ProductBundles productBundles : this.getNeedInstalledBundle()) {
                    String linuxInitCmd = productBundles.getLinuxInitCmd();
                    logger.info((Object)("begin callBack product script, name=" + linuxInitCmd), "");
                    if (VerifyUtil.isEmpty((String)linuxInitCmd) || !linuxInitCmd.endsWith(".sh")) continue;
                    String path = BASE_PATH + LegoResourceManager.getProValue("install.product.path") + File.separator + productBundles.getBundlePath() + File.separator + linuxInitCmd;
                    CmdUtil.runShell(path, null);
                }
            }
            logger.info((Object)"end execute System Script.", "");
        }
        catch (Exception e) {
            logger.error((Object)("executeSystemScript failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException("");
        }
    }

    protected List<ProductBundles> getNeedInstalledBundle() {
        ArrayList<ProductBundles> pdList = new ArrayList<ProductBundles>();
        List<ProductBundles> tmpList = NeedInstallBundles.PRODUCT_BUNDLES;
        List<String> selectBundles = PrepareParamUtil.getsInstallDto().getProductList();
        for (ProductBundles productBundles : tmpList) {
            if (!selectBundles.contains(productBundles.getId())) continue;
            logger.info((Object)("add user selected bundle: " + productBundles.getId()), "");
            pdList.add(productBundles);
        }
        return pdList;
    }

    private void cleanOldService() {
        boolean existRD;
        boolean existLego = this.checkServicIsExist("LEGOWebSrv") && this.checkServicIsExist("LEGOService");
        boolean bl = existRD = this.checkServicIsExist("RDWebSrv") && this.checkServicIsExist("RDService");
        if (existLego && existRD) {
            return;
        }
        if (existLego) {
            Install.removeOldService("LEGOWebSrv");
            Install.removeOldService("LEGOService");
            Install.removeOldService("LEGOMonitor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeOldService(String serviceName) {
        StringBuffer command = new StringBuffer();
        command.append("cmd /c sc delete " + serviceName);
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            if (null != runtime) {
                process = runtime.exec(command.toString());
            }
        }
        catch (IOException e) {
            logger.error((Object)("remove old service failed, the service name is: " + serviceName), "");
        }
        finally {
            if (null != process) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkServicIsExist(String serviceName) {
        StringBuffer command = new StringBuffer();
        command.append("cmd /c sc query " + serviceName);
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            if (null != runtime) {
                process = runtime.exec(command.toString());
            }
        }
        catch (IOException e) {
            logger.error((Object)("query service failed ,the service name is :" + serviceName), "");
        }
        InputStream inStream = null;
        if (null != process) {
            inStream = process.getInputStream();
        }
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader bufReader = new BufferedReader(inStreamReader);
        String listeningCmdLine = null;
        try {
            listeningCmdLine = bufReader.readLine();
            while (null != listeningCmdLine) {
                if (listeningCmdLine.contains(STATE_COLUME)) {
                    boolean bl = true;
                    return bl;
                }
                listeningCmdLine = bufReader.readLine();
            }
        }
        catch (IOException e) {
            logger.error((Object)("query service status failed ,the service name is :" + serviceName), "");
        }
        finally {
            FileUtil.close(bufReader, "");
            FileUtil.close(inStreamReader, "");
            FileUtil.close(inStream, "");
            if (null != process) {
                process.destroy();
            }
        }
        return false;
    }

    protected void cleanInstalledFile() {
        logger.info((Object)"start clean installed file.", "");
        String deleteFileKey = "windows.install.del.script.file";
        if (OSInformation.isLinux()) {
            deleteFileKey = "linux.install.del.script.file";
        }
        FileUtil.delScript4Installed(this.installPath + File.separator + "Runtime" + File.separator, deleteFileKey, "Gauss".toLowerCase(Locale.US));
    }

    public void callProductInstall(boolean isUpgrade) {
        try {
            List<ProductBundles> productList = this.getNeedInstalledBundle();
            for (ProductBundles product : productList) {
                String clzName = product.getExtendCallBackClz();
                if (VerifyUtil.isEmpty((String)clzName)) continue;
                logger.info((Object)("start call product install, name=" + clzName), "");
                IextendCallBack callBack = (IextendCallBack)Class.forName(clzName).newInstance();
                if (isUpgrade) {
                    UpdateUtil.updateSql(callBack);
                    continue;
                }
                callBack.callInstall();
            }
        }
        catch (Exception e) {
            logger.error((Object)("callProductInstall failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException("", e);
        }
    }

    protected void releaseStream(XMLWriter writer) {
        if (null != writer) {
            try {
                writer.close();
                writer = null;
            }
            catch (IOException e) {
                logger.error((Object)("Release XMLWriter is Error:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    protected void releaseStream(Closeable streamObject) {
        if (null != streamObject) {
            try {
                streamObject.close();
            }
            catch (IOException e) {
                logger.error((Object)("Release Stream is Error:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }
}

