/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.install;

import com.huawei.lego.common.changeport.ProcessFile;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.ha.DisasterRecoveryData;
import com.huawei.lego.common.ha.HAConfigEnum;
import com.huawei.lego.common.ha.HAConfigInfo;
import com.huawei.lego.common.ha.HAInfo;
import com.huawei.lego.common.ha.LinkInfo;
import com.huawei.lego.common.ha.XmlTool;
import com.huawei.lego.common.install.NetWorkPanel;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class InstallCommon {
    private static final String INSTALL_TYPE_HA = "HA";
    private static final String INSTALL_TYPE_AS = "Active/standby";
    private static final String SP = File.separator;
    private static final String SUFIX_TMP = "@tmp";
    private static final String INSTALL_HA_SCRIPT = "/Runtime/bin/installHA.sh";
    private static final String CATALINA_SERVICE_SECOND = "Catalina_second";
    private static final String CATALINE_DEFAULT_SERVIE = "Catalina";
    private static final String BUSINESS_USER_NAME = "ICUser";
    private static final String BUSINES_USER_GROUP = "LEGO";
    private static Log logger = LogFactory.getInstance(InstallCommon.class);

    public static void installHASoft(String installDir, boolean isUpgrade) {
        logger.info((Object)"start install ha soft.", "");
        try {
            String currPath = new File("").getCanonicalPath();
            String haScript = currPath + SP + "ha" + SP + "install.sh";
            String haResourceScp = currPath + SP + "Runtime" + SP + "bin" + SP + "installHA.sh";
            String installPath = installDir + SP + "Runtime";
            if (!new File(haScript).exists() || !new File(haResourceScp).exists()) {
                throw new PatchException("install or resource script not found.");
            }
            if (!CmdUtil.execShellCmd(haScript, new String[]{"-p", installPath, "-u", BUSINESS_USER_NAME, "-g", BUSINES_USER_GROUP})) {
                throw new PatchException("exec install script failed.");
            }
            if (!CmdUtil.execShellCmd(haResourceScp, new String[]{"resource", installDir, String.valueOf(isUpgrade)})) {
                throw new PatchException("exec script failed.");
            }
            logger.info((Object)"install ha soft successful.", "");
        }
        catch (Exception e) {
            logger.error((Object)("installHASoft failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("installHASoft failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRealNetCardIp() {
        String ip = "";
        String haConfFile = InitInstalledXmlTool.getInstalledSystem().getInstallpath() + "/Runtime/ha/local/conf/ha.properties";
        File file = new File(haConfFile);
        if (!file.exists()) {
            logger.error((Object)"getRealNetCardIp failed, ha local conf file not found.", "");
            return ip;
        }
        FileInputStream input = null;
        try {
            Properties properties = new Properties();
            input = new FileInputStream(file);
            properties.load(input);
            String panelInfo = properties.getProperty("BCMProductManagementPlane");
            ip = panelInfo.substring(0, panelInfo.indexOf(124));
        }
        catch (Exception e) {
            String string;
            try {
                logger.error((Object)("getRealNetCardIp failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                string = ip;
            }
            catch (Throwable throwable) {
                FileUtil.close(input, "getRealNetCardIp ");
                throw throwable;
            }
            FileUtil.close(input, "getRealNetCardIp ");
            return string;
        }
        FileUtil.close(input, "getRealNetCardIp ");
        return ip;
    }

    private static void reCopyResource() {
        try {
            String currPath = new File("").getCanonicalPath();
            String haResourceScp = currPath + SP + "Runtime" + SP + "bin" + SP + "installHA.sh";
            String installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
            if (!new File(haResourceScp).exists() || !CmdUtil.execShellCmd(haResourceScp, new String[]{"recopy", installPath})) {
                throw new PatchException("exec script failed.");
            }
        }
        catch (Exception e) {
            logger.error((Object)("reCopyResource failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("reCopyResource failed.");
        }
    }

    public static void uninstallHASoft() {
        logger.info((Object)"start uninstall ha.", "");
        String bcmPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
        String installPath = bcmPath + SP + "Runtime";
        String unInstallS = installPath + SP + "ha" + SP + "uninstall.sh";
        if (!new File(unInstallS).exists()) {
            logger.info((Object)"ha uninstall script is not exists.", "");
            return;
        }
        StringBuffer cmdBuf = new StringBuffer();
        cmdBuf.append("echo ");
        cmdBuf.append("y | ");
        cmdBuf.append(unInstallS);
        if (!CmdUtil.execShellCmd(cmdBuf.toString())) {
            logger.error((Object)"uninstall ha failed.", "");
            throw new PatchException("install ha failed.");
        }
        logger.info((Object)"uninstall ha successful.", "");
    }

    private static void getAllXmlFile(File file, List<String> xmlList) {
        block4: {
            block3: {
                if (!file.isDirectory()) break block3;
                for (File dir : file.listFiles()) {
                    InstallCommon.getAllXmlFile(dir, xmlList);
                }
                break block4;
            }
            if (!file.getName().endsWith(".xml")) break block4;
            try {
                xmlList.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                logger.error((Object)"Get path failed, msg: %s.", ExceptionUtil.getErrorMessage((Throwable)e));
            }
        }
    }

    private static List<Map.Entry<String, Map<String, String>>> getSingleNodeChanged(Map<String, Map<String, String>> srcMap, Map<String, Map<String, String>> destMap) {
        ArrayList<Map.Entry<String, Map<String, String>>> changedMap = new ArrayList<Map.Entry<String, Map<String, String>>>();
        Set<Map.Entry<String, Map<String, String>>> entryMap = srcMap.entrySet();
        for (Map.Entry<String, Map<String, String>> tmpMap : entryMap) {
            String node = tmpMap.getKey();
            if (destMap.containsKey(node) && destMap.get(node).equals(tmpMap.getValue())) continue;
            changedMap.add(tmpMap);
        }
        return changedMap;
    }

    private static void updateXmlConfig(String installPath) {
        File path = new File(installPath + "/Runtime@tmp/ha");
        ArrayList<String> xmlList = new ArrayList<String>();
        InstallCommon.getAllXmlFile(path, xmlList);
        for (String xml : xmlList) {
            XmlTool oldF = new XmlTool(xml);
            String newFile = xml.replace(SUFIX_TMP, "");
            File newTmpFile = new File(newFile);
            if (!newTmpFile.exists() || "hacom_local.xml".equals(newTmpFile.getName())) {
                logger.info((Object)("the file not exists, or file can not be updated, file is " + newTmpFile.getName()), "");
                continue;
            }
            XmlTool newF = new XmlTool(newFile);
            XmlTool.updateXml(newFile, InstallCommon.getSingleNodeChanged(oldF.getSingleMap(), newF.getSingleMap()));
        }
    }

    public static String getFormatIp(String addr) {
        String address = addr;
        if (VerifyUtil.isEmpty((String)addr)) {
            return address;
        }
        if (addr.contains(":")) {
            address = "[" + addr + "]";
        }
        return address;
    }

    private static void updateLinkInfo(String installPath) {
        HAInfo haInfo = HAInfo.getHAInfo();
        StringBuffer cmdBuf = new StringBuffer();
        cmdBuf.append(" -l ");
        cmdBuf.append(haInfo.getLocalName());
        cmdBuf.append(" -p ");
        cmdBuf.append(haInfo.getRemoteName());
        cmdBuf.append(" -b \"");
        cmdBuf.append(haInfo.getHeartLink());
        cmdBuf.append("\" -s \"");
        cmdBuf.append(haInfo.getSyncLink());
        cmdBuf.append("\" -i ");
        String floatIp = haInfo.getFloatIP();
        if (!VerifyUtil.isEmpty((String)haInfo.getFloatIP2())) {
            floatIp = floatIp + "," + haInfo.getFloatIP2();
        }
        cmdBuf.append(floatIp);
        if (null != haInfo.getGwLink() && !"".equals(haInfo.getGwLink())) {
            cmdBuf.append(" -g ");
            cmdBuf.append(haInfo.getGwLink());
        }
        logger.info((Object)("ha link info: " + cmdBuf.toString()), "");
        String configScript = installPath + "/Runtime/ha/module/hacom/script/config_ha.sh";
        if (!new File(configScript).exists()) {
            throw new PatchException("updateLinkInfo failed, ha config_ha.sh not exists.");
        }
        if (!CmdUtil.execShellCmd(configScript, new String[]{cmdBuf.toString()})) {
            throw new PatchException("updateLinkInfo failed, exec script failed.");
        }
    }

    private static void recopyArbKeystore() {
        String arbPath = "/LegoRuntime/certs/arb.keystore";
        String oldFile = InitInstalledXmlTool.getInstalledSystem().getInstallpath() + File.separator + "Runtime" + SUFIX_TMP + File.separator + arbPath;
        String newFile = InitInstalledXmlTool.getInstalledSystem().getInstallpath() + File.separator + "Runtime" + File.separator + arbPath;
        if (!new File(oldFile).exists()) {
            logger.info((Object)"can not find the old arb.keystore, return.", "");
            return;
        }
        try {
            FileUtil.copyFile(oldFile, newFile);
        }
        catch (Exception e) {
            logger.error((Object)("upgrade ha failed, copy arb.keystore failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("upgrade ha failed.");
        }
    }

    public static void upgradeHA() {
        logger.info((Object)"start upgrade ha.", "");
        String installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
        InstallCommon.installHASoft(installPath, true);
        DisasterRecoveryData configData = new DisasterRecoveryData(true);
        if (configData.isEnable()) {
            logger.info((Object)"is not single ha, need update ha xml.", "");
            InstallCommon.updateXmlConfig(installPath);
            if (INSTALL_TYPE_HA.equals(configData.getDrType())) {
                logger.info((Object)"start upgrade ha double.", "");
                InstallCommon.updateLinkInfo(installPath);
            } else if (INSTALL_TYPE_AS.equals(configData.getDrType())) {
                logger.info((Object)"start upgrade active/standby.", "");
                InstallCommon.ConfigActiveStandby(configData.getHaData());
            } else {
                logger.error((Object)("dr type is error: " + configData.getDrType()), "");
            }
        }
        InstallCommon.reCopyResource();
        InstallCommon.recopyArbKeystore();
        logger.info((Object)"upgrade ha successfully.", "");
    }

    private static void writeConfig(String message) {
        if (message.length() >= 2048) {
            logger.error((Object)"the buff size is too long", "");
            throw new PatchException("ConfigActiveStandby failed.");
        }
        OutputStreamWriter write = null;
        try {
            String currPath = new File("").getCanonicalPath();
            String confFile = currPath + File.separator + "ha" + File.separator + "haconfig.conf";
            write = new FileWriter(new File(confFile));
            write.write(message);
            write.flush();
            String script = currPath + INSTALL_HA_SCRIPT;
            if (!new File(script).exists()) {
                logger.error((Object)"config DisasterRecovery failed, installHA.sh not found.", "");
                throw new PatchException("config active/standby failed.");
            }
            String installPath = InitInstalledXmlTool.getInstallPath();
            if (CmdUtil.runShell(script, new String[]{"Config", installPath}, "manually")) {
                logger.error((Object)"config failed.", "");
                throw new PatchException("config active/standby failed.");
            }
            FileUtil.deleteFile(installPath + INSTALL_HA_SCRIPT);
        }
        catch (IOException e) {
            logger.error((Object)("write config file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("write config failed.");
        }
        finally {
            if (null != write) {
                try {
                    write.close();
                }
                catch (Exception e2) {
                    logger.error((Object)("close writer failed: " + e2), "");
                }
            }
        }
    }

    public static void ConfigActiveStandby(HAConfigInfo asPrarm) {
        String sp = System.getProperty("line.separator");
        if (!VerifyUtil.isEmpty((String)sp)) {
            logger.error((Object)("get line separator failed, sp=" + sp), "");
            throw new PatchException("ConfigActiveStandby failed.");
        }
        StringBuilder buff = new StringBuilder();
        buff.append("MODE=Active-Standby" + sp);
        buff.append("LOCALROLE=" + asPrarm.getRole() + sp);
        buff.append("LOCALNAME=ha1" + sp);
        buff.append("PEERNAME=ha2" + sp);
        StringBuffer sync = new StringBuffer();
        for (LinkInfo info : asPrarm.getLinkInfo()) {
            if (!info.getName().startsWith(HAConfigEnum.CONFIG_ENUM.SYNC.getConfigLab())) continue;
            sync.append("ha1").append(":").append(InstallCommon.getFormatIp(info.getLocalIp())).append(":").append(info.getLocalPort()).append(",").append("ha2").append(":").append(InstallCommon.getFormatIp(info.getPeerIp())).append(":").append(info.getPeerPort()).append(";");
        }
        if (sync.toString().endsWith(";")) {
            sync.deleteCharAt(sync.length() - 1);
        }
        buff.append("SYNC=" + sync.toString() + sp);
        logger.info((Object)("active standby info, msg=" + buff.toString()), "");
        InstallCommon.writeConfig(buff.toString());
    }

    public static void addInstalledXml(Element element, NetWorkPanel panel) {
        Element httpPortEle = element.addElement("httport");
        httpPortEle.addText(panel.getWorkMangHttpPort());
        Element httpsPortEle = element.addElement("httpsport");
        httpsPortEle.addText(panel.getWorkMangHttpsPort());
        Element httpsIpEle = element.addElement("httpsip");
        httpsIpEle.addText(panel.getWorkMangIp());
        if (OSInformation.isLinux()) {
            Element floatIpEle = element.addElement("floatip");
            String floatip = panel.getWorkMangFloatIp();
            if (null == floatip) {
                floatip = "";
            }
            floatIpEle.addText(floatip);
        }
        Element secondNet = element.addElement("secondnet");
        secondNet.addAttribute("sip", panel.getSecondip());
        if (OSInformation.isLinux()) {
            secondNet.addAttribute("sfloatip", panel.getSecondFloatIp());
        }
        secondNet.addAttribute("isEnable", String.valueOf(panel.isEnableSecondIp()));
        secondNet.addAttribute("shttpsport", panel.getSecondHttpsPort());
        secondNet.addAttribute("shttpport", panel.getSecondHttpPort());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateInstalledXml(String fileName, NetWorkPanel panel) {
        FileOutputStream fos;
        block10: {
            File file = new File(fileName);
            if (!file.exists()) {
                logger.error((Object)"update install file failed. the file not found.", "");
                throw new PatchException("");
            }
            XMLWriter output = null;
            fos = null;
            try {
                SAXReader reader = new SAXReader();
                CommonUtil.setSecurityFeatures((SAXReader)reader);
                Document document = reader.read(file);
                Element installEle = (Element)document.selectSingleNode("/install");
                InstallCommon.updateInstalledXml(installEle, panel);
                OutputFormat format = OutputFormat.createPrettyPrint();
                format.setEncoding("UTF-8");
                fos = new FileOutputStream(fileName);
                output = new XMLWriter((OutputStream)fos, format);
                output.write(document);
                logger.info((Object)("end update installed xml: " + fileName), "0x000252000FB5002F");
                if (null == output) break block10;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("updateInstalledXml failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                    throw new PatchException("");
                }
                catch (Throwable throwable) {
                    if (null != output) {
                        try {
                            output.close();
                        }
                        catch (Exception e2) {
                            logger.error((Object)("close xml writer failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
                        }
                    }
                    FileUtil.close(fos, "");
                    throw throwable;
                }
            }
            try {
                output.close();
            }
            catch (Exception e) {
                logger.error((Object)("close xml writer failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
        FileUtil.close(fos, "");
    }

    public static void updateInstalledXml(Element element, NetWorkPanel panel) {
        Element secondEle;
        Element httpsIpEle;
        Element httpsEle;
        logger.info((Object)"start update installed xml file.", "");
        Element httpEle = (Element)element.selectSingleNode("httport");
        if (null != httpEle) {
            httpEle.setText(panel.getWorkMangHttpPort());
        }
        if (null != (httpsEle = (Element)element.selectSingleNode("httpsport"))) {
            httpsEle.setText(panel.getWorkMangHttpsPort());
        }
        if (null != (httpsIpEle = (Element)element.selectSingleNode("httpsip"))) {
            httpsIpEle.setText(panel.getWorkMangIp());
        }
        if (null == (secondEle = (Element)element.selectSingleNode("secondnet"))) {
            secondEle = element.addElement("secondnet");
        }
        secondEle.addAttribute("sip", panel.getSecondip());
        secondEle.addAttribute("isEnable", String.valueOf(panel.isEnableSecondIp()));
        secondEle.addAttribute("shttpsport", panel.getSecondHttpsPort());
        secondEle.addAttribute("shttpport", panel.getSecondHttpPort());
        if (OSInformation.isLinux()) {
            secondEle.addAttribute("sfloatip", panel.getSecondFloatIp());
        }
        if (OSInformation.isLinux()) {
            Element floatEle = (Element)element.selectSingleNode("floatip");
            if (null == floatEle) {
                floatEle = element.addElement("floatip");
            }
            floatEle.setText(panel.getWorkMangFloatIp());
        }
    }

    private static Map<String, String> getChangedPort(String portIniFile, NetWorkPanel panel, String dbPort) {
        HashMap<String, String> mapData = new HashMap<String, String>();
        FileInputStream input = null;
        try {
            input = new FileInputStream(portIniFile);
            Properties properties = new Properties();
            properties.load(input);
            String gaussPort = properties.getProperty("gauss.port");
            String smPort = properties.getProperty("https.port");
            if (null != dbPort && !dbPort.equals(gaussPort)) {
                mapData.put("gauss.port", dbPort);
            }
            if (null != panel.getWorkMangHttpsPort() && !panel.getWorkMangHttpsPort().equals(smPort)) {
                mapData.put("https.port", panel.getWorkMangHttpsPort());
            }
        }
        catch (IOException e) {
            logger.error((Object)("getChangedPort failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("getChangedPort failed.");
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e2) {
                    logger.error((Object)e2, "close error.");
                }
            }
        }
        logger.info((Object)("changedPort: " + mapData), "");
        return mapData;
    }

    public static void updatePortInI() {
        logger.info((Object)"start update port.ini.", "");
        String portIniFile = InitInstalledXmlTool.getInstalledSystem().getInstallpath() + "/Runtime/bin/config/conf/port.ini";
        File file = new File(portIniFile);
        if (!file.exists()) {
            throw new PatchException("updatePortInI failed, port.ini not exists.");
        }
        String dbPort = InitInstalledXmlTool.getInstalledSystem().getDbInfor().getDbPort();
        NetWorkPanel panel = InitInstalledXmlTool.getInstalledSystem().getNetWorkPanel();
        Map<String, String> changedPort = InstallCommon.getChangedPort(portIniFile, panel, dbPort);
        ProcessFile.updatePortConfFile(changedPort, portIniFile);
        logger.info((Object)"end update port.ini.", "");
    }
}

