/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.memory;

import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class LinuxSystemTool {
    private static final String MEM_INFO_PATH = "/proc/meminfo";
    private static final String CPU_INFO_PATH = "/proc/stat";
    private static final String MEM_TOTAL_KEY = "MemTotal";
    private static Log logger = LogFactory.getInstance(LinuxSystemTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalMemInfo() {
        long totalMem = 0L;
        Runtime rt = Runtime.getRuntime();
        BufferedReader bufRead = null;
        InputStreamReader inputReader = null;
        Process process = null;
        try {
            process = rt.exec("cat /proc/meminfo");
            inputReader = new InputStreamReader(process.getInputStream());
            bufRead = new BufferedReader(inputReader);
            String str = null;
            while ((str = FileUtil.getLineFromFile(bufRead)) != null) {
                StringTokenizer token;
                if (!str.startsWith(MEM_TOTAL_KEY) || !(token = new StringTokenizer(str.trim())).nextToken().startsWith(MEM_TOTAL_KEY) || !token.hasMoreTokens()) continue;
                totalMem = Integer.parseInt(token.nextToken());
                break;
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)("getTotalMemInfo failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            catch (Throwable throwable) {
                FileUtil.close(bufRead, "close bufRead");
                FileUtil.close(inputReader, "close inputReader");
                if (null != process) {
                    process.destroy();
                }
                throw throwable;
            }
            FileUtil.close(bufRead, "close bufRead");
            FileUtil.close(inputReader, "close inputReader");
            if (null != process) {
                process.destroy();
            }
        }
        FileUtil.close(bufRead, "close bufRead");
        FileUtil.close(inputReader, "close inputReader");
        if (null != process) {
            process.destroy();
        }
        return totalMem;
    }

    public static String getMemInfoPath() {
        return MEM_INFO_PATH;
    }

    public static String getCpuInfoPath() {
        return CPU_INFO_PATH;
    }
}

