/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.memory;

import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.memory.LinuxSystemTool;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.SignatureException;

public class WindowsGetMem {
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static Log logger = LogFactory.getInstance(LinuxSystemTool.class);
    private static String toolsPath = Singleton.getBasePath().endsWith("/") || Singleton.getBasePath().endsWith("\\") ? Singleton.getBasePath() + "tools/windows/Memory/Resource.exe" : Singleton.getBasePath() + "/tools/windows/Memory/Resource.exe";

    public static long getTotalMemInfo() {
        return WindowsGetMem.getCPUAndMenInfo(toolsPath, MEM_TOTALMEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized long getCPUAndMenInfo(String toolPath, String para) {
        try {
            SignVerifier.getInstance().verify(toolPath);
        }
        catch (SignatureException e1) {
            logger.error((Object)("exception: " + ExceptionUtil.getErrorMessage((Throwable)e1)), "");
            return 1L;
        }
        String[] paraexec = new String[]{toolPath, para};
        Process pp = null;
        BufferedReader input = null;
        try {
            pp = Runtime.getRuntime().exec(paraexec);
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            input = new LineNumberReader(ir);
            String nextStr = FileUtil.getLineFromFile((LineNumberReader)input);
            if (nextStr != null) {
                long l = Long.parseLong(nextStr);
                return l;
            }
        }
        catch (IOException e) {
            logger.error((Object)e, "getCPUAndMenInfo IOException");
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.debug((Object)e.getMessage(), "");
                }
            }
            if (null != pp) {
                pp.destroy();
            }
        }
        return 1L;
    }
}

