/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.PatchHandlerManager;
import com.huawei.lego.common.patch.action.InstallPatchAction;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;

public class PatchHandlerContext {
    private static final Log logger = LogFactory.getInstance(PatchHandlerContext.class);
    private PatchHandlerManager manager = null;
    private int index = 0;

    public PatchHandlerContext(PatchHandlerManager manager) {
        this.manager = manager;
    }

    public void backup(String source) {
        if (this.manager.backupMappings.containsKey(source)) {
            return;
        }
        String target = this.getTempFilePath();
        try {
            FileUtil.copyFile(source, target);
        }
        catch (IOException e) {
            logger.error((Object)"backup file filed", (Throwable)e, "");
            throw new PatchException(e);
        }
        ++this.index;
        this.manager.backupMappings.put(source, target);
    }

    public void rollback(String source) {
        this.rollback(source, true);
    }

    public void rollback() {
        for (String source : this.manager.backupMappings.keySet()) {
            this.rollback(source, false);
        }
    }

    public void clean(String source) {
        this.clean(source, true);
    }

    public void clean() {
        for (String source : this.manager.backupMappings.keySet()) {
            this.clean(source, false);
        }
        this.manager.backupMappings.clear();
    }

    private void rollback(String source, boolean remove) {
        String target = this.manager.backupMappings.get(source);
        if (target == null) {
            return;
        }
        try {
            FileUtil.copyFile(source, target);
        }
        catch (IOException e) {
            logger.error((Object)"rollback file filed", (Throwable)e, "");
            throw new PatchException(e);
        }
        if (remove) {
            this.manager.backupMappings.remove(source);
        }
    }

    private void clean(String source, boolean remove) {
        String target = this.manager.backupMappings.get(source);
        if (target == null) {
            return;
        }
        try {
            new File(target).delete();
        }
        catch (Exception e) {
            logger.error((Object)("clean file filed:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("clean failed.");
        }
        if (remove) {
            this.manager.backupMappings.remove(source);
        }
    }

    private String getTempFilePath() {
        return InstallPatchAction.getTmpPath() + File.separatorChar + this.index + ".tmp";
    }
}

