/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.PatchHandler;
import com.huawei.lego.common.patch.PatchHandlerContext;
import com.huawei.lego.common.patch.handler.LicensePatchHandler;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchHandlerManager {
    private String version;
    private List<PatchHandler> handlers = new ArrayList<PatchHandler>();
    final Map<String, String> backupMappings = new HashMap<String, String>();

    public PatchHandlerManager(String version) {
        this.version = version;
        this.init();
        Collections.sort(this.handlers);
    }

    public String getVersion() {
        return this.version;
    }

    public void backup() {
        PatchHandlerContext context = new PatchHandlerContext(this);
        for (PatchHandler handler : this.handlers) {
            handler.backup(context);
        }
    }

    public void process() {
        try {
            for (PatchHandler handler : this.handlers) {
                handler.process();
            }
        }
        catch (PatchException e) {
            this.rollback();
            throw e;
        }
        catch (Exception e) {
            this.rollback();
            throw new PatchException("process failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public void rollback() {
        PatchHandlerContext context = new PatchHandlerContext(this);
        for (PatchHandler handler : this.handlers) {
            handler.rollback(context);
        }
        context.rollback();
    }

    public void clean() {
        PatchHandlerContext context = new PatchHandlerContext(this);
        for (PatchHandler handler : this.handlers) {
            handler.clean(context);
        }
        context.clean();
    }

    private void addPatchHandler(PatchHandler handler) {
        if (handler.compatible(this.version)) {
            this.handlers.add(handler);
        }
    }

    private void init() {
        this.addPatchHandler(new LicensePatchHandler());
    }
}

