/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch.action;

import com.huawei.KmcUtil;
import com.huawei.ProperUtil;
import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.lego.cli.climain.CliMain;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.PatchHandlerManager;
import com.huawei.lego.common.patch.action.UnInstallPatchAction;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.model.PatchFile;
import com.huawei.lego.common.patch.model.SqlFile;
import com.huawei.lego.common.patch.util.InitPatchZipTool;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SysConfigDataUtil;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.common.util.dbtool.ChangeDbInforInJar;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class InstallPatchAction {
    private static final Log LOGGER = LogFactory.getInstance(InstallPatchAction.class);
    private static String patchPath = InitPatchZipTool.getRuntimePath() + "Runtime" + File.separator + "patch";
    private static String tmpPath = patchPath + File.separator + "tmp";
    private static String tmpPackagePath = tmpPath + File.separator + "package";
    private static String packagePath = patchPath + File.separator + "package";
    private static String backupPath = patchPath + File.separator + "backup" + File.separator + "oldFiles";
    private static String dataPath = patchPath + File.separator + "data";
    private static String versionFile = "patchVersion.conf";
    private static String patchFile = "patch.xml";
    private static List<String> updateList = new ArrayList<String>();
    private static List<String> sqlFileList = new ArrayList<String>();
    private static final String PLATFORM = "platform";
    private static final String VS = "vsphere";
    private static final String VR = "vr";
    private static final String APP = "app";
    private static final String KMC_CONF = "/Runtime/LegoRuntime/conf/wcc";

    public static String getTmpPath() {
        return tmpPath;
    }

    public static void doAction(boolean isCLI) throws IOException, PatchException {
        LOGGER.info((Object)"Do InstallPatchAction.", "");
        PatchDto dto = CliMain.getDto();
        PatchHandlerManager manager = new PatchHandlerManager("V200R001C00SPC100");
        InstallPatchAction.exportCryptConf();
        InstallPatchAction.backupFiles(backupPath, dto);
        manager.backup();
        InstallPatchAction.zipHistoryPatch();
        InstallPatchAction.releaseFiles(dto);
        InstallPatchAction.execInstall(dto);
        manager.process();
        InstallPatchAction.cleanFile();
        manager.clean();
        InstallPatchAction.registerService();
        LOGGER.info((Object)"InstallPatchAction end.", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerService() {
        if (!OSInformation.isWindows()) {
            return;
        }
        LOGGER.info((Object)"start register service.", "");
        FileInputStream input = null;
        try {
            String installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
            String curPath = InstallConstant.getCurrentPath();
            String backSrvFile = curPath + "/bat/serviceMgr.bat";
            String runSrvFile = curPath + "/bat/run.bat";
            String tomcatSrvFile = curPath + "/bat/service.bat";
            String monitorFile = curPath + "/bat/monitor.bat";
            String legoServer = installPath + "/Runtime/LegoRuntime/serviceMgr.bat";
            String legoRunSrv = installPath + "/Runtime/LegoRuntime/run.bat";
            String legoWebSrv = installPath + "/Runtime/Tomcat6/bin/service.bat";
            String monitor = installPath + "/Runtime/monitor/serviceMgr.bat";
            if (new File(backSrvFile).exists()) {
                LOGGER.info((Object)"start register backend service.", "");
                FileUtil.copyFile(backSrvFile, legoServer);
                FileUtil.copyFile(backSrvFile + ".sign", legoServer + ".sign");
                FileUtil.copyFile(runSrvFile, legoRunSrv);
                FileUtil.copyFile(runSrvFile + ".sign", legoRunSrv + ".sign");
                String legoFile = installPath + "/Runtime/LegoRuntime/conf/lego.properties";
                Properties prop = new Properties();
                input = new FileInputStream(legoFile);
                prop.load(input);
                CmdUtil.runbatParams(legoServer, new String[]{"install", prop.getProperty("MemTotalSize", "4096")});
            }
            if (new File(tomcatSrvFile).exists()) {
                LOGGER.info((Object)"start register tomcat service.", "");
                FileUtil.copyFile(tomcatSrvFile, legoWebSrv);
                FileUtil.copyFile(tomcatSrvFile + ".sign", legoWebSrv + ".sign");
                CmdUtil.runbatParams(legoWebSrv, new String[]{"install"});
            }
            if (new File(monitorFile).exists()) {
                LOGGER.info((Object)"start register monitor service.", "");
                FileUtil.copyFile(monitorFile, monitor);
                FileUtil.copyFile(monitorFile + ".sign", monitor + ".sign");
                CmdUtil.runbatParams(monitor, new String[]{"install"});
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("register service failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        finally {
            FileUtil.close(input, "");
        }
    }

    private static String getVersionKey() {
        String version = "";
        try {
            String patchVersion = packagePath + File.separator + versionFile;
            File file = new File(patchVersion);
            if (file.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(file));
                version = prop.getProperty("PATCH_VER");
            } else {
                version = InitPatchZipTool.getSystemVersion();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("getVersionKey failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            version = String.valueOf(System.currentTimeMillis());
        }
        return version.substring(version.lastIndexOf(32) + 1);
    }

    private static void zipHistoryPatch() {
        try {
            String oldVersion = InstallPatchAction.getVersionKey();
            FileUtil.deleteAllFolder(new File(dataPath));
            String destFile = dataPath + File.separator + "data-" + oldVersion + ".zip";
            SysConfigDataUtil.backupSystemData(destFile, null, false);
            InstallPatchAction.backUpAllFiles(oldVersion);
        }
        catch (Exception e) {
            LOGGER.error((Object)("zipHistoryPatch failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("zipHistoryPatch failed.");
        }
    }

    private static void backUpAllFiles(String fileName) throws IOException {
        File dataPathFolder = new File(dataPath);
        if (!dataPathFolder.exists()) {
            dataPathFolder.mkdirs();
        }
        String patchZipFile = dataPath + File.separator + "patch" + "-" + fileName + ".zip";
        String oldPatchXml = packagePath + File.separator + patchFile;
        String oldVersionFile = packagePath + File.separator + versionFile;
        File xml = new File(oldPatchXml);
        File version = new File(oldVersionFile);
        if (xml.exists() || version.exists()) {
            String xmlPath = backupPath + File.separator + xml.getParent().substring(InitPatchZipTool.getRuntimePath().length());
            File path = new File(xmlPath);
            if (!path.exists()) {
                LOGGER.info((Object)("create xml path result: " + path.mkdirs()), "");
            }
            String backXml = xmlPath + File.separator + patchFile;
            String backVersion = xmlPath + File.separator + versionFile;
            FileUtil.copyFile(oldPatchXml, backXml);
            FileUtil.copyFile(oldVersionFile, backVersion);
        }
        String srcIni = InitPatchZipTool.getRuntimePath() + LegoResourceManager.getProValue("install.platform.config.ini");
        String destIni = backupPath + File.separator + LegoResourceManager.getProValue("install.platform.config.ini");
        File iniPath = new File(destIni);
        if (!iniPath.exists() || !iniPath.isDirectory()) {
            LOGGER.info((Object)("create ini path result: " + new File(iniPath.getParent()).mkdirs()), "");
        }
        FileUtil.copyFile(srcIni, destIni);
        FileUtil.zipFile(null, backupPath, patchZipFile, true);
        WccEncryptor.signFile(patchZipFile);
        String srcPath = InitPatchZipTool.getRuntimePath() + KMC_CONF;
        if (new File(srcPath).exists()) {
            FileUtil.copyFolder(srcPath, dataPath + File.separator + "wcc");
        }
    }

    private static void exportCryptConf() {
        String tmpFile = "";
        try {
            String sp = File.separator;
            String appHome = sp + "Runtime" + sp + "LegoRuntime" + sp + "conf" + sp + "wcc" + sp;
            String currentPath = InstallConstant.getCurrentPath();
            String installPath = InitInstalledXmlTool.getInstallPath();
            tmpFile = currentPath + sp + "tmp.conf";
            String pwd = LegoResourceManager.getProValue("default.gauss.mangement.password");
            String decode = WccEncryptor.decode(pwd);
            KmcUtil.refreshCryptoConf();
            ProperUtil properUtil = new ProperUtil();
            KmcUtil.initKmc((String)(installPath + KMC_CONF), (ProperUtil)properUtil);
            WccEncryptor.getInstance().exportCipherKey(tmpFile, decode);
            KmcUtil.refreshCryptoConf();
            KmcUtil.initKmc((String)(currentPath + KMC_CONF), (ProperUtil)properUtil);
            WccEncryptor.getInstance().importCipherKey(tmpFile, decode);
            UpdateUtil.updateCrypt();
            FileUtil.copyFolder(currentPath + appHome + "crypt", installPath + appHome + "crypt");
        }
        catch (Exception e) {
            LOGGER.error((Object)e, "copy crypt failed.");
            throw new PatchException(21001L);
        }
        finally {
            FileUtil.deleteFile(tmpFile);
        }
    }

    private static void backUpInstallFile() throws IOException {
        String installFile = OSInformation.getInstalledFile();
        String backupFile = installFile + "@backup";
        File file = new File(installFile);
        if (!file.exists()) {
            LOGGER.error((Object)"Can not find the install file.", "");
            throw new IOException("Can not find the install file.");
        }
        FileUtil.copyFile(installFile, backupFile);
    }

    private static void execInstall(PatchDto dto) throws PatchException, IOException {
        List<PatchFile> rpFiles = dto.getRpFiles();
        List<PatchFile> addFiles = dto.getAddFiles();
        List<PatchFile> delFiles = dto.getDelFiles();
        List<SqlFile> installsqls = dto.getInstallSqlFiles();
        String backupFile = OSInformation.getUserHomePath() + File.separator + "RDInstalled_Bak.xml";
        String sp = File.separator;
        try {
            InstallPatchAction.rpFiles(rpFiles, sp);
            InstallPatchAction.delFiles(delFiles, sp);
            InstallPatchAction.addFiles(addFiles, sp);
        }
        catch (IOException e) {
            LOGGER.error((Object)"replace or add files failed. ", (Throwable)e, "");
            InstallPatchAction.installRollBack(false);
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20012L);
            throw ex;
        }
        catch (PatchException e) {
            InstallPatchAction.installRollBack(false);
            throw e;
        }
        try {
            InstallPatchAction.backUpInstallFile();
            ArrayList<String> list = new ArrayList<String>();
            list.add(PLATFORM);
            list.add(VR);
            list.add(VS);
            list.add(APP);
            for (String bundle : list) {
                List<SqlFile> filterSqls = InstallPatchAction.fiterSql(installsqls, bundle);
                InstallPatchAction.execSql(filterSqls, sp);
            }
        }
        catch (IOException ex) {
            InstallPatchAction.installRollBack(false);
            throw ex;
        }
        catch (PatchException ex) {
            InstallPatchAction.installRollBack(true);
            throw ex;
        }
        finally {
            File bakFile = new File(backupFile);
            if (bakFile.exists()) {
                bakFile.delete();
            }
        }
    }

    private static void execSql(List<SqlFile> sqls, String sp) throws PatchException {
        HashMap sqlFileMap = new HashMap();
        if (sqls == null || sqls.isEmpty()) {
            LOGGER.info((Object)"No Sql file should be exec.", "");
            return;
        }
        try {
            for (SqlFile sFile : sqls) {
                File sf = new File(packagePath + sp + sFile.getSrcName());
                LOGGER.info((Object)("SqlFile: " + sFile.getSrcName()), "");
                if (sqlFileMap.containsKey(sFile.getDbName())) {
                    ((List)sqlFileMap.get(sFile.getDbName())).add(sf);
                    continue;
                }
                ArrayList<File> sqlFiles = new ArrayList<File>();
                sqlFiles.add(sf);
                sqlFileMap.put(sFile.getDbName(), sqlFiles);
            }
            Set set = sqlFileMap.entrySet();
            DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            LOGGER.info((Object)("Exec sql size:" + set.size()), "");
            for (Map.Entry entry : set) {
                InitSQL iSql = new InitSQL(null);
                dbInfo.setDbName((String)entry.getKey());
                List sql = (List)entry.getValue();
                for (File file : sql) {
                    sqlFileList.add(file.getName());
                    iSql.fixSql(dbInfo, file);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("execInstall error. " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchException ex = new PatchException("execInstall error");
            ex.setErrorCode(20014L);
            throw ex;
        }
        catch (IOException e) {
            LOGGER.error((Object)"execInstall error. ", (Throwable)e, "");
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20014L);
            throw ex;
        }
    }

    private static List<SqlFile> fiterSql(List<SqlFile> sqls, String key) throws PatchException {
        String oldVersion;
        ArrayList<SqlFile> filterSqls = new ArrayList<SqlFile>();
        String maxVersion = oldVersion = InstallPatchAction.getMaxOldVersion(OSInformation.getInstalledFile(), key);
        LOGGER.info((Object)("the bundle[" + key + "], sql version is more than " + oldVersion + " will be exec."), "");
        if ("".equals(oldVersion) || oldVersion == null) {
            LOGGER.error((Object)("get Bundle version failed. bundle is :" + key), "");
            return null;
        }
        for (SqlFile sqlFile : sqls) {
            String sqlVersion = sqlFile.getVersion();
            if (!sqlFile.getSrcName().contains(key) || !InitBundleXmlTool.isNewVersion(oldVersion, sqlVersion)) continue;
            LOGGER.info((Object)("add install sql file: " + sqlFile.getSrcName()), "");
            filterSqls.add(sqlFile);
            if (maxVersion.compareTo(sqlVersion) >= 0) continue;
            maxVersion = sqlVersion;
        }
        if (maxVersion.compareTo(oldVersion) > 0) {
            InstallPatchAction.updateInstallXml(key, maxVersion);
            updateList.add(key);
        }
        return InstallPatchAction.sortSqlFile(filterSqls);
    }

    private static void updateInstallXml(String bundle, String version) throws PatchException {
        String installXml = OSInformation.getInstalledFile();
        File file = new File(installXml);
        SAXReader reader = new SAXReader();
        Document document = null;
        XMLWriter writer2 = null;
        FileOutputStream fos = null;
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            if (!file.exists()) {
                throw new FileNotFoundException("updateInstallXml failed, file not exists: " + file.getName());
            }
            document = reader.read(file);
            if (bundle.equalsIgnoreCase(PLATFORM)) {
                Element el = (Element)document.selectSingleNode("/install/platform");
                el.addAttribute("version", version);
            } else {
                List list = document.selectNodes("/install/product");
                for (Object obj : list) {
                    Element product = (Element)obj;
                    if (!product.attributeValue("name").contains(bundle)) continue;
                    product.addAttribute("version", version);
                }
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fos = new FileOutputStream(new File(installXml));
            writer2 = new XMLWriter((OutputStream)fos, format);
            writer2.write(document);
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"update install xml failed. ", (Throwable)e, "");
                throw new PatchException(20014L);
            }
            catch (Throwable throwable) {
                InstallPatchAction.closeStream(fos, writer2);
                throw throwable;
            }
        }
        InstallPatchAction.closeStream(fos, writer2);
    }

    private static void closeStream(FileOutputStream fos, XMLWriter writer) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close fileoutputStream failed. ", (Throwable)e, "");
            }
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close IOException failed. ", (Throwable)e, "");
            }
        }
    }

    public static String getMaxOldVersion(String installxml, String key) {
        String maxVersion = "";
        File install = new File(installxml);
        if (!install.exists()) {
            LOGGER.error((Object)"can not find the install file.", "");
            return maxVersion;
        }
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            document = reader.read(install);
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)("read install file fialed. " + e), "");
            return maxVersion;
        }
        if (key.equalsIgnoreCase(PLATFORM)) {
            Element el = (Element)document.selectSingleNode("/install/platform");
            maxVersion = el.attributeValue("version");
        } else {
            List list = document.selectNodes("/install/product");
            for (Object obj : list) {
                Element product = (Element)obj;
                if (!product.attributeValue("name").contains(key)) continue;
                maxVersion = product.attributeValue("version");
            }
        }
        return maxVersion;
    }

    private static void addFiles(List<PatchFile> addFiles, String sp) throws IOException {
        for (PatchFile file : addFiles) {
            String srcFileName = packagePath + sp + file.getSrcName();
            for (Map.Entry<String, String> distPath : file.getPaths().entrySet()) {
                boolean flag;
                File distDir = new File(distPath.getValue());
                if (!distDir.exists() && !(flag = distDir.mkdirs())) {
                    LOGGER.error((Object)"mkdirs error!", "");
                }
                FileUtil.copyFile(srcFileName, distPath.getValue() + file.getDistName());
            }
        }
    }

    private static void rpFiles(List<PatchFile> rpFiles, String sp) throws IOException {
        for (PatchFile file : rpFiles) {
            String srcFileName = packagePath + sp + file.getSrcName();
            for (Map.Entry<String, String> distPath : file.getPaths().entrySet()) {
                FileUtil.copyFile(srcFileName, distPath.getValue() + file.getDistName());
                String jarName = LegoResourceManager.getProValue("install.db.propfile.jar");
                if (null != jarName && jarName.equals(file.getSrcName())) {
                    LOGGER.info((Object)"start modify lego-core-base.", "");
                    InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
                    DataBaseInfo dbInfo = system.getDbInfor();
                    String installPath = system.getInstallpath();
                    ChangeDbInforInJar.changePropDBFile(dbInfo, installPath);
                }
                LOGGER.info((Object)("Rp files, src:" + file.getSrcName() + ",dist:" + file.getDistName()), "");
            }
        }
    }

    private static void delFiles(List<PatchFile> delFiles, String sp) throws PatchException {
        for (PatchFile file : delFiles) {
            for (Map.Entry<String, String> distPath : file.getPaths().entrySet()) {
                String delfile = distPath.getValue() + file.getDistName();
                FileUtil.deleteFile(distPath.getValue() + file.getDistName());
                if (new File(delfile).exists()) {
                    LOGGER.error((Object)"delete file failed.", "");
                    throw new PatchException(20013L);
                }
                LOGGER.info((Object)("del files:" + file.getDistName()), "");
            }
        }
    }

    private static void releaseFiles(PatchDto dto) throws IOException, PatchException {
        File packageF = new File(packagePath);
        File tmpF = new File(tmpPackagePath);
        if (!tmpF.exists()) {
            boolean flag = tmpF.mkdirs();
            if (!flag) {
                LOGGER.error((Object)"mkdirs error!", "");
            }
        } else {
            FileUtil.deleteAllFilesInFolder(tmpF);
        }
        if (packageF.exists()) {
            FileUtil.copyFolder(packagePath, tmpPackagePath);
        }
        try {
            FileUtil.deleteAllFilesInFolder(packageF);
            FileUtil.copyFolderToPatch(InstallConstant.getCurrentPath(), packagePath);
            InitPatchZipTool.setPatchVersion(packagePath, dto);
        }
        catch (IOException e2) {
            LOGGER.error((Object)"delete history files failed. ", (Throwable)e2, "");
            InstallPatchAction.unZipRollBack();
            throw e2;
        }
        catch (PatchException e) {
            LOGGER.error((Object)"unzip files failed. ", (Throwable)e, "");
            InstallPatchAction.unZipRollBack();
            throw e;
        }
    }

    private static void backupFiles(String realOutputPath, PatchDto dto) throws PatchException {
        List<PatchFile> rpFiles = dto.getRpFiles();
        List<PatchFile> delFiles = dto.getDelFiles();
        try {
            InstallPatchAction.backupFiles(realOutputPath, rpFiles, delFiles);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"backup files failed. ", (Throwable)ex, "");
            InstallPatchAction.backupRollBack();
            PatchException e = new PatchException(ex);
            e.setErrorCode(20011L);
            throw e;
        }
        catch (PatchException e) {
            LOGGER.error((Object)"backup files is not found in BCManager.", (Throwable)e, "");
            InstallPatchAction.backupRollBack();
            throw e;
        }
    }

    private static File backupFiles(String realOutputPath, List<PatchFile> rpFiles, List<PatchFile> delFiles) throws IOException, PatchException {
        String pathBackupPath = realOutputPath + File.separator;
        File backupDir = new File(pathBackupPath);
        if (!backupDir.exists()) {
            boolean flag = backupDir.mkdirs();
            if (!flag) {
                LOGGER.error((Object)"mkdirs error.", "");
            }
            backupDir.setWritable(true);
        } else {
            FileUtil.deleteAllFilesInFolder(backupDir);
        }
        for (PatchFile file : rpFiles) {
            LOGGER.info((Object)("backup the file which will be replaced: " + file.getSrcName()), "");
            InstallPatchAction.cpFiles(pathBackupPath, file);
        }
        for (PatchFile file : delFiles) {
            LOGGER.info((Object)("backup the file which will be deleted: " + file.getSrcName()), "");
            InstallPatchAction.cpFiles(pathBackupPath, file);
        }
        return backupDir;
    }

    private static void restorePackage(String src, String dst) throws IOException {
        File packageDir = new File(dst);
        if (packageDir.exists()) {
            FileUtil.deleteAllFilesInFolder(packageDir);
            FileUtil.copyFolder(src, dst);
        }
    }

    private static void cpFiles(String pathTmpPath, PatchFile file) throws IOException, PatchException {
        String tmpDir = null;
        File tmpFile = null;
        for (Map.Entry<String, String> distPath : file.getPaths().entrySet()) {
            String srcPath;
            File srcFile;
            boolean flag;
            tmpDir = pathTmpPath + distPath.getKey();
            tmpFile = new File(tmpDir);
            if (!tmpFile.exists() && !(flag = tmpFile.mkdirs())) {
                LOGGER.error((Object)"mkdirs error!", "");
            }
            if (!(srcFile = new File(srcPath = distPath.getValue() + file.getDistName())).exists()) {
                LOGGER.error((Object)("The file to copy is not exist, file: " + file.getDistName()), "");
                throw new PatchException(20011L);
            }
            FileUtil.copyFile(srcPath, tmpDir + File.separator + file.getDistName());
        }
    }

    private static void cleanFile() {
        File[] files;
        File backupDir = new File(backupPath);
        File tmpDir = new File(tmpPackagePath);
        try {
            FileUtil.deleteAllFilesInFolder(backupDir);
            FileUtil.deleteAllFilesInFolder(tmpDir);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Clean backup files error. ", (Throwable)e, "");
        }
        File packagedir = new File(packagePath);
        for (File f : files = packagedir.listFiles()) {
            if (f.getName().equals(patchFile) || f.getName().equals(versionFile)) continue;
            f.delete();
        }
    }

    private static void unZipRollBack() {
        try {
            InstallPatchAction.restorePackage(tmpPackagePath, packagePath);
            FileUtil.deleteAllFilesInFolder(new File(tmpPackagePath));
        }
        catch (IOException e) {
            LOGGER.error((Object)"unzip RoolBack failed.", "");
        }
    }

    private static void backupRollBack() {
        try {
            InstallPatchAction.unZipRollBack();
            FileUtil.deleteAllFilesInFolder(new File(backupPath));
        }
        catch (IOException e) {
            LOGGER.error((Object)"backup RoolBack failed.", "");
        }
    }

    private static void installRollBack(boolean isUpdateSQL) throws PatchException {
        UnInstallPatchAction.doAction(isUpdateSQL);
    }

    public static List<String> getUpdateList() {
        return updateList;
    }

    public static List<String> getSqlFileVersion() {
        ArrayList<String> version = new ArrayList<String>();
        if (sqlFileList != null) {
            for (String list : sqlFileList) {
                int index = list.indexOf("_");
                version.add(list.substring(0, index));
            }
        }
        return version;
    }

    private static List<SqlFile> sortSqlFile(List<SqlFile> sqlList) {
        int i = 0;
        int j = 0;
        for (i = 0; i < sqlList.size(); ++i) {
            for (j = i + 1; j < sqlList.size(); ++j) {
                if (sqlList.get(i).compareTo(sqlList.get(j)) <= 0) continue;
                SqlFile minFile = sqlList.get(j);
                sqlList.set(j, sqlList.get(i));
                sqlList.set(i, minFile);
            }
        }
        return sqlList;
    }
}

