/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch.handler;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.PatchHandler;
import com.huawei.lego.common.patch.PatchHandlerContext;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.IOException;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class LicensePatchHandler
extends PatchHandler {
    private static final Log logger = LogFactory.getInstance(LicensePatchHandler.class);

    @Override
    public String getVersion() {
        return "V100R005C00SPC101";
    }

    @Override
    public void backup(PatchHandlerContext context) {
        context.backup(UpdateUtil.getLicXmlPath());
    }

    @Override
    public void process() {
        try {
            UpdateUtil.updateLicXml();
        }
        catch (IOException e) {
            logger.error((Object)"handle license xml file failed", (Throwable)e, "");
            throw new PatchException(e);
        }
        catch (DocumentException | SAXException e) {
            logger.error((Object)"parse license xml file failed", e, "");
            throw new PatchException(e);
        }
    }

    @Override
    public void rollback(PatchHandlerContext context) {
        context.rollback(UpdateUtil.getLicXmlPath());
    }
}

