/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch.util;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.model.PatchFile;
import com.huawei.lego.common.patch.model.SqlFile;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class InitPatchZipTool {
    private static final Log LOGGER = LogFactory.getInstance(InitPatchZipTool.class);
    private static final int BUFFER_2048 = 2048;
    private static String installPath = null;
    private static final String PATCH_VERSION_CONF = "patchVersion.conf";
    private static final String PATCH_VERSION_KEY = "PATCH_VER";

    public static PatchDto getPatchInforFromXml() {
        String patchPath = InitPatchZipTool.getRuntimePath() + "Runtime" + File.separator + "patch";
        String packagePath = patchPath + File.separator + "package";
        String patchxmlPath = packagePath + File.separator + "patch.xml";
        PatchDto dto = InitPatchZipTool.getPatchInfoFromXml(patchxmlPath);
        return dto;
    }

    public static PatchDto getPatchInfoFromXml(String patchxmlPath) {
        PatchDto dto = new PatchDto();
        InputStream in = null;
        BufferedReader br = null;
        try {
            File patchxmlFile = new File(patchxmlPath);
            if (!patchxmlFile.exists()) {
                LOGGER.info((Object)("The old patch file is not exist: " + patchxmlFile.getName()));
                PatchDto patchDto = null;
                return patchDto;
            }
            in = new BufferedInputStream(new FileInputStream(patchxmlFile));
            br = new BufferedReader(new InputStreamReader(in));
            dto = InitPatchZipTool.getPatchInfor(br);
        }
        catch (PatchException e) {
            LOGGER.error((Object)"getPatchInforFromXml", (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            PatchException ex = new PatchException("FileNotFoundException");
            ex.setErrorCode(20005L);
            throw ex;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"getPatchInforFromXml close error ", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"getPatchInforFromXml close error ", (Throwable)e);
                }
            }
        }
        return dto;
    }

    public static PatchDto getPatchInforFromZip(File file) {
        if (!file.exists()) {
            LOGGER.error((Object)("getPatchInforFromZip failed, file not found: " + file.getName()));
            throw new PatchException(20001L);
        }
        PatchDto dto = new PatchDto();
        BufferedReader br = null;
        InputStreamReader brIn = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            brIn = new InputStreamReader(fs);
            br = new BufferedReader(brIn);
            dto = InitPatchZipTool.getPatchInfor(br);
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"getPatchInforFromZip error", (Throwable)e);
                PatchException ex = new PatchException("", e);
                ex.setErrorCode(20006L);
                throw ex;
            }
            catch (Throwable throwable) {
                InitPatchZipTool.releaseStream(br);
                InitPatchZipTool.releaseStream(brIn);
                InitPatchZipTool.releaseStream(fs);
                throw throwable;
            }
        }
        InitPatchZipTool.releaseStream(br);
        InitPatchZipTool.releaseStream(brIn);
        InitPatchZipTool.releaseStream(fs);
        dto.setPatchFileNames(InitPatchZipTool.traverseFiles(file.getParent()));
        return dto;
    }

    private static Set<String> traverseFiles(String path) {
        File file = new File(path);
        HashSet<String> results = new HashSet<String>();
        if (!file.exists()) {
            return results;
        }
        LinkedList<File> list = new LinkedList<File>();
        list.add(file);
        while (!list.isEmpty()) {
            File[] files;
            File temp_file = (File)list.removeFirst();
            for (File file2 : files = temp_file.listFiles()) {
                if (file2.isDirectory()) {
                    list.add(file2);
                    continue;
                }
                results.add(file2.getName());
            }
        }
        return results;
    }

    private static void releaseStream(ZipFile stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Release ZipFile is Error:");
            }
        }
    }

    private static void releaseStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Release Stream is Error:");
            }
        }
    }

    private static void getPatchInforNull(String sqlfile, String dbName, int index) {
        if (sqlfile == null || dbName == null || index == -1) {
            throw new PatchException(20015L);
        }
    }

    private static boolean getPatchInforValidate(List<Node> list) {
        return null != list && !list.isEmpty();
    }

    public static PatchDto getPatchInfor(Reader reader) {
        PatchDto dto = new PatchDto();
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(reader);
            Element eleTmp = (Element)document.selectSingleNode("/files/patchversion");
            String patchversion = eleTmp.getTextTrim();
            dto.setPatchVersion(patchversion);
            ArrayList<PatchFile> rpFiles = new ArrayList<PatchFile>();
            List list = document.selectNodes("/files/replacefile/file");
            if (InitPatchZipTool.getPatchInforValidate(list)) {
                for (Object ele : list) {
                    PatchFile rpFile = new PatchFile();
                    if (ele == null) continue;
                    rpFile.setSrcName(((Element)ele).attributeValue("srcName"));
                    rpFile.setDistName(((Element)ele).attributeValue("distName"));
                    rpFile.setBundleName(((Element)ele).attributeValue("bundle"));
                    String paths = ((Element)ele).attributeValue("path");
                    InitPatchZipTool.setPath(rpFile, paths);
                    rpFiles.add(rpFile);
                }
                dto.setRpFiles(rpFiles);
            }
            ArrayList<PatchFile> delFiles = new ArrayList<PatchFile>();
            list = document.selectNodes("/files/delfile/file");
            if (InitPatchZipTool.getPatchInforValidate(list)) {
                for (Node ele : list) {
                    PatchFile delFile = new PatchFile();
                    if (ele == null) continue;
                    delFile.setSrcName(((Element)ele).attributeValue("srcName"));
                    delFile.setDistName(((Element)ele).attributeValue("distName"));
                    delFile.setBundleName(((Element)ele).attributeValue("bundle"));
                    String paths = ((Element)ele).attributeValue("path");
                    InitPatchZipTool.setPath(delFile, paths);
                    delFiles.add(delFile);
                }
                dto.setDelFiles(delFiles);
            }
            ArrayList<PatchFile> addfiles = new ArrayList<PatchFile>();
            list = document.selectNodes("/files/addfile/file");
            if (InitPatchZipTool.getPatchInforValidate(list)) {
                for (Node ele : list) {
                    PatchFile addFile = new PatchFile();
                    if (ele == null) continue;
                    addFile.setSrcName(((Element)ele).attributeValue("srcName"));
                    addFile.setDistName(((Element)ele).attributeValue("distName"));
                    addFile.setBundleName(((Element)ele).attributeValue("bundle"));
                    String paths = ((Element)ele).attributeValue("path");
                    InitPatchZipTool.setPath(addFile, paths);
                    addfiles.add(addFile);
                }
                dto.setAddFiles(addfiles);
            }
            InitPatchZipTool.installSQL(dto, document);
            InitPatchZipTool.uninstallSQL(dto, document);
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"getPatchInfor error ", e);
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20015L);
            throw ex;
        }
        return dto;
    }

    private static void installSQL(PatchDto dto, Document document) {
        ArrayList<SqlFile> isqlfiles = new ArrayList<SqlFile>();
        List list = document.selectNodes("/files/sqlfile/install");
        if (InitPatchZipTool.getPatchInforValidate(list)) {
            for (Node ele : list) {
                String isqlfile = ((Element)ele).attributeValue("file");
                String dbName = ((Element)ele).attributeValue("dbName");
                int index = isqlfile.indexOf("_");
                InitPatchZipTool.getPatchInforNull(isqlfile, dbName, index);
                String version = isqlfile.substring(0, index);
                SqlFile sqlF = new SqlFile();
                sqlF.setDbName(dbName);
                sqlF.setSrcName(isqlfile);
                sqlF.setVersion(version);
                isqlfiles.add(sqlF);
            }
            dto.setInstallSqlFiles(isqlfiles);
        }
    }

    private static void uninstallSQL(PatchDto dto, Document document) {
        ArrayList<SqlFile> usqlfiles = new ArrayList<SqlFile>();
        List list = document.selectNodes("/files/sqlfile/uninstall");
        if (InitPatchZipTool.getPatchInforValidate(list)) {
            for (Node ele : list) {
                String usqlfile = ((Element)ele).attributeValue("file");
                String dbName = ((Element)ele).attributeValue("dbName");
                int index = usqlfile.indexOf("_");
                InitPatchZipTool.getPatchInforNull(usqlfile, dbName, index);
                String version = usqlfile.substring(0, index);
                SqlFile sqlF = new SqlFile();
                sqlF.setDbName(dbName);
                sqlF.setSrcName(usqlfile);
                sqlF.setVersion(version);
                usqlfiles.add(sqlF);
            }
            dto.setUninstallSqlFiles(usqlfiles);
        }
    }

    private static void setPath(PatchFile rpFile, String paths) {
        if (null != paths) {
            for (String str : paths.split(",")) {
                String realPath = str.startsWith("/") || !str.startsWith("/") && str.contains(":") ? str : InitPatchZipTool.getRuntimePath() + str;
                if (!(realPath = realPath.replace("/", File.separator).replace("\\", File.separator)).substring(realPath.length() - 1, realPath.length()).equals(File.separator)) {
                    realPath = realPath + File.separator;
                }
                if ((str = str.replace("/", File.separator).replace("\\", File.separator)).substring(str.length() - 1, str.length()).equals(File.separator)) {
                    str = str.substring(0, realPath.length() - 1);
                }
                rpFile.getPaths().put(str, realPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String unZip(String unZipfileName, String outputPath) throws PatchException {
        boolean flag;
        String distpath = null;
        File file = new File(unZipfileName);
        if (!file.exists()) {
            throw new PatchException(20008L);
        }
        File outputDir = new File(outputPath);
        if (!(outputPath.equals("") || outputDir.exists() || (flag = outputDir.mkdirs()))) {
            LOGGER.error((Object)"mkdirs error!");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(unZipfileName);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            ZipEntry zipEntry = null;
            while (e.hasMoreElements()) {
                zipEntry = e.nextElement();
                if (zipEntry.isDirectory()) {
                    LOGGER.info((Object)("ZipEntry is Directory: " + zipEntry.getName()));
                    continue;
                }
                String fileName = zipEntry.getName();
                fileName = fileName.replace('\\', '/');
                if (zipEntry.isDirectory()) {
                    LOGGER.info((Object)("sub zip entry is Directory: " + zipEntry.getName()));
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                String zfName = zipEntry.getName();
                int nameIndex = zfName.lastIndexOf("/");
                if (-1 == nameIndex) {
                    LOGGER.info((Object)("nameIndex of '/' is -1: , " + zfName));
                    continue;
                }
                zfName = zfName.substring(nameIndex + 1, zfName.length());
                list.add(outputPath + File.separator + zfName);
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    int c;
                    File f = new File(outputPath + File.separator + zfName);
                    boolean flag2 = f.createNewFile();
                    if (!flag2) {
                        LOGGER.error((Object)"createNewFile error!");
                    }
                    if (zipEntry.getName().endsWith("patch.xml")) {
                        distpath = f.getParent();
                    }
                    in = zipFile.getInputStream(zipEntry);
                    out = new FileOutputStream(f);
                    byte[] by = new byte[2048];
                    while ((c = in.read(by)) != -1) {
                        out.write(by, 0, c);
                    }
                }
                catch (Throwable throwable) {
                    InitPatchZipTool.releaseStream(out);
                    InitPatchZipTool.releaseStream(in);
                    throw throwable;
                }
                InitPatchZipTool.releaseStream(out);
                InitPatchZipTool.releaseStream(in);
            }
        }
        catch (IOException ex) {
            try {
                LOGGER.error((Object)"unZip exception. ", (Throwable)ex);
                PatchException e = new PatchException("", ex);
                e.setErrorCode(20010L);
                throw e;
            }
            catch (Throwable throwable) {
                InitPatchZipTool.releaseStream(zipFile);
                throw throwable;
            }
        }
        InitPatchZipTool.releaseStream(zipFile);
        return distpath;
    }

    public static void createDirectory(String directory, String subDirectory) {
        File fl = new File(directory);
        if (subDirectory.equals("") && !fl.exists()) {
            boolean flag = fl.mkdirs();
            if (!flag) {
                LOGGER.error((Object)"mkdirs error!");
            }
            return;
        }
        if (!subDirectory.equals("")) {
            String[] dir = subDirectory.replace("\\", "/").split("/");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dir.length; ++i) {
                sb.append(File.separator);
                sb.append(dir[i]);
                File subFile = new File(directory + File.separator + dir[i]);
                if (subFile.exists() || subFile.mkdir()) continue;
                LOGGER.error((Object)"mkdirs error!");
            }
            String tmp = sb.toString();
            directory = directory + tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemVersion() {
        String deployFile = InitPatchZipTool.getRuntimePath() + LegoResourceManager.getProValue("patch.software.name.version.file");
        String version = "";
        FileInputStream deploy = null;
        Properties p = new Properties();
        try {
            deploy = new FileInputStream(new File(deployFile));
            p.load(deploy);
            version = p.getProperty("version");
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"getSystemVersion failed, can not find the legoDeploy.conf");
        }
        catch (IOException e) {
            LOGGER.error((Object)"load FileInputStream failed.", (Throwable)e);
        }
        finally {
            if (deploy != null) {
                try {
                    deploy.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close ioexception failed.", (Throwable)e);
                }
            }
        }
        return version;
    }

    public static String getRuntimePath() {
        if (null != installPath) {
            return installPath;
        }
        String fileName = "RDInstalled.xml";
        SAXReader sax = new SAXReader();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                LOGGER.error((Object)("file is not exists. getRuntimePath failed." + file.getName()));
                throw new DocumentException("file is not exists. getRuntimePath failed." + file.getName());
            }
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(fileName));
            Element installElement = (Element)document.selectSingleNode("/install/installpath");
            String installPathStr = installElement.attribute("path").getValue();
            if (installPathStr != null) {
                boolean isSpLinux = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("/");
                boolean isSpWindows = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("\\");
                if (!isSpLinux && !isSpWindows) {
                    installPathStr = installPathStr + File.separator;
                }
                installPath = installPathStr;
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"getRuntimePath error. ", e);
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20009L);
            throw ex;
        }
        return installPath;
    }

    public static PatchDto getBackupPatchPto() {
        String patchPath = InitPatchZipTool.getRuntimePath() + "Runtime" + File.separator + "patch";
        String backupOldPatchConfPath = patchPath + File.separator + "backup" + File.separator + "oldPatchConf";
        String patchxmlPath = backupOldPatchConfPath + File.separator + "patch.xml";
        File patchxmlFile = new File(patchxmlPath);
        if (!patchxmlFile.exists()) {
            return null;
        }
        PatchDto dto = InitPatchZipTool.getPatchInfoFromXml(patchxmlPath);
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPatchVersion(String packagePath, PatchDto dto) {
        String confFileName = packagePath + File.separator + PATCH_VERSION_CONF;
        LOGGER.info((Object)"setPatchVersion path is patchVersion.conf");
        Properties pro = new Properties();
        FileOutputStream fileOutput = null;
        File flagFile = null;
        try {
            flagFile = new File(confFileName);
            Boolean result = Boolean.FALSE;
            if (flagFile.exists()) {
                LOGGER.info((Object)"setPatchVersion file is exist!");
                flagFile.setWritable(true);
                boolean flag = flagFile.delete();
                if (!flag) {
                    LOGGER.error((Object)"delete error.");
                }
            }
            if ((result = Boolean.valueOf(flagFile.createNewFile())).booleanValue()) {
                fileOutput = new FileOutputStream(flagFile);
            }
            pro.setProperty(PATCH_VERSION_KEY, dto.getPatchVersion());
            pro.store(fileOutput, "patch version");
        }
        catch (IOException e) {
            LOGGER.error((Object)"setStartStatus error", (Throwable)e);
        }
        finally {
            if (null != fileOutput) {
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"setStartStatus error", (Throwable)e);
                }
            }
        }
    }
}

