/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch.util;

import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.model.PatchFile;
import com.huawei.lego.common.patch.model.SqlFile;
import com.huawei.lego.common.patch.util.InitPatchZipTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class PatchChecker {
    private static Log LOGGER = LogFactory.getInstance(PatchChecker.class);
    private static String minSysVersion = "OceanStor BCManager V200R001C00SPC100";
    private static final String UPDATE_SUPPORT_FILE = "config/conf/update_support.xml";

    public static void isLegal(PatchDto dto) throws IOException {
        LOGGER.info((Object)"PatchChecker begin", "");
        PatchChecker.CheckSupportUpdate(dto);
        PatchChecker.checkPatchIsComplete(dto);
        PatchChecker.delBundle(dto, "RDInstalled.xml");
        LOGGER.info((Object)"PatchChecker end", "");
    }

    public static void CheckSupportUpdate(PatchDto dto) {
        try {
            File file = new File(UPDATE_SUPPORT_FILE);
            SAXReader xmlReader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)xmlReader);
            Document document = xmlReader.read(file);
            String sysVersion = InitPatchZipTool.getSystemVersion();
            Element ele = (Element)document.selectSingleNode("/Upgrade/patch");
            if (null == ele || null != sysVersion && !sysVersion.equals(ele.attribute("target").getValue())) {
                LOGGER.error((Object)("The system version is not support install this patch,system is " + sysVersion + ", support is " + ele.attribute("target").getValue()), "");
                throw new PatchException(20002L, new String[]{LegoResourceManager.getProValue("software.install.name")});
            }
            if (!PatchChecker.checkInstalledPatch()) {
                LOGGER.info((Object)"first install patch.", "");
                return;
            }
            String oldVersion = PatchChecker.getInstalledPatchVersion();
            if (oldVersion.equals(dto.getPatchVersion())) {
                LOGGER.error((Object)"current patch already been installed.", "");
                throw new PatchException(20017L);
            }
            List spcList = ele.selectNodes("child");
            for (Node spc : spcList) {
                if (!oldVersion.equals(spc.getText())) continue;
                return;
            }
            LOGGER.error((Object)"installed patch version is not in support version list.", "");
            throw new PatchException(20003L, new String[]{oldVersion});
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)e, "parase update_support.xml failed.");
            throw new PatchException(21001L);
        }
    }

    private static void delBundle(PatchDto dto, String installedFile) {
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(installedFile));
            List pdElementList = document.selectNodes("/install/product");
            HashSet<String> productList = new HashSet<String>();
            for (Node element : pdElementList) {
                String productId = ((Element)element).attributeValue("id");
                productList.add(productId);
            }
            List<PatchFile> files = dto.getAddFiles();
            List<PatchFile> newfiles = PatchChecker.getFileList(productList, files);
            dto.setAddFiles(newfiles);
            files = dto.getRpFiles();
            newfiles = PatchChecker.getFileList(productList, files);
            dto.setRpFiles(newfiles);
            files = dto.getDelFiles();
            newfiles = PatchChecker.getFileList(productList, files);
            dto.setDelFiles(newfiles);
        }
        catch (Exception e) {
            LOGGER.error((Object)("delBundle error:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private static List<PatchFile> getFileList(Set<String> productList, List<PatchFile> files) {
        ArrayList<PatchFile> newfiles = new ArrayList<PatchFile>();
        block0: for (PatchFile file : files) {
            if (null == file.getBundleName() || "".equals(file.getBundleName())) {
                newfiles.add(file);
                continue;
            }
            for (String pro : productList) {
                if (!pro.contains(file.getBundleName())) continue;
                newfiles.add(file);
                continue block0;
            }
        }
        return newfiles;
    }

    public static boolean checkSystemVersion() {
        String sysVersion = InitPatchZipTool.getSystemVersion();
        if (sysVersion.compareTo(minSysVersion) < 0) {
            LOGGER.error((Object)("the required minVersion is: " + minSysVersion + ", Current system version is: " + sysVersion), "");
            return false;
        }
        return true;
    }

    private static boolean checkInstalledPatch() {
        boolean isInstalled = false;
        String patchFolder = InitPatchZipTool.getRuntimePath() + LegoResourceManager.getProValue("patch.save.folder");
        String patchDsFile = patchFolder + File.separator + "package" + File.separator + "patch.xml";
        File oldPatchXml = new File(patchDsFile);
        if (oldPatchXml.exists()) {
            isInstalled = true;
        }
        return isInstalled;
    }

    private static String getInstalledPatchVersion() {
        String oldVersion = "";
        String patchFolder = InitPatchZipTool.getRuntimePath() + LegoResourceManager.getProValue("patch.save.folder");
        String patchDsFile = patchFolder + File.separator + "package" + File.separator + "patch.xml";
        patchDsFile = patchDsFile.replace("/", File.separator);
        File oldPatchXml = new File(patchDsFile = patchDsFile.replace("\\", File.separator));
        if (oldPatchXml.exists()) {
            oldVersion = PatchChecker.getOldPatchVersion(oldPatchXml);
        } else {
            PatchDto pto = InitPatchZipTool.getBackupPatchPto();
            if (null != pto) {
                oldVersion = pto.getPatchVersion();
            }
        }
        return oldVersion;
    }

    private static void checkPatchIsComplete(PatchDto dto) {
        for (PatchFile addFile : dto.getAddFiles()) {
            if (dto.getPatchFileNames().contains(addFile.getSrcName())) continue;
            throw new PatchException(20004L, new String[]{addFile.getSrcName()});
        }
        for (SqlFile sqlFile : dto.getInstallSqlFiles()) {
            if (dto.getPatchFileNames().contains(sqlFile.getSrcName())) continue;
            throw new PatchException(20004L, new String[]{sqlFile.getSrcName()});
        }
        for (PatchFile rpFile : dto.getRpFiles()) {
            if (dto.getPatchFileNames().contains(rpFile.getSrcName())) continue;
            throw new PatchException(20004L, new String[]{rpFile.getSrcName()});
        }
    }

    private static String getOldPatchVersion(File oldPatchXml) {
        SAXReader sax = new SAXReader();
        String patchversion = "";
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(oldPatchXml);
            Element eleTmp = (Element)document.selectSingleNode("/files/patchversion");
            patchversion = eleTmp.getTextTrim();
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"getoldPatchVersion error. ", e, "");
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20015L);
            ex.setParams(new String[]{Singleton.getSoftWareName()});
            throw ex;
        }
        return patchversion;
    }
}

