/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.upgrade;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.DataBaseUtil;
import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.util.InstallBuffer;
import com.huawei.drm.install.common.util.ProtectGroupUpdateHandler;
import com.huawei.drm.install.common.util.RdBaseExtenderImpl;
import com.huawei.drm.install.common.util.dbtool.InitDBTool;
import com.huawei.lego.cli.update.NeedInstallBundles;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.certs.ExportServiceCert;
import com.huawei.lego.common.changeport.ChangePort;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.extend.ExtendCommon;
import com.huawei.lego.common.extend.IextendCallBack;
import com.huawei.lego.common.ha.DisasterRecoveryData;
import com.huawei.lego.common.ha.HAInfo;
import com.huawei.lego.common.install.Install;
import com.huawei.lego.common.install.InstallCommon;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.DataBaseTestUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.SysConfigDataUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.common.util.dbtool.GaussDBUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Upgrade
extends Install {
    private static final String SUFIX_TMP = "@tmp";
    private static final String SEPT = File.separator;
    private static final String INSTALL_TYPE_HA = "HA";
    private static final String INSTALL_TYPE_AS = "Active/standby";
    private static final String PLATEXTEND = "com.huawei.lego.common.extend.PlatExtendUpdate";
    private static final Set<String> REMOVED_PRODUCT_SET = new HashSet<String>();
    private static Log logger;
    private static boolean isDBChanged;
    private static String backupPath;
    private static String backupFile;
    private static String installPath;
    private boolean isGuiMode = false;
    private boolean isCoreUpdate = false;
    private boolean isProductUpdate = false;
    private boolean isBackupEnd = false;
    private List<PlatformBundles> ptList = new ArrayList<PlatformBundles>();
    private List<ProductBundles> pdList = new ArrayList<ProductBundles>();

    public Upgrade(boolean isGuiMode) {
        super(Upgrade.getInstallPath());
        this.initBundleInfo();
    }

    public static String getInstallPath() {
        if (VerifyUtil.isEmpty((String)installPath)) {
            installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
        }
        return installPath;
    }

    private void initBundleInfo() {
        this.pdList = NeedInstallBundles.PRODUCT_BUNDLES;
        this.ptList = NeedInstallBundles.PLATFORM_BUNDLES;
        if (!VerifyUtil.isEmpty(this.ptList)) {
            for (PlatformBundles platformBundles : this.ptList) {
                String id = platformBundles.getId();
                if (!id.equals(LegoResourceManager.getProValue("lego.core.base.bundle.id"))) continue;
                this.isCoreUpdate = true;
                break;
            }
        }
        this.isProductUpdate = !this.pdList.isEmpty();
    }

    public boolean isBaseBundleUpdate() {
        return this.isCoreUpdate;
    }

    @Override
    public void process() {
        logger.info((Object)"enter upgrade process", "");
        try {
            ExtendCommon.setInstalledSystem();
            this.upgradeDatabase();
            this.reNameOldFile();
            this.updatePlatForm();
            this.installProduct();
            this.updateSysConfigData();
            this.savePathForLinux();
            this.executeSystemScript();
            if (OSInformation.isLinux() && this.isCoreUpdate) {
                logger.info((Object)"Is core update, need update HA.", " ");
                this.isInterrupted();
                InstallCommon.upgradeHA();
            }
            this.updateNodeAgentConfigFile();
            this.endProcess();
            logger.info((Object)"end upgrade process.", "");
        }
        catch (InstallException e) {
            logger.error((Object)("upgrade failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            if (e.getErrorCode() <= 0L) {
                e.setErrorCode(20005L);
            }
            this.dealwithUpgradeFail(e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("process upgrade failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            InstallException exception = new InstallException(20005L);
            this.dealwithUpgradeFail(exception);
            throw exception;
        }
    }

    public void dealwithUpgradeFail(InstallException exp) {
        if (exp.getErrorCode() != 20008L) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.UPDATE.FAILED", LegoResourceManager.getProValue("software.install.name")));
        }
        try {
            this.rollback();
        }
        catch (InstallException e) {
            SystemPrint.systemPrintStr(e.getErrorMsg());
        }
    }

    private void endProcess() {
        try {
            this.cleanTmpFile();
            this.cleanInstalledFile();
            if (!VerifyUtil.isEmpty((String)backupPath) && new File(backupPath).exists()) {
                FileUtil.deleteAllFolder(new File(backupPath));
            }
        }
        catch (Exception e) {
            logger.error((Object)("endProcess failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    public void cleanTmpFile() {
        String installPath = Upgrade.getInstallPath();
        if (this.isCoreUpdate) {
            this.deleteBkFolder(installPath);
            String installXMLPath = OSInformation.getUserHomePath();
            Upgrade.deleteBkFile(installXMLPath);
        } else {
            String frontPath = installPath + SEPT + LegoResourceManager.getProValue("install.lego_version.frontend.jar.path");
            String backPath = installPath + SEPT + LegoResourceManager.getProValue("install.lego_version.backend.jar.path");
            String configIniPath = installPath + SEPT + LegoResourceManager.getProValue("install.platform.config.ini.folder");
            String installXMLPath = OSInformation.getUserHomePath();
            Upgrade.deleteBkFile(frontPath);
            Upgrade.deleteBkFile(backPath);
            Upgrade.deleteBkFile(configIniPath);
            Upgrade.deleteBkFile(installXMLPath);
            String uninstallFolder = installPath + SEPT + LegoResourceManager.getProValue("install.uninstalldb.script");
            this.deleteBkFolder(uninstallFolder);
            String frontWarFolder = installPath + SEPT + LegoResourceManager.getProValue("install.lego_version.frontend.war.path");
            this.deleteBkFolder(frontWarFolder);
        }
    }

    private static void deleteBkFile(String folderPath) {
        File folder = new File(folderPath);
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(Upgrade.SUFIX_TMP);
            }
        });
        if (null != files) {
            for (File file : files) {
                logger.info((Object)("delete backup file: " + file.getName()), "");
                file.setWritable(true);
                boolean rt = file.delete();
                if (rt) continue;
                logger.info((Object)("deleteBkFile file failed:" + file.getName()), "");
            }
        }
    }

    private void deleteBkFolder(String folderPath) {
        File folder = new File(folderPath);
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(Upgrade.SUFIX_TMP);
            }
        });
        if (null != files) {
            for (File file : files) {
                FileUtil.deleteAllFolder(file);
            }
        }
    }

    private void updateCert() {
        logger.info((Object)"start dealwith cert.", "");
        UpdateUtil.updateCerts();
        if (OSInformation.isLinux()) {
            new ExportServiceCert().exportKeyStoreCert();
        }
    }

    private void updateNodeAgentConfigFile() throws IOException {
        InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
        String installPath = system.getInstallpath();
        String oldNodeAgentConfPath = installPath + SEPT + "Runtime" + SUFIX_TMP + SEPT + "NodeAgent/conf/nodeAgent.properties";
        String newNodeAgentConfPath = installPath + SEPT + "Runtime" + SEPT + "NodeAgent/conf/nodeAgent.properties";
        logger.info((Object)("update nodeAgent config file, installPath=" + installPath), "");
        PropertyUtil oldProUtil = new PropertyUtil(oldNodeAgentConfPath);
        String oldNode1 = oldProUtil.getValue("node_1");
        String oldNode2 = oldProUtil.getValue("node_2");
        String oldNode3 = oldProUtil.getValue("node_3");
        String oldNode4 = oldProUtil.getValue("node_4");
        HashMap<String, String> data = new HashMap<String, String>();
        if (oldNode1 == null && oldNode2 == null && oldNode3 == null && oldNode4 == null) {
            this.reConfigNodeAgent(data);
        } else {
            data.put("node_1", oldNode1 == null ? "" : oldNode1);
            data.put("node_2", oldNode2 == null ? "" : oldNode2);
            data.put("node_3", oldNode3 == null ? "" : oldNode3);
            data.put("node_4", oldNode4 == null ? "" : oldNode4);
        }
        JSONObject jsonData = new JSONObject();
        jsonData.putAll(data);
        logger.info((Object)("update nodeAgent config file, jsonData=" + jsonData.toString()), "");
        FileUtil.modifyDBPropFileUsingStr(newNodeAgentConfPath, data, newNodeAgentConfPath);
    }

    private void reConfigNodeAgent(Map<String, String> data) {
        String oldNodeConfPath = installPath + SEPT + "Runtime" + SUFIX_TMP + SEPT + "LegoRuntime/conf/node.properties";
        DisasterRecoveryData configData = new DisasterRecoveryData(true);
        HAInfo haInfo = HAInfo.getHAInfo();
        StringBuilder localIpSb = new StringBuilder();
        StringBuilder peerIpSb = new StringBuilder();
        if (configData.isEnable()) {
            haInfo.getHeartList().forEach(i -> localIpSb.append(i.getLocalIp() + ","));
            haInfo.getHeartList().forEach(i -> peerIpSb.append(i.getPeerIp() + ","));
            if (localIpSb.length() > 0) {
                localIpSb.replace(localIpSb.length() - 1, localIpSb.length(), ";");
            }
            if (peerIpSb.length() > 0) {
                peerIpSb.replace(peerIpSb.length() - 1, peerIpSb.length(), ";");
            }
            if (INSTALL_TYPE_HA.equals(configData.getDrType())) {
                PropertyUtil oldProUtil = new PropertyUtil(oldNodeConfPath);
                String oldRegionName = oldProUtil.getValue("config.hcs.node.region");
                localIpSb.append(oldRegionName == null ? "" : oldRegionName);
                peerIpSb.append(oldRegionName == null ? "" : oldRegionName);
            }
            data.put("node_1", localIpSb.toString());
            data.put("node_2", peerIpSb.toString());
        } else {
            InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
            localIpSb.append(system.getNetWorkPanel().getWorkMangIp());
            if (!VerifyUtil.isEmpty((String)system.getNetWorkPanel().getSecondip())) {
                localIpSb.append(",");
                localIpSb.append(system.getNetWorkPanel().getSecondip());
            }
            localIpSb.append(";");
            data.put("node_1", localIpSb.toString());
        }
    }

    private void updateConfigFile() throws Exception {
        this.updateInstallXML();
        UpdateUtil.updateLicXml();
        ChangePort.upgradePortConfFile();
    }

    private boolean recoveryName(String fileName) {
        File oldFile = new File(fileName);
        if (oldFile.exists()) {
            oldFile.setWritable(true);
            return oldFile.renameTo(new File(fileName.substring(0, fileName.length() - SUFIX_TMP.length())));
        }
        return true;
    }

    protected void rollback() {
        try {
            logger.info((Object)"Roll back begin", "");
            InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
            String installPath = system.getInstallpath();
            if (!this.isBackupEnd) {
                logger.info((Object)"the backup is not end, rollback is remove backpath and return.", "");
                FileUtil.deleteAllFolder(new File(installPath + SEPT + "Runtime" + SUFIX_TMP));
                if (OSInformation.isWindows()) {
                    Singleton.recoveryInstallFile();
                }
                return;
            }
            if (this.isCoreUpdate) {
                logger.info((Object)"roll back Runtime: ", "0x000252000FB5002F");
                GaussDBUtil.stopGaussDatabase();
                FileUtil.deleteAllFolder(new File(installPath + SEPT + "Runtime"));
                String backRuntime = installPath + SEPT + "Runtime" + SUFIX_TMP;
                if (!this.recoveryName(backRuntime)) {
                    throw new InstallException("Rollback Runtime failed.");
                }
                if (OSInformation.isLinux()) {
                    String envFile = "/etc/profile.d/lego.sh";
                    String serviceFile = "/etc/init.d/lego";
                    this.recoveryName(envFile + SUFIX_TMP);
                    this.recoveryName(serviceFile + SUFIX_TMP);
                }
            } else if (this.isProductUpdate) {
                logger.info((Object)"start rollback product.", "");
                String frontPath = installPath + SEPT + LegoResourceManager.getProValue("install.lego_version.frontend.jar.path");
                String backPath = installPath + SEPT + LegoResourceManager.getProValue("install.lego_version.backend.jar.path");
                for (ProductBundles productBundles : this.pdList) {
                    logger.info((Object)("start rollback product, id=" + productBundles.getId()), "");
                    List<String> backEndJarList = productBundles.getBackEndJar();
                    for (String name : backEndJarList) {
                        logger.info((Object)("delete backjar file: " + name), "");
                        FileUtil.deleteFile(backPath + SEPT + name);
                    }
                    List<String> ptFrontEndJarList = productBundles.getFrontEndJar();
                    for (String name : ptFrontEndJarList) {
                        logger.info((Object)("delete front jar file: " + name), "");
                        FileUtil.deleteFile(frontPath + SEPT + name);
                    }
                    FileUtil.deleteAllFolder(new File(installPath + SEPT + LegoResourceManager.getProValue("install.uninstalldb.script") + productBundles.getId()));
                    this.recoveryName(installPath + SEPT + LegoResourceManager.getProValue("install.uninstalldb.script") + productBundles.getId() + SUFIX_TMP);
                }
                this.recoveryFolderAllFile(frontPath);
                this.recoveryFolderAllFile(backPath);
                FileUtil.deleteFile(installPath + SEPT + LegoResourceManager.getProValue("install.platform.config.ini"));
                this.recoveryName(installPath + SEPT + LegoResourceManager.getProValue("install.platform.config.ini") + SUFIX_TMP);
            } else {
                logger.debug((Object)"other update scene.");
            }
            String installedFile = OSInformation.getInstalledFile();
            FileUtil.deleteFile(installedFile);
            this.recoveryName(installedFile + SUFIX_TMP);
            if (OSInformation.isWindows()) {
                Singleton.recoveryInstallFile();
            }
        }
        catch (Exception e) {
            logger.error((Object)("eReplication auto rollback failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20010L);
        }
        this.rollbackDatabase();
        if (!VerifyUtil.isEmpty((String)backupPath) && new File(backupPath).exists()) {
            FileUtil.deleteAllFolder(new File(backupPath));
        }
    }

    private void recoveryFolderAllFile(String folderPath) throws IOException {
        File folder = new File(folderPath);
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(Upgrade.SUFIX_TMP);
            }
        });
        if (null != files) {
            for (File file : files) {
                this.recoveryName(file.getCanonicalPath());
            }
        }
    }

    private void rollbackDatabase() {
        if (!isDBChanged) {
            logger.info((Object)"database not changed, no need rollback database.", "");
            return;
        }
        if (VerifyUtil.isEmpty((String)backupFile) || !new File(backupFile).exists()) {
            logger.info((Object)"the backup data file not found, no need rollback database.", "");
            return;
        }
        try {
            logger.info((Object)"start rollback database data.", "");
            if (!DataBaseTestUtil.connectionGauss()) {
                logger.info((Object)"db is not running, start it.", "");
                GaussDBUtil.startGaussDB();
            }
            SysConfigDataUtil.recoveryConfigData(backupFile, InitInstalledXmlTool.getInstalledSystem().getDbInfor().getDbaPassword());
            isDBChanged = false;
        }
        catch (Exception e) {
            logger.error((Object)("rollback database failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20009L);
        }
    }

    public void updateSysConfigData() {
        this.isInterrupted();
        InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
        DataBaseInfo dbInfo = system.getDbInfor();
        try {
            GaussDBUtil.startGaussDB(true);
            UpdateUtil.dealGaussDBUserAuth();
            List<String> selectBundles = PrepareParamUtil.getsInstallDto().getProductList();
            Map<String, PlatformBundles> oldPtMap = system.getPtMap();
            Map<String, ProductBundles> oldPdmap = system.getPdMap();
            backupPath = system.getInstallpath() + File.separator + "tmp_" + System.currentTimeMillis();
            backupFile = backupPath + File.separator + "ConfigData.zip";
            SysConfigDataUtil.backupSystemData(backupFile, dbInfo.getDbaPassword(), true);
            SysConfigDataUtil.transWccData();
            SysConfigDataUtil.importKsf(Upgrade.getInstallPath());
            if (!VerifyUtil.isEmpty(this.ptList)) {
                this.platformBundleUpdate(dbInfo, oldPtMap);
            }
            if (this.isProductUpdate) {
                this.productBundleUpdate(dbInfo, selectBundles, oldPdmap);
            }
            UpdateUtil.updateSysConfigData();
            String preVersion = InstallBuffer.getInstance().getStringBuffer("preVersion");
            logger.error((Object)("preVersion=" + preVersion), "");
            if (!VerifyUtil.isEmpty((String)preVersion) && preVersion.startsWith("OceanStor ReplicationDirector V100R003C10")) {
                RdBaseExtenderImpl.callUpdate(dbInfo);
                ProtectGroupUpdateHandler.processPolicyTemplate(dbInfo);
            }
            this.callPlatformUpdate();
            this.callProductInstall(true);
        }
        catch (Exception e) {
            logger.error((Object)("executeUpdateSql failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException("");
        }
    }

    private void platformBundleUpdate(DataBaseInfo dbInfo, Map<String, PlatformBundles> oldPtMap) throws IOException, SQLException {
        for (PlatformBundles platformBundles : this.ptList) {
            this.isCoreUpdate = true;
            String id = platformBundles.getId();
            if (!id.equals(LegoResourceManager.getProValue("lego.core.base.bundle.id"))) continue;
            isDBChanged = true;
            logger.info((Object)("start update platform bundle, id=" + id), "");
            InitDBTool.updatePlatformDB(dbInfo, oldPtMap.get(id).getVersion(), null, false);
        }
    }

    private void productBundleUpdate(DataBaseInfo dbInfo, List<String> selectBundles, Map<String, ProductBundles> oldPdmap) throws IOException, SQLException {
        for (ProductBundles productBundles : this.pdList) {
            String productPath;
            logger.info((Object)("start update product bundle, id=" + productBundles.getId()), "");
            if (!productBundles.isNeeded() && !selectBundles.contains(productBundles.getId())) {
                logger.info((Object)"the bundle is not selected, no need update. continue", "");
                continue;
            }
            isDBChanged = true;
            ProductBundles oldPd = oldPdmap.get(productBundles.getId());
            if (null != oldPd) {
                productPath = productBundles.getBundlePath();
                InitDBTool.updateProductDB(dbInfo, productPath, oldPd.getVersion(), null);
                continue;
            }
            productPath = productBundles.getBundlePath();
            InitDBTool.initProductDB(dbInfo, productPath);
        }
    }

    private void callPlatformUpdate() {
        try {
            IextendCallBack callBack = (IextendCallBack)Class.forName(PLATEXTEND).newInstance();
            UpdateUtil.updateSql(callBack);
        }
        catch (Exception e) {
            logger.error((Object)("update platform sql failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException("update platform sql failed.");
        }
    }

    public void reNameOldFile() {
        this.isInterrupted();
        String installPath = Upgrade.getInstallPath();
        try {
            String installedFile = OSInformation.getInstalledFile();
            FileUtil.copyFile(installedFile, installedFile + SUFIX_TMP);
            if (this.isCoreUpdate) {
                ChangePort.setPlatFromUpgrade(true);
                if (!this.reName(installPath + SEPT + "Runtime")) {
                    logger.error((Object)"backup runtime file failed.", "");
                    throw new InstallException(20001L);
                }
                if (OSInformation.isLinux()) {
                    String envFile = "/etc/profile.d/lego.sh";
                    String serviceFile = "/etc/init.d/lego";
                    FileUtil.copyFile(envFile, envFile + SUFIX_TMP);
                    FileUtil.copyFile(serviceFile, serviceFile + SUFIX_TMP);
                }
            }
            if (this.isProductUpdate) {
                Map<String, ProductBundles> pdMap = InitInstalledXmlTool.getInstalledSystem().getPdMap();
                for (ProductBundles product : this.getNeedInstalledBundle()) {
                    String id = product.getId();
                    ProductBundles oldPd = pdMap.get(id);
                    if (null == oldPd) continue;
                    List<String> backEndJarList = oldPd.getBackEndJar();
                    for (String name : backEndJarList) {
                        String oldFileName = installPath + SEPT + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + SEPT + name;
                        this.reName(oldFileName);
                    }
                    List<String> pdFrontEndJarList = oldPd.getFrontEndJar();
                    for (String name : pdFrontEndJarList) {
                        String oldFileName = installPath + SEPT + LegoResourceManager.getProValue("install.lego_version.frontend.jar.path") + SEPT + name;
                        this.reName(oldFileName);
                    }
                    this.reName(installPath + SEPT + LegoResourceManager.getProValue("install.uninstalldb.script") + product.getId());
                }
                FileUtil.copyFile(installPath + SEPT + LegoResourceManager.getProValue("install.platform.config.ini"), installPath + SEPT + LegoResourceManager.getProValue("install.platform.config.ini") + SUFIX_TMP);
            }
            this.isBackupEnd = true;
        }
        catch (InstallException e) {
            logger.error((Object)("backup file failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("backup file failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20002L);
        }
    }

    private boolean reName(String fileName) {
        boolean succ = false;
        File oldFile = new File(fileName);
        if (oldFile.exists()) {
            oldFile.setWritable(true);
            oldFile.setReadable(true, false);
            succ = oldFile.renameTo(new File(fileName + SUFIX_TMP));
        }
        return succ;
    }

    private void upgradeDatabase() {
        this.isInterrupted();
        try {
            GaussDBUtil.upgradeGaussDB();
            GaussDBUtil.stopGaussDatabase();
            if (!GaussDBUtil.takeOffArchiveMode()) {
                throw new InstallException("take archive mode to off failed");
            }
        }
        catch (Exception e) {
            logger.error((Object)("upgrade database failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20000L);
        }
    }

    private void copyGaussFiles(String installPath) {
        DataBaseInfo sDbInfor = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        try {
            if (sDbInfor.getDbPath().startsWith(InitInstalledXmlTool.getInstalledSystem().getInstallpath() + File.separator + "Runtime")) {
                logger.info((Object)"need copy dbpath.", "");
                FileUtil.copyFolder(sDbInfor.getDbPath().replace("Runtime", "Runtime@tmp"), sDbInfor.getDbPath());
            }
            if (sDbInfor.getDbFilePath().startsWith(InitInstalledXmlTool.getInstalledSystem().getInstallpath() + File.separator + "Runtime")) {
                logger.info((Object)"need copy dbfilepath.", "");
                FileUtil.copyFolder(sDbInfor.getDbFilePath().replace("Runtime", "Runtime@tmp"), sDbInfor.getDbFilePath());
            }
            String oldGaussScriptPath = InstallConstant.getsBasePath() + LegoResourceManager.getProValue("default.gauss.script.source");
            String newGaussScriptPath = installPath + File.separator + LegoResourceManager.getProValue("default.gauss.script.target");
            FileUtil.copyFolder(oldGaussScriptPath, newGaussScriptPath);
            logger.info((Object)"copy gauss files success!", "");
        }
        catch (Exception e) {
            logger.error((Object)("copy gaussdb files failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20003L);
        }
    }

    private void updatePlatForm() {
        this.isInterrupted();
        String installPath = Upgrade.getInstallPath();
        try {
            this.copyRuntimeFile();
            this.installPlatForm();
            FileUtil.copyFolder(installPath + SEPT + "Runtime" + SUFIX_TMP + SEPT + "LegoRuntime" + SEPT + "datastorage", installPath + SEPT + "Runtime" + SEPT + "LegoRuntime" + SEPT + "datastorage");
            FileUtil.copyFolder(installPath + SEPT + "Runtime" + SUFIX_TMP + SEPT + "LegoRuntime" + SEPT + "lic", installPath + SEPT + "Runtime" + SEPT + "LegoRuntime" + SEPT + "lic");
            this.copyGaussFiles(installPath);
            if (OSInformation.isLinux()) {
                logger.info((Object)"Linux Permission setting:", "");
                CmdUtil.setLinuxWithoutRoot(installPath);
            }
            this.changeDBConnectionInfo(InitInstalledXmlTool.getInstalledSystem().getDbInfor());
            this.updateConfigFile();
            this.updateCert();
        }
        catch (InstallException e) {
            logger.error((Object)("update platform failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20004L);
        }
        catch (Exception e) {
            logger.error((Object)("update platform failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new InstallException(20005L);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateInstallXML() {
        logger.info((Object)"start update installed xml file.", "");
        XMLWriter output = null;
        XMLWriter output2 = null;
        XMLWriter output3 = null;
        FileOutputStream fos = null;
        FileOutputStream fos2 = null;
        FileOutputStream fos3 = null;
        try {
            Element licEle;
            String fileName = LegoResourceManager.getProValue("install.params.installed.file");
            String installedFile = OSInformation.getInstalledFile();
            HashMap<String, PlatformBundles> newPtBundleMap = new HashMap<String, PlatformBundles>();
            HashMap<String, ProductBundles> newPdBundleMap = new HashMap<String, ProductBundles>();
            HashSet<String> newPtBundleSet = new HashSet<String>();
            HashSet<String> newPdBundleSet = new HashSet<String>();
            for (PlatformBundles ptBundle : this.ptList) {
                newPtBundleMap.put(ptBundle.getId(), ptBundle);
                newPtBundleSet.add(ptBundle.getId());
            }
            for (ProductBundles productBundles : this.getNeedInstalledBundle()) {
                newPdBundleMap.put(productBundles.getId(), productBundles);
                newPdBundleSet.add(productBundles.getId());
            }
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(installedFile));
            Element installElement = (Element)document.selectSingleNode("/install");
            InstallCommon.updateInstalledXml(installElement, InitInstalledXmlTool.getInstalledSystem().getNetWorkPanel());
            DataBaseUtil.updateDatabaseConfig(installPath, InitInstalledXmlTool.getInstalledSystem().getDbInfor());
            Element rootEle = document.getRootElement();
            Element dbElement = (Element)document.selectSingleNode("/install/database");
            if (null != dbElement) {
                logger.info((Object)"start remove database element.", "");
                rootEle.remove(dbElement);
            }
            if (null != (licEle = (Element)document.selectSingleNode("/install/licPath"))) {
                logger.info((Object)"start remove licpath element.", "");
                rootEle.remove(licEle);
            }
            if (this.isCoreUpdate) {
                this.updatePlatForm(installElement, newPtBundleSet, newPtBundleMap);
            }
            if (this.isProductUpdate) {
                this.updateProductForm(installElement, newPdBundleSet, newPdBundleMap);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            fos = new FileOutputStream(installedFile);
            output = new XMLWriter((OutputStream)fos, format);
            output.write(document);
            fos2 = new FileOutputStream(installPath + "/Runtime/bin/" + fileName);
            output2 = new XMLWriter((OutputStream)fos2, format);
            output2.write(document);
            fos3 = new FileOutputStream(installPath + "/Runtime/monitor/" + fileName);
            output3 = new XMLWriter((OutputStream)fos3, format);
            output3.write(document);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error((Object)"RDInstalled.xml is not found.", "");
                throw new InstallException("RDInstalled.xml is not found.");
                catch (Exception e2) {
                    logger.error((Object)("update RDInstalled.xml failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
                    throw new InstallException("");
                }
            }
            catch (Throwable throwable) {
                this.releaseStream(output);
                this.releaseStream(output2);
                this.releaseStream(output3);
                this.releaseStream(fos);
                this.releaseStream(fos2);
                this.releaseStream(fos3);
                throw throwable;
            }
        }
        this.releaseStream(output);
        this.releaseStream(output2);
        this.releaseStream(output3);
        this.releaseStream(fos);
        this.releaseStream(fos2);
        this.releaseStream(fos3);
    }

    private void updatePlatForm(Element installElement, Set<String> newPtBundleSet, Map<String, PlatformBundles> newPtBundleMap) {
        List list = installElement.elements("platform");
        ArrayList<Element> needDeleteEle = new ArrayList<Element>();
        for (Element ptBundleEle : list) {
            String id = ptBundleEle.attributeValue("id");
            if (!newPtBundleSet.contains(id)) continue;
            needDeleteEle.add(ptBundleEle);
            this.addNewPlatFormEle(installElement, newPtBundleMap, id);
            newPtBundleSet.remove(id);
        }
        for (String newPtId : newPtBundleSet) {
            this.addNewPlatFormEle(installElement, newPtBundleMap, newPtId);
        }
        for (Element element : needDeleteEle) {
            installElement.remove(element);
        }
    }

    private void addNewPlatFormEle(Element installElement, Map<String, PlatformBundles> newPtBundleMap, String newPtId) {
        Element newptEleTmp = installElement.addElement("platform");
        PlatformBundles ptBundle = newPtBundleMap.get(newPtId);
        newptEleTmp.addAttribute("id", ptBundle.getId());
        newptEleTmp.addAttribute("version", ptBundle.getVersion());
        newptEleTmp.addAttribute("name", ptBundle.getName());
        newptEleTmp.addAttribute("required", Boolean.toString(ptBundle.isNeeded()));
        newptEleTmp.addAttribute("description", ptBundle.getDescription());
        newptEleTmp.addAttribute("size", ptBundle.getSize());
        newptEleTmp.addAttribute("dependson", ptBundle.getDependson());
        newptEleTmp.addAttribute("dependsonversion", ptBundle.getDependsonVersion());
        List<String> bkJarList = ptBundle.getJarList();
        for (String jarName : bkJarList) {
            Element jarEle = newptEleTmp.addElement("jar");
            jarEle.addText(jarName);
        }
    }

    private void updateProductForm(Element installElement, Set<String> newPdBundleSet, Map<String, ProductBundles> newPdBundleMap) {
        List list = installElement.elements("product");
        ArrayList<Element> needDeleteEle = new ArrayList<Element>();
        for (Element pdBundleEle : list) {
            String id = pdBundleEle.attributeValue("id");
            if (REMOVED_PRODUCT_SET.contains(id)) {
                needDeleteEle.add(pdBundleEle);
                continue;
            }
            if (!newPdBundleSet.contains(id)) continue;
            needDeleteEle.add(pdBundleEle);
            this.addNewProductFormEle(installElement, newPdBundleMap, id);
            newPdBundleSet.remove(id);
        }
        for (String newPtId : newPdBundleSet) {
            this.addNewProductFormEle(installElement, newPdBundleMap, newPtId);
        }
        for (Element element : needDeleteEle) {
            installElement.remove(element);
        }
    }

    private void addNewProductFormEle(Element installElement, Map<String, ProductBundles> newPdBundleMap, String newPtId) {
        String extendClz;
        Element pdEleTmp = installElement.addElement("product");
        ProductBundles pdBundle = newPdBundleMap.get(newPtId);
        pdEleTmp.addAttribute("id", pdBundle.getId());
        pdEleTmp.addAttribute("version", pdBundle.getVersion());
        pdEleTmp.addAttribute("name", pdBundle.getName());
        pdEleTmp.addAttribute("required", Boolean.toString(pdBundle.isNeeded()));
        pdEleTmp.addAttribute("description", pdBundle.getDescription());
        pdEleTmp.addAttribute("size", pdBundle.getSize());
        pdEleTmp.addAttribute("dependson", pdBundle.getDependson());
        pdEleTmp.addAttribute("dependsonversion", pdBundle.getDependsonVersion());
        List<String> bkJarList = pdBundle.getBackEndJar();
        for (String string : bkJarList) {
            Element bkjarEle = pdEleTmp.addElement("backendjar");
            bkjarEle.addText(string);
        }
        List<String> ftJarList = pdBundle.getFrontEndJar();
        for (String jarName : ftJarList) {
            Element ftjarEle = pdEleTmp.addElement("frontendjar");
            ftjarEle.addText(jarName);
        }
        String string = pdBundle.getWindowsUnsCmd();
        String linuxUnsCmd = pdBundle.getLinuxUnsCmd();
        if (null != string) {
            Element windowUnsCmdEle = pdEleTmp.addElement("finalizescript");
            windowUnsCmdEle.addAttribute("os", "windows");
            windowUnsCmdEle.addText(string);
        }
        if (null != linuxUnsCmd) {
            Element linuxUnsCmdEle = pdEleTmp.addElement("finalizescript");
            linuxUnsCmdEle.addAttribute("os", "linux");
            linuxUnsCmdEle.addText(linuxUnsCmd);
        }
        if (null != (extendClz = pdBundle.getExtendCallBackClz())) {
            Element callbackclassEle = pdEleTmp.addElement("extend").addElement("callbackclass");
            callbackclassEle.addAttribute("class", extendClz);
        }
    }

    static {
        REMOVED_PRODUCT_SET.add("ism.drm.for.vsphere.bundle");
        REMOVED_PRODUCT_SET.add("ism.drm.for.app.bundle");
        logger = LogFactory.getInstance(Upgrade.class);
        isDBChanged = false;
        backupPath = "";
        backupFile = "";
        installPath = "";
    }
}

