/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.ism.drm.wcc.util.WccHelper;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryptor {
    private static Log logger = LogFactory.getInstance(AESEncryptor.class);
    private static String aesHexFirstHalf = "b15414c3c580bcddc1b00850b88915db";
    private static final int INT_0XFF = 255;
    private static final int INT_0X10 = 16;
    private static final int KEYLEN = 128;
    private static final int IVLEN = 16;
    private static final int IREATOR = 50000;
    private static final int LEN = 1024;
    private Cipher cipher;
    private IvParameterSpec dps;
    private SecretKeySpec skeySpec;

    public AESEncryptor() throws NumberFormatException, PatchException, GeneralSecurityException {
        String sp = File.separator;
        String currPath = InstallConstant.getCurrentPath();
        String appConfigFile = currPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "conf" + sp + "lego.properties";
        Properties pro = new Properties();
        try (FileInputStream inputStream = new FileInputStream(appConfigFile);){
            pro.load(inputStream);
        }
        catch (IOException ex) {
            throw new PatchException("lego.properties Not Found.");
        }
        String passKeyStr = pro.getProperty("common.util.AESEncryptor", "");
        try {
            passKeyStr = WccHelper.getInstance().decrypt(passKeyStr);
        }
        catch (IOException ex) {
            throw new PatchException("Get common.util.AESEncryptor from lego.properties failed.");
        }
        byte[] passkey = this.hex2Bin(passKeyStr);
        byte[] key = this.getAESKey(passkey);
        byte[] iv = this.getAESIV(passkey);
        this.dps = new IvParameterSpec(iv);
        this.skeySpec = new SecretKeySpec(key, "AES");
        this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    private byte[] getAESIV(byte[] keyRaw) {
        byte[] iv = new byte[16];
        System.arraycopy(keyRaw, 8, iv, 0, 16);
        return iv;
    }

    private byte[] getAESKey(byte[] keyRaw) {
        byte[] key = new byte[16];
        System.arraycopy(keyRaw, 0, key, 0, 8);
        System.arraycopy(keyRaw, 24, key, 8, 8);
        return key;
    }

    private String encrypt(String command) {
        try {
            this.cipher.init(1, (Key)this.skeySpec, this.dps);
            byte[] buf = this.cipher.doFinal(command.getBytes());
            return this.byte2hexString(buf);
        }
        catch (IllegalBlockSizeException es) {
            PatchException ex = new PatchException("", es);
            throw ex;
        }
        catch (InvalidKeyException ei) {
            PatchException ex = new PatchException("", ei);
            throw ex;
        }
        catch (InvalidAlgorithmParameterException ea) {
            PatchException ex = new PatchException("", ea);
            throw ex;
        }
        catch (BadPaddingException eb) {
            PatchException ex = new PatchException("", eb);
            throw ex;
        }
    }

    private String decrypt(String sSrc) {
        byte[] bin = this.hex2Bin(sSrc);
        if (null == bin) {
            throw new PatchException("hex is null value");
        }
        try {
            this.cipher.init(2, (Key)this.skeySpec, this.dps);
            return new String(this.cipher.doFinal(bin));
        }
        catch (IllegalBlockSizeException eb) {
            PatchException ex = new PatchException("", eb);
            throw ex;
        }
        catch (InvalidKeyException ek) {
            PatchException ex = new PatchException("", ek);
            throw ex;
        }
        catch (InvalidAlgorithmParameterException ep) {
            PatchException ex = new PatchException("", ep);
            throw ex;
        }
        catch (BadPaddingException ex) {
            PatchException eh = new PatchException("", ex);
            throw eh;
        }
    }

    private byte[] hex2Bin(String src) {
        if (src.length() < 1) {
            return null;
        }
        byte[] encrypted = new byte[src.length() / 2];
        for (int i = 0; i < src.length() / 2; ++i) {
            int high = Integer.parseInt(src.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(src.substring(i * 2 + 1, i * 2 + 2), 16);
            encrypted[i] = (byte)(high * 16 + low);
        }
        return encrypted;
    }

    private String byte2hexString(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }

    private static void writeSaltAndIV(String ivFile, String saltFile, String destPath, byte[] salt, byte[] iv) {
        FileOutputStream out1 = null;
        FileOutputStream out2 = null;
        try {
            out1 = new FileOutputStream(new File(saltFile), false);
            ((OutputStream)out1).write(salt);
            out1.flush();
            out2 = new FileOutputStream(new File(ivFile), false);
            ((OutputStream)out2).write(iv);
            out2.flush();
        }
        catch (IOException e) {
            try {
                logger.error((Object)("writeSaltAndIV failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("writeSaltAndIV failed.");
            }
            catch (Throwable throwable) {
                AESEncryptor.closeOutStream(out1, out2);
                throw throwable;
            }
        }
        AESEncryptor.closeOutStream(out1, out2);
    }

    private static void closeOutStream(OutputStream stream1, OutputStream stream2) {
        try {
            if (stream1 != null) {
                stream1.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close error:", "");
        }
        try {
            if (stream2 != null) {
                stream2.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close error:", "");
        }
    }

    private static Cipher initAESCipher(String sKey, int cipherMode, byte[] salt, byte[] iv) throws Exception {
        Cipher cipher = null;
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec keyspec = new PBEKeySpec(sKey.toCharArray(), salt, 50000, 128);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(keyspec).getEncoded(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(cipherMode, (Key)key, ivSpec);
        }
        catch (Exception e) {
            logger.error((Object)("InvalidKeyException when initAESCipher!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return cipher;
    }

    private static Cipher initAESCipher(String ivFile, String saltFile, String destPath, String sKey, int cipherMode) {
        Cipher cipher = null;
        try {
            SecureRandom saltRandom = SecureRandom.getInstance("SHA1PRNG");
            SecureRandom ivRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[128];
            saltRandom.nextBytes(salt);
            byte[] iv = new byte[16];
            ivRandom.nextBytes(iv);
            AESEncryptor.writeSaltAndIV(ivFile, saltFile, destPath, salt, iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec keyspec = new PBEKeySpec(sKey.toCharArray(), salt, 50000, 128);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(keyspec).getEncoded(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(cipherMode, (Key)key, ivSpec);
        }
        catch (Exception e) {
            throw new PatchException("initAESCipher failed", e);
        }
        return cipher;
    }

    public static void encryptFile(String ivFile, String saltFile, File sourceFile, String destName, String sKey) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherInputStream cipherInputStream = null;
        try {
            int nRead;
            inputStream = new FileInputStream(sourceFile);
            String outFile = sourceFile.getParent() + File.separator + destName;
            outputStream = new FileOutputStream(outFile);
            Cipher cipher = AESEncryptor.initAESCipher(ivFile, saltFile, sourceFile.getParent(), sKey, 1);
            cipherInputStream = new CipherInputStream(inputStream, cipher);
            byte[] cache = new byte[1024];
            while ((nRead = cipherInputStream.read(cache)) != -1) {
                ((OutputStream)outputStream).write(cache, 0, nRead);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("encrypt file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new LegoCheckedException("encrypt file failed.");
            }
            catch (Throwable throwable) {
                AESEncryptor.doCloseStream(inputStream, outputStream, cipherInputStream);
                throw throwable;
            }
        }
        AESEncryptor.doCloseStream(inputStream, outputStream, cipherInputStream);
    }

    public static void decryptFile(String sourceFile, String destFile, String sKey, byte[] salt, byte[] iv) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherOutputStream cipherOutputStream = null;
        try {
            int r;
            File file = new File(destFile);
            if (!file.exists()) {
                logger.info((Object)("create file result: " + file.createNewFile()), "");
            }
            Cipher cipher = AESEncryptor.initAESCipher(sKey, 2, salt, iv);
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(file);
            cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            byte[] buffer = new byte[1024];
            while ((r = ((InputStream)inputStream).read(buffer)) >= 0) {
                cipherOutputStream.write(buffer, 0, r);
            }
            cipherOutputStream.flush();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("IOException when decryptFile!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("decryptFile failed.");
            }
            catch (Throwable throwable) {
                FileUtil.close(outputStream, "close output");
                FileUtil.close(cipherOutputStream, "close ciphere");
                FileUtil.close(inputStream, "close input");
                throw throwable;
            }
        }
        FileUtil.close(outputStream, "close output");
        FileUtil.close(cipherOutputStream, "close ciphere");
        FileUtil.close(inputStream, "close input");
    }

    private static void doCloseStream(InputStream inputStream, OutputStream outputStream, CipherInputStream cipherInputStream) {
        try {
            if (null != cipherInputStream) {
                cipherInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (null != outputStream) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile close error.", "");
        }
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile close error.", "");
        }
    }

    public static String aes123encrypt(String user, String decryptCtxt) {
        String encryptCtxt;
        try {
            AESEncryptor aes = new AESEncryptor();
            encryptCtxt = user.length() == "".length() ? aes.encrypt(decryptCtxt) : aes.encrypt(user + decryptCtxt);
        }
        catch (Exception ex) {
            encryptCtxt = "";
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return encryptCtxt;
    }

    private static String aes123decrypt(String user, String encryptCtxt) {
        String decryptCtxt = "";
        try {
            AESEncryptor aes = new AESEncryptor();
            String param = aes.decrypt(encryptCtxt);
            if (user.length() == "".length()) {
                decryptCtxt = param;
            } else {
                boolean isStartWithUser = param.startsWith(user);
                if (isStartWithUser) {
                    decryptCtxt = param.substring(user.length());
                }
            }
        }
        catch (Exception ex) {
            decryptCtxt = "";
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return decryptCtxt;
    }

    public static String encode(String rawData) {
        return AESEncryptor.aes123encrypt("", rawData);
    }

    public static String decode(String encryptedData) {
        return AESEncryptor.aes123decrypt("", encryptedData);
    }
}

