/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.dto.InstallScript;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.ErrHandleTask;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class CmdUtil {
    private static final String ERRLOG = "logs/importDBErr.log";
    private static final String INFOLOG = "logs/importDBInput.log";
    private static Log logger = LogFactory.getInstance(CmdUtil.class);

    public static void runInstallScript(InstallScript script) {
        File tmpFile;
        if (null == script) {
            logger.info((Object)"Install System Script: null", "");
            return;
        }
        String scriptPath = script.getName();
        boolean absPath = script.isAbsolutePath();
        String[] params = script.getParams();
        if (!absPath) {
            scriptPath = InstallConstant.getsBasePath() + script.getName();
        }
        if (!(tmpFile = new File(scriptPath)).exists()) {
            logger.error((Object)("the script is not exists: " + tmpFile.getName()), "");
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(scriptPath);
        Properties props = System.getProperties();
        String os = props.getProperty("os.name");
        if (os.contains("Windows")) {
            CmdUtil.runbatParams(sb.toString(), params);
        } else {
            if (null != params && params.length > 0) {
                for (String param : params) {
                    sb.append(" " + param);
                }
            }
            try {
                CmdUtil.runShell(sb.toString());
            }
            catch (IOException e) {
                logger.error((Object)"Install System Script Error:", (Throwable)e, "");
            }
            catch (InterruptedException e) {
                logger.error((Object)"Install System Script Error:", (Throwable)e, "");
            }
        }
    }

    public static void runbatParams(String path, String[] params) {
        File file = new File(path);
        if (!file.exists()) {
            logger.error((Object)("runbatParams error, return, file is not exists: " + file.getName()), "");
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("cmd /c start /b ");
        sb.append(path.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
    }

    public static void setLinuxWithoutRoot(String savaPath) throws IOException, InterruptedException {
        String legoRuntimePath;
        String tomcatPath;
        String jrePath;
        String path;
        File tmpPath = new File(savaPath);
        if (!tmpPath.exists()) {
            throw new FileNotFoundException("setLinuxWithoutRoot failed.");
        }
        ArrayList<String> lists = new ArrayList<String>();
        String serverUser = "ICUser";
        String serverUserGroup = "lego";
        String webUser = "ICUser";
        if (CmdUtil.isConfigExits().booleanValue()) {
            serverUser = LegoResourceManager.getProValue("custom.user.name");
            serverUserGroup = LegoResourceManager.getProValue("custom.user.group");
            webUser = LegoResourceManager.getProValue("tomcat.user.name");
        }
        if (!(ParamCheck.checkUserName(serverUser) && ParamCheck.checkUserName(serverUserGroup) && ParamCheck.checkUserName(webUser))) {
            throw new IOException("get system user from startinfo.properties failed.");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(savaPath.replace("\\/", "/").replace(" ", "\" \""));
        if (savaPath.endsWith("/")) {
            path = sb.toString() + LegoResourceManager.getProValue("install.lego_version.platform.runtime");
            jrePath = sb.toString() + LegoResourceManager.getProValue("install.java.name");
            tomcatPath = sb.toString() + LegoResourceManager.getProValue("install.lego_version.frontend.war");
            legoRuntimePath = sb.toString() + "Runtime/LegoRuntime";
            lists.add("chmod 700 -R " + path + "/*");
            lists.add("chown -R " + serverUser + ":" + serverUserGroup + " " + path);
            lists.add("chmod 750 " + savaPath);
            lists.add("chown  " + serverUser + ":" + serverUserGroup + " " + savaPath);
            lists.add("chmod 750 " + legoRuntimePath);
            lists.add("chmod 750 " + path + "/");
            lists.add("chmod 750 -R " + jrePath);
            lists.add("chmod 750 -R " + tomcatPath);
            lists.add("chown -R " + webUser + ":" + serverUserGroup + " " + tomcatPath);
        } else {
            path = sb.toString() + "/" + LegoResourceManager.getProValue("install.lego_version.platform.runtime");
            jrePath = sb.toString() + "/" + LegoResourceManager.getProValue("install.java.name");
            tomcatPath = sb.toString() + "/" + LegoResourceManager.getProValue("install.lego_version.frontend.war");
            legoRuntimePath = sb.toString() + "/Runtime/LegoRuntime";
            lists.add("chmod 700 -R " + path + "/*");
            lists.add("chown -R " + serverUser + ":" + serverUserGroup + " " + path);
            lists.add("chmod 750 " + savaPath);
            lists.add("chmod 750 " + legoRuntimePath);
            lists.add("chown  " + serverUser + ":" + serverUserGroup + " " + savaPath);
            lists.add("chmod 750 " + path + "/");
            lists.add("chmod 750 -R " + jrePath);
            lists.add("chmod 750 -R " + tomcatPath);
            lists.add("chown -R " + webUser + ":" + serverUserGroup + " " + tomcatPath);
        }
        for (String cmd : lists) {
            CmdUtil.runShell(cmd);
        }
    }

    private static Boolean isConfigExits() {
        String deployFile = InstallConstant.getsBasePath() + LegoResourceManager.getProValue("start.user.info.file");
        File file = new File(deployFile);
        if (file.exists()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void runShell(String shPath, String[] params) throws IOException, InterruptedException {
        File file = new File(shPath);
        if (!file.exists()) {
            throw new FileNotFoundException("can not find the script: " + file.getName());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(shPath.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        CmdUtil.runShell(sb.toString());
    }

    public static boolean runShell(String shPath, String[] params, String result) {
        File file = new File(shPath);
        if (!file.exists()) {
            logger.error((Object)("runShell failed, file is not exists: " + file.getName()), "");
            return false;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(shPath.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        return CmdUtil.runShell(sb.toString(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runShell(String shStr) throws IOException, InterruptedException {
        Process process = new ProcessBuilder("/bin/sh", "-c", shStr).redirectErrorStream(true).start();
        LineNumberReader input = null;
        try {
            String line;
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            input = new LineNumberReader(ir);
            while ((line = FileUtil.getLineFromFile(input)) != null) {
                logger.info((Object)("Linux shell output: " + line), "");
            }
            CmdUtil.closeRealble(input);
        }
        catch (IOException e) {
            logger.error((Object)"run shell error :", e.getMessage());
        }
        finally {
            CmdUtil.closeRealble(input);
        }
        Integer waitFor = process.waitFor();
        logger.info((Object)waitFor, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSysoShell(String shStr) throws IOException, InterruptedException {
        Process process = new ProcessBuilder("/bin/sh", "-c", shStr).redirectErrorStream(true).start();
        LineNumberReader input = null;
        try {
            String line;
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            input = new LineNumberReader(ir);
            while ((line = FileUtil.getLineFromFile(input)) != null) {
                SystemPrint.systemPrintStr(line);
            }
            CmdUtil.closeRealble(input);
        }
        catch (IOException e) {
            logger.error((Object)"run SysoShell error :", e.getMessage());
        }
        finally {
            CmdUtil.closeRealble(input);
        }
        Integer waitFor = process.waitFor();
        logger.info((Object)waitFor, "");
    }

    public static boolean execStrCmd(String cmd) {
        return CmdUtil.execStrCmd(cmd, new String[0]);
    }

    public static boolean execStrCmd(String cmd, String[] params) {
        Process ps = null;
        boolean isSuccess = false;
        try {
            ps = Runtime.getRuntime().exec(cmd);
            try (BufferedWriter outputBW = new BufferedWriter(new OutputStreamWriter(ps.getOutputStream(), StandardCharsets.UTF_8));){
                for (String param : params) {
                    outputBW.write(param);
                    outputBW.newLine();
                }
                outputBW.flush();
            }
            catch (Exception e) {
                logger.error((Object)String.format(Locale.ENGLISH, "Failed to execute the input command(%s).", cmd));
                boolean bl = false;
                if (null != ps) {
                    ps.destroy();
                }
                return bl;
            }
            InputStreamReader input = new InputStreamReader(ps.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader inputBr = new BufferedReader(input);
            ErrHandleTask inputTask = new ErrHandleTask(inputBr, INFOLOG);
            InputStreamReader err = new InputStreamReader(ps.getErrorStream(), StandardCharsets.UTF_8);
            BufferedReader errBr = new BufferedReader(err);
            ErrHandleTask errTask = new ErrHandleTask(errBr, ERRLOG);
            Thread inputT = new Thread(inputTask);
            Thread errT = new Thread(errTask);
            inputT.start();
            errT.start();
            int result = ps.waitFor();
            logger.info((Object)("check result: " + result), "");
            if (result == 0) {
                isSuccess = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("exec failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("exec cmd failed");
        }
        finally {
            if (null != ps) {
                ps.destroy();
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execShellCmd(String cmd) {
        boolean isSuccess;
        block10: {
            InputStreamReader ir;
            LineNumberReader input;
            block9: {
                Process ps = null;
                input = null;
                ir = null;
                isSuccess = false;
                try {
                    String line;
                    ps = new ProcessBuilder("/bin/sh", "-c", cmd).redirectErrorStream(true).start();
                    ir = new InputStreamReader(ps.getInputStream());
                    input = new LineNumberReader(ir);
                    while ((line = FileUtil.getLineFromFile(input)) != null) {
                        logger.info((Object)("line: " + line), "");
                    }
                    while ((line = FileUtil.getLineFromFile(new LineNumberReader(new InputStreamReader(ps.getErrorStream())))) != null) {
                        logger.info((Object)("error: " + line), "");
                    }
                    int result = ps.waitFor();
                    logger.info((Object)("check result: " + result), "");
                    if (result == 0) {
                        isSuccess = true;
                    }
                    if (null == ps) break block9;
                    ps.destroy();
                }
                catch (Exception e) {
                    logger.error((Object)"exec failed", ExceptionUtil.getErrorMessage((Throwable)e));
                    break block10;
                }
                finally {
                    if (null != ps) {
                        ps.destroy();
                    }
                    CmdUtil.closeRealble(ir);
                    CmdUtil.closeRealble(input);
                }
            }
            CmdUtil.closeRealble(ir);
            CmdUtil.closeRealble(input);
        }
        return isSuccess;
    }

    public static boolean execShellCmd(String cmd, String[] param) {
        StringBuffer buff = new StringBuffer();
        buff.append(cmd);
        if (null != param) {
            for (String par : param) {
                buff.append(" " + par);
            }
        }
        return CmdUtil.execShellCmd(buff.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runShell(String shStr, String result) {
        boolean ret;
        block11: {
            ret = false;
            Process process = null;
            LineNumberReader input = null;
            InputStreamReader ir = null;
            try {
                String line;
                process = new ProcessBuilder("/bin/sh", "-c", shStr).redirectErrorStream(true).start();
                ir = new InputStreamReader(process.getInputStream());
                input = new LineNumberReader(ir);
                while ((line = FileUtil.getLineFromFile(input)) != null) {
                    if (line.indexOf(result) != -1) {
                        ret = true;
                    }
                    logger.info((Object)line, "");
                }
                try {
                    Integer waitFor = process.waitFor();
                    logger.info((Object)waitFor, "");
                }
                catch (InterruptedException e) {
                    logger.error((Object)"runshell waitFor exception:", (Throwable)e, "");
                }
                CmdUtil.closeRealble(input);
            }
            catch (IOException ioe) {
                logger.error((Object)"runshell waitFor ioexception:", (Throwable)ioe, "");
                break block11;
            }
            finally {
                CmdUtil.closeRealble(input);
                CmdUtil.closeRealble(ir);
                if (null != process) {
                    process.destroy();
                }
            }
            CmdUtil.closeRealble(ir);
            if (null != process) {
                process.destroy();
            }
        }
        return ret;
    }

    private static void closeRealble(Closeable cls) {
        if (null != cls) {
            try {
                cls.close();
            }
            catch (IOException e) {
                logger.error((Object)e, "close error.");
            }
        }
    }
}

