/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class CommonDBUtil {
    private static Log logger = LogFactory.getInstance(CommonDBUtil.class);

    private CommonDBUtil() {
    }

    public static void executeSQL(Connection conn, String sql) throws SQLException, PatchException {
        PreparedStatement pst = null;
        try {
            if (null == conn) {
                PatchException ex = new PatchException("", new NullPointerException());
                throw ex;
            }
            pst = CommonDBUtil.executeSQLQuery(conn, sql);
            pst.execute();
        }
        catch (SQLException es) {
            try {
                logger.error((Object)("SQL SQLException: " + ExceptionUtil.getErrorMessage((Throwable)es)));
                throw new SQLException("executeSQL failed.");
            }
            catch (Throwable throwable) {
                CommonDBUtil.closePreparedStatement(pst);
                throw throwable;
            }
        }
        CommonDBUtil.closePreparedStatement(pst);
    }

    private static void closePreparedStatement(PreparedStatement pst) {
        try {
            if (pst != null) {
                pst.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("PreparedStatement close SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public static void executeSQL(Connection conn, String sql, Object[] params) throws SQLException, PatchException {
        PreparedStatement pst3 = null;
        try {
            if (null == conn) {
                PatchException ex = new PatchException("", new NullPointerException());
                throw ex;
            }
            pst3 = CommonDBUtil.executeSQLQuery(conn, sql);
            for (int i = 0; i < params.length; ++i) {
                Object paramVal = params[i];
                if (paramVal instanceof Integer) {
                    pst3.setInt(i + 1, (Integer)paramVal);
                } else if (paramVal instanceof String) {
                    pst3.setString(i + 1, (String)paramVal);
                } else if (paramVal instanceof Long) {
                    pst3.setLong(i + 1, (Long)paramVal);
                }
                if (null != paramVal) continue;
                pst3.setString(i + 1, null);
            }
            pst3.execute();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)("execute SQL Error: " + ExceptionUtil.getErrorMessage((Throwable)ex)));
                throw new SQLException("executeSQL failed.");
            }
            catch (Throwable throwable) {
                CommonDBUtil.closePreparedStatement(pst3);
                throw throwable;
            }
        }
        CommonDBUtil.closePreparedStatement(pst3);
    }

    public static PreparedStatement executeSQLQuery(Connection conn, String sql) throws SQLException {
        PreparedStatement pst = conn.prepareStatement(sql);
        return pst;
    }

    public static PreparedStatement executeSQLQuery(Connection conn, String sql, Object[] params) throws SQLException, PatchException {
        PreparedStatement pst = null;
        try {
            if (null == conn) {
                PatchException ex = new PatchException("", new NullPointerException());
                throw ex;
            }
            pst = CommonDBUtil.executeSQLQuery(conn, sql);
            for (int i = 0; i < params.length; ++i) {
                Object paramVal = params[i];
                if (paramVal instanceof Integer) {
                    pst.setInt(i + 1, (Integer)paramVal);
                } else if (paramVal instanceof String) {
                    pst.setString(i + 1, (String)paramVal);
                } else if (paramVal instanceof Long) {
                    pst.setLong(i + 1, (Long)paramVal);
                }
                if (null != paramVal) continue;
                pst.setString(i + 1, null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("execute SQL Error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            if (null != pst) {
                pst.close();
            }
            throw new SQLException("executeSQLQuery faild.");
        }
        return pst;
    }

    public static Integer executeSQL(Connection conn, String sql, String[] keyColumns, Object[] params) throws SQLException, PatchException {
        Integer n;
        Integer genKey = 0;
        PreparedStatement pStatement0 = null;
        try {
            if (null == conn) {
                PatchException ex = new PatchException("", new NullPointerException());
                throw ex;
            }
            pStatement0 = conn.prepareStatement(sql, keyColumns);
            for (int i = 0; i < params.length; ++i) {
                Object paramVal = params[i];
                if (paramVal instanceof Integer) {
                    pStatement0.setInt(i + 1, (Integer)paramVal);
                } else if (paramVal instanceof String) {
                    pStatement0.setString(i + 1, (String)paramVal);
                } else if (paramVal instanceof Long) {
                    pStatement0.setLong(i + 1, (Long)paramVal);
                }
                if (null != paramVal) continue;
                pStatement0.setString(i + 1, null);
            }
            pStatement0.execute();
            ResultSet rsKey = pStatement0.getGeneratedKeys();
            while (rsKey.next()) {
                genKey = rsKey.getInt(1);
            }
            n = genKey;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("SQL error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new SQLException("executeSQL failed.");
            }
            catch (Throwable throwable) {
                CommonDBUtil.closePreparedStatement(pStatement0);
                throw throwable;
            }
        }
        CommonDBUtil.closePreparedStatement(pStatement0);
        return n;
    }
}

