/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.cipher.sm.SMFileEncryptor;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.AESEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;

public class FileEncryptor {
    private static final Log LOGGER = LogFactory.getInstance(FileEncryptor.class);
    private static final int SALT_LEN = 128;
    private static final int IV_LEN = 16;
    private static final String GENERAL_CIPHER = "generalCipher";
    private static final String LEGO_CONFIG_PATH = "/LegoRuntime/conf/lego.properties";

    public static void encryptFileAccordingCipher(String pwd, File sourceFile, String ivPath, String saltPath, String targetPath) {
        String currentCipher = FileEncryptor.getCurrentCipher();
        if (GENERAL_CIPHER.equals(currentCipher)) {
            AESEncryptor.encryptFile(ivPath, saltPath, sourceFile, targetPath, pwd);
        } else {
            SMFileEncryptor.encryptFile(ivPath, sourceFile, targetPath, pwd);
        }
    }

    private static String getCurrentCipher() {
        Optional<String> runtimePath = FileEncryptor.getRuntimePath();
        if (runtimePath.isPresent()) {
            File file = new File(runtimePath.get() + LEGO_CONFIG_PATH);
            if (!file.exists()) {
                LOGGER.error((Object)String.format(Locale.ENGLISH, "get properties failed. file %s not exist.%n", runtimePath.get() + LEGO_CONFIG_PATH));
                throw new PatchException("get properties failed.");
            }
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException e) {
                LOGGER.error((Object)"read properties error.");
                throw new PatchException("read properties failed.");
            }
            return properties.getProperty("cipher.type", GENERAL_CIPHER);
        }
        return GENERAL_CIPHER;
    }

    private static Optional<String> getRuntimePath() {
        try {
            Path path;
            Path home = Paths.get("Runtime", new String[0]);
            for (path = Paths.get(FileEncryptor.class.getProtectionDomain().getCodeSource().getLocation().toURI()); path != null && !home.equals(path.getFileName()); path = path.getParent()) {
            }
            if (path == null) {
                LOGGER.error((Object)"can't find runtime path.");
                return Optional.empty();
            }
            return Optional.of(path.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)"can't find runtime path.");
            return Optional.empty();
        }
    }

    public static void decryptFileAccordingCipher(String srcFile, String destFile, String pwd, String saltFile, String ivFile) {
        File saltFIle = new File(saltFile);
        if (saltFIle.exists()) {
            AESEncryptor.decryptFile(srcFile, destFile, pwd, FileEncryptor.getByte(saltFile, 128), FileEncryptor.getByte(ivFile, 16));
        } else {
            SMFileEncryptor.decryptFile(srcFile, destFile, pwd, FileEncryptor.getByte(ivFile, 16));
        }
    }

    private static byte[] getByte(String file, int size) {
        byte[] bytes = new byte[size];
        int hasReadLen = 0;
        try (FileInputStream inputStream = new FileInputStream(file);){
            int readLen;
            while ((readLen = inputStream.read(bytes, hasReadLen, size - hasReadLen)) > 0) {
                hasReadLen += readLen;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("get Bytes failed for size: " + size + ", error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("get salt or iv failed.");
        }
        return bytes;
    }
}

