/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static Log logger = LogFactory.getInstance(FileUtil.class);
    private static final int MAX_LEN = 0xFFFFFFE;
    private static final int INDEX = 1;
    private static final int SIZE = 10240;

    private static void copyFolderFile(InputStream sIn, OutputStream sOut) throws IOException {
        try {
            int len;
            byte[] b = new byte[2048];
            while ((len = sIn.read(b)) != -1) {
                sOut.write(b, 0, len);
            }
        }
        catch (IOException e) {
            logger.error((Object)"copyFolderFile has error", (Throwable)e, "");
            throw e;
        }
    }

    public static void copyFolderToPatch(String oldPath, String newPath) throws IOException {
        File temp = null;
        try {
            File a = new File(oldPath);
            if (!a.exists()) {
                logger.error((Object)("Old Path is not exists: " + a.getName()), "");
                return;
            }
            boolean flag = new File(newPath).mkdirs();
            if (!flag) {
                logger.error((Object)"mkdirs exists!", "");
            }
            String[] file = a.list();
            FileInputStream sIn = null;
            FileOutputStream sOut = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    try {
                        sIn = new FileInputStream(temp);
                        sOut = new FileOutputStream(newPath + File.separator + temp.getName());
                        FileUtil.copyFolderFile(sIn, sOut);
                        sOut.flush();
                    }
                    catch (IOException e) {
                        try {
                            logger.info((Object)"Copy  File Exception is:", e.getMessage());
                            throw e;
                        }
                        catch (Throwable throwable) {
                            FileUtil.releaseStream(sOut);
                            FileUtil.releaseStream(sIn);
                            throw throwable;
                        }
                    }
                    FileUtil.releaseStream(sOut);
                    FileUtil.releaseStream(sIn);
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolderToPatch(oldPath + File.separator + file[i], newPath);
            }
        }
        catch (IOException e) {
            logger.error((Object)("File " + temp.getName() + "has error"), (Throwable)e, "");
            throw e;
        }
    }

    public static void copyFolder(String oldPath, String newPath) throws IOException {
        File temp = null;
        try {
            File a = new File(oldPath);
            if (!a.exists()) {
                logger.error((Object)("Old Path is not exists: " + a.getName()), "");
                return;
            }
            boolean flag = new File(newPath).mkdirs();
            if (!flag) {
                logger.error((Object)"mkdirs exists!", "");
            }
            String[] file = a.list();
            FileInputStream sIn = null;
            FileOutputStream sOut = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    try {
                        sIn = new FileInputStream(temp);
                        sOut = new FileOutputStream(newPath + File.separator + temp.getName());
                        FileUtil.copyFolderFile(sIn, sOut);
                        sOut.flush();
                    }
                    catch (IOException e) {
                        try {
                            logger.info((Object)"Copy  File Exception is:", e.getMessage());
                            throw e;
                        }
                        catch (Throwable throwable) {
                            FileUtil.releaseStream(sOut);
                            FileUtil.releaseStream(sIn);
                            throw throwable;
                        }
                    }
                    FileUtil.releaseStream(sOut);
                    FileUtil.releaseStream(sIn);
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolder(oldPath + File.separator + file[i], newPath + File.separator + file[i]);
            }
        }
        catch (IOException e) {
            logger.error((Object)("File " + temp.getName() + "has error"), (Throwable)e, "");
            throw e;
        }
    }

    public static boolean reNameFile(String src, String dest) {
        boolean status = false;
        File destFile = new File(dest);
        File srcFile = new File(src);
        if (!destFile.exists() && srcFile.exists() && srcFile.renameTo(destFile)) {
            status = true;
        }
        return status;
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileOutputStream sOut;
        FileInputStream sIn;
        block6: {
            sIn = null;
            sOut = null;
            File oldfile = new File(src.trim());
            try {
                int byteread = 0;
                if (oldfile.exists()) {
                    oldfile.setWritable(true);
                    sIn = new FileInputStream(oldfile.getCanonicalPath());
                    sOut = new FileOutputStream(new File(dest).getCanonicalPath());
                    byte[] buffer = new byte[2048];
                    while ((byteread = ((InputStream)sIn).read(buffer)) != -1) {
                        ((OutputStream)sOut).write(buffer, 0, byteread);
                    }
                    break block6;
                }
                logger.info((Object)("Copy File But File is not exists:" + oldfile.getName()), "0x000252000FB50018");
            }
            catch (IOException e) {
                try {
                    logger.error((Object)("copyFile error, fileName=" + oldfile.getName() + ", error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                    throw e;
                }
                catch (Throwable throwable) {
                    FileUtil.releaseStream(sOut);
                    FileUtil.releaseStream(sIn);
                    throw throwable;
                }
            }
        }
        FileUtil.releaseStream(sOut);
        FileUtil.releaseStream(sIn);
    }

    private static void releaseStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                logger.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }

    public static void modifyDBPropFileUsingPro(String fileName, String[] keys, String[] values) throws IOException {
        FileInputStream sIn = null;
        FileOutputStream sOut = null;
        Properties prop = new Properties();
        try {
            boolean flag;
            File file = new File(fileName);
            if (!file.exists() && !(flag = file.createNewFile())) {
                logger.error((Object)"createNewFile error!", "");
            }
            sIn = new FileInputStream(file);
            prop.load(sIn);
        }
        catch (IOException e) {
            try {
                logger.error((Object)e, "createNewFile IO error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(sIn);
                throw throwable;
            }
        }
        FileUtil.releaseStream(sIn);
        try {
            sOut = new FileOutputStream(fileName);
            for (int i = 0; i < keys.length; ++i) {
                prop.setProperty(keys[i], values[i]);
            }
            prop.store(sOut, "Update DB value");
        }
        catch (IOException e) {
            try {
                logger.error((Object)e, "Update db IO error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(sOut);
                throw throwable;
            }
        }
        FileUtil.releaseStream(sOut);
    }

    public static void modifyDBPropFileUsingStr(String file, String[] keys, String[] values, String targetFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        FileReader fr = null;
        FileWriter writer = null;
        try {
            File tmpFile = new File(file);
            if (!tmpFile.exists()) {
                logger.error((Object)("the file is not exists: " + tmpFile.getName()), "");
                throw new FileNotFoundException();
            }
            fr = new FileReader(file);
            reader = new BufferedReader(fr);
            String text = null;
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                for (int i = 0; i < keys.length; ++i) {
                    if (!text.startsWith(keys[i])) continue;
                    text = keys[i] + "=" + values[i];
                }
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            writer = new FileWriter(targetFile);
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            try {
                logger.error((Object)e, "modifyDBPropFileUsingStr IO Error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(writer);
                FileUtil.releaseStream(reader);
                FileUtil.releaseStream(fr);
                throw throwable;
            }
        }
        FileUtil.releaseStream(writer);
        FileUtil.releaseStream(reader);
        FileUtil.releaseStream(fr);
    }

    public static void modifyDBPropFileUsingStr(String file, Map<String, String> data, String targetFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        BufferedWriter writer = null;
        OutputStreamWriter output = null;
        InputStreamReader input = null;
        FileOutputStream outpuStream = null;
        FileInputStream inputStream = null;
        try {
            File tmpFile = new File(file);
            if (!tmpFile.exists()) {
                logger.error((Object)("the file is not exists: " + tmpFile.getName()), "");
                throw new FileNotFoundException();
            }
            inputStream = new FileInputStream(file);
            input = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(input);
            String text = null;
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    if (!text.startsWith(entry.getKey())) continue;
                    String value = entry.getValue();
                    if (text.contains(":") && text.contains("=")) {
                        int start = text.indexOf("=");
                        int end = text.lastIndexOf(":");
                        value = text.substring(start + 1, end) + ":" + entry.getValue();
                    }
                    text = entry.getKey() + "=" + value;
                }
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            outpuStream = new FileOutputStream(targetFile);
            output = new OutputStreamWriter((OutputStream)outpuStream, "UTF-8");
            writer = new BufferedWriter(output);
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            try {
                logger.error((Object)e, "modifyDBPropFileUsingStr IO Error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(reader);
                FileUtil.releaseStream(input);
                FileUtil.releaseStream(inputStream);
                FileUtil.releaseStream(writer);
                FileUtil.releaseStream(output);
                FileUtil.releaseStream(outpuStream);
                throw throwable;
            }
        }
        FileUtil.releaseStream(reader);
        FileUtil.releaseStream(input);
        FileUtil.releaseStream(inputStream);
        FileUtil.releaseStream(writer);
        FileUtil.releaseStream(output);
        FileUtil.releaseStream(outpuStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void combineFile(String file, String target) throws IOException {
        BufferedReader sOld1Reader = null;
        BufferedReader sOld2Reader = null;
        FileWriter sWriter = null;
        StringBuilder sb = new StringBuilder();
        FileReader sOld1Fr = null;
        FileReader sOld2Fr = null;
        try {
            sOld1Fr = new FileReader(file);
            sOld1Reader = new BufferedReader(sOld1Fr);
            sOld2Fr = new FileReader(target);
            sOld2Reader = new BufferedReader(sOld2Fr);
            String text = null;
            while ((text = FileUtil.getLineFromFile(sOld2Reader)) != null) {
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            while ((text = FileUtil.getLineFromFile(sOld1Reader)) != null) {
                String oldString = sb.toString();
                if (oldString.contains(text)) continue;
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            sWriter = new FileWriter(target);
            sWriter.write(sb.toString());
            sWriter.flush();
        }
        catch (FileNotFoundException e) {
            try {
                logger.error((Object)"combineFile IO error, file not founed.", "");
                throw new FileNotFoundException("combineFile failed.");
                catch (IOException e2) {
                    logger.error((Object)e2, "combineFile IO error");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(sWriter);
                FileUtil.releaseStream(sOld2Reader);
                FileUtil.releaseStream(sOld1Reader);
                FileUtil.releaseStream(sOld1Fr);
                FileUtil.releaseStream(sOld2Fr);
                throw throwable;
            }
        }
        FileUtil.releaseStream(sWriter);
        FileUtil.releaseStream(sOld2Reader);
        FileUtil.releaseStream(sOld1Reader);
        FileUtil.releaseStream(sOld1Fr);
        FileUtil.releaseStream(sOld2Fr);
    }

    public static void deleteAllFolder(File file) {
        file.setWritable(true);
        if (file.exists()) {
            if (file.isFile()) {
                boolean flag = file.delete();
                if (!flag) {
                    logger.error((Object)"delete error!", "");
                }
            } else if (file.isDirectory()) {
                File[] files;
                for (File value : files = file.listFiles()) {
                    FileUtil.deleteAllFolder(value);
                }
            }
        }
        file.delete();
    }

    public static void deleteAllFilesInFolder(File file) throws IOException {
        file.setWritable(true);
        if (file.exists()) {
            if (file.isFile()) {
                return;
            }
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteAllFolder(files[i]);
                }
            }
        }
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.setWritable(true);
            boolean flag = file.delete();
            if (!flag) {
                logger.error((Object)"delete file Error", "");
            }
        }
    }

    public static void delScript4Installed(String folderPath, String delFileValue, String dbType) {
        String[] delFiles = FileUtil.getDelFileNames(delFileValue);
        if (null != delFiles && delFiles.length > 0) {
            for (String delFileName : delFiles) {
                File file = new File(folderPath + File.separator + delFileName);
                if (!file.exists()) continue;
                if (file.isDirectory() && file.getName().equals("script")) {
                    FileUtil.delDBScript(file, dbType);
                    continue;
                }
                FileUtil.deleteAllFolder(file);
            }
        }
    }

    private static String[] getDelFileNames(String delFileValuedelFileValue) {
        String delFileNames = LegoResourceManager.getProValue(delFileValuedelFileValue);
        if (delFileNames != null && delFileNames.length() > 0) {
            return delFileNames.split(";");
        }
        return new String[0];
    }

    private static void delDBScriptUninstall(File file, String dbtype) {
        for (File folder : file.listFiles()) {
            if (!folder.getName().equalsIgnoreCase("uninstall") && folder.isDirectory()) {
                FileUtil.deleteAllFolder(folder);
            }
            if (!FileUtil.extracted(folder)) continue;
            FileUtil.delDBScript(folder, dbtype);
        }
    }

    public static void delDBScript(File delFile, String dbtype) {
        block6: {
            File file = delFile;
            if (!file.exists() || !file.isDirectory()) break block6;
            List<String> fileNames = Arrays.asList(file.list());
            if (fileNames.contains(dbtype.toLowerCase(Locale.US))) {
                for (File folder : file.listFiles()) {
                    if (dbtype.equalsIgnoreCase(folder.getName()) || !folder.isDirectory()) continue;
                    FileUtil.deleteAllFolder(folder);
                }
            } else if (fileNames.contains("uninstall")) {
                FileUtil.delDBScriptUninstall(file, dbtype);
            } else {
                for (File folder : file.listFiles()) {
                    FileUtil.delDBScript(folder, dbtype);
                }
            }
        }
    }

    private static boolean extracted(File folder) {
        return folder.getName().equalsIgnoreCase("uninstall") && folder.isDirectory();
    }

    public static String getLineFromFile(LineNumberReader bufReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = bufReader.read()) != -1) {
                if (strBuf.length() >= 0xFFFFFFE) {
                    throw new IOException("input too long");
                }
                if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                    strBuf.append((char)tempChar);
                    continue;
                }
                return strBuf.toString();
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }

    public static String getLineFromFile(BufferedReader bufReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = bufReader.read()) != -1) {
                if (strBuf.length() >= 0xFFFFFFE) {
                    throw new IOException("input too long");
                }
                if (tempChar == 13) {
                    tempChar = bufReader.read();
                    if (tempChar == 10) {
                        return strBuf.toString();
                    }
                    strBuf.append('\r');
                }
                if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                    strBuf.append((char)tempChar);
                    continue;
                }
                return strBuf.toString();
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }

    public static String join(String ... pathes) {
        StringBuilder builder = null;
        for (String path : pathes) {
            if (builder != null) {
                builder.append(File.separatorChar).append(path);
                continue;
            }
            builder = new StringBuilder(path);
        }
        return builder != null ? builder.toString() : null;
    }

    public static void close(Closeable closeable, String message) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.error((Object)("close closeable failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static void writeFile(String destFile, String message) {
        if (message.length() > 5000) {
            logger.info((Object)"message length is too long, more than 5000", "");
            throw new PatchException("writeFile failed.");
        }
        File file = new File(destFile);
        if (file.exists()) {
            logger.info((Object)("delete tmpfile: " + file.delete()), "");
        }
        FileWriter write = null;
        try {
            write = new FileWriter(file);
            write.write(message);
            write.flush();
        }
        catch (IOException e) {
            logger.error((Object)("write config file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("write HA config failed.");
        }
        finally {
            if (null != write) {
                try {
                    write.close();
                }
                catch (IOException e2) {
                    logger.error((Object)("close writer failed: " + e2), "");
                }
            }
        }
    }

    public static File zipFile(File souceFile) {
        File file;
        ZipOutputStream out = null;
        FileInputStream in = null;
        try {
            int b;
            String dir = souceFile.getParent();
            String name = souceFile.getName().replace(".sql", "");
            String zipFile = dir + File.separator + name + ".zip";
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            out.putNextEntry(new ZipEntry(souceFile.getName()));
            in = new FileInputStream(souceFile);
            byte[] by = new byte[10240];
            while ((b = in.read(by)) != -1) {
                out.write(by, 0, b);
            }
            out.flush();
            file = new File(zipFile);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("zip file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("zipFile failed.");
            }
            catch (Throwable throwable) {
                FileUtil.doCloseStream(out, in);
                throw throwable;
            }
        }
        FileUtil.doCloseStream(out, in);
        return file;
    }

    private static void doCloseStream(ZipOutputStream out, FileInputStream in) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipFile close out error", "");
        }
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipFile close in error", "");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipFile(String srcFile, String outPath) {
        File file = new File(outPath);
        if (!file.exists() || !file.isDirectory()) {
            logger.info((Object)("outPath not exists, create result: " + file.mkdirs()), "");
        }
        ZipInputStream zin = null;
        FileInputStream input = null;
        BufferedInputStream bin = null;
        try {
            ZipEntry entry;
            input = new FileInputStream(srcFile);
            zin = new ZipInputStream(input);
            bin = new BufferedInputStream(zin);
            while (null != (entry = zin.getNextEntry()) && !entry.isDirectory()) {
                BufferedOutputStream bout = null;
                FileOutputStream out = null;
                try {
                    int b;
                    File fout = new File(outPath, entry.getName());
                    if (!fout.exists()) {
                        new File(fout.getParent()).mkdirs();
                    }
                    out = new FileOutputStream(fout);
                    bout = new BufferedOutputStream(out);
                    while ((b = bin.read()) != -1) {
                        bout.write(b);
                    }
                    bout.flush();
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)("unzip failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                        throw new PatchException("");
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(out, "close out");
                        FileUtil.close(bout, "close bout");
                        throw throwable;
                    }
                }
                FileUtil.close(out, "close out");
                FileUtil.close(bout, "close bout");
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("unzip file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("unzip file failed.");
            }
            catch (Throwable throwable) {
                FileUtil.close(bin, "close bin");
                FileUtil.close(zin, "close zin");
                FileUtil.close(input, "close input");
                throw throwable;
            }
        }
        FileUtil.close(bin, "close bin");
        FileUtil.close(zin, "close zin");
        FileUtil.close(input, "close input");
    }

    public static void zipFile(List<String> fileList, String zipPath, String zipFile, boolean isRecursion) {
        if (VerifyUtil.isEmpty((String)zipPath) || VerifyUtil.isEmpty((String)zipFile)) {
            logger.error((Object)"zipFile failed, zip path or file is empty.", "");
            throw new PatchException("zipFile failed.");
        }
        ZipOutputStream zip = null;
        File file = new File(zipFile);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            zip = new ZipOutputStream(new FileOutputStream(file));
            File srcFile = new File(zipPath);
            String base = "";
            FileUtil.fileZip(fileList, srcFile, zip, base, isRecursion);
        }
        catch (IOException e) {
            logger.error((Object)("zipOutPutFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("zipOutPutFile failed.");
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e, "close stream failed.");
            }
        }
    }

    private static void fileZip(List<String> fileList, File srcFile, ZipOutputStream zos, String base, boolean isRecursion) {
        FileInputStream fis;
        block9: {
            fis = null;
            try {
                int n;
                if (srcFile.isDirectory()) {
                    File[] files;
                    if (isRecursion) {
                        base = base.length() == 0 ? "" : base + "/";
                    }
                    for (File file : files = srcFile.listFiles()) {
                        if (null != fileList && !fileList.isEmpty() && fileList.contains(file.getName())) {
                            FileUtil.fileZip(fileList, file, zos, base + file.getName(), isRecursion);
                        }
                        if (null != fileList && !fileList.isEmpty()) continue;
                        FileUtil.fileZip(null, file, zos, base + file.getName(), isRecursion);
                    }
                    break block9;
                }
                zos.putNextEntry(new ZipEntry(base));
                fis = new FileInputStream(srcFile);
                byte[] buf = new byte[1024];
                while ((n = fis.read(buf, 0, buf.length)) != -1) {
                    zos.write(buf, 0, n);
                }
                zos.flush();
            }
            catch (IOException e) {
                try {
                    logger.error((Object)("zipFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                    throw new PatchException("zipFile failed.");
                }
                catch (Throwable throwable) {
                    FileUtil.doCloseStream(fis);
                    throw throwable;
                }
            }
        }
        FileUtil.doCloseStream(fis);
    }

    private static void doCloseStream(FileInputStream in) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"zipFile close in error", "");
        }
    }

    public static String readAll(String file) {
        return com.huawei.lego.core.sdk.file.util.FileUtil.readText((File)new File(file), (int)0, null);
    }
}

