/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.exception.PatchException;
import java.net.InetAddress;

public class IPv4Util {
    public static byte[] ipToBytesByInet(String ipAddr) {
        try {
            return InetAddress.getByName(ipAddr).getAddress();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static int bytesToInt(byte[] bytes) {
        int addr = bytes[3] & 0xFF;
        addr |= bytes[2] << 8 & 0xFF00;
        addr |= bytes[1] << 16 & 0xFF0000;
        return addr |= bytes[0] << 24 & 0xFF000000;
    }

    public static int ipToInt(String ipAddr) {
        try {
            return IPv4Util.bytesToInt(IPv4Util.ipToBytesByInet(ipAddr));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static String intToIp(int ipInt) {
        return "" + (ipInt >> 24 & 0xFF) + '.' + (ipInt >> 16 & 0xFF) + '.' + (ipInt >> 8 & 0xFF) + '.' + (ipInt & 0xFF);
    }

    public static int[] getIPIntScope(String ipAndMask) {
        String[] ipArr = ipAndMask.split("/");
        if (ipArr.length != 2) {
            throw new PatchException(10025L);
        }
        int netMask = Integer.valueOf(ipArr[1].trim());
        if (netMask < 0 || netMask > 31) {
            throw new PatchException(10025L);
        }
        int ipInt = IPv4Util.ipToInt(ipArr[0]);
        int netIP = ipInt & -1 << 32 - netMask;
        int hostScope = -1 >>> netMask;
        return new int[]{netIP, netIP + hostScope};
    }

    public static String getIPSegment(String ip, String maskStr) {
        String ipAndMask = ip + "/" + maskStr;
        int[] ipscope = IPv4Util.getIPIntScope(ipAndMask);
        String networkID = IPv4Util.intToIp(ipscope[0]);
        return networkID;
    }
}

