/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class JarFileUtil {
    private static Log logger = LogFactory.getInstance(JarFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editJar(String file, String entryName, String fileNameTow) throws IOException {
        FileInputStream sIn = null;
        InputStream sEntryIn = null;
        JarOutputStream sOut = null;
        JarFile jf = null;
        FileOutputStream fos = null;
        File jarFile = new File(file);
        File targetFile = new File(fileNameTow);
        if (!jarFile.exists() || !targetFile.exists()) {
            logger.error((Object)("editJar failed: " + jarFile.getName() + " or " + targetFile.getName() + " not exists."));
            return;
        }
        logger.info((Object)("start to Edit Jar File: " + jarFile.getName()), "0x000252000FB50033");
        try {
            sIn = new FileInputStream(fileNameTow);
            byte[] data = JarFileUtil.getByte(sIn);
            jf = new JarFile(file);
            TreeMap<String, byte[]> tm = new TreeMap<String, byte[]>();
            Enumeration<JarEntry> es = jf.entries();
            while (es.hasMoreElements()) {
                JarEntry je = es.nextElement();
                try {
                    sEntryIn = jf.getInputStream(je);
                    byte[] b = JarFileUtil.getByte(sEntryIn);
                    tm.put(je.getName(), b);
                }
                finally {
                    if (null == sEntryIn) continue;
                    sEntryIn.close();
                }
            }
            fos = new FileOutputStream(file);
            sOut = new JarOutputStream(fos);
            Set set = tm.entrySet();
            for (Map.Entry me : set) {
                String name = (String)me.getKey();
                JarEntry jeNew = new JarEntry(name);
                sOut.putNextEntry(jeNew);
                byte[] b = name.equals(entryName) ? data : (byte[])me.getValue();
                sOut.write(b, 0, b.length);
                sOut.closeEntry();
            }
            sOut.flush();
            logger.info((Object)"End to Edit Jar File.", "0x000252000FB50033");
        }
        catch (Throwable throwable) {
            JarFileUtil.releaseStream(sOut);
            JarFileUtil.releaseStream(sIn);
            JarFileUtil.releaseStream(fos);
            JarFileUtil.releaseStream(jf);
            JarFileUtil.releaseStream(sEntryIn);
            throw throwable;
        }
        JarFileUtil.releaseStream(sOut);
        JarFileUtil.releaseStream(sIn);
        JarFileUtil.releaseStream(fos);
        JarFileUtil.releaseStream(jf);
        JarFileUtil.releaseStream(sEntryIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileFromJar(String jarFile, String targetFile, String outFile) throws IOException {
        InputStream sEntryIn = null;
        JarFile jf = null;
        FileOutputStream fos = null;
        File jar = new File(jarFile);
        if (!jar.exists()) {
            logger.error((Object)("the jar file is not exist: " + jar.getName()), "");
            return;
        }
        try {
            jf = new JarFile(jarFile);
            Enumeration<JarEntry> es = jf.entries();
            while (es.hasMoreElements()) {
                JarEntry je = es.nextElement();
                if (!je.getName().equals(targetFile)) continue;
                sEntryIn = jf.getInputStream(je);
                byte[] b = JarFileUtil.getByte(sEntryIn);
                fos = new FileOutputStream(outFile);
                fos.write(b, 0, b.length);
            }
        }
        finally {
            JarFileUtil.releaseStream(fos);
            JarFileUtil.releaseStream(jf);
            JarFileUtil.releaseStream(sEntryIn);
        }
    }

    private static void releaseStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                logger.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }

    private static void releaseStream(JarFile stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                logger.error((Object)"Release JarFile is Error:", e.getMessage());
            }
        }
    }

    public static byte[] getByte(InputStream s) throws IOException {
        int count;
        byte[] buffer = new byte[]{};
        byte[] chunk = new byte[15360];
        while ((count = s.read(chunk)) >= 0) {
            byte[] t = new byte[buffer.length + count];
            System.arraycopy(buffer, 0, t, 0, buffer.length);
            System.arraycopy(chunk, 0, t, buffer.length, count);
            buffer = t;
        }
        return buffer;
    }
}

