/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.InstallType;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.File;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class LegoResourceManager {
    private static final Log logger = LogFactory.getInstance(LegoResourceManager.class);
    private static Locale locale = null;
    private static final Map<Locale, Map<String, String>> LAUG_POOL = new HashMap<Locale, Map<String, String>>();
    private static final Map<String, String> PROP_POOL = new HashMap<String, String>();
    private static final String I18N_FILE = "config/lauguages";
    private static final String EN_FILE = "_en";
    private static final String CN_FILE = "_zh";
    private static final String CONFIG_FILE = "config/conf";
    private static final String FILE_PATH = "config/framework/configuration/custom.properties";
    private static LegoResourceManager INSTANCE = new LegoResourceManager();
    private Properties MAPPINGS = new Properties();
    private InputStream INSTREAM = null;

    private LegoResourceManager() {
    }

    public static LegoResourceManager getInstance() {
        return INSTANCE;
    }

    public static synchronized void registerPropertyFile() {
        File[] files;
        File dir = new File(InstallConstant.getsBasePath() + CONFIG_FILE);
        for (File file : files = dir.listFiles()) {
            if (file.getName().startsWith("arb") || !file.getName().endsWith(".properties")) continue;
            try {
                SignVerifier.getInstance().verify(file);
            }
            catch (SignatureException e) {
                logger.error((Object)"verify error", (Throwable)e, 1L);
                continue;
            }
            PropertyUtil enProperties = new PropertyUtil(file);
            Properties pro = enProperties.getProp();
            Set<Map.Entry<Object, Object>> set = pro.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                PROP_POOL.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
    }

    public static synchronized void registerLaugFile() {
        File dir = new File(InstallConstant.getsBasePath() + I18N_FILE);
        File[] files = dir.listFiles();
        HashMap<String, String> enMap = new HashMap<String, String>();
        HashMap<String, String> cnMap = new HashMap<String, String>();
        for (File file : files) {
            String value;
            String key;
            Set<Map.Entry<Object, Object>> entrSet;
            if (file.getName().contains(CN_FILE)) {
                PropertyUtil cnProperties = new PropertyUtil(file);
                Properties cnpro = cnProperties.getProp();
                entrSet = cnpro.entrySet();
                for (Map.Entry<Object, Object> entry : entrSet) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    cnMap.put(key, value);
                }
                continue;
            }
            if (!file.getName().contains(EN_FILE)) continue;
            PropertyUtil enProperties = new PropertyUtil(file);
            Properties enpro = enProperties.getProp();
            entrSet = enpro.entrySet();
            for (Map.Entry<Object, Object> entry : entrSet) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                enMap.put(key, value);
            }
        }
        LAUG_POOL.put(Locale.CHINA, cnMap);
        LAUG_POOL.put(Locale.US, enMap);
    }

    public static String getString(String key, String param) {
        String[] params = new String[]{param};
        return LegoResourceManager.getString(key, params);
    }

    public static String getProValue(String key) {
        if (PROP_POOL.get(key) == null || "".equals(PROP_POOL.get(key))) {
            return PROP_POOL.get(key);
        }
        String value = PROP_POOL.get(key).trim();
        return value;
    }

    public static synchronized String getString(String key) {
        Map<String, String> pro;
        String value;
        Locale l = locale;
        if (!Locale.CHINA.equals(l)) {
            l = Locale.US;
        }
        if ((value = (pro = LAUG_POOL.get(l)).get(key)) == null) {
            return "";
        }
        return value;
    }

    public static String getString(String key, String[] params) {
        String value = LegoResourceManager.getString(key);
        if (VerifyUtil.isEmpty((Object[])params)) {
            return value;
        }
        int count = 0;
        for (String param : params) {
            String location = "{" + count++ + "}";
            if (!value.contains(location)) continue;
            value = value.replace(location, param);
        }
        return value;
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale l) {
        locale = l;
    }

    private static void init() {
        if (locale == null) {
            locale = InstallType.getInstallType().contains("guiInstall") ? LegoResourceManager.getOSLocaleDefaultEn() : Locale.US;
        }
        LegoResourceManager.registerPropertyFile();
        LegoResourceManager.registerLaugFile();
    }

    private static Locale getOSLocaleDefaultEn() {
        Locale retLocal = Locale.getDefault();
        List<Locale> locales = LegoResourceManager.getInstance().getLanguages();
        if (locales.contains(retLocal)) {
            return retLocal;
        }
        Locale defaultLocale = null;
        for (Locale l : locales) {
            if (!l.getLanguage().equals(Locale.ENGLISH.getLanguage())) continue;
            defaultLocale = l;
            break;
        }
        if (defaultLocale == null) {
            defaultLocale = Locale.US;
        }
        return defaultLocale;
    }

    private List<Locale> getLanguages() {
        ArrayList<Locale> languages = new ArrayList<Locale>();
        String languagesStr = LegoResourceManager.getString("custom.language");
        if (languagesStr == null || languagesStr.isEmpty()) {
            this.reloadDefaultConfig();
            languagesStr = LegoResourceManager.getString("custom.language");
        }
        if (languagesStr == null) {
            LogManager.error((Object)"getLanguages failed, languagesStr is null.");
            return languages;
        }
        String[] strArray = languagesStr.split(";");
        String key = "";
        for (String string : strArray) {
            String[] arr = string.split(",");
            Locale[] locales = Locale.getAvailableLocales();
            key = arr.length > 1 ? arr[0] + "_" + arr[1] : arr[0];
            this.getTmpLocale(languages, key, locales);
        }
        return languages;
    }

    private void reloadDefaultConfig() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            LogManager.error((Object)"classLoader is null in reloadDefaultConfig method");
            return;
        }
        this.INSTREAM = classLoader.getResourceAsStream(FILE_PATH);
        this.MAPPINGS = new Properties();
        try {
            this.MAPPINGS.load(this.INSTREAM);
        }
        catch (Throwable t) {
            LogManager.error((Object)("CustomResourceManager: reload property file fail,file=config/framework/configuration/custom.properties" + LogManager.getErrorMessage((Throwable)t)));
        }
        finally {
            try {
                if (this.INSTREAM != null) {
                    this.INSTREAM.close();
                }
            }
            catch (Exception e) {
                LogManager.error((Object)("close stream failed" + LogManager.getErrorMessage((Throwable)e)));
            }
        }
    }

    private void getTmpLocale(List<Locale> languages, String key, Locale[] locales) {
        for (Locale tmpLocale : locales) {
            String str = tmpLocale.toString();
            if (!str.equals(key)) continue;
            if ("en_US".equals(key)) {
                languages.add(Locale.ENGLISH);
                break;
            }
            languages.add(tmpLocale);
            break;
        }
    }

    static {
        LegoResourceManager.init();
    }
}

