/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.dto.NetInterface;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetWorkUtil {
    private static final List<String> EXCEPTIONIP = new ArrayList<String>(Arrays.asList("255.255.255.255", "127.0.0.1", "0.0.0.0", "::1", "0:0:0:0:0:0:0:1"));
    private static Log logger = LogFactory.getInstance(NetWorkUtil.class);

    public static List<NetInterface> getAllNetInterfaceInfo(boolean isFilterSubNet) {
        ArrayList<NetInterface> devList = new ArrayList<NetInterface>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                String ipAddress;
                InetAddress address;
                NetworkInterface nif = e.nextElement();
                StringBuilder sb = new StringBuilder();
                byte[] macAddress = nif.getHardwareAddress();
                if (null != macAddress) {
                    for (int i = 0; i < macAddress.length; ++i) {
                        sb.append(String.format("%02X%s", macAddress[i], i < macAddress.length - 1 ? "-" : ""));
                    }
                }
                ArrayList<String> subnetList = new ArrayList<String>();
                if (isFilterSubNet) {
                    Enumeration<NetworkInterface> subnet = nif.getSubInterfaces();
                    while (null != subnet && subnet.hasMoreElements()) {
                        NetworkInterface sub = subnet.nextElement();
                        for (InterfaceAddress inter : sub.getInterfaceAddresses()) {
                            address = inter.getAddress();
                            ipAddress = address.getHostAddress();
                            if (address instanceof Inet6Address) {
                                ipAddress = NetWorkUtil.getSimpleIPv6Addr(ipAddress);
                            }
                            subnetList.add(ipAddress);
                        }
                    }
                }
                List<InterfaceAddress> interfaceList = nif.getInterfaceAddresses();
                for (InterfaceAddress inter : interfaceList) {
                    NetInterface netFace = new NetInterface();
                    address = inter.getAddress();
                    ipAddress = address.getHostAddress();
                    if (address instanceof Inet6Address) {
                        ipAddress = NetWorkUtil.getSimpleIPv6Addr(ipAddress);
                    }
                    netFace.setDevName(nif.getDisplayName());
                    netFace.setIp(ipAddress);
                    netFace.setMac(sb.toString());
                    netFace.setNetmask(String.valueOf(inter.getNetworkPrefixLength()));
                    if (EXCEPTIONIP.contains(ipAddress) || subnetList.contains(ipAddress)) continue;
                    devList.add(netFace);
                }
            }
        }
        catch (SocketException e) {
            logger.error((Object)("get Local IP Error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return devList;
    }

    public static List<String> getLocalAllIps() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                Enumeration<InetAddress> l = nif.getInetAddresses();
                while (l.hasMoreElements()) {
                    InetAddress inetAddress = l.nextElement();
                    String ipAddress = inetAddress.getHostAddress();
                    if (inetAddress instanceof Inet6Address) {
                        ipAddress = NetWorkUtil.getSimpleIPv6Addr(ipAddress);
                    }
                    if (EXCEPTIONIP.contains(ipAddress)) continue;
                    ipList.add(ipAddress);
                }
            }
        }
        catch (SocketException e) {
            logger.error((Object)("get Local IP Error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        logger.info((Object)("get all local ips: " + ipList), "");
        return ipList;
    }

    public static Map<String, Short> getLocalAllIpAndMask() {
        HashMap<String, Short> ipMap = new HashMap<String, Short>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                List<InterfaceAddress> interfaceList = nif.getInterfaceAddresses();
                for (InterfaceAddress inter : interfaceList) {
                    String ip = inter.getAddress().getHostAddress();
                    if (inter.getAddress() instanceof Inet6Address) {
                        ip = NetWorkUtil.getSimpleIPv6Addr(ip);
                    }
                    if (EXCEPTIONIP.contains(ip)) continue;
                    ipMap.put(ip, inter.getNetworkPrefixLength());
                }
            }
        }
        catch (SocketException e) {
            logger.error((Object)("getLocalAllIpAndMask failed, " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        logger.info((Object)("getLocalAllIpAndMask: " + ipMap), "");
        return ipMap;
    }

    private static String getNormalIPv6(String ipv6) throws UnknownHostException {
        byte[] ret = new byte[16];
        ret[0] = 0;
        int ib = 15;
        if (ipv6.startsWith(":")) {
            ipv6 = ipv6.substring(1);
        }
        String[] groups = ipv6.split(":");
        for (int ig = groups.length - 1; ig > -1; --ig) {
            if ("".equals(groups[ig])) {
                int zlg = 9 - groups.length;
                while (zlg-- > 0) {
                    ret[ib--] = 0;
                    ret[ib--] = 0;
                }
                continue;
            }
            int temp = Integer.parseInt(groups[ig], 16);
            ret[ib--] = (byte)temp;
            ret[ib--] = (byte)(temp >> 8);
        }
        String ipv6_new = InetAddress.getByAddress(ret).toString();
        return ipv6_new.substring(ipv6_new.indexOf(47) + 1).trim();
    }

    public static String getSimpleIPv6Addr(String ipaddr) {
        String ipAddr = ipaddr.toLowerCase();
        if (VerifyUtil.isEmpty((String)ipAddr)) {
            throw new PatchException("getSimpleIPv6Addr failed, param is null.");
        }
        logger.info((Object)("start get simple ipv6 address for " + ipaddr), "");
        if (ipAddr.contains("%")) {
            ipAddr = ipAddr.substring(0, ipAddr.lastIndexOf("%"));
        }
        if (ipAddr.contains("::")) {
            String[] ipSpits = ipAddr.split(":");
            boolean isSimple = true;
            for (String ipSplt : ipSpits) {
                if (VerifyUtil.isEmpty((String)ipSplt) || !ipSplt.startsWith("0")) continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                return ipAddr;
            }
        }
        try {
            String ipv6_new = NetWorkUtil.getNormalIPv6(ipAddr);
            String[] ipv6_normal_array = ipv6_new.split(":");
            if (ipv6_normal_array.length == 8) {
                List<String> zero_list = NetWorkUtil.getZeroList(ipv6_normal_array);
                int zero_max = 1;
                int zero_begin = 0;
                for (String str : zero_list) {
                    int zero_count = Integer.parseInt(str.split(";")[1]);
                    if (zero_count <= zero_max) continue;
                    zero_max = zero_count;
                    zero_begin = Integer.parseInt(str.split(";")[0]);
                }
                StringBuffer format_IPv6 = new StringBuffer();
                for (int i = 0; i < 8; ++i) {
                    if (i == zero_begin || i == zero_begin + zero_max - 1) {
                        format_IPv6.append(":");
                        continue;
                    }
                    if (i >= zero_begin && i <= zero_begin + zero_max - 1) continue;
                    if (i == 7 || i == zero_begin - 1) {
                        format_IPv6.append(ipv6_normal_array[i]);
                        continue;
                    }
                    format_IPv6.append(ipv6_normal_array[i] + ":");
                }
                String new_IPv6 = format_IPv6.toString();
                if (ParamCheck.checkIPV6Address(new_IPv6)) {
                    logger.info((Object)("format successfully: ip=" + new_IPv6), "");
                    return new_IPv6;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("get simple ipv6 failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return ipAddr;
    }

    private static List<String> getZeroList(String[] ipv6_normal_array) {
        ArrayList<String> zero_list = new ArrayList<String>();
        block0: for (int i = 0; i < 8; ++i) {
            if (!ipv6_normal_array[i].equals("0")) continue;
            int zero_num = 1;
            for (int j = i + 1; j < 8; ++j) {
                if (ipv6_normal_array[j].equals("0")) {
                    if (j != 7 || ++zero_num <= 1) continue;
                    zero_list.add(i + ";" + zero_num);
                    continue;
                }
                if (zero_num <= 1) continue block0;
                zero_list.add(i + ";" + zero_num);
                continue block0;
            }
        }
        return zero_list;
    }
}

