/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OperaTxtFile {
    private static final String GAUSS = "Gauss";
    private static final Log LOG = LogFactory.getInstance(OperaTxtFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String fileName, String fileABSPath) throws SQLException, FileNotFoundException {
        FileReader reader;
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block10: {
            conn = null;
            st = null;
            rs = null;
            reader = null;
            try {
                conn = OperaTxtFile.getConnection(PrepareParamUtil.getsInstallDto().getDbDto());
                if (null != conn) break block10;
            }
            catch (Throwable throwable) {
                OperaTxtFile.releaseStreamForSaveMethod(conn, st, rs, reader);
                throw throwable;
            }
            OperaTxtFile.releaseStreamForSaveMethod(conn, st, rs, reader);
            return;
        }
        String sql0 = "select filename from T_backConfFile where filename=?";
        try {
            st = conn.prepareStatement(sql0);
            st.setString(1, fileName);
            rs = st.executeQuery();
        }
        finally {
            if (null != st) {
                st.close();
            }
        }
        String sql = null;
        File file = new File(fileABSPath);
        if (!file.exists()) {
            throw new FileNotFoundException("file not found: " + file.getName());
        }
        reader = new FileReader(file);
        if (!rs.next()) {
            sql = "insert into T_backConfFile (filename,context) values (?,?)";
            st = conn.prepareStatement(sql);
            st.setString(1, fileName);
            st.setCharacterStream(2, (Reader)reader, (int)file.length());
        } else {
            sql = "update T_backConfFile set context =? where filename=?";
            st = conn.prepareStatement(sql);
            st.setString(2, fileName);
            st.setCharacterStream(1, (Reader)reader, (int)file.length());
        }
        st.executeUpdate();
        OperaTxtFile.releaseStreamForSaveMethod(conn, st, rs, reader);
    }

    private static void releaseStreamForSaveMethod(Connection conn, PreparedStatement st, ResultSet rs, FileReader reader) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("close PreparedStatement Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e, "close FileReader Exception");
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("close ResultSet Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("close Connection Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String fileName, String fileABSPath) throws SQLException, IOException {
        FileWriter fw;
        Reader reader;
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block5: {
            conn = null;
            st = null;
            rs = null;
            reader = null;
            fw = null;
            conn = OperaTxtFile.getConnection(PrepareParamUtil.getsInstallDto().getDbDto());
            if (null != conn) break block5;
            OperaTxtFile.releaseStream(conn, st, rs, reader, fw);
            return;
        }
        try {
            String sql = "select context from T_backConfFile  where filename=?";
            st = conn.prepareStatement(sql);
            st.setString(1, fileName);
            rs = st.executeQuery();
            if (rs.next()) {
                reader = rs.getCharacterStream("context");
                char[] buffer = new char[1024];
                int len = 0;
                fw = new FileWriter(fileABSPath);
                while ((len = reader.read(buffer)) > 0) {
                    fw.write(buffer, 0, len);
                }
            }
        }
        catch (Throwable throwable) {
            OperaTxtFile.releaseStream(conn, st, rs, reader, fw);
            throw throwable;
        }
        OperaTxtFile.releaseStream(conn, st, rs, reader, fw);
    }

    private static void releaseStream(Connection conn, PreparedStatement st, ResultSet rs, Reader reader, FileWriter fw) {
        try {
            if (null != fw) {
                fw.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e, "close FileWriter Error");
        }
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e, "close Reader Error");
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("close ResultSet Error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("close PreparedStatement Error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("close Connection Error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private static Connection getConnection(DataBaseInfo dbInfor) {
        Connection conn = null;
        if (dbInfor.getDbType().equalsIgnoreCase(GAUSS)) {
            conn = LegoDBConnection.getInstance().connectGaussDB(dbInfor, "lego");
        }
        return conn;
    }
}

