/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamCheck {
    private static Log logger = LogFactory.getInstance(ParamCheck.class);
    private static final int MAX_PORT = 65535;

    public static boolean checkPort(String port) {
        boolean result = false;
        if (ParamCheck.checkStrNull(port)) {
            logger.error((Object)"port is null, checkPort failed.", "");
            return result;
        }
        try {
            int number = Integer.valueOf(port);
            result = ParamCheck.checkPort(number);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e, "checkPort failed.");
        }
        return result;
    }

    public static boolean checkPort(int port) {
        return port > 0 && 65535 >= port;
    }

    public static boolean checkIpAddress(String ip) {
        return ParamCheck.checkIPV4Address(ip) || ParamCheck.checkIPV6Address(ip);
    }

    public static boolean checkIPV4Address(String address) {
        return Ipv4AddressUtil.isIPv4Address((String)address);
    }

    public static boolean checkIPV6Address(String address) {
        return Ipv6AddressUtil.isIPv6Address((String)address);
    }

    public static boolean checkStrNull(String str) {
        return null == str || str.trim().isEmpty();
    }

    public static boolean checkIsPath(String path) {
        boolean result = false;
        if (ParamCheck.checkStrNull(path)) {
            logger.error((Object)"path is null, checkIsPath failed.", "");
            return result;
        }
        File file = new File(path);
        if (file.exists() && file.isDirectory()) {
            result = true;
        }
        return result;
    }

    public static boolean checkUserName(String userName) {
        if (ParamCheck.checkStrNull(userName)) {
            logger.error((Object)"userName is null, checkUserName failed.", "");
            return false;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z]{4,10}$");
        Matcher matcher = pattern.matcher(Normalizer.normalize(userName, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    public static boolean checkDBParam(DataBaseInfo dbInfor) {
        boolean result = false;
        if (!ParamCheck.checkIpAddress(dbInfor.getDbHost())) {
            logger.error((Object)"db host is error.", "");
        } else if (!ParamCheck.checkPort(dbInfor.getDbPort())) {
            logger.error((Object)"db port is error.", "");
        } else if (!ParamCheck.checkUserName(dbInfor.getDbaUsername())) {
            logger.error((Object)"db username is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfor.getDbaPassword())) {
            logger.error((Object)"db pwd is error.", "");
        } else if (!ParamCheck.checkUserName(dbInfor.getManagerUsername())) {
            logger.error((Object)"db manager username is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfor.getManagerPassword())) {
            logger.error((Object)"db manager pwd is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfor.getDbFilePath())) {
            logger.error((Object)"db file path is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfor.getDbPath())) {
            logger.error((Object)"db path is error.", "");
        } else {
            result = true;
        }
        return result;
    }
}

