/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordCheckUtil {
    public static boolean checkPasswordComplexity(String pwd) {
        String numberLowerLetterRegex = "(?=.*\\d)(?=.*[a-z])(?=.*[`~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:'\",<.>/?\\s]).{8,32}";
        String numberUpperLetterRegex = "(?=.*\\d)(?=.*[A-Z])(?=.*[`~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:'\",<.>/?\\s]).{8,32}";
        String lowerUpperLetterRegex = "(?=.*[a-z])(?=.*[A-Z])(?=.*[`~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:'\",<.>/?\\s]).{8,32}";
        Pattern pattern = Pattern.compile(numberLowerLetterRegex);
        Matcher match0 = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match0.matches()) {
            return true;
        }
        pattern = Pattern.compile(numberUpperLetterRegex);
        match0 = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match0.matches()) {
            return true;
        }
        pattern = Pattern.compile(lowerUpperLetterRegex);
        match0 = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        return match0.matches();
    }

    public static boolean checkPasswordComplexity4Gauss(String pwd) {
        String excludeRegex = "[`'\"\\^&\\(\\)\\|<>\\s]";
        String numberLowerLetterRegex = "(?=.*\\d)(?=.*[a-z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,15}";
        String numberUpperLetterRegex = "(?=.*\\d)(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,15}";
        String lowerUpperLetterRegex = "(?=.*[a-z])(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,15}";
        Pattern pattern = Pattern.compile(excludeRegex);
        Matcher match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match.find()) {
            return false;
        }
        pattern = Pattern.compile(numberLowerLetterRegex);
        match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match.matches()) {
            return true;
        }
        pattern = Pattern.compile(numberUpperLetterRegex);
        match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match.matches()) {
            return true;
        }
        pattern = Pattern.compile(lowerUpperLetterRegex);
        match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        return match.matches();
    }

    public static boolean checkPasswordMirror(String user, String pwd) {
        boolean flag = false;
        if (null != user && null != pwd) {
            String pwdMirror = pwd;
            StringBuffer sb = new StringBuffer(pwdMirror);
            flag = !user.equals(pwd) && !user.equals(sb.reverse().toString());
        }
        return flag;
    }
}

