/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.cli.climain.CliMain;
import com.huawei.lego.common.InstallType;
import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.HalfFullCheckUtil;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;

public class PortCheckUtil {
    public static final int PORT_OK = -1;
    private static final Log LOG = LogFactory.getInstance(PortCheckUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPortUsed(int port) {
        if (port == 0) {
            LOG.info((Object)"checkPortUsed:", "port is 0");
            return true;
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (null != ss) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e, "close socket failed");
                }
            }
        }
        return false;
    }

    public static boolean checkPortUsed(String port) {
        try {
            int ptInt = Integer.parseInt(port);
            return PortCheckUtil.checkPortUsed(ptInt);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)e, "NumberFormatException, checkPortUsed failed.");
            return false;
        }
    }

    public static void checkPortUsed(String host, String port) {
        try {
            PortCheckUtil.bindPort("0.0.0.0", port);
            PortCheckUtil.bindPort(host, port);
        }
        catch (Exception e) {
            LOG.error((Object)("portused: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException(port, 10027L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindPort(String host, String port) throws IOException {
        Socket s = new Socket();
        try {
            s.bind(new InetSocketAddress(host, Integer.parseInt(port)));
        }
        finally {
            if (null != s) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"close socket error", (Throwable)e);
                }
            }
        }
    }

    public static int checkSystemUsing() {
        int rmiPortNumber;
        PropertyUtil propertyUtil;
        String str;
        String portStr;
        boolean backEnd = false;
        boolean frontEnd = false;
        InstalledSystem legoSystem = null;
        legoSystem = InstallType.getInstallType().contains("guiInstall") ? Singleton.getInstance().getSystem() : CliMain.getInstance().getSystem();
        if (null != legoSystem && (portStr = legoSystem.getNetWorkPanel().getWorkMangHttpsPort()) != null && portStr.length() > 0 && portStr.matches("\\d+")) {
            try {
                int httpPort = Integer.parseInt(portStr);
                frontEnd = PortCheckUtil.checkPortUsed(httpPort);
                if (frontEnd) {
                    return httpPort;
                }
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("HTTP Port is illeagl:" + portStr), "");
            }
        }
        if ((str = (propertyUtil = new PropertyUtil("config/conf/port.ini")).getValue("spring.export.rmi.service.port0")) != null && str.length() > 0 && str.matches("\\d+") && (backEnd = PortCheckUtil.checkPortUsed(rmiPortNumber = Integer.parseInt(str)))) {
            return rmiPortNumber;
        }
        return -1;
    }

    public static boolean checkPortRepeat(String[] ports) {
        boolean valid = false;
        HashSet<String> set = new HashSet<String>();
        for (String port : ports) {
            if (set.contains(port)) {
                return true;
            }
            set.add(port);
        }
        return valid;
    }

    public static boolean checkPort(String port) {
        boolean flag = false;
        int minPort = 1;
        if (OSInformation.isLinux()) {
            minPort = 1024;
        }
        if (HalfFullCheckUtil.validFullChar(port)) {
            return false;
        }
        try {
            int ptInt = Integer.parseInt(port);
            if (ptInt <= 65535 && ptInt >= minPort) {
                flag = true;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Port format is error :" + port), (Throwable)e, "");
        }
        return flag;
    }
}

