/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyUtil {
    private static final Log LOGGER = LogFactory.getInstance(PropertyUtil.class);
    private Properties prop = null;

    public PropertyUtil(String fileName) {
        this.init(new File(fileName));
    }

    public PropertyUtil(File file) {
        this.init(file);
    }

    public Properties getProp() {
        return this.prop;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(File file) {
        this.prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.prop.load(in);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("init properties failed, cant not find the file: " + file.getName()), "");
        }
        catch (IOException e) {
            LOGGER.error((Object)e, "Property Util Init error!");
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e, "close Property Util InputStream error!");
                }
            }
        }
    }

    public String getValue(String key) {
        String value = this.prop.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static String getaesLastHalf() {
        return "0a90c8d14cc341650e0c5c5c56897bec";
    }
}

