/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.SignatureException;

public class SignVerifier {
    public static final String SIGNFILE_POSTFIX = ".sign";
    private static final int BUFFSIZE = 500;
    private static final Log logger = LogFactory.getInstance(SignVerifier.class);
    private static SignVerifier instance;

    private SignVerifier() {
    }

    public static SignVerifier getInstance() {
        return instance;
    }

    public void verify(String fileName) throws SignatureException {
        File file = new File(fileName);
        this.verify(file);
    }

    public void verify(String[] fileNames) throws SignatureException {
        for (String fileName : fileNames) {
            File file = new File(fileName);
            this.verify(file);
        }
    }

    public void verify(File file) throws SignatureException {
        if (null == file || !file.exists()) {
            throw new SignatureException("Verify fail, file is not exists: " + file.getName());
        }
        String path = file.getParent();
        File saltFile = new File(path, file.getName() + SIGNFILE_POSTFIX);
        FileInputStream input = null;
        try {
            String saltEncrypted = this.readEncryptedSign(saltFile);
            input = new FileInputStream(file.getCanonicalPath());
            byte[] bytes = new byte[input.available()];
            input.read(bytes);
            String str = new String(bytes);
            boolean isIntegrated = KmcInstance.hmacVerify((String)str, (String)saltEncrypted);
            if (!isIntegrated) {
                throw new SignatureException("Verify failed.");
            }
            this.closeStream(input);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Verify file [" + file.getName() + "], failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB50012");
                throw new SignatureException("Verify file failed.");
            }
            catch (Throwable throwable) {
                this.closeStream(input);
                throw throwable;
            }
        }
    }

    private void closeStream(FileInputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error((Object)"close inputstream failed, ", (Throwable)e, "0x000252000FB50012");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readEncryptedSign(File file) throws IOException, SignatureException {
        String string;
        FileInputStream fileInputStream = null;
        InputStreamReader inputReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
            bufferedReader = new BufferedReader(inputReader, 500);
            char[] buffer = new char[500];
            int numRead = bufferedReader.read(buffer);
            string = new String(buffer).substring(0, numRead);
        }
        catch (Throwable throwable) {
            CommonUtil.close(bufferedReader);
            CommonUtil.close(inputReader);
            CommonUtil.close((Closeable)fileInputStream);
            throw throwable;
        }
        CommonUtil.close((Closeable)bufferedReader);
        CommonUtil.close((Closeable)inputReader);
        CommonUtil.close((Closeable)fileInputStream);
        return string;
    }

    private static void setWccFile() {
        String currPath = InstallConstant.getCurrentPath();
        String LegoConfPath = File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "wcc";
        String wccConfPath = currPath + File.separator + "Runtime" + LegoConfPath;
        if (currPath.endsWith(File.separator + "bin")) {
            wccConfPath = currPath.substring(0, currPath.length() - "bin".length()) + LegoConfPath;
        }
        try {
            KmcInstance.initComponent((String)wccConfPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SignVerifier.setWccFile();
        instance = new SignVerifier();
    }
}

