/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.EncryptedPropertiesHandler;
import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.entity.KmcImportCfg;
import com.huawei.kmc.entity.KmcImportMode;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.DataBaseTestUtil;
import com.huawei.lego.common.util.FileEncryptor;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class SysConfigDataUtil {
    public static final String DATA_FILE_STARTS_SUPFIX = "data";
    private static final String LINUX_DMP = "/usr/local/gaussdb/bin/gs_dump";
    private static final String LINUX_RESTORE = "/usr/local/gaussdb/bin/gsql";
    private static final Log LOGGER = LogFactory.getInstance(SysConfigDataUtil.class);
    private static final String DATA_ENCRYPT_FILE = "config.data";
    private static final String DATA_ENCRYPT_KEY = "key";
    private static final String SALTFILE = "zip1.tmp";
    private static final String IVFILE = "zip2.tmp";
    private static final String SQL_FILE_NAME = "data.sql";
    private static final String WCC_CONFIG_FILE = "wcc.conf";
    private static final String WCC_HW_CONFIG_FILE = "wcc-hw.conf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupSystemData(String dstFile, String encrytPwd, boolean isExportWcc) {
        boolean dbStartOK = false;
        try {
            LOGGER.info((Object)"start check db status. ", "");
            DataBaseInfo dbInfor = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            DataBaseTestUtil.setConnParam(dbInfor);
            if (OSInformation.isLinux() && !DataBaseTestUtil.connectionGauss()) {
                LOGGER.info((Object)"need start gaussdb.", "");
                CmdUtil.execStrCmd("/etc/init.d/gaussdb start");
            }
            for (int i = 0; i < 5; ++i) {
                TimeUnit.SECONDS.sleep(5L);
                if (!DataBaseTestUtil.connectionGauss()) continue;
                LOGGER.info((Object)("try connect database success. times: " + i), "");
                dbStartOK = true;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("backupSystemData failed. start gaussdb failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("");
        }
        if (!dbStartOK) {
            LOGGER.error((Object)"start database failed.", "");
            throw new PatchException("");
        }
        String dstParent = new File(dstFile).getParent();
        File outPath = new File(dstParent);
        if (!(outPath.exists() && outPath.isDirectory() || outPath.mkdirs())) {
            LOGGER.info((Object)"create backupSystemData path failed.", "");
            throw new PatchException("backupSystemData failed.");
        }
        String sqlFile = SysConfigDataUtil.getDBSQL(dstParent);
        File data = new File(sqlFile);
        if (!data.exists()) {
            LOGGER.error((Object)"data file not exists.", "");
            throw new LegoCheckedException("backupSystemData failed.");
        }
        ArrayList<String> fileList = new ArrayList<String>();
        File zipFile = null;
        String destPath = "";
        try {
            zipFile = FileUtil.zipFile(new File(sqlFile));
            destPath = zipFile.getParent();
            String destName = DATA_FILE_STARTS_SUPFIX + System.currentTimeMillis() + ".zip";
            if (VerifyUtil.isEmpty((String)encrytPwd)) {
                encrytPwd = SysConfigDataUtil.getRandomPassword();
                String pwdDestFile = destPath + File.separator + DATA_ENCRYPT_FILE;
                String value = "key=" + WccEncryptor.encode(encrytPwd);
                FileUtil.writeFile(pwdDestFile, value);
                fileList.add(DATA_ENCRYPT_FILE);
            }
            String ivFile = destPath + File.separator + IVFILE;
            String saltFile = destPath + File.separator + SALTFILE;
            FileEncryptor.encryptFileAccordingCipher(encrytPwd, zipFile, ivFile, saltFile, destName);
            fileList.add(destName);
            fileList.add(IVFILE);
            fileList.add(SALTFILE);
            if (isExportWcc) {
                String wccFile = destPath + File.separator + WCC_CONFIG_FILE;
                WccEncryptor.getInstance().exportAllCipherKey(wccFile, encrytPwd);
                fileList.add(WCC_CONFIG_FILE);
                fileList.add(WCC_HW_CONFIG_FILE);
            }
            FileUtil.zipFile(fileList, destPath, dstFile, true);
            WccEncryptor.signFile(dstFile);
        }
        finally {
            if (data.exists()) {
                data.delete();
            }
            if (null != zipFile && zipFile.exists()) {
                zipFile.delete();
            }
            for (String fileTmp : fileList) {
                File file = new File(destPath + File.separator + fileTmp);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    private static String getDBSQL(String dstParent) {
        String dumpFile = LINUX_DMP;
        DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        String sqlFile = dstParent + File.separator + SQL_FILE_NAME;
        StringBuffer buffer = new StringBuffer();
        buffer.append(dumpFile.contains(" ") ? "\"" + dumpFile + "\"" : dumpFile);
        buffer.append(" -h " + dbInfo.getDbHost());
        buffer.append(" -U " + dbInfo.getDbaUsername());
        buffer.append(" -W " + dbInfo.getDbaPassword());
        buffer.append(" -p " + dbInfo.getDbPort());
        buffer.append(" -Eutf8 ");
        buffer.append(" --pg-format ");
        buffer.append(" lego ");
        buffer.append(" -f ");
        buffer.append(sqlFile.contains(" ") ? "\"" + sqlFile + "\"" : sqlFile);
        if (!CmdUtil.execStrCmd(buffer.toString())) {
            LOGGER.error((Object)"exec backup system data cmd failed.", "");
            throw new LegoCheckedException("backupSystemData failed.");
        }
        return sqlFile;
    }

    public static void recoveryConfigData(String configData, String decryptPwd) {
        LOGGER.info((Object)"start recovery config data.", "");
        if (!new File(configData).exists()) {
            LOGGER.error((Object)"configData file not found. recovery config data failed.", "");
            throw new PatchException("recoveryConfigData failed.");
        }
        String outPath = new File(configData).getParent() + File.separator + "dataTmp";
        FileUtil.unzipFile(configData, outPath);
        if (VerifyUtil.isEmpty((String)decryptPwd)) {
            decryptPwd = SysConfigDataUtil.getDecryptPwd(outPath);
        }
        String srcFile = SysConfigDataUtil.getSourceFile(outPath);
        String destFile = outPath + File.separator + "tmp.zip";
        String ivFile = outPath + File.separator + IVFILE;
        String saltFile = outPath + File.separator + SALTFILE;
        FileEncryptor.decryptFileAccordingCipher(srcFile, destFile, decryptPwd, saltFile, ivFile);
        FileUtil.unzipFile(destFile, outPath);
        String destSqlFile = outPath + File.separator + SQL_FILE_NAME;
        if (!new File(destSqlFile).exists()) {
            LOGGER.error((Object)"recoveryConfigData failed, data.sql not found.", "");
            throw new PatchException("recoveryConfigData failed.");
        }
        SysConfigDataUtil.inputDBSQL(destSqlFile);
    }

    private static void inputDBSQL(String destSqlFile) {
        String tool = LINUX_RESTORE;
        DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        SysConfigDataUtil.clearDB(dbInfo);
        StringBuffer buffer = new StringBuffer();
        buffer.append(tool.contains(" ") ? "\"" + tool + "\"" : tool);
        buffer.append(" -h " + dbInfo.getDbHost());
        buffer.append(" -U " + dbInfo.getDbaUsername());
        buffer.append(" -W " + dbInfo.getDbaPassword());
        buffer.append(" -p " + dbInfo.getDbPort());
        buffer.append(" lego ");
        buffer.append(" -f ");
        buffer.append(destSqlFile.contains(" ") ? "\"" + destSqlFile + "\"" : destSqlFile);
        if (!CmdUtil.execStrCmd(buffer.toString())) {
            LOGGER.error((Object)"recoveryConfigData failed.", "");
            throw new PatchException("recoveryConfigData failed.");
        }
    }

    private static String getSourceFile(String outPath) {
        File[] files;
        String sourceFile = "";
        File path = new File(outPath);
        if (!path.exists() || !path.isDirectory()) {
            throw new PatchException("path not found, getSourceFile failed.");
        }
        for (File file : files = path.listFiles()) {
            if (!file.getName().startsWith(DATA_FILE_STARTS_SUPFIX) || !file.getName().endsWith(".zip")) continue;
            try {
                sourceFile = file.getCanonicalPath();
                break;
            }
            catch (IOException e) {
                LOGGER.error((Object)("getSourceFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("getSourceFile failed.");
            }
        }
        return sourceFile;
    }

    private static String getDecryptPwd(String outPath) {
        String encryptFile = outPath + File.separator + DATA_ENCRYPT_FILE;
        File file = new File(encryptFile);
        if (!file.exists()) {
            LOGGER.error((Object)"encrypt file not found, getDecryptPwd failed.", "");
            throw new PatchException("getDecryptPwd failed.");
        }
        Properties properties = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(encryptFile);
            properties.load(input);
            String string = WccEncryptor.decode(properties.getProperty(DATA_ENCRYPT_KEY));
            return string;
        }
        catch (Exception e) {
            LOGGER.error((Object)("getDecryptPwd failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("getDecryptPwd failed.");
        }
        finally {
            FileUtil.close(input, "close input");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearDB(DataBaseInfo dbInfo) {
        Connection connection = null;
        try {
            connection = LegoDBConnection.getInstance().connectionGauss(dbInfo);
            String dropScript = "DROP DATABASE if exists lego;";
            String createScript = "CREATE DATABASE lego WITH TEMPLATE = TEMPLATE0 ENCODING 'UTF8';";
            String ownerScript = "ALTER DATABASE lego OWNER TO " + dbInfo.getDbaUsername();
            String connLimit = "ALTER DATABASE lego CONNECTION LIMIT=100;";
            ArrayList<String> scripts = new ArrayList<String>();
            scripts.add(dropScript);
            scripts.add(createScript);
            scripts.add(ownerScript);
            scripts.add(connLimit);
            InitSQL.executeSQL(connection, scripts);
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)("close connection failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
            }
        }
    }

    public static String getRandomPassword() {
        String tmpStr = "abcdefghigklmnopqrstuvwxyz";
        String tmpInteger = "0123456789";
        String tmpChar = "!@#$%_-=?";
        StringBuffer randPwd = new StringBuffer();
        SecureRandom random = new SecureRandom();
        int sCount = random.nextInt(5) + 5;
        for (int i = 0; i < sCount; ++i) {
            int tmp1 = random.nextInt(tmpStr.length() - 1);
            if (tmp1 % 2 == 0) {
                randPwd.append(String.valueOf(tmpStr.charAt(tmp1)).toUpperCase(Locale.ENGLISH));
                continue;
            }
            randPwd.append(tmpStr.charAt(tmp1));
        }
        randPwd.append(tmpChar.charAt(random.nextInt(tmpChar.length() - 1)));
        int count = random.nextInt(3) + 2;
        for (int i = 0; i < count; ++i) {
            randPwd.append(tmpInteger.charAt(random.nextInt(tmpInteger.length() - 1)));
        }
        return randPwd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transWccData() {
        String kmcConf = InitInstalledXmlTool.getInstallPath() + "/Runtime/LegoRuntime/conf/wcc";
        String wccConf = InitInstalledXmlTool.getInstallPath() + "/Runtime@tmp/LegoRuntime/conf/wcc";
        EncryptedPropertiesHandler encryptedPropertiesHandler = new EncryptedPropertiesHandler(wccConf, kmcConf);
        String sql = SysConfigDataUtil.getDBSQL("");
        File wccStore = new File(wccConf + File.separator + "crypt" + File.separator + "wccStore.xml");
        try {
            if (wccStore.exists()) {
                encryptedPropertiesHandler.updateSqlData(sql);
            } else {
                encryptedPropertiesHandler.updateSqlDataFromKmc(sql);
            }
            SysConfigDataUtil.inputDBSQL(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.deleteFile(sql);
        }
    }

    public static void importKsf(String installPath) {
        String installConf = installPath + "/Runtime@tmp/LegoRuntime/conf/wcc";
        if (!new File(installConf).exists()) {
            LOGGER.error((Object)"Ks file not found. No import is required.", "");
            return;
        }
        String masterKsFile = "/crypt/master.ks";
        String backupKsFile = "/crypt/backup.ks";
        String installedKsFile = installConf + masterKsFile;
        try {
            FileUtil.copyFile(installedKsFile, installedKsFile + ".bak");
            KmcInstance.getSoftInstance().finalized();
            KmcInstance.initComponent((String)installConf, (boolean)true);
            String currentConf = installPath + "/Runtime/LegoRuntime/conf/wcc";
            KmcImportCfg kmcImportCfg = new KmcImportCfg(currentConf + masterKsFile);
            kmcImportCfg.setImportMode(KmcImportMode.IMPORT_APPAND);
            KmcInstance.getSoftInstance().importKsf(kmcImportCfg);
            FileUtil.copyFile(installedKsFile, currentConf + masterKsFile);
            FileUtil.copyFile(installedKsFile, currentConf + backupKsFile);
            FileUtil.copyFile(installedKsFile + ".bak", installedKsFile);
            FileUtil.copyFile(installedKsFile + ".bak", installConf + backupKsFile);
        }
        catch (AppException | IOException e) {
            LOGGER.error((Object)("Import ks file failed. Error:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("Import ks file failed.");
        }
    }
}

