/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.certs.ChangeCertsPwd;
import com.huawei.lego.common.certs.ChangePrivateKeyPwd;
import com.huawei.lego.common.certs.PrivateKey;
import com.huawei.lego.common.cloud.CloudUpdateUtil;
import com.huawei.lego.common.cloud.VhaUpdateProcess;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.extend.IextendCallBack;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class UpdateUtil {
    private static Log logger = LogFactory.getInstance(UpdateUtil.class);
    private static final String installedPath = InitInstalledXmlTool.getInstallPath();
    private static final String pass = WccEncryptor.decode(LegoResourceManager.getProValue("default.gauss.mangement.password"));
    private static final String tmpFile = installedPath + File.separator + "tmp.conf";
    private static final String PLATEXTEND = "com.huawei.lego.common.extend.PlatExtendUpdate";
    private static final String DEFAULTTYPE = "JKS";
    private static final String DBNAME = "LEGO";
    private static Map<String, String> statusMap = null;

    public static void updateSql(IextendCallBack callBack) throws SQLException {
        Connection connect = null;
        try {
            DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            connect = LegoDBConnection.getInstance().connectGaussDB(dataBase, DBNAME);
            callBack.callDataBaseUpdate(connect);
        }
        finally {
            if (null != connect) {
                connect.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateSysConfigData() {
        Connection connect = null;
        try {
            DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            connect = LegoDBConnection.getInstance().connectGaussDB(dataBase, DBNAME);
            if (null == connect) {
                throw new PatchException("updateSysConfigData failed, get db connection is null.");
            }
            VhaUpdateProcess process = new VhaUpdateProcess(connect);
            process.updateAzMapping();
            if (null == connect) return;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("updateSysConfigData failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("updateSysConfigData failed");
            }
            catch (Throwable throwable) {
                if (null == connect) throw throwable;
                UpdateUtil.closeConnection(connect);
                throw throwable;
            }
        }
        UpdateUtil.closeConnection(connect);
        return;
    }

    public static void dealGaussDBUserAuth() {
        DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        String dbUserName = dataBase.getDbaUsername();
        String dbPwd = dataBase.getDbaPassword();
        String superUser = dataBase.getManagerUsername();
        dataBase.setDbaUsername(dataBase.getManagerUsername());
        dataBase.setDbaPassword(dataBase.getManagerPassword());
        Connection connect = LegoDBConnection.getInstance().connectGaussDB(dataBase, DBNAME);
        dataBase.setDbaUsername(dbUserName);
        dataBase.setDbaPassword(dbPwd);
        try {
            UpdateUtil.changeTableOwner(dbUserName, superUser, connect);
            logger.info((Object)"start dealwith Gauss's user.", "");
            String sqlStr = "alter user " + dbUserName + " with nosuperuser noReplication nocreatedb;";
            String alterDB = "alter database LEGO owner to " + dbUserName;
            InitSQL.executeSQL(connect, alterDB);
            InitSQL.executeSQL(connect, sqlStr);
        }
        catch (Exception e) {
            logger.error((Object)("dealwith Gauss's user auth failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("dealGaussDBUserAuth failed.");
        }
        finally {
            if (null != connect) {
                try {
                    connect.close();
                }
                catch (SQLException e2) {
                    logger.error((Object)("close connect faile: " + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
                }
            }
        }
    }

    public static void changeWccLogConfFile(String installPath) throws IOException {
        String sp = File.separator;
        String wccLogFile = installPath + sp + "Runtime" + sp + "logs" + sp + "wcc.log";
        String log4jFile = installPath + "/Runtime/LegoRuntime/conf/wcc/log4j.properties";
        if (installPath.endsWith(File.separator)) {
            wccLogFile = installPath + "Runtime" + sp + "logs" + sp + "wcc.log";
        }
        if (OSInformation.isWindows()) {
            wccLogFile = wccLogFile.replaceAll("\\\\", "\\\\\\\\");
        }
        String backUpFile = log4jFile + "@back";
        File file = new File(log4jFile);
        if (!file.exists()) {
            logger.info((Object)"log4j.properties is not exists, no need changeWccLogConfFile", "");
            return;
        }
        try {
            String key = "appender.rolling.fileName";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(key, wccLogFile);
            UpdateUtil.changeFile(log4jFile, backUpFile, data);
        }
        catch (Exception e) {
            logger.info((Object)("update log4j.properties failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            FileUtil.copyFile(backUpFile, log4jFile);
            throw new IOException();
        }
        finally {
            FileUtil.deleteFile(backUpFile);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void changeFile(String file, String backUpFile, Map<String, String> data) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        BufferedWriter writer = null;
        OutputStreamWriter output = null;
        InputStreamReader input = null;
        FileOutputStream outpuStream = null;
        FileInputStream inputStream = null;
        try {
            String text;
            FileUtil.copyFile(file, backUpFile);
            inputStream = new FileInputStream(backUpFile);
            input = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(input);
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    if (!text.startsWith(entry.getKey())) continue;
                    String value = entry.getValue();
                    text = entry.getKey() + "=" + value;
                }
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            outpuStream = new FileOutputStream(file);
            output = new OutputStreamWriter((OutputStream)outpuStream, "UTF-8");
            writer = new BufferedWriter(output);
            writer.write(sb.toString());
            writer.flush();
        }
        catch (FileNotFoundException e) {
            try {
                logger.error((Object)("File not found: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new FileNotFoundException();
                catch (IOException e2) {
                    logger.error((Object)e2, "change file failed.");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(writer, "");
                FileUtil.close(output, "");
                FileUtil.close(outpuStream, "");
                FileUtil.close(reader, "");
                FileUtil.close(input, "");
                FileUtil.close(inputStream, "");
                FileUtil.deleteFile(backUpFile);
                throw throwable;
            }
        }
        FileUtil.close(writer, "");
        FileUtil.close(output, "");
        FileUtil.close(outpuStream, "");
        FileUtil.close(reader, "");
        FileUtil.close(input, "");
        FileUtil.close(inputStream, "");
        FileUtil.deleteFile(backUpFile);
    }

    private static void changeTableOwner(String comUser, String superUser, Connection connect) {
        logger.info((Object)"Start change Table Owner.", "");
        int iCount = 0;
        PreparedStatement preparedStatement = null;
        String allTableQuery = "select TABLENAME,TABLEOWNER from pg_tables where SCHEMANAME='PUBLIC' and TABLEOWNER='" + superUser.toUpperCase(Locale.getDefault()) + "';";
        try {
            preparedStatement = connect.prepareStatement(allTableQuery);
            ResultSet rs = preparedStatement.executeQuery();
            if (null != rs) {
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    String sql = "alter table " + tableName + " owner to " + comUser + ";";
                    preparedStatement = connect.prepareStatement(sql);
                    preparedStatement.execute();
                    ++iCount;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("changeTableOwner failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("changeTableOwner failed.");
        }
        finally {
            UpdateUtil.closeStatement(preparedStatement);
        }
        logger.info((Object)("End change Table Owner, count = " + iCount), "");
    }

    protected static void closeStatement(PreparedStatement state) {
        if (null != state) {
            try {
                state.close();
            }
            catch (SQLException e) {
                logger.error((Object)("closeStatement failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static void callPlatformUpdate() {
        try {
            IextendCallBack callBack = (IextendCallBack)Class.forName(PLATEXTEND).newInstance();
            UpdateUtil.updateSql(callBack);
        }
        catch (Exception e) {
            logger.error((Object)("update platform sql failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("update platform sql failed.");
        }
    }

    public static void updateCrypt() {
        String sp = File.separator;
        String currPath = InstallConstant.getCurrentPath();
        String appConfigPath = currPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "conf" + sp + "wcc";
        String appConfigFile = appConfigPath + sp + "application.properties";
        File file = new File(appConfigFile);
        if (!file.exists()) {
            logger.error((Object)"Can not find the wcc config file, update crypt failed.", "");
            throw new PatchException("");
        }
        try {
            int mkCount = KmcInstance.getSoftInstance().getMaxMkID(KmcInstance.kmcDomain);
            if (mkCount == 1) {
                logger.info((Object)"need update wcc crypt.", "");
                WccEncryptor.updateSoftCrypt();
            }
        }
        catch (Exception e) {
            logger.error((Object)("update crypt failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("");
        }
    }

    private static boolean checkIfUpdated(File path) {
        boolean isUpdated = false;
        String sp = File.separator;
        try {
            File[] fileList;
            String cryptPath = path.getCanonicalPath().substring(0, path.getCanonicalPath().lastIndexOf(sp));
            String fileName = path.getName();
            File tmpPath = new File(cryptPath);
            for (File file : fileList = tmpPath.listFiles()) {
                String tmpFile = file.getName();
                if (!tmpFile.startsWith(fileName) || tmpFile.equals(fileName)) continue;
                isUpdated = true;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("check If crypt Updated failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return isUpdated;
    }

    public static void updateCerts() {
        try {
            UpdateUtil.dealWithCerts();
        }
        catch (IOException e) {
            logger.info((Object)("dealWithCerts failed: " + e), "");
            throw new PatchException("dealWithCerts failed.");
        }
    }

    private static void dealWithCerts() throws IOException {
        String sp = File.separator;
        String runtimePath = InitInstalledXmlTool.getInstallPath() + sp;
        String backKeystore = runtimePath + "Runtime" + LegoResourceManager.getProValue("install.platform.keystore");
        String tomcatKeystore = runtimePath + "Runtime" + LegoResourceManager.getProValue("install.tomcat.keystore");
        if (!new File(backKeystore).exists()) {
            throw new PatchException("dealWithCerts, can not find the backend keystore.");
        }
        FileUtil.copyFile(backKeystore, tomcatKeystore);
        String oldKeyStore = runtimePath + "Runtime@tmp" + LegoResourceManager.getProValue("install.platform.keystore");
        File file = new File(oldKeyStore);
        if (!file.exists()) {
            logger.info((Object)"can not find the keystore file, return.", "0x000252000FB5000D");
            return;
        }
        logger.info((Object)"start deal with backend keystore.", "");
        UpdateUtil.dealWithBackEndKeyStore(runtimePath);
        logger.info((Object)"start deal with tomcat keystore.", "");
        UpdateUtil.dealWithFrontKeyStore(runtimePath);
        logger.info((Object)"start deal with nginx certs.", "");
        UpdateUtil.dealWithNginxCerts(runtimePath);
    }

    private static void dealWithNginxCerts(String runtimePath) {
        Path tempCertsDir = Paths.get(runtimePath, "Runtime@tmp", "nginx", "certs");
        Path targetCertsDir = Paths.get(runtimePath, "Runtime", "nginx", "certs");
        if (!Files.isDirectory(tempCertsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> sourceStream = Files.walk(tempCertsDir, 1, new FileVisitOption[0]);){
            sourceStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(source -> {
                try {
                    Files.copy(source, targetCertsDir.resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException e) {
                    logger.error((Object)String.format(Locale.ENGLISH, "Copy cert [%s] failed.", source.getFileName()), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            logger.error((Object)String.format(Locale.ENGLISH, "Copy certs from directory [%s] failed.", tempCertsDir), (Throwable)e);
        }
    }

    private static String getTomcatKeyStoreFile(String xmlFile) {
        SAXReader reader = new SAXReader();
        String keystore = "";
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            File file = new File(xmlFile);
            if (!file.exists()) {
                logger.error((Object)("getTomcatKeyStoreFile faield, file not exists: " + file.getName()), "");
                throw new FileNotFoundException();
            }
            Document document = reader.read(xmlFile);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreFile");
                if (null == keyStore) continue;
                keystore = keyStore.getValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get keystore pwd from tomcat conf file failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("get keystore pwd from tomcat conf file failed.");
        }
        return keystore;
    }

    private static String getTomcatKeyStoreType(String xmlFile) {
        SAXReader reader = new SAXReader();
        String keystoreType = "";
        try {
            File file = new File(xmlFile);
            if (!file.exists()) {
                logger.error((Object)("getTomcatKeyStoreType faield, file not exists: " + file.getName()), "");
                throw new FileNotFoundException();
            }
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xmlFile);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreType");
                if (null == keyStore) continue;
                keystoreType = keyStore.getValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get keystore pwd from tomcat conf file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("get keystore pwd from tomcat conf file failed.");
        }
        return keystoreType;
    }

    private static void updateServerXML(String xmlFile, String data, String pwd, String keyPwd, String keyStoreType) {
        File xml = new File(xmlFile);
        if (!xml.exists()) {
            logger.info((Object)"can not find the file server.xml or http port is null, not changed, return.", "");
            return;
        }
        FileOutputStream fout = null;
        XMLWriter writer = null;
        SAXReader reader = new SAXReader();
        boolean isChanged = false;
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xml);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore1 = ((Element)ele).attribute("keystoreFile");
                if (null == keyStore1) continue;
                ((Element)ele).addAttribute("keystoreFile", data);
                ((Element)ele).addAttribute("keystorePass", WccEncryptor.encode(pwd));
                ((Element)ele).addAttribute("keyPass", WccEncryptor.encode(keyPwd));
                if (!"".equals(keyStoreType)) {
                    ((Element)ele).addAttribute("keystoreType", keyStoreType);
                }
                if (!VerifyUtil.isEmpty((String)keyPwd) && !keyPwd.equals(pwd)) {
                    ((Element)ele).addAttribute("keyPass", WccEncryptor.encode(keyPwd));
                }
                isChanged = true;
            }
            if (!isChanged) {
                logger.info((Object)"password is not changed, return.", "");
                return;
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fout = new FileOutputStream(new File(xmlFile));
            writer = new XMLWriter((OutputStream)fout, format);
            writer.write(document);
            UpdateUtil.closeStream(fout);
        }
        catch (Exception e) {
            logger.error((Object)("update server.xml failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("update server.xml failed.");
        }
        finally {
            UpdateUtil.closeStream(fout);
            UpdateUtil.closeXmlWriter(writer);
        }
        UpdateUtil.closeXmlWriter(writer);
    }

    private static void closeXmlWriter(XMLWriter writer) {
        if (null != writer) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error((Object)e, "close xml writer failed.");
            }
        }
    }

    private static void dealWithFrontKeyStore(String runPath) {
        try {
            String sp = File.separator;
            String tomcatKeyStore = runPath + "Runtime@tmp" + sp + "Tomcat6/certs/tomcat.keystore";
            String xmlFile = runPath + "Runtime@tmp" + sp + "Tomcat6/conf/server.xml";
            String targetKeyStore = runPath + "Runtime/Tomcat6/certs/tomcat.keystore";
            String targetServerXml = runPath + "Runtime/Tomcat6/conf/server.xml";
            String oldPwd = ChangeCertsPwd.getTomcatKeyStorePwd(xmlFile);
            String okdKeyPass = ChangeCertsPwd.getTomcatKeyPwd(xmlFile);
            String keyStoreType = UpdateUtil.getTomcatKeyStoreType(xmlFile);
            String currentKeyStore = UpdateUtil.getTomcatKeyStoreFile(xmlFile);
            File file = new File(tomcatKeyStore);
            if (!file.exists()) {
                logger.info((Object)"the default keystore is not exists, get it from tomcat config file.", "");
                String src = runPath + "Runtime@tmp/Tomcat6/" + currentKeyStore;
                String dest = runPath + "Runtime/Tomcat6/" + currentKeyStore;
                FileUtil.copyFile(src, dest);
                UpdateUtil.updateServerXML(targetServerXml, currentKeyStore, oldPwd, okdKeyPass, keyStoreType);
                FileUtil.deleteFile(targetKeyStore);
                return;
            }
            CertificateUtil CerUtl = new CertificateUtil(tomcatKeyStore, oldPwd, keyStoreType);
            ArrayList<String> exceptAlias = new ArrayList<String>();
            exceptAlias.add("bcmrootca");
            exceptAlias.add("bcmtomcat");
            String newPwd = ChangeCertsPwd.getTomcatKeyStorePwd(targetServerXml);
            CerUtl.exportCertToKeyStore(exceptAlias, targetKeyStore, DEFAULTTYPE, newPwd);
            if (!VerifyUtil.isEmpty((String)okdKeyPass) && !okdKeyPass.equals(oldPwd)) {
                logger.info((Object)"need update tomcat server.xml private key password.", "");
                UpdateUtil.updateServerXML(targetServerXml, currentKeyStore, newPwd, okdKeyPass, keyStoreType);
            }
            if (!VerifyUtil.isEmpty((String)okdKeyPass) && !okdKeyPass.equals(newPwd)) {
                logger.info((Object)"start update private key password.", "");
                PrivateKey privateKey = new PrivateKey();
                privateKey.setAliasName("bcmrootca");
                privateKey.setKeyStore(targetKeyStore);
                privateKey.setKeyStorePwd(newPwd);
                privateKey.setOldKeyPwd(newPwd);
                privateKey.setNewKeyPwd(okdKeyPass);
                ChangePrivateKeyPwd.updateKeyPwd(privateKey);
            }
        }
        catch (Exception e) {
            logger.error((Object)("dealWithFrontKeyStore failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("dealWithFrontKeyStore failed: ");
        }
    }

    private static void dealWithBackEndKeyStore(String runPath) throws IOException {
        String sp = File.separator;
        String oldKeyStore = runPath + "Runtime@tmp" + LegoResourceManager.getProValue("install.platform.keystore");
        String oldConfFile = runPath + "Runtime@tmp" + sp + "LegoRuntime/conf/lego.properties";
        String targetFile = runPath + "Runtime" + sp + "LegoRuntime/conf/lego.properties";
        String newConfFile = "Runtime/LegoRuntime/conf/lego.properties";
        try {
            PropertyUtil pro = new PropertyUtil(oldConfFile);
            String oldkeyPwd = WccEncryptor.decode(pro.getValue("keyStore"));
            CertificateUtil oldCerUtl = new CertificateUtil(oldKeyStore, oldkeyPwd, DEFAULTTYPE);
            PropertyUtil newPro = new PropertyUtil(newConfFile);
            String newkeyPwd = WccEncryptor.decode(newPro.getValue("keyStore"));
            ArrayList<String> exceptAlias = new ArrayList<String>();
            exceptAlias.add("bcmrootca");
            exceptAlias.add("bcmagentca");
            String newStore = runPath + "Runtime" + LegoResourceManager.getProValue("install.platform.keystore");
            oldCerUtl.exportCertToKeyStore(exceptAlias, newStore, DEFAULTTYPE, newkeyPwd);
            if (!ChangeCertsPwd.updateKeyPwd(newkeyPwd, oldkeyPwd)) {
                logger.error((Object)"dealWithBackEndKeyStore failed, update key password failed.", "");
                throw new PatchException("dealWithBackEndKeyStore failed.");
            }
            ChangeCertsPwd.changePwd(runPath, oldkeyPwd);
            UpdateUtil.changeConfFile(targetFile, pro);
        }
        catch (Exception e) {
            logger.error((Object)("dealWithBackEndKeyStore faield: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("restore certs failed: ");
        }
    }

    private static void changeConfFile(String file, PropertyUtil pro) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("default.lego.alias", pro.getValue("default.lego.alias"));
        data.put("Issuer.info", pro.getValue("Issuer.info"));
        try {
            FileUtil.modifyDBPropFileUsingStr(file, data, file);
        }
        catch (IOException e) {
            logger.error((Object)e, "changeConfFile failed.");
            throw new PatchException("changeConfFile failed: " + e);
        }
    }

    public static void exportConfig() {
        try {
            UpdateUtil.dealWithFile();
        }
        catch (Exception e) {
            logger.error((Object)("export error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("dealWithFile failed: ");
        }
        finally {
            FileUtil.deleteFile(tmpFile);
        }
    }

    private static void dealWithFile() throws IOException {
        String sp = File.separator;
        String proper = "application.properties";
        String wccStore = "wccStore.xml";
        String oldConfPath = "Runtime" + sp + "LegoRuntime" + sp + "conf";
        String oldAppHome = installedPath + sp + oldConfPath;
        String oldConfFile = oldAppHome + sp + proper;
        String newConfPath = oldConfPath + sp + "wcc" + sp + "crypt";
        String newConfFile = installedPath + sp + newConfPath + sp + wccStore;
        File oldFile = new File(oldConfFile);
        File newFile = new File(newConfFile);
        if (!oldFile.exists() && !newFile.exists()) {
            logger.info((Object)"linux no need deal while cli install, return.", "");
            return;
        }
        if (newFile.exists()) {
            logger.info((Object)"use new wcc config file path.", "");
            oldAppHome = installedPath + sp + newConfPath;
        }
        String newAppHome = InstallConstant.getCurrentPath() + sp + newConfPath;
        FileUtil.copyFile("", "");
    }

    public static void copyCryptConfig() throws IOException {
        String sp = File.separator;
        String newConfig = "Runtime" + sp + "LegoRuntime" + sp + "crypt";
        String oldConfig = installedPath + sp + newConfig;
        try {
            FileUtil.copyFolder(newConfig, oldConfig);
        }
        catch (IOException e) {
            logger.error((Object)("copy crypt config failed." + e.getMessage()), "");
            throw e;
        }
    }

    public static String getLicXmlPath() {
        String sp = File.separator;
        return installedPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "lic" + sp + LegoResourceManager.getProValue("install.params.license.file");
    }

    public static void updateLicXml() throws IOException, DocumentException, SAXException {
        String sp = File.separator;
        String licFile = installedPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "lic" + sp + LegoResourceManager.getProValue("install.params.license.file");
        File file = new File(licFile);
        if (!file.exists()) {
            logger.info((Object)"can not find the legolic.xml, no need to update.", "0x000252000FB5000D");
            return;
        }
        UpdateUtil.updateLicXml(licFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLicXml(String xmlFile) throws IOException, DocumentException, SAXException {
        String code;
        Element element;
        Document document;
        XMLWriter writer;
        FileOutputStream fout;
        block4: {
            fout = null;
            writer = null;
            SAXReader reader = new SAXReader();
            File xml = new File(xmlFile);
            try {
                if (!xml.exists()) {
                    logger.error((Object)"LegoLic.xml is not exists.", "");
                    throw new FileNotFoundException("updateLicXml failed, file not found.");
                }
                CommonUtil.setSecurityFeatures((SAXReader)reader);
                document = reader.read(xml);
                element = (Element)document.selectSingleNode("/install/lic");
                String timeSit = element.attributeValue("sit");
                code = WccEncryptor.retryDecode(timeSit);
                if (!VerifyUtil.isEmpty((String)code)) break block4;
                logger.info((Object)"not need change license time, return.", "0x000252000FB5000D");
            }
            catch (Throwable throwable) {
                UpdateUtil.releaseStream(writer);
                UpdateUtil.closeStream(fout);
                throw throwable;
            }
            UpdateUtil.releaseStream(writer);
            UpdateUtil.closeStream(fout);
            return;
        }
        element.addAttribute("sit", code);
        OutputFormat format = OutputFormat.createPrettyPrint();
        fout = new FileOutputStream(new File(xmlFile));
        writer = new XMLWriter((OutputStream)fout, format);
        writer.write(document);
        UpdateUtil.releaseStream(writer);
        UpdateUtil.closeStream(fout);
    }

    private static String getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E rpStatus) {
        if (null == rpStatus) {
            throw new PatchException("get status key failed, rpStatus is null");
        }
        return "KEY_" + rpStatus.getValue();
    }

    private static String caculateStatus(DrmEnumDefine.RECOVERY_PLAN_STATUS_E rpStatus) {
        if (null == statusMap) {
            statusMap = new HashMap<String, String>();
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.CLEARING.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_CLEAR.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTING.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTED.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_TEST.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_RUNNING.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_COMPLETED.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_RUNNING.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_RUNNING.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue());
            statusMap.put(UpdateUtil.getKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue());
        }
        return statusMap.get(UpdateUtil.getKey(rpStatus));
    }

    public static String getProjectId(String id) {
        if (VerifyUtil.isEmpty((String)id)) {
            return null;
        }
        if (id.contains(":")) {
            id = id.split(":")[1];
        }
        return id;
    }

    private static String getOpenstackUuid(String id) {
        if (VerifyUtil.isEmpty((String)id)) {
            return null;
        }
        if (id.contains(":")) {
            id = id.split(":")[0];
        }
        return id;
    }

    private static List<ServiceInstance> getServiceInstance(Connection connect) {
        String sqlStr = "select pg.PGNAME,pg.PGDESC,pt.type,pg.PGID,rp.PLANID,pp.PROPVALUE,rp.PLANSTATUS from ti_protectgroup as pg, ti_policytemplate as pt, ti_protectgroup_prop as pp, ti_drp_r_pg as drp,  ti_recoveryplan as rp where pg.PGID not in  (select PROTECTGROUPID from ti_serviceinstance) and pg.PTID = pt.PTID and (pt.TYPE='22' or pt.TYPE='21') and pg.PGID = pp.PGID and pp.PROPNAME = 'projectId' and drp.PGID = pg.PGID  and drp.PLANID = rp.PLANID;";
        ArrayList<ServiceInstance> instanceList = new ArrayList<ServiceInstance>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connect.prepareStatement(sqlStr);
            ResultSet rs = preparedStatement.executeQuery();
            if (null != rs) {
                Date currentTime = new Date();
                while (rs.next()) {
                    ServiceInstance inst = new ServiceInstance();
                    inst.setUuid(UUIDGenerator.getUUID());
                    inst.setCreateTime(Long.valueOf(currentTime.getTime()));
                    inst.setStartPriority(3);
                    inst.setName(rs.getString(1));
                    inst.setDescription(rs.getString(2));
                    inst.setType("replication");
                    inst.setProtectGroupId(rs.getString(4));
                    inst.setRecoveryPlanId(rs.getString(5));
                    inst.setProjectId(UpdateUtil.getProjectId(rs.getString(6)));
                    inst.setStatus(UpdateUtil.caculateStatus(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)rs.getInt(7))));
                    instanceList.add(inst);
                }
            }
            logger.info((Object)("get service instance size: " + instanceList.size()), "");
            ArrayList<ServiceInstance> arrayList = instanceList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Object)("getServiceInstance failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("getServiceInstance failed");
        }
        finally {
            UpdateUtil.closeStatement(preparedStatement);
        }
    }

    private static File getConfigFile() {
        String basePath = InstallConstant.getsBasePath();
        String confFile = basePath + File.separator + "upgrade.conf";
        File file = new File(confFile);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static boolean isAutoUpdate() {
        if (null == UpdateUtil.getConfigFile()) {
            logger.error((Object)"file not found, is not auto upgrade.", "");
            return false;
        }
        return true;
    }

    private static Map<String, String> getIAMInfo() {
        File confFile = UpdateUtil.getConfigFile();
        Properties prop = new Properties();
        FileInputStream input = null;
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            input = new FileInputStream(confFile);
            prop.load(input);
            String iamAddress = prop.getProperty("iam_address");
            String iamUser = prop.getProperty("iam_account");
            String iamPwd = prop.getProperty("iam_account_pwd");
            if (VerifyUtil.isEmpty((String)iamAddress) || VerifyUtil.isEmpty((String)iamUser) || VerifyUtil.isEmpty((String)iamPwd)) {
                throw new PatchException("getIAMInfo failed.");
            }
            String[] address = iamAddress.split(":");
            data.put("ip", address[0]);
            data.put("port", address[1]);
            data.put("user", iamUser);
            if (!VerifyUtil.isEmpty((String)WccEncryptor.decode(iamPwd))) {
                data.put("password", iamPwd);
            } else {
                data.put("password", WccEncryptor.encode(iamPwd));
            }
            HashMap<String, String> hashMap = data;
            return hashMap;
        }
        catch (IOException e) {
            throw new PatchException("getIAMInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            logger.info((Object)("get iam info end, delete config file: " + confFile.delete()), "");
            FileUtil.close(input, "");
        }
    }

    private static void updateOpenstackInfo(Connection connect) {
        logger.info((Object)"start updateOpenstackInfo", "");
        String opsUuid = "";
        PreparedStatement preparedStatement = null;
        try {
            String sql = "select pp.PROPVALUE from ti_protectgroup as pg,ti_policytemplate as pt, ti_protectgroup_prop as pp where pg.PTID = pt.PTID and pt.TYPE in ('21','22','25') and pg.PGID = pp.PGID and pp.PROPNAME='projectId'";
            preparedStatement = connect.prepareStatement(sql);
            ResultSet rs = preparedStatement.executeQuery();
            if (null != rs && rs.next()) {
                logger.info((Object)("get projectId: " + rs.getString(1)), "");
                opsUuid = UpdateUtil.getOpenstackUuid(rs.getString(1));
            }
            logger.info((Object)("get openstack uuid: " + opsUuid), "");
            if (VerifyUtil.isEmpty((String)opsUuid)) {
                throw new PatchException("get openstack uuid failed.");
            }
            preparedStatement.close();
            sql = "select MOID from t_managedobject where UUID=?";
            preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, opsUuid);
            ResultSet idResult = preparedStatement.executeQuery();
            if (null == idResult || !idResult.next()) {
                logger.error((Object)("get MOID failed, ops uuid=" + opsUuid), "");
                throw new PatchException("get moid failed.");
            }
            String moId = idResult.getObject(1).toString();
            logger.info((Object)("get moid=" + moId + ", uuid=" + opsUuid), "");
            Map<String, String> data = UpdateUtil.getIAMInfo();
            sql = "replace into ti_ne_user_properties (MOID,PARAMVAL,NAME) values (?, 'op_service', 'domain')";
            preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, moId);
            preparedStatement.executeUpdate();
            sql = "replace into ti_ne_user_properties (MOID,PARAMVAL,NAME) values (?, 'IAM', 'authType')";
            preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, moId);
            preparedStatement.executeUpdate();
            sql = "replace into ti_ne_user_properties (MOID,PARAMVAL,NAME) values (?, '6.1', 'version')";
            preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, moId);
            preparedStatement.executeUpdate();
            sql = "replace into ti_ne_user_properties (MOID,PARAMVAL,NAME) values (?, ?, 'port')";
            preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, moId);
            preparedStatement.setString(2, data.get("port"));
            preparedStatement.executeUpdate();
            sql = "update ti_nemgrprotocolextend set NETWORKIPADDRESS=?,NETWORKUSERNAME=?, NETWORKPWD=? where MOID=?";
            preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, data.get("ip"));
            preparedStatement.setString(2, data.get("user"));
            preparedStatement.setString(3, data.get("password"));
            preparedStatement.setString(4, moId);
            preparedStatement.executeUpdate();
            sql = "update ti_dr_resource set IPADDRESS=? where DEVICESN=?";
            preparedStatement = connect.prepareStatement(sql);
            preparedStatement.setString(1, data.get("ip"));
            preparedStatement.setString(2, opsUuid);
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("updateOpenstackInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("updateOpenstackInfo failed");
            }
            catch (Throwable throwable) {
                UpdateUtil.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        UpdateUtil.closeStatement(preparedStatement);
    }

    public static void convertCloudData() {
        List<ServiceInstance> instList;
        Connection connect;
        PreparedStatement preparedStatement;
        block8: {
            logger.info((Object)"start convert cloud data.", "");
            if (!UpdateUtil.isAutoUpdate()) {
                logger.info((Object)"is not auto upgrade, no need convert cloud data.", "");
                return;
            }
            preparedStatement = null;
            connect = null;
            DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            connect = LegoDBConnection.getInstance().connectGaussDB(dataBase, DBNAME);
            if (null == connect) {
                logger.error((Object)"convertCloudData failed, get database connection failed.", "");
                throw new PatchException("convertCloudData failed");
            }
            UpdateUtil.updateOpenstackInfo(connect);
            instList = UpdateUtil.getServiceInstance(connect);
            if (!VerifyUtil.isEmpty(instList)) break block8;
            logger.info((Object)"serviceInstance list is empty, no need convertCloudData", "");
            UpdateUtil.closeStatement(preparedStatement);
            UpdateUtil.closeConnection(connect);
            return;
        }
        try {
            for (ServiceInstance instance : instList) {
                logger.info((Object)String.format("start convert cloud data,name[%s], des[%s], pgId[%s], rpId[%s], projectid[%s],status[%s], type[%s].", instance.getName(), instance.getDescription(), instance.getProtectGroupId(), instance.getRecoveryPlanId(), instance.getProjectId(), instance.getStatus(), instance.getType()), "");
                String sql = "insert into ti_serviceinstance (UUID, NAME, DESCRIPTION, PROTECTGROUPID, RECOVERYPLANID, PROJECTID, STATUS, TYPE, STARTPRIORITY, EXTENDINFO, CREATETIME)values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                preparedStatement = connect.prepareStatement(sql);
                preparedStatement.setString(1, instance.getUuid());
                preparedStatement.setString(2, instance.getName());
                preparedStatement.setString(3, instance.getDescription());
                preparedStatement.setString(4, instance.getProtectGroupId());
                preparedStatement.setString(5, instance.getRecoveryPlanId());
                preparedStatement.setString(6, instance.getProjectId());
                preparedStatement.setString(7, instance.getStatus());
                preparedStatement.setString(8, instance.getType());
                preparedStatement.setInt(9, instance.getStartPriority());
                preparedStatement.setString(10, null);
                preparedStatement.setLong(11, instance.getCreateTime());
                preparedStatement.executeUpdate();
                preparedStatement.close();
                sql = "insert into ti_protectgroup_prop (PGID, PROPVALUE, PROPNAME) values (?, ?, ?)";
                preparedStatement = connect.prepareStatement(sql);
                preparedStatement.setString(1, instance.getProtectGroupId());
                preparedStatement.setString(2, "replication");
                preparedStatement.setString(3, "serviceInstanceType");
                preparedStatement.executeUpdate();
                preparedStatement = connect.prepareStatement(sql);
                preparedStatement.setString(1, instance.getProtectGroupId());
                preparedStatement.setString(2, instance.getUuid());
                preparedStatement.setString(3, "SERVICEINSTANCE_UUID");
                preparedStatement.executeUpdate();
            }
            CloudUpdateUtil.updateRegionAndProject(connect);
            CloudUpdateUtil.updateAzMapping(connect);
            CloudUpdateUtil.updateHoldVmInfo(connect);
            CloudUpdateUtil.updateVolTypeMapping(connect);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("convertCloudData failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("convertCloudData failed");
            }
            catch (Throwable throwable) {
                UpdateUtil.closeStatement(preparedStatement);
                UpdateUtil.closeConnection(connect);
                throw throwable;
            }
        }
        UpdateUtil.closeStatement(preparedStatement);
        UpdateUtil.closeConnection(connect);
    }

    public static String getInstallPath() {
        return installedPath;
    }

    private static void releaseStream(XMLWriter stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                logger.error((Object)"Release XMLWriter is Error:", e.getMessage());
            }
        }
    }

    public static void closeConnection(Connection connect) {
        try {
            if (null != connect) {
                connect.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("close connection failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private static void closeStream(Closeable be) {
        if (null != be) {
            try {
                be.close();
            }
            catch (IOException e) {
                logger.error((Object)"close stream failed.", (Throwable)e, "0x000252000FB50012");
            }
        }
    }
}

