/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.AESEncryptor;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class WccEncryptor {
    private static WccEncryptor cryp = null;
    private static Log logger = LogFactory.getInstance(WccEncryptor.class);

    private WccEncryptor() {
        WccEncryptor.setWccFile();
    }

    public static WccEncryptor getInstance() {
        if (null == cryp) {
            cryp = new WccEncryptor();
        }
        return cryp;
    }

    private static void setWccFile() {
        String currPath = InstallConstant.getCurrentPath();
        String conf = File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "wcc";
        String wccConf = currPath + File.separator + "Runtime" + conf;
        if (currPath.endsWith(File.separator + "bin")) {
            wccConf = currPath.substring(0, currPath.length() - "bin".length()) + conf;
        }
        try {
            KmcInstance.initComponent((String)wccConf, (boolean)false);
        }
        catch (Exception e) {
            logger.error((Object)("Init kmc catch exception:" + e.getMessage()), "");
            e.printStackTrace();
        }
    }

    public static void updateSoftCrypt() {
        WccEncryptor.getInstance();
        try {
            logger.info((Object)"Begin to update key", "");
            KmcInstance.getSoftInstance().activeNewKey(KmcInstance.kmcDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String wccEncrypt(String data) {
        try {
            return KmcInstance.encrypt((String)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String wccDecrypt(String data) {
        try {
            return KmcInstance.decrypt((String)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof AppException) {
                throw new LegoCheckedException("decrypt error", (Throwable)e);
            }
            return null;
        }
    }

    public void exportCipherKey(String file, String encryptPwd) {
        try {
            KmcInstance.getSoftInstance().exportMkFile(file, encryptPwd.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error((Object)("Export kmc key catch exception:" + e.getMessage()), "");
            e.printStackTrace();
        }
    }

    public void exportAllCipherKey(String file, String encryptPwd) {
        try {
            KmcInstance.getSoftInstance().exportMkFile(file, encryptPwd.getBytes(StandardCharsets.UTF_8));
            String hwFile = file.replace("wcc.conf", "wcc-hw.conf");
            KmcInstance.getHwInstance().exportMkFile(hwFile, encryptPwd.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error((Object)("Export kmc key catch exception:" + e.getMessage()), "");
            e.printStackTrace();
        }
    }

    public void importCipherKey(String file, String decryptPwd) {
        try {
            KmcInstance.getSoftInstance().importMkFile(file, decryptPwd.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error((Object)("Import kmc key catch exception:" + e.getMessage()), "");
            e.printStackTrace();
        }
    }

    public static void signFile(String file) {
        try {
            String hash = KmcInstance.hmac((String)new String(Files.readAllBytes(Paths.get(file, new String[0])), StandardCharsets.UTF_8));
            String sign = file + ".sign";
            FileUtil.writeFile(sign, hash);
        }
        catch (Exception e) {
            logger.error((Object)("signFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("signFile failed.");
        }
    }

    public static String retryDecode(String data) {
        String pwd = AESEncryptor.decode(data);
        if ("".equals(pwd)) {
            logger.info((Object)"use wcc decrypt data.", "");
            try {
                pwd = WccEncryptor.getInstance().wccDecrypt(data);
            }
            catch (Exception e) {
                logger.info((Object)("retry decode failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                pwd = "";
            }
        }
        return pwd;
    }

    public static String decode(String data) {
        return WccEncryptor.getInstance().wccDecrypt(data);
    }

    public static String encode(String data) {
        return WccEncryptor.getInstance().wccEncrypt(data);
    }

    public static void updateCrypt() {
        WccEncryptor.getInstance();
        try {
            logger.info((Object)"Begin to update key", "");
            KmcInstance.getInstance().activeNewKey(KmcInstance.kmcDomain);
        }
        catch (Exception e) {
            logger.error((Object)("Update kmc key failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            e.printStackTrace();
        }
    }

    public void generateWorkKey(String userKey) {
        try {
            KmcInstance.registerKey((String)userKey);
        }
        catch (Exception e) {
            logger.error((Object)("Import key failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("Import key failed.");
        }
    }
}

