/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.DataBaseTestUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GaussDBUtil {
    private static final int CONNECTION_SECONDS = 3;
    private static final int CONNECTION_TIMES = 10;
    private static Log logger = LogFactory.getInstance(GaussDBUtil.class);
    private static final String DBPLUGINPATH = "Plug-In" + File.separator + "DataBase" + File.separator + "Script" + File.separator;
    private static final String DBAFTERINSTALLSCRIPTPATH = ".." + File.separator + "gs" + File.separator + "bin" + File.separator;
    private static final String GSSERVICE4WIN = LegoResourceManager.getProValue("lego.install.gaussdb.windows.scriptname");
    private static final String GSSERVICE4LINUX = LegoResourceManager.getProValue("lego.install.gaussdb.linux.scriptname");
    private static final String EXECUTECMD_SUCCESS = "0";

    public static void installGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("install");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                logger.error((Object)"Install GaussDB Error", "0x000252000FB50041");
                throw new IOException();
            }
            logger.info((Object)"Install GaussDB success", "0x000252000FB50040");
        }
        catch (IOException e) {
            logger.error((Object)e, "install gauss DB Error!0x000252000FB50041");
            throw e;
        }
        catch (InterruptedException e) {
            logger.error((Object)e, "install gauss DB Error!0x000252000FB50041");
            throw e;
        }
    }

    public static void upgradeGaussDB() {
        try {
            logger.info((Object)"start upgrade gaussdb.", "");
            String result = GaussDBUtil.exec("upgrade");
            if (EXECUTECMD_SUCCESS.equals(result)) {
                logger.info((Object)"upgrade GaussDB success", "0x000252000FB50040");
                return;
            }
            throw new PatchException("upgradeGaussDB failed, result: " + result);
        }
        catch (Exception e) {
            logger.error((Object)("upgradeGaussDB failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("upgradeGaussDB failed.");
        }
    }

    public static void startGaussDB() throws IOException, InterruptedException {
        GaussDBUtil.startGaussDB(false);
    }

    public static void startGaussDB(boolean needTest) throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("start");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                logger.error((Object)("Start GaussDB Error, result=" + result), "0x000252000FB50043");
                throw new IOException();
            }
            logger.info((Object)"Start GaussDB success", "0x000252000FB50042");
        }
        catch (IOException e) {
            logger.error((Object)e, "Start GaussDB Error0x000252000FB50043");
            throw e;
        }
        catch (InterruptedException e) {
            logger.error((Object)e, "Start GaussDB Error0x000252000FB50043");
            throw e;
        }
        if (!needTest) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            TimeUnit.SECONDS.sleep(3L);
            if (!DataBaseTestUtil.connectionGauss()) continue;
            logger.info((Object)("try connect database success. times: " + i), "");
            return;
        }
        throw new IOException("try connect database failed. times: 10");
    }

    public static void stopGaussDatabase() throws IOException, InterruptedException {
        boolean green = Boolean.parseBoolean(LegoResourceManager.getProValue("isGreenGauss"));
        if (InitBundleXmlTool.getDBType().equalsIgnoreCase("Gauss") && green && DataBaseTestUtil.connectionGauss()) {
            GaussDBUtil.stopGaussDB();
        }
    }

    public static boolean takeOffArchiveMode() {
        DataBaseInfo dbInfor = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        return GaussDBUtil.takeOffArchiveMode(dbInfor.getDbFilePath() + File.separator + "postgresql.conf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean takeOffArchiveMode(String conf) {
        RandomAccessFile f;
        boolean done;
        block11: {
            done = false;
            File file = new File(conf);
            if (!file.exists() || !file.isFile()) {
                return done;
            }
            f = null;
            try {
                f = new RandomAccessFile(file, "rw");
                String line = null;
                long s = 0L;
                long c = 0L;
                boolean none = true;
                boolean deal = false;
                while ((line = f.readLine()) != null) {
                    ++c;
                    if (line.matches("archive_mode\\s*=.*")) {
                        if ((line = line.toLowerCase()).matches("archive_mode\\s*=\\s*on\\s*(#.*)?")) {
                            f.seek(s);
                            f.writeByte(35);
                            deal = true;
                        } else if (line.matches("archive_mode\\s*=\\s*off\\s*(#.*)?")) {
                            done = true;
                        } else {
                            logger.error((Object)("Error at line " + c), "take off archive mode failed");
                        }
                        none = false;
                        break;
                    }
                    s = f.getFilePointer();
                }
                if (!none && !deal) break block11;
                f.seek(f.length());
                byte[] separator = System.getProperty("line.separator").getBytes();
                f.write(separator);
                f.write("archive_mode = off".getBytes());
                f.write(separator);
                done = true;
            }
            catch (IOException e) {
                try {
                    logger.error((Object)e, "take off archive mode failed");
                }
                catch (Throwable throwable) {
                    FileUtil.close(f, "close RandomAccessFile");
                    throw throwable;
                }
                FileUtil.close(f, "close RandomAccessFile");
            }
        }
        FileUtil.close(f, "close RandomAccessFile");
        return done;
    }

    public static void stopGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("stop");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                logger.error((Object)"Stop GaussDB Error", "0x000252000FB50045");
                throw new IOException();
            }
            logger.info((Object)"Stop GaussDB success", "0x000252000FB50044");
        }
        catch (IOException e) {
            logger.error((Object)e, "Stop GaussDB Error0x000252000FB50045");
            throw e;
        }
        catch (InterruptedException e) {
            logger.error((Object)e, "Stop GaussDB Error0x000252000FB50045");
            throw e;
        }
    }

    public static void reinforceGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("reinforce");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                logger.error((Object)"Reinforce GaussDB Error", "0x000252000FB50049");
                throw new IOException();
            }
            logger.info((Object)"Reinforce GaussDB success", "0x000252000FB50048");
        }
        catch (IOException e) {
            logger.error((Object)e, "Reinforce GaussDB Error0x000252000FB50049");
            throw e;
        }
        catch (InterruptedException e) {
            logger.error((Object)"Reinforce GaussDB Error", "0x000252000FB50049");
            throw e;
        }
    }

    public static void unInstallGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("uninstall");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                logger.error((Object)"Uninstall GaussDB Error", "0x000252000FB50047");
                throw new IOException();
            }
            logger.info((Object)"Uninstall GaussDB success", "0x000252000FB50046");
        }
        catch (IOException e) {
            logger.error((Object)e, "unInstall Gauss DB IO error");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exec(String action) throws IOException, InterruptedException {
        String string;
        File scripFile;
        String batPath = InstallConstant.getsBasePath() + DBPLUGINPATH;
        File file = new File(batPath);
        if (!file.exists()) {
            batPath = InstallConstant.getsBasePath() + DBAFTERINSTALLSCRIPTPATH;
        }
        List<String> params = GaussDBUtil.getGaussDBFileParamas(action);
        String[] commands = null;
        ArrayList<String> cmdList = new ArrayList<String>();
        String execScript = batPath + GSSERVICE4LINUX;
        if (null != System.getProperty("os.name") && System.getProperty("os.name").contains("Windows")) {
            execScript = batPath + GSSERVICE4WIN;
        }
        if (!(scripFile = new File(execScript)).exists()) {
            logger.info((Object)"can not find the gsService script.", "");
            throw new FileNotFoundException();
        }
        cmdList.add(execScript);
        cmdList.addAll(params);
        commands = cmdList.toArray(new String[cmdList.size()]);
        InputStream in = null;
        BufferedReader reader = null;
        Process ps = null;
        try {
            ps = Runtime.getRuntime().exec(commands);
            in = ps.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            String result = "";
            while ((line = FileUtil.getLineFromFile(reader)) != null) {
                result = line;
            }
            Integer waitFor = ps.waitFor();
            logger.info((Object)waitFor, "");
            string = result;
        }
        catch (Throwable throwable) {
            GaussDBUtil.closeStream(in, reader, ps);
            throw throwable;
        }
        GaussDBUtil.closeStream(in, reader, ps);
        return string;
    }

    private static void closeStream(InputStream in, BufferedReader reader, Process ps) {
        FileUtil.close(reader, "BufferedReader close");
        FileUtil.close(in, "InputStream close");
        if (ps != null) {
            ps.destroy();
        }
    }

    private static List<String> getGaussDBFileParamas(String type) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(type);
        if ("start".equals(type) || "stop".equals(type)) {
            return params;
        }
        DataBaseInfo sDbInfor = null == PrepareParamUtil.getsInstallDto() ? InitInstalledXmlTool.getInstalledSystem().getDbInfor() : PrepareParamUtil.getsInstallDto().getDbDto();
        if (type.equals("install")) {
            GaussDBUtil.checkPathChar(sDbInfor.getDbPath());
            GaussDBUtil.checkPathChar(sDbInfor.getDbFilePath());
            params.add(sDbInfor.getDbPath());
            params.add(sDbInfor.getDbFilePath());
            params.add(sDbInfor.getDbPort());
            params.add(sDbInfor.getDbaUsername());
            params.add("\"" + sDbInfor.getDbaPassword() + "\"");
            params.add(sDbInfor.getManagerUsername());
            params.add("\"" + WccEncryptor.retryDecode(sDbInfor.getDefaultManagerPassword()) + "\"");
            params.add("\"" + sDbInfor.getManagerPassword() + "\"");
        } else if (type.equals("upgrade")) {
            params.add(sDbInfor.getManagerUsername());
            params.add(sDbInfor.getManagerPassword());
            params.add(sDbInfor.getDbPort());
            params.add(sDbInfor.getDbFilePath());
            params.add(sDbInfor.getDbPath());
        } else if (type.equals("reinforce")) {
            params.add(sDbInfor.getDbPath());
            params.add(sDbInfor.getDbPort());
            params.add(sDbInfor.getManagerUsername());
            params.add("\"" + WccEncryptor.retryDecode(sDbInfor.getDefaultManagerPassword()) + "\"");
            params.add(sDbInfor.getDbaUsername());
            params.add("\"" + sDbInfor.getDbaPassword() + "\"");
            params.add(sDbInfor.getDbFilePath());
            params.add("\"" + sDbInfor.getManagerPassword() + "\"");
        } else if (type.equals("uninstall")) {
            params.add(sDbInfor.getDbPath());
            params.add(sDbInfor.getDbFilePath());
        } else {
            logger.warn((Object)("the type is not supported. type:" + type), "");
        }
        return params;
    }

    private static void checkPathChar(String path) {
        if (null == path || path.trim().length() < 1) {
            logger.error((Object)LegoResourceManager.getString("LEGO.GAUSSDBPATH.SET.ERROR.CHAR"), "0x000252000FB50041");
            SystemExitUtil.exitFail();
        }
        String[] folderNames = null;
        if (null != System.getProperty("os.name") && System.getProperty("os.name").contains("Windows")) {
            String unRootPath = path.substring(path.indexOf(":\\") + 2);
            unRootPath = unRootPath.replace("\\", "/");
            folderNames = unRootPath.split("/");
        } else {
            folderNames = path.split("/");
        }
        for (String folder : folderNames) {
            Pattern pattern;
            Matcher matcher;
            boolean flag;
            if (folder.length() == 0 || (flag = (matcher = (pattern = Pattern.compile("^[\\w-.]+$")).matcher(Normalizer.normalize(folder, Normalizer.Form.NFKC))).matches())) continue;
            logger.error((Object)LegoResourceManager.getString("LEGO.GAUSSDBPATH.SET.ERROR.CHAR"), "0x000252000FB50041");
            SystemExitUtil.exitFail();
        }
    }
}

