/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.quota;

import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.quota.QuotaCommon;
import com.huawei.quota.QuotaObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CshaQuota {
    private static final Float INST_NUM = Float.valueOf(1.0f);
    private static Log logger = LogFactory.getInstance(CshaQuota.class);

    public static void main(String[] args) {
        try {
            logger.info((Object)"start query quota data.", "");
            List<QuotaObject> quotaList = CshaQuota.queryQuotaData();
            if (args.length == 1 && "2.0.6".equals(args[0])) {
                CshaQuota.writeCsvFileFor206(quotaList);
            } else {
                Map<String, List<QuotaObject>> data = QuotaCommon.analyzeQuota(quotaList);
                for (Map.Entry<String, List<QuotaObject>> tmpData : data.entrySet()) {
                    CshaQuota.writeCsvFile(tmpData.getKey(), tmpData.getValue());
                }
            }
            logger.info((Object)"query quota data successfully", "");
            SystemExitUtil.exitOK();
        }
        catch (Exception e) {
            logger.error((Object)("get csha quota info failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        SystemExitUtil.exitFail();
    }

    private static void writeCsvFileFor206(List<QuotaObject> quotaList) {
        ArrayList<String> column = new ArrayList<String>();
        column.add("projectId");
        column.add("regionId");
        column.add("resource");
        column.add("used");
        ArrayList<List<String>> dataList = new ArrayList<List<String>>();
        dataList.add(column);
        for (QuotaObject obj : quotaList) {
            ArrayList<String> num = new ArrayList<String>();
            num.add(obj.getProjectId());
            num.add(obj.getRegionId());
            num.add("csha.vol.num");
            num.add(String.valueOf(obj.getVolumeNum()));
            ArrayList<String> size = new ArrayList<String>();
            size.add(obj.getProjectId());
            size.add(obj.getRegionId());
            size.add("csha.vol.size");
            size.add(String.valueOf(obj.getVolumeSize()));
            ArrayList<String> inst = new ArrayList<String>();
            inst.add(obj.getProjectId());
            inst.add(obj.getRegionId());
            inst.add("csha.instance.num");
            inst.add(String.valueOf(obj.getInstNum()));
            dataList.add(num);
            dataList.add(size);
            dataList.add(inst);
        }
        QuotaCommon.writerCsv("csha_quota.csv", dataList);
    }

    private static void writeCsvFile(String regionId, List<QuotaObject> quotaList) {
        logger.info((Object)("start write csv file for " + regionId), "");
        ArrayList<String> column = new ArrayList<String>();
        column.add("project_id");
        column.add("az_id");
        column.add("user_id");
        column.add("service_id");
        column.add("resource");
        column.add("used");
        column.add("target_id");
        ArrayList<List<String>> dataList = new ArrayList<List<String>>();
        dataList.add(column);
        for (QuotaObject obj : quotaList) {
            ArrayList<String> num = new ArrayList<String>();
            num.add(obj.getProjectId());
            num.add("");
            num.add("");
            num.add("csha");
            num.add("csha.vol.num");
            num.add(String.valueOf(obj.getVolumeNum()));
            num.add("");
            ArrayList<String> size = new ArrayList<String>();
            size.add(obj.getProjectId());
            size.add("");
            size.add("");
            size.add("csha");
            size.add("csha.vol.size");
            size.add(String.valueOf(obj.getVolumeSize()));
            size.add("");
            ArrayList<String> inst = new ArrayList<String>();
            inst.add(obj.getProjectId());
            inst.add("");
            inst.add("");
            inst.add("csha");
            inst.add("csha.instance.num");
            inst.add(String.valueOf(obj.getInstNum()));
            inst.add("");
            dataList.add(num);
            dataList.add(size);
            dataList.add(inst);
        }
        String fileName = "quotas_" + regionId.replace('.', '_') + "_csha.csv";
        QuotaCommon.writerCsv(fileName, dataList);
    }

    private static List<QuotaObject> queryQuotaData() {
        ArrayList<QuotaObject> arrayList;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ArrayList<QuotaObject> quotaList = new ArrayList<QuotaObject>();
        try {
            connection = QuotaCommon.getConnection();
            String querySql = "select pg.PGID, dpp.PROPVALUE, rpp.PROPVALUE from ti_protectgroup as pg, ti_drp_r_pg as pgrp, ti_policytemplate as pt, ti_protectgroup_prop as dpp, ti_protectgroup_prop as rpp where pg.PTID = pt.PTID and pgrp.PGID = pg.PGID and pt.TYPE='25' and pg.PGID = dpp.PGID and dpp.PROPNAME = 'projectId' and pg.PGID = rpp.PGID and rpp.PROPNAME = 'regionId'";
            preparedStatement = connection.prepareStatement(querySql);
            ResultSet rs = preparedStatement.executeQuery();
            while (null != rs && rs.next()) {
                QuotaObject qobj = new QuotaObject();
                qobj.setPgId(rs.getString(1));
                qobj.setProjectId(QuotaCommon.getSplitString(rs.getString(2)));
                qobj.setRegionId(QuotaCommon.getSplitString(rs.getString(3)));
                qobj.setInstNum(INST_NUM);
                QuotaCommon.calculateVolumeSizeAndNum(qobj, connection);
                boolean is_repeat = false;
                for (QuotaObject quotaObj : quotaList) {
                    if (!quotaObj.getProjectId().equals(qobj.getProjectId())) continue;
                    is_repeat = true;
                    quotaObj.setVolumeNum(Float.valueOf(quotaObj.getVolumeNum().floatValue() + qobj.getVolumeNum().floatValue()));
                    quotaObj.setVolumeSize(Float.valueOf(quotaObj.getVolumeSize().floatValue() + qobj.getVolumeSize().floatValue()));
                    quotaObj.setInstNum(Float.valueOf(quotaObj.getInstNum().floatValue() + INST_NUM.floatValue()));
                }
                if (is_repeat) continue;
                logger.info((Object)("add target: " + qobj.toString()), "");
                quotaList.add(qobj);
            }
            arrayList = quotaList;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query quota data failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new LegoCheckedException("query quota data failed");
            }
            catch (Throwable throwable) {
                QuotaCommon.closeStatement(preparedStatement);
                QuotaCommon.closeConnection(connection);
                throw throwable;
            }
        }
        QuotaCommon.closeStatement(preparedStatement);
        QuotaCommon.closeConnection(connection);
        return arrayList;
    }
}

