/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.quota;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.CsvFileUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.quota.QuotaObject;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class QuotaCommon
extends CsvFileUtil {
    private static final String INSTALL_PATH = "installpath";
    private static final String DB_HOST = "dbhost";
    private static final String DB_PORT = "dbport";
    private static final String DB_USER = "user";
    private static final String DB_PWD = "pwd";
    private static final String LINE_SEPARATOR = "\n";
    private static Map<String, String> dbMap = null;
    private static Log logger = LogFactory.getInstance(QuotaCommon.class);

    public static Connection getConnection() {
        try {
            Map<String, String> dbInfo = QuotaCommon.getInstallInfo();
            String url = "jdbc:postgresql://" + dbInfo.get(DB_HOST) + ":" + dbInfo.get(DB_PORT) + "/LEGO";
            Class.forName("org.postgresql.Driver");
            Connection connection = DriverManager.getConnection(url, dbInfo.get(DB_USER), QuotaCommon.decrypt(dbInfo.get(DB_PWD)));
            return connection;
        }
        catch (Exception e) {
            logger.error((Object)("get connection failed, errmsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("Failed to getConnection.");
        }
    }

    public static String getInstallPath() {
        return QuotaCommon.getInstallInfo().get(INSTALL_PATH);
    }

    public static void calculateVolumeSizeAndNum(QuotaObject qobj, Connection connection) {
        PreparedStatement preparedStatement = null;
        String querySql = "select pop.PROPVALUE from ti_protectobject as po, ti_po_prop as pop  where po.POID = pop.POID and pop.PROPNAME='replicationInfo' and po.PGID=?";
        try {
            preparedStatement = connection.prepareStatement(querySql);
            preparedStatement.setString(1, qobj.getPgId());
            ResultSet poRes = preparedStatement.executeQuery();
            Float volumeNum = Float.valueOf(0.0f);
            Float volumeSize = Float.valueOf(0.0f);
            ArrayList<String> volumeIdList = new ArrayList<String>();
            while (null != poRes && poRes.next()) {
                JSONObject repObj = JSONObject.fromObject((Object)poRes.getString(1));
                JSONArray records = repObj.getJSONArray("pairInfos");
                for (int iTmp = 0; iTmp < records.size(); ++iTmp) {
                    String volumeId = QuotaCommon.getSplitString(records.getJSONObject(iTmp).getString("volumeId"));
                    String volumeStatus = records.getJSONObject(iTmp).getString("volumeStatus");
                    String tmpSize = records.getJSONObject(iTmp).getString("size");
                    float size = 0.0f;
                    if (!VerifyUtil.isEmpty((String)tmpSize)) {
                        size = Float.parseFloat(tmpSize);
                    }
                    if (!"PROTECTED".equals(volumeStatus) && !"REMOVED".equals(volumeStatus) || volumeIdList.contains(volumeId)) continue;
                    volumeIdList.add(volumeId);
                    Float f = volumeNum;
                    Float f2 = volumeNum = Float.valueOf(volumeNum.floatValue() + 1.0f);
                    volumeSize = Float.valueOf(volumeSize.floatValue() + size);
                }
            }
            qobj.setVolumeNum(volumeNum);
            qobj.setVolumeSize(volumeSize);
        }
        catch (Exception e) {
            logger.error((Object)("calculateVolumeSizeAndNum failed, errMsg=" + e), "");
            throw new LegoCheckedException("calculateVolumeSizeAndNum failed");
        }
        finally {
            QuotaCommon.closeStatement(preparedStatement);
        }
    }

    public static void writerCsv(String destFile, List<List<String>> dataList) {
        CSVPrinter csvPrinter = null;
        CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[]{LINE_SEPARATOR}).withSkipHeaderRecord();
        try {
            FileWriter fileWriter = new FileWriter(destFile);
            csvPrinter = new CSVPrinter((Appendable)fileWriter, format);
            for (List<String> data : dataList) {
                csvPrinter.printRecord(data);
            }
            csvPrinter.flush();
        }
        catch (Exception e) {
            logger.error((Object)("writer csv file failed. errMsg=%s" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new LegoCheckedException("write csv file failed.");
        }
        finally {
            try {
                if (!VerifyUtil.isEmpty(csvPrinter)) {
                    csvPrinter.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("closer writer failed, errMsg=%s" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static Map<String, List<QuotaObject>> analyzeQuota(List<QuotaObject> quotaList) {
        HashMap<String, List<QuotaObject>> data = new HashMap<String, List<QuotaObject>>();
        for (QuotaObject obj : quotaList) {
            if (!data.containsKey(obj.getRegionId())) {
                ArrayList<QuotaObject> objList = new ArrayList<QuotaObject>();
                objList.add(obj);
                data.put(obj.getRegionId(), objList);
                continue;
            }
            ((List)data.get(obj.getRegionId())).add(obj);
        }
        return data;
    }

    private static Map<String, String> getInstallInfo() {
        if (null != dbMap) {
            return dbMap;
        }
        dbMap = new HashMap<String, String>();
        try {
            List pathList;
            String installFile = OSInformation.getInstalledFile();
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(installFile);
            List list = document.selectNodes("/install/database");
            if (null != list && !list.isEmpty()) {
                Element ele = (Element)list.get(0);
                dbMap.put(DB_HOST, ele.attributeValue(DB_HOST));
                dbMap.put(DB_PORT, ele.attributeValue(DB_PORT));
                dbMap.put(DB_USER, ele.attributeValue("dbuserName"));
                dbMap.put(DB_PWD, ele.attributeValue("dbpassword"));
            }
            if (null != (pathList = document.selectNodes("/install/installpath")) && !pathList.isEmpty()) {
                Element ele = (Element)pathList.get(0);
                dbMap.put(INSTALL_PATH, ele.attributeValue("path"));
            }
            return dbMap;
        }
        catch (Exception e) {
            logger.error((Object)("get installInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new LegoCheckedException("get installInfo failed");
        }
    }

    private static String decrypt(String data) {
        String sp = File.separator;
        String installPath = QuotaCommon.getInstallInfo().get(INSTALL_PATH);
        String appHome = installPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "conf" + sp + "wcc";
        try {
            KmcInstance.initComponent((String)appHome);
            return KmcInstance.decrypt((String)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void closeStatement(PreparedStatement preparedStatement) {
        try {
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("close statement failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    public static void closeConnection(Connection conn) {
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("close Connection failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    public static String getSplitString(String data) {
        if (VerifyUtil.isEmpty((String)data) || !data.contains(":")) {
            throw new LegoCheckedException("getSplitString failed, data=" + data);
        }
        return data.split(":")[1];
    }
}

