/*
 * Decompiled with CFR 0.152.
 */
package plugin.common;

import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class BuildProductBundlesFile {
    private static final Log logger = LogFactory.getInstance(BuildProductBundlesFile.class);

    public static void main(String[] args) {
        String outPutPath = "./productFile";
        ArrayList<String> list = new ArrayList<String>();
        try (FileWriter writer = new FileWriter(outPutPath);){
            Map<String, ProductBundles> productBundles = InitBundleXmlTool.initProductBundls();
            for (Map.Entry<String, ProductBundles> item : productBundles.entrySet()) {
                list.add(item.getKey());
            }
            Map<String, PlatformBundles> ptList = InitBundleXmlTool.initPlatFormBundls();
            PlatformBundles ptBundle = ptList.values().stream().filter(e -> e.getId().equals(LegoResourceManager.getProValue("lego.core.base.bundle.id"))).findFirst().orElseGet(null);
            int iCount = 1;
            if (null != ptBundle) {
                BuildProductBundlesFile.writeBundle(writer, ptBundle, iCount);
                ++iCount;
            }
            Collections.sort(list);
            for (String id : list) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, ProductBundles> item : productBundles.entrySet()) {
                    ProductBundles value = item.getValue();
                    if (!value.getId().trim().equals(id.trim()) || value.getId().trim().equals("ism.v2r5.base.bundle")) continue;
                    builder.append(iCount++).append(". ").append("\t").append(item.getKey()).append("\t").append(LegoResourceManager.getString(value.getName())).append("\t").append(LegoResourceManager.getString(value.getDescription())).append("\t").append(value.getVersion()).append("\t").append(value.getExtendCallBackClz()).append("\t").append(value.getSize()).append("MB");
                    writer.write(builder.toString());
                    writer.write("\r\n");
                }
            }
            writer.flush();
        }
        catch (IOException | SignatureException e2) {
            logger.error((Object)"Exception: ", (Throwable)e2, "");
        }
        System.exit(0);
    }

    private static void writeBundle(FileWriter writer, PlatformBundles ptBundle, int iCount) throws IOException {
        String builder = iCount + ". \t" + ptBundle.getId() + "\t" + LegoResourceManager.getString(ptBundle.getName()) + "\t" + LegoResourceManager.getString(ptBundle.getName()) + "\t" + ptBundle.getVersion() + "\tnull\t" + ptBundle.getSize() + "MB";
        writer.write(builder);
        writer.write("\r\n");
    }
}

