/*
 * Decompiled with CFR 0.152.
 */
package plugin.common;

import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class GetOriginalBundlesFile {
    private static Log logger = LogFactory.getInstance(GetOriginalBundlesFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (null == args || args.length < 1) {
            logger.error((Object)"Get InstallInfo error, can not get file param");
            return;
        }
        File file = new File(args[0]);
        if (file.exists()) {
            String outPutPath = "./originalProductFile";
            Map<String, PlatformBundles> platBundles = InitInstalledXmlTool.getInstalledSystem().getPtMap();
            Map<String, ProductBundles> installedProduct = InitInstalledXmlTool.getInstalledProductBundlsToCli(args[0]);
            FileWriter writer = null;
            try {
                writer = new FileWriter(outPutPath);
                int i = 1;
                for (Map.Entry<String, PlatformBundles> entry : platBundles.entrySet()) {
                    PlatformBundles value = entry.getValue();
                    StringBuilder builder = new StringBuilder();
                    builder.append(i++).append(". ").append("\t").append(value.getId()).append("\t").append(LegoResourceManager.getString(value.getName())).append("\t").append(LegoResourceManager.getString(value.getDescription())).append("\t").append(value.getVersion()).append("\t").append("null").append("\t").append(value.getSize()).append("MB");
                    writer.write(builder.toString());
                    writer.write("\r\n");
                }
                for (Map.Entry<String, ProductBundles> entry : installedProduct.entrySet()) {
                    ProductBundles value = entry.getValue();
                    if (value.getId().trim().equals("ism.v2r5.base.bundle")) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append(i++).append(". ").append("\t").append(entry.getKey()).append("\t").append(LegoResourceManager.getString(value.getName())).append("\t").append(LegoResourceManager.getString(value.getDescription())).append("\t").append(value.getVersion()).append("\t").append(value.getExtendCallBackClz()).append("\t").append(value.getSize()).append("MB");
                    writer.write(builder.toString());
                    writer.write("\r\n");
                }
                writer.flush();
            }
            catch (Exception e) {
                logger.error((Object)("Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"IOException: ", (Throwable)e);
                    }
                }
            }
        }
    }
}

