/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.base.port.sdk.model;

import com.huawei.ism.base.port.sdk.model.Port;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.unit.MathUtil;

public class EthernetPort
extends Port {
    private static final long serialVersionUID = -3217722255820196043L;
    private String mac;
    private String ipAddress;
    private String ipv4Mask;
    private String ipv4Gateway;
    private String netmask;
    private String portStatus;
    private String portSpeed;
    private String ipv6Address;
    private String ipv6Mask;
    private String ipv6Gateway;
    private String ipv6Profix;
    private String virtualIps;

    private boolean checkMac(EthernetPort other) {
        return !(this.mac == null ? other.mac != null : !this.mac.equals(other.mac));
    }

    private boolean checkPortStatus(EthernetPort other) {
        return !(this.portStatus == null ? other.portStatus != null : !this.portStatus.equals(other.portStatus));
    }

    private boolean checkProp(EthernetPort other) {
        if (!this.checkMac(other)) {
            return false;
        }
        return this.checkPortStatus(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EthernetPort other = (EthernetPort)obj;
        return this.checkProp(other);
    }

    public String getMac() {
        return this.mac;
    }

    public String getNetmask() {
        return this.netmask;
    }

    @Override
    public String getPortDesc() {
        return "" + this.getName();
    }

    public String getPortSpeed() {
        return this.portSpeed;
    }

    public String getPortStatus() {
        return this.portStatus;
    }

    public String getVirtualIps() {
        return this.virtualIps;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        result = 31 * result + (this.portStatus == null ? 0 : this.portStatus.hashCode());
        return result;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    public void setPortSpeed(String portSpeed) {
        this.portSpeed = portSpeed;
    }

    public void setPortStatus(String portStatus) {
        this.portStatus = portStatus;
    }

    public void setVirtualIps(String virtualIps) {
        this.virtualIps = virtualIps;
    }

    public String getPortSpeedDisplay() {
        Long lPortSpeed = NumberUtil.parseLong(this.portSpeed);
        if (lPortSpeed > 0L) {
            return MathUtil.parseNumber((Object)lPortSpeed, Boolean.TRUE, 0);
        }
        return this.portSpeed;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpv4Mask() {
        return this.ipv4Mask;
    }

    public void setIpv4Mask(String ipv4Mask) {
        this.ipv4Mask = ipv4Mask;
    }

    public String getIpv6Address() {
        return this.ipv6Address;
    }

    public void setIpv6Address(String ipv6Address) {
        this.ipv6Address = ipv6Address;
    }

    public String getIpv6Mask() {
        return this.ipv6Mask;
    }

    public void setIpv6Mask(String ipv6Mask) {
        this.ipv6Mask = ipv6Mask;
    }

    public String getIpv6Gateway() {
        return this.ipv6Gateway;
    }

    public void setIpv6Gateway(String ipv6Gateway) {
        this.ipv6Gateway = ipv6Gateway;
    }

    public String getIpv6Profix() {
        return this.ipv6Profix;
    }

    public void setIpv6Profix(String ipv6Profix) {
        this.ipv6Profix = ipv6Profix;
    }

    public String getIpv4Gateway() {
        return this.ipv4Gateway;
    }

    public void setIpv4Gateway(String ipv4Gateway) {
        this.ipv4Gateway = ipv4Gateway;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EthernetPort: Mac,").append(this.getMac()).append(" ip,").append(this.getIpAddress()).append(" netmask,").append(this.getNetmask()).append(" PortType,").append(this.getPortType()).append(" uuid,").append(this.getUuid()).append(" super,").append(super.toString());
        return sb.toString();
    }
}

