/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.base.port.sdk.model;

import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.util.unit.MathUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;

public class Port
extends ManagedObject
implements HSObject {
    private static final long serialVersionUID = 3365149293139587434L;
    private Long portId;
    private String portName;
    private Long speed;
    private Integer connectStatus;
    private Integer portType;
    private String neSN;
    private Integer healthStatus;
    private Integer runningStatus;
    private String networkAddress;

    public String getPortDesc() {
        String result = "--";
        if (this.portId != null) {
            result = this.portId + "";
        } else if (this.getName() != null) {
            result = this.getName();
        } else if (this.portName != null) {
            result = this.portName;
        }
        return result;
    }

    public Long getPortId() {
        return this.portId;
    }

    public Integer getPortType() {
        return this.portType;
    }

    public void setPortType(Integer portType) {
        this.portType = portType;
    }

    public void setPortId(Long portId) {
        this.portId = portId;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public Long getSpeed() {
        return this.speed;
    }

    public String getSpeedDisplay() {
        if (null == this.speed || this.speed < 0L) {
            return "--";
        }
        return MathUtil.parseNumber((Object)this.speed, Boolean.TRUE, 0);
    }

    public void setSpeed(Long speed) {
        this.speed = speed;
    }

    public Integer getConnectStatus() {
        return this.connectStatus;
    }

    public void setConnectStatus(Integer connectStatus) {
        this.connectStatus = connectStatus;
    }

    public String getNeSN() {
        return this.neSN;
    }

    public void setNeSN(String neSN) {
        this.neSN = neSN;
    }

    public Integer getHealthStatus() {
        return this.healthStatus;
    }

    public void setHealthStatus(Integer healthStatus) {
        this.healthStatus = healthStatus;
    }

    public Integer getRunningStatus() {
        return this.runningStatus;
    }

    public void setRunningStatus(Integer runningStatus) {
        this.runningStatus = runningStatus;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PortType : ").append(this.getPortType()).append(" name: ").append(this.getName()).append(" neSN: ").append(this.getNeSN());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectStatus == null ? 0 : this.connectStatus.hashCode());
        result = 31 * result + (this.healthStatus == null ? 0 : this.healthStatus.hashCode());
        result = 31 * result + (this.neSN == null ? 0 : this.neSN.hashCode());
        result = 31 * result + (this.portId == null ? 0 : this.portId.hashCode());
        result = 31 * result + (this.portName == null ? 0 : this.portName.hashCode());
        result = 31 * result + (this.portType == null ? 0 : this.portType.hashCode());
        result = 31 * result + (this.runningStatus == null ? 0 : this.runningStatus.hashCode());
        result = 31 * result + (this.speed == null ? 0 : this.speed.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Port other = (Port)obj;
        if (!this.checkProp(other)) {
            return false;
        }
        return this.checkProp3(other);
    }

    private boolean checkProp(Port other) {
        if (!this.checkStatus(other)) {
            return false;
        }
        return this.checkPortId(other);
    }

    private boolean checkProp3(Port other) {
        return !(this.runningStatus == null ? other.runningStatus != null : !this.runningStatus.equals(other.runningStatus));
    }

    private boolean checkPortId(Port other) {
        return !(this.portId == null ? other.portId != null : !this.portId.equals(other.portId));
    }

    private boolean checkStatus(Port other) {
        if (this.connectStatus == null ? other.connectStatus != null : !this.connectStatus.equals(other.connectStatus)) {
            return false;
        }
        return this.checkHealStatus(other);
    }

    private boolean checkHealStatus(Port other) {
        return !(this.healthStatus == null ? other.healthStatus != null : !this.healthStatus.equals(other.healthStatus));
    }
}

