/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.lang;

import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt16;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt32;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt64;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt8;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt16;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt32;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt64;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt8;
import com.huawei.ism.cbb.util.VerifyUtil;
import java.util.Optional;

public final class IsmIntegerFactory {
    private static volatile IsmIntegerFactory instacne;

    private IsmIntegerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IsmIntegerFactory getInstance() {
        if (instacne != null) return instacne;
        Class<IsmIntegerFactory> clazz = IsmIntegerFactory.class;
        synchronized (IsmIntegerFactory.class) {
            if (instacne != null) return instacne;
            instacne = new IsmIntegerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instacne;
        }
    }

    public Optional<IsmInteger> newIsmInteger(ParamType dataType, byte[] value, int byteLength) {
        if (VerifyUtil.isEmpty((Object)value)) {
            return Optional.empty();
        }
        IsmInteger result = null;
        if (dataType == ParamType.UNSIGN_INT || dataType == ParamType.BOOL || dataType == ParamType.ENUM) {
            if (byteLength == 1) {
                result = new UnsignedInt8(value[0]);
            }
            if (byteLength == 2) {
                result = new UnsignedInt16(value);
            }
            if (byteLength == 4) {
                result = new UnsignedInt32(value);
            }
            if (byteLength == 8) {
                result = new UnsignedInt64(value);
            }
        }
        if (dataType == ParamType.SIGN_INT || dataType == ParamType.TIME) {
            if (byteLength == 1) {
                result = new SignedInt8(value[0]);
            }
            if (byteLength == 2) {
                result = new SignedInt16(value);
            }
            if (byteLength == 4) {
                result = new SignedInt32(value);
            }
            if (byteLength == 8) {
                result = new SignedInt64(value);
            }
        }
        return Optional.ofNullable(result);
    }
}

