/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.lang;

import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmUnsignedInteger;

public class UnsignedInt64
extends IsmUnsignedInteger {
    public static final int HEX_FF = 255;
    private static final long serialVersionUID = -3183266319515813451L;
    private long value;

    public UnsignedInt64(byte[] bytes) {
        this.fromByteArray(bytes, bytes.length);
    }

    public UnsignedInt64(long value) {
        this.value = value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedInt64 other = (UnsignedInt64)obj;
        return this.value == other.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public void fromByteArray(byte[] values, int bytesToRead) {
        if (values.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        this.value = 0L;
        int arrayLength = values.length;
        int count = bytesToRead >= 8 ? 8 : bytesToRead;
        this.value = values[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            this.value <<= 8;
            this.value |= (long)(values[arrayLength - i] & 0xFF);
        }
    }

    @Override
    public ParamType getType() {
        return ParamType.UNSIGN_INT;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public byte[] toByteArray() {
        byte[] returnArray = new byte[8];
        returnArray[7] = (byte)(this.value >>> 56);
        returnArray[6] = (byte)(this.value >>> 48 & 0xFFL);
        returnArray[5] = (byte)(this.value >>> 40 & 0xFFL);
        returnArray[4] = (byte)(this.value >>> 32 & 0xFFL);
        returnArray[3] = (byte)(this.value >>> 24 & 0xFFL);
        returnArray[2] = (byte)(this.value >>> 16 & 0xFFL);
        returnArray[1] = (byte)(this.value >>> 8 & 0xFFL);
        returnArray[0] = (byte)this.value;
        return returnArray;
    }
}

