/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.msg;

import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt16;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt32;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt64;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt32;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class MessageHead
implements Cloneable,
Serializable {
    private static final int LOGIC_MAGIC_WORD_CONSTANT = 0x55555555;
    private static final int LOGIC_SESSION_KEY_CONSTANT = 0x660001;
    private static final long serialVersionUID = 8171856627398902460L;
    private int magicWord = 0x55555555;
    private int version = 3;
    private long status = 0L;
    private int sessionKey = 0x660001;
    private long operationCode;
    private int dataLength = 0;
    private short nodeId = (short)-1;
    private short reserved = (short)-1;
    private short boardId = (short)-1;
    private short serial = (short)-1;

    public MessageHead() {
    }

    public MessageHead(byte[] head) {
        if (head == null || head.length < 28) {
            String msg = "Head data cannot be null or head data length less than ";
            throw new IllegalArgumentException(msg + 28);
        }
        byte[] bytes = new byte[4];
        System.arraycopy(head, 0, bytes, 0, 4);
        this.setMagicWord(new SignedInt32(bytes).intValue());
        System.arraycopy(head, 4, bytes, 0, 4);
        this.setVersion(new SignedInt32(bytes).intValue());
        System.arraycopy(head, 8, bytes, 0, 4);
        this.setStatus(new UnsignedInt32(bytes).longValue());
        System.arraycopy(head, 12, bytes, 0, 4);
        this.setSessionKey(new SignedInt32(bytes).intValue());
        if (this.getVersion() == 3) {
            bytes = new byte[2];
            System.arraycopy(head, 16, bytes, 0, 2);
            this.setNodeId(new SignedInt16(bytes).shortValue());
            System.arraycopy(head, 18, bytes, 0, 2);
            this.setReserved(new SignedInt16(bytes).shortValue());
            System.arraycopy(head, 20, bytes, 0, 2);
            this.setBoardId(new SignedInt16(bytes).shortValue());
            System.arraycopy(head, 22, bytes, 0, 2);
            this.setSerial(new SignedInt16(bytes).shortValue());
        } else {
            bytes = new byte[8];
            System.arraycopy(head, 16, bytes, 0, 8);
            this.setOperationCode(new SignedInt64(bytes).longValue());
        }
        bytes = new byte[4];
        System.arraycopy(head, 24, bytes, 0, 4);
        this.setDataLength(new SignedInt32(bytes).intValue());
    }

    public int getMagicWord() {
        return this.magicWord;
    }

    public void setMagicWord(int magicWord) {
        this.magicWord = magicWord;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getStatus() {
        return this.status;
    }

    public void setStatus(long status) {
        this.status = status;
    }

    public int getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(int sessionKey) {
        this.sessionKey = sessionKey;
    }

    public long getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(long operationCode) {
        this.operationCode = operationCode;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(short nodeId) {
        this.nodeId = nodeId;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(short reserved) {
        this.reserved = reserved;
    }

    public int getBoardId() {
        return this.boardId;
    }

    public void setBoardId(short boardId) {
        this.boardId = boardId;
    }

    public int getSerial() {
        return this.serial;
    }

    public void setSerial(short serial) {
        this.serial = serial;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        out.write(new SignedInt32(this.magicWord).toByteArray());
        out.write(new SignedInt32(this.version).toByteArray());
        out.write(new UnsignedInt32(this.status).toByteArray());
        out.write(new SignedInt32(this.sessionKey).toByteArray());
        if (this.version == 3) {
            out.write(new SignedInt16(this.nodeId).toByteArray());
            out.write(new SignedInt16(this.reserved).toByteArray());
            out.write(new SignedInt16(this.boardId).toByteArray());
            out.write(new SignedInt16(this.serial).toByteArray());
        } else {
            out.write(new SignedInt64(this.operationCode).toByteArray());
        }
        out.write(new SignedInt32(this.dataLength).toByteArray());
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    public Object clone() throws CloneNotSupportedException {
        MessageHead head;
        try {
            head = (MessageHead)super.clone();
            head.magicWord = this.magicWord;
            head.status = this.status;
            head.version = this.version;
            head.sessionKey = this.sessionKey;
            head.operationCode = this.operationCode;
        }
        catch (CloneNotSupportedException e) {
            throw new TLVException("exception:", (Throwable)e);
        }
        return head;
    }

    public String toString() {
        return "operationCode=" + this.operationCode + ", dataLength=" + this.dataLength + "]";
    }
}

